<?php
/**
 * Custom filters Elementor widget template
 *
 * @package car-dealer-helper
 */
$car_filters     = ( isset( $settings['car_filters'] ) && is_array( $settings['car_filters'] ) ) ? $settings['car_filters'] : array();
$car_filters     = array_filter( $car_filters );
$list_columns    = $settings['list_columns'];
$cars_taxonomies = $this->get_taxonomies( false );
$dealers         = array();

$settings['car_filters_array']  = $car_filters;
$settings['list_columns_array'] = $list_columns;

$cars_args = array(
	'post_type'      => 'cars',
	'posts_per_page' => -1,
	'nopaging'       => true,
);

$cars_tax_query     = array();
$filter_query_found = array();

foreach ( $car_filters as $filter_key ) {
	if ( array_key_exists( $filter_key, $cars_taxonomies ) && isset( $_GET[ $filter_key ] ) ) {
		$filter_query_found[] = $filter_key;
		if ( ! empty( $_GET[ $filter_key ] ) ) {

			$filter_value = sanitize_text_field( wp_unslash( $_GET[ $filter_key ] ) );
			if ( 'car_mileage' === $filter_key ) {
				$mileage_array = cardealer_get_mileage_array();
				if ( in_array( $filter_value, $mileage_array ) ) {
					$mileage_terms     = array();
					$car_mileage_terms = get_terms(
						array(
							'taxonomy'   => 'car_mileage',
							'hide_empty' => true,
						)
					);
					foreach ( $car_mileage_terms as $car_mileage_term ) {
						$mileage = $car_mileage_term->slug;
						if ( is_numeric( $mileage ) && is_numeric( $filter_value ) ) {
							if ( (int) $mileage <= (int) $filter_value ) {
								$mileage_terms[] = $car_mileage_term->slug;
							}
						}
					}
					if ( ! empty( $mileage_terms ) ) {
						$cars_tax_query[] = array(
							'taxonomy' => 'car_mileage',
							'field'    => 'slug',
							'terms'    => $mileage_terms,
						);
					}
				}
			} else {
				$cars_tax_query[] = array(
					'taxonomy' => $filter_key,
					'field'    => 'slug',
					'terms'    => $filter_value,
				);
			}
		}
	}
}

if ( ! empty( $cars_tax_query ) ) {
	$cars_args['tax_query'] = $cars_tax_query;
}

$car_owners_car_count = array();

// Cars Query
$cars_query = new WP_Query( $cars_args );

if ( $cars_query->have_posts() ) {
	// $dealers_list
	$cars                 = $cars_query->posts;
	$car_owners           = array_column( $cars, 'post_author' );
	$car_owners_car_count = array_count_values( $car_owners );
}

$user_args = array(
	'role' => 'car_dealer',
);


if ( ! empty( $filter_query_found ) ) {
	$user_args['include'] = array_keys( $car_owners_car_count );
}

$keyword_value = ( isset( $_GET['keyword'] ) && ! empty( $_GET['keyword'] ) ) ? sanitize_text_field( wp_unslash( $_GET['keyword'] ) ) : '';

if ( ! empty( $keyword_value ) ) {
	$user_args['search']         = "*$keyword_value*";
	$user_args['search_columns'] = array(
		'user_nicename',
		'display_name',
	);
}

$orderby_value = ( isset( $_GET['orderby'] ) && ! empty( $_GET['orderby'] ) ) ? sanitize_text_field( wp_unslash( $_GET['orderby'] ) ) : 'name';

if ( 'name' === $orderby_value ) {
	$user_args['orderby'] = 'display_name';
}elseif ( 'date' === $orderby_value ) {
	$user_args['orderby'] = 'registered';
}

$user_query = new WP_User_Query( $user_args );

// Get the results.
if ( ! empty( $user_query->get_results() ) ) {
	foreach ( $user_query->get_results() as $user ) {
		$user->car_count = ( isset( $car_owners_car_count[ $user->ID ] ) ) ? $car_owners_car_count[ $user->ID ] : 0;

		$cdfs_review    = new CDFS_Review();
		$avg_rating_all = $cdfs_review->get_dealer_rating( $user->ID );
		$user->rating_active = false;
		$user->avg_rating    = 0;
		$user->rating_count  = 0;

		if ( 0 !== $avg_rating_all['avg_rating'] && 0 !== $avg_rating_all['count'] ) {
			$user->rating_active = true;
			$user->avg_rating    = $avg_rating_all['avg_rating'];
			$user->rating_count  = $avg_rating_all['count'];
		}

		$dealers[] = $user;
	}
}

if ( ! empty( $filter_query_found ) && 0 === count( $car_owners_car_count ) ) {
	$dealers = array();
}

if ( 'rating' === $orderby_value ) {
	usort( $dealers, function( $a, $b ) {
		if ( $a->avg_rating == $b->avg_rating ) {
			if ( $a->rating_count == $b->rating_count ) {
				return 0;
			}
			return ( $a->rating_count > $b->rating_count ) ? -1 : 1;
		}
		return ( $a->avg_rating > $b->avg_rating ) ? -1 : 1;
	});
}elseif ( 'stock' === $orderby_value ) {
	usort( $dealers, function( $a, $b ) {
		if ( $a->car_count == $b->car_count ) {
			return 0;
		}
		return ( $a->car_count > $b->car_count ) ? -1 : 1;
	});
}

$wrapper_class = array(
	'cd-cdfs-dealers',
);

wp_enqueue_script( 'cardealer-map' );
wp_enqueue_script( 'cardealer-shortcodes-js' );
$element_id = uniqid( $this->get_shortcode_id( 'cd-' ) );
ob_start();
?>
<div id="<?php echo esc_attr( $element_id ); ?>" class="<?php cdhl_class_builder( $wrapper_class ); ?>">
	<div class="cdfs-dealers-wrapper">
		<div class="cdfs-dealers-search-wrapper">
			<?php
			$uid             = uniqid();
			$orderby_options = $this->get_orderby_options();
			$location_value  = ( isset( $_GET['location'] ) && ! empty( $_GET['location'] ) ) ? sanitize_text_field( wp_unslash( $_GET['location'] ) ) : '';
			$loc_lat_value   = ( isset( $_GET['loc_lat'] ) && ! empty( $_GET['loc_lat'] ) ) ? sanitize_text_field( wp_unslash( $_GET['loc_lat'] ) ) : '';
			$loc_lng_value   = ( isset( $_GET['loc_lng'] ) && ! empty( $_GET['loc_lng'] ) ) ? sanitize_text_field( wp_unslash( $_GET['loc_lng'] ) ) : '';
			$keyword_value   = ( isset( $_GET['keyword'] ) && ! empty( $_GET['keyword'] ) ) ? sanitize_text_field( wp_unslash( $_GET['keyword'] ) ) : '';
			$orderby_value   = ( isset( $_GET['orderby'] ) && ! empty( $_GET['orderby'] ) ) ? sanitize_text_field( wp_unslash( $_GET['orderby'] ) ) : '';
			?>
			<form class="cdfs-dealers-search-form">
				<?php
				if ( ! empty( $car_filters ) ) {
					?>
					<div class="cdfs-dealers-search-filters">
						<div class="row">
							<?php
							$filters_sr = 0;
							foreach ( $car_filters as $filter_key ) {

								// Check whether selected filter_key exists in the taxonomy list.
								if ( array_key_exists( $filter_key, $cars_taxonomies ) ) {
									$taxonomy_obj = get_taxonomy( $filter_key );
									if ( $taxonomy_obj ) {
										$tax_label      = $taxonomy_obj->labels->singular_name;
										$field_id       = "cdfs-dealers-search-filter-{$filter_key}-{$uid}";
										$selected_value = ( isset( $_GET[ $filter_key ] ) ) ? sanitize_text_field( wp_unslash( $_GET[ $filter_key ] ) ) : '';
										?>
										<div class="cdfs-dealers-search-field cdfs-dealers-search-select cdfs-dealers-search-filter col-lg-4 col-md-4 col-sm-4">
											<label for="<?php echo esc_attr( $field_id ); ?>"><?php echo esc_html( $tax_label ); ?></label>
											<select id="<?php echo esc_attr( $field_id ); ?>" name="<?php echo esc_attr( $filter_key ); ?>" class="selectpicker">
												<option value=""><?php echo sprintf( esc_html__( 'Select %s', 'cardealer-helper' ), $tax_label ); ?></option>
												<?php
												if ( 'car_mileage' === $taxonomy_obj->name ) {
													$mileage_array = cardealer_get_mileage_array();
													foreach ( $mileage_array as $mileage ) {
														?>
														<option value="<?php echo esc_attr( $mileage ); ?>" <?php selected( $selected_value, $mileage ); ?>>&leq; <?php echo esc_html( $mileage ); ?></option>
														<?php
													}
												} else {
													$tax_terms = cdhl_get_terms( array( 'taxonomy' => $filter_key ) );
													foreach ( $tax_terms as $label => $value ) {
														?>
														<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $selected_value, $value ); ?>><?php echo esc_html( $label ); ?></option>
														<?php
													};
												}
												?>
											</select>
										</div>
										<?php
									}
								}
								$filters_sr++;
							}
							?>
						</div>
					</div>
					<?php
				}
				?>
				<div class="cdfs-dealers-search-tools">
					<div class="row">
						<?php
						$empty_class = ( ! filter_var( $settings['show_location'], FILTER_VALIDATE_BOOLEAN ) && ! filter_var( $settings['show_keyword'], FILTER_VALIDATE_BOOLEAN ) ) ? 'is-empty' : 'is-not-empty';
						?>
						<div class="col-md-3 col-sm-4 cdfs-dealers-search-tools-first <?php echo esc_attr( $empty_class ); ?>">
							<?php
							if ( filter_var( $settings['show_location'], FILTER_VALIDATE_BOOLEAN ) ) {
								?>
								<div class="cdfs-dealers-search-field cdfs-dealers-search-text cdfs-dealers-search-location">
									<input class="cdfs-dealers-search-loc_search" type="text" name="location" value="<?php echo esc_attr( $location_value ); ?>" placeholder="<?php echo esc_html__( 'Location', 'cardealer-helper' ); ?>">
									<input class="cdfs-dealers-search-loc_lat" type="hidden" name="loc_lat" value="<?php echo esc_attr( $loc_lat_value ); ?>">
									<input class="cdfs-dealers-search-loc_lng" type="hidden" name="loc_lng" value="<?php echo esc_attr( $loc_lng_value ); ?>">
								</div>
								<?php
							}
							if ( filter_var( $settings['show_keyword'], FILTER_VALIDATE_BOOLEAN ) ) {
								?>
								<div class="cdfs-dealers-search-field cdfs-dealers-search-text cdfs-dealers-search-keyword">
									<input type="text" name="keyword" value="<?php echo esc_attr( $keyword_value ); ?>" placeholder="<?php echo esc_html__( 'Keyword', 'cardealer-helper' ); ?>">
								</div>
								<?php
							}
							?>
						</div>
						<div class="col-md-3 col-sm-4 cdfs-dealers-search-tools-second">
							<div class="cdfs-dealers-search-field cdfs-dealers-search-select cdfs-dealers-search-orderby">
								<select name="orderby">
									<option value=""><?php echo esc_html__( 'Default sorting', 'cardealer-helper' ); ?></option>
									<?php
									foreach ( $orderby_options as $orderby_k => $orderby_v ) {
										?>
										<option value="<?php echo esc_attr( $orderby_k ); ?>" <?php selected( $orderby_value, $orderby_k ); ?>><?php echo esc_html( $orderby_v ); ?></option>
										<?php
									}
									?>
								</select>
							</div>
						</div>
						<div class="col-md-3 col-sm-6 cdfs-dealers-search-tools-third">
							<div class="cdfs-dealers-search-field cdfs-dealers-search-button cdfs-dealers-search-white cdfs-dealers-search-search">
								<button id="cdfs-dealers-search-search" type="submit" class="btn btn-default"><i class="fas fa-search"></i><?php echo esc_html__( 'Search', 'cardealer-helper' ); ?></button>
							</div>
							<div class="cdfs-dealers-search-field cdfs-dealers-search-button cdfs-dealers-search-cs cdfs-dealers-search-reset">
								<button id="cdfs-dealers-search-reset" type="reset" class="btn btn-default"><?php echo esc_html__( 'Reset', 'cardealer-helper' ); ?></button>
							</div>
						</div>
					</div>
				</div>
				<div class="clearfix"></div>
			</form>
		</div>
		<div class="cdfs-dealers-list-wrapper">
			<?php
			$list_columns_option = $this->get_list_columns();
			$list_columns_found  = array();
			$list_columns_count  = 0;
			?>
			<table class="cdfs-dealers-list" style="width:100%">
				<thead>
					<tr>
						<?php
						foreach ( $list_columns as $column_id ) {
							if ( isset( $list_columns_option[ $column_id ] ) && ! empty( $list_columns_option[ $column_id ] ) ) {
								$list_columns_count++;

								$column_name = $list_columns_option[ $column_id ];

								$list_columns_found[ $column_id ] = $column_name;

								$list_header_class = array(
									'cdfs-dealers-list-header',
									'cdfs-dealers-list-header-' . $column_id,
									'cdfs-dealers-list-column',
									'cdfs-dealers-list-column-' . $column_id,
								);
								?>
								<th class=" <?php cdhl_class_builder( $list_header_class ); ?>"><?php echo esc_html( $column_name ); ?></th>
								<?php
							}
						}
						?>
					</tr>
				</thead>
				<tbody>
					<?php
					if ( ! empty( $dealers ) ) {
						foreach ( $dealers as $user ) {
							$list_row_class = array(
								'cdfs-dealers-list-row',
								'cdfs-dealers-list-user-' . $user->ID,
							);
							?>
							<tr class="<?php cdhl_class_builder( $list_row_class); ?>">
								<?php
								$author_name        = get_the_author_meta( 'display_name', $user->ID );
								$author_url         = get_author_posts_url( $user->ID );
								$user_avatar_url    = cdfs_get_avatar_url( $user->ID );
								$cdfs_show_email    = filter_var( get_the_author_meta( 'cdfs_show_email', $user->ID ), FILTER_VALIDATE_BOOLEAN );
								$cdfs_show_phone    = filter_var( get_the_author_meta( 'cdfs_show_phone', $user->ID ), FILTER_VALIDATE_BOOLEAN );
								$cdfs_show_whatsapp = filter_var( get_the_author_meta( 'cdfs_show_whatsapp', $user->ID ), FILTER_VALIDATE_BOOLEAN );
								$email              = cdfs_get_user_email( $user->ID );
								$phone              = cdfs_get_user_phone( $user->ID );
								$phone_url          = cdfs_get_user_phone_url( $phone, $user->ID );
								$whatsapp           = cdfs_get_user_whatsapp( $user->ID );

								$cdfs_review    = new CDFS_Review();
								$avg_rating_all = $cdfs_review->get_dealer_rating( $user->ID );
								$avg_rating     = 0;
								$rating_count   = 0;
								$rating_active  = false;

								if ( 0 !== $avg_rating_all['avg_rating'] && 0 !== $avg_rating_all['count'] ) {
									$rating_active = true;
									$avg_rating    = $avg_rating_all['avg_rating'];
									$rating_count  = $avg_rating_all['count'];
								}

								$dealer_location = get_the_author_meta( 'dealer_location', $user->ID );
								$dealer_address  = '';
								$dealer_lat      = '';
								$dealer_lng      = '';
								if ( ! empty( $dealer_location ) && is_array( $dealer_location ) ) {
									$dealer_address = ( isset( $dealer_location['address'] ) && ! empty( $dealer_location['address'] ) ) ? $dealer_location['address'] : $dealer_address;
									$dealer_lat     = ( isset( $dealer_location['lat'] ) && ! empty( $dealer_location['lat'] ) ) ? $dealer_location['lat'] : $dealer_lat;
									$dealer_lng     = ( isset( $dealer_location['lng'] ) && ! empty( $dealer_location['lng'] ) ) ? $dealer_location['lng'] : $dealer_lng;
								}

								$location_value  = ( isset( $_GET['location'] ) && ! empty( $_GET['location'] ) ) ? sanitize_text_field( wp_unslash( $_GET['location'] ) ) : '';
								$loc_lat_value   = ( isset( $_GET['loc_lat'] ) && ! empty( $_GET['loc_lat'] ) ) ? sanitize_text_field( wp_unslash( $_GET['loc_lat'] ) ) : '';
								$loc_lng_value   = ( isset( $_GET['loc_lng'] ) && ! empty( $_GET['loc_lng'] ) ) ? sanitize_text_field( wp_unslash( $_GET['loc_lng'] ) ) : '';

								$distance      = false;
								$address_url   = false;
								$location_part = false;

								if (
									! empty( $location_value )
									&& ! empty( $loc_lat_value )
									&& ! empty( $loc_lng_value )
									&& ! empty( $dealer_address )
									&& ! empty( $dealer_lat )
									&& ! empty( $dealer_lng )
								) {
									$distance = cdhl_distance_calculator( $loc_lat_value, $loc_lng_value, $dealer_lat, $dealer_lng, $settings['distance_unit'] );
									$location_parts = explode( ',', $location_value );
									$location_part  = $location_parts[0];
								}


								if (
									! empty( $dealer_address )
									&& ! empty( $dealer_lat )
									&& ! empty( $dealer_lng )
								) {
									$address_url = "https://maps.google.com/?q={$dealer_lat},{$dealer_lng}";
								}

								$distance_units = $this->get_distance_unit( 'short' );

								foreach ( $list_columns_found as $column_id => $column_name ) {
									$table_column_class = array(
										'cdfs-dealers-list-column',
										'cdfs-dealers-list-column-' . $column_id,
									);
									?>
									<td class="<?php cdhl_class_builder( $table_column_class); ?>" data-title="<?php echo esc_attr( $column_name); ?>">
										<?php
										if ( has_action( "cardealer/dealers_list/column/$column_id" ) ) {
											do_action( "cardealer/dealers_list/column/$column_id", $column_id, $user );
										// Subscription ID.
										} elseif ( 'dealer' === $column_id ) {
											?>
											<div class="cdfs-dealers-list-dealer">
												<span class="cdfs-dealers-list-dealer-thumb"><a href="<?php echo esc_url( $author_url ); ?>"><img height="40" width="40" src="<?php echo esc_url( $user_avatar_url ); ?>" class="img-circle"></a></span>
												<span class="cdfs-dealers-list-dealer-name"><a href="<?php echo esc_url( $author_url ); ?>"><?php echo esc_html( $author_name ); ?></a></span>
											</div>
											<?php
										} elseif ( 'rating' === $column_id ) {
												?>
												<div class="vehicle-seller-info-rating">
													<?php $cdfs_review->get_rating_html( $avg_rating ); ?>
													<span class="vehicle-seller-info-rating-count">
														<?php
														/* translators: %s: Number of reviews. */
														printf( _n( '%s Review', '%s Reviews', $rating_count, 'cardealer-helper' ), number_format_i18n( $rating_count ) );
														?>
													</span>
												</div>
												<?php
										} elseif ( 'stock' === $column_id ) {
											echo esc_html( $user->car_count );
										} elseif ( 'phone' === $column_id ) {
											if ( $cdfs_show_phone && $phone ) {
												?>
												<a href="<?php echo esc_url( $phone_url ); ?>"><?php echo esc_html( $phone ); ?></a>
												<?php
											}
										} elseif ( 'email' === $column_id ) {
											if ( $cdfs_show_email && $email ) {
												?>
												<a href="<?php echo esc_url( "mailto:{$email}" ); ?>"><?php echo esc_html( $email ); ?></a>
												<?php
											}
										} elseif ( 'whatsapp' === $column_id ) {
											if ( $cdfs_show_whatsapp && $whatsapp ) {
												?>
												<a href="<?php echo esc_url( "https://wa.me/{$whatsapp}" ); ?>" target="_blank" rel="noreferrer noopener"><?php echo esc_html( $whatsapp ); ?></a>
												<?php
											}
										} elseif ( 'location' === $column_id ) {
											if ( ! empty( $dealer_address ) && $address_url ) {
												?>
												<a href="<?php echo esc_url( $address_url ); ?>" target="_blank" rel="noopener"><?php echo esc_html( $dealer_address ); ?></a>
												<?php
												if ( $distance ) {
													?>
													<div class="search-distance"><?php
													printf(
														wp_kses(
															/* translators: %1$s: distance, %2$s: distance unit, %3$s: location */
															__( '<span>%1$s  %2$s</span> from  %3$s', 'cardealer-helper' ),
															array(
																'span' => array(),
															)
														),
														number_format( $distance, 2 ),
														$distance_units[ $settings['distance_unit'] ],
														$location_part
													);
													?></div>
													<?php
												}
											}
										}
										?>
									</td>
									<?php
								}
								?>
							</tr>
							<?php
						}
					} else {
						?>
						<tr class="cdfs-dealers-list-no-data-found"><td colspan="<?php echo esc_attr( $list_columns_count ); ?>">No Data found.</td></tr>
						<?php
					}
					?>
				</tbody>
			</table>
		</div>
	</div>
</div>
<?php
