<?php
/**
 * Elementor Vehicle Attribute template.
 *
 * @package car-dealer-helper
 */

global $post, $wp_taxonomies;

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$attribute_slug = isset( $settings['attribute_slug'] ) ? $settings['attribute_slug'] : '';
$fallback_text  = isset( $settings['fallback_text'] ) ? $settings['fallback_text'] : '';
$html_tag       = isset( $settings['html_tag'] ) ? $settings['html_tag'] : 'h2';
$transform      = isset( $settings['transform'] ) ? $settings['transform'] : 'capitalize';
$post_id        = get_the_ID();
$value          = '';

$this->add_render_attribute( 'cd_vehicle_attribute', 'id', 'cd_vehicle_attribute-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_attribute', 'class', 'cd-vehicle-attribute' );
$this->add_render_attribute( 'cd_vehicle_attribute', 'class', 'text-transform-' . $transform );

if ( empty( $attribute_slug ) ) {
	return null;
}

if ( ! isset( $wp_taxonomies[ $attribute_slug ] ) ) {
	return null;
}

if ( ! in_array( 'cars', $wp_taxonomies[ $attribute_slug ]->object_type, true ) ) {
	return null;
}

if ( CDHL_CPT_Template::CPT === $post->post_type && class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
}

$terms = wp_get_post_terms( $post_id, $attribute_slug );

if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
	$value = $terms[0]->name;
}

if ( empty( $value ) ) {
	$value = $fallback_text;
}
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_attribute' ); ?>>
	<<?php echo esc_attr( $html_tag ); ?> class="vehicle-attribute"><?php echo wp_kses_post( $value ); ?></<?php echo esc_attr( $html_tag ); ?>>
</div>
