<?php
/**
 * Elementor Breadcrumb template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

if ( ! function_exists( 'cardealer_bcn_display_list' ) ) {
	return null;
}

$this->add_render_attribute( 'cdhl_breadcrumb', 'id', 'cd_vehicle_breadcrumb-' . $this->get_id() );
$this->add_render_attribute( 'cdhl_breadcrumb', 'class', 'cd-vehicle-breadcrumb' );
?>
<div <?php $this->print_render_attribute_string( 'cdhl_breadcrumb' ); ?>>
	<ul class="page-breadcrumb" typeof="BreadcrumbList" vocab="http://schema.org/">
		<?php cardealer_bcn_display_list(); ?>
	</ul>
</div>
