<?php
/**
 * Elementor Vehicle Compare template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$this->add_render_attribute( 'cd_vehicle_compare', 'id', 'cd_vehicle_compare-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_compare', 'class', 'cd-compare-button cd-vehicle-compare ' . $settings['compare_button_type'] );

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}

$title = isset( $settings['title'] ) ? $settings['title'] : '';
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_compare' ); ?>>
	<a href="javascript:void(0)" title="<?php echo esc_attr( get_the_title( $post_id ) ); ?>" data-id="<?php echo esc_attr( $post_id ); ?>" class="pgs_compare_popup compare_pgs"><i class="fas fa-exchange-alt"></i> <?php echo esc_html( $title ); ?></a>
</div>
