<?php
/**
 * Elementor Vehicle Meta template.
 *
 * @package car-dealer-helper
 */


if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$this->add_render_attribute( 'cd_vehicle_meta', 'id', 'cd_vehicle_meta-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_meta', 'class', 'cd-vehicle-meta' );
$this->add_render_attribute( 'cd_vehicle_meta', 'class', 'text-transform-' . $settings['transform'] );

$vehicle_meta_tag      = isset( $settings['vehicle_meta_tag'] ) ? $settings['vehicle_meta_tag'] : 'h2';
$vehicle_meta          = isset( $settings['vehicle_meta'] ) ? $settings['vehicle_meta'] : '';
$vehicle_meta_fallback = isset( $settings['vehicle_meta_fallback'] ) ? $settings['vehicle_meta_fallback'] : 'N/A';

if ( empty( $vehicle_meta ) ) {
	return null;
}

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}

$vehicle_meta_value = get_post_meta( $post_id, sanitize_key( $vehicle_meta ), true );
if ( ! $vehicle_meta_value ) {
	$vehicle_meta_value = $vehicle_meta_fallback;
}
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_meta' ); ?>>
	<<?php echo esc_attr( $vehicle_meta_tag ); ?> class="vehicle-meta">
		<?php echo wp_kses_post( $vehicle_meta_value ); ?>
	</<?php echo esc_attr( $vehicle_meta_tag ); ?>>
</div>
