<?php
/**
 * Elementor Vehicle Title template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$tax_label_alignment = ( isset( $settings['tax_label_alignment'] ) ) ? $settings['tax_label_alignment'] : 'left';
$tax_label           = ( isset( $settings['tax_label'] ) ) ? $settings['tax_label'] : 'default';
$hide_sold_label     = ( isset( $settings['hide_sold_label'] ) ) ? $settings['hide_sold_label'] : false;

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}

$this->add_render_attribute( 'cd_vehicle_price', 'id', 'cd_vehicle_price-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_price', 'class', 'cd-vehicle-price' );
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_price' ); ?>>
	<?php
	$class = 'text-' . $tax_label_alignment;
	$class .= ' text-label-' . $tax_label;
	if ( 'true' === $hide_sold_label ) {
		$class .= ' hide-status';
	}
	cardealer_car_price_html( $class, $post_id );
	?>
</div>
