<?php
/**
 * Elementor Vehicle Seller Info template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}

$show_title   = ( isset( $settings['show_title'] ) ) ? $settings['show_title'] : 'no';
$show_title   = filter_var( $show_title, FILTER_VALIDATE_BOOLEAN );
$show_phone   = ( isset( $settings['show_phone'] ) ) ? $settings['show_phone'] : 'yes';
$show_phone   = filter_var( $show_phone, FILTER_VALIDATE_BOOLEAN );

$dealer_title = ( isset( $settings['dealer_title'] ) && ! empty( $settings['dealer_title'] ) ) ? $settings['dealer_title'] : esc_html__( 'Dealer Details', 'cardealer-helper' );
$user_title   = ( isset( $settings['user_title'] ) && ! empty( $settings['user_title'] ) ) ? $settings['user_title'] : esc_html__( 'User Details', 'cardealer-helper' );

$seller_info_args = array(
	'wrapper_id'    => 'cd-vehicle-seller-info-' . $this->get_id(),
	'wrapper_class' => array(
		'cd-vehicle-seller-info',
		'cd-vehicle-seller-info-style-default',
	),
	'post_id'       => $post_id,
	'show_title'    => $show_title,
	'show_phone'    => $show_phone,
	'dealer_title'  => $dealer_title,
	'user_title'    => $user_title,
);

cdhl_vehicle_seller_info_html( $seller_info_args );
