<?php
/**
 * Elementor Vehicle Compare template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}

$post_author_id  = get_post_field( 'post_author', $post_id );

if ( ! filter_var( get_the_author_meta( 'cdfs_show_whatsapp', $post_author_id ), FILTER_VALIDATE_BOOLEAN ) )  {
	return;
}

$seller_whatsapp  = cdfs_get_user_whatsapp( $post_author_id );

if ( ! $seller_whatsapp ) {
	return;
}

$title        = ( isset( $settings['title'] ) && ! empty( $settings['title'] ) ) ? $settings['title'] : esc_html__( 'WhatsApp', 'cardealer-helper' );
$whatsapp_url = "https://wa.me/{$seller_whatsapp}";

$this->add_render_attribute( 'cd_vehicle_whatsapp_btn', 'id', 'cd-vehicle-seller-whatsapp-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_whatsapp_btn', 'class', 'cd-vehicle-seller-whatsapp-btn' );
$this->add_render_attribute( 'cd_vehicle_whatsapp_btn', 'class', 'cd-vehicle-seller-whatsapp-btn-style-default' );

$this->add_render_attribute( 'cd_vehicle_whatsapp_link', 'class', 'cd-vehicle-seller-whatsapp-link' );
$this->add_render_attribute( 'cd_vehicle_whatsapp_link', 'title', $title );
$this->add_render_attribute( 'cd_vehicle_whatsapp_link', 'href', $whatsapp_url );
$this->add_render_attribute( 'cd_vehicle_whatsapp_link', 'target', '_blank' );
$this->add_render_attribute( 'cd_vehicle_whatsapp_link', 'rel', 'noopener' );
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_whatsapp_btn' ); ?>>
	<a <?php $this->print_render_attribute_string( 'cd_vehicle_whatsapp_link' ); ?>><i class="fab fa-whatsapp"></i> <?php echo esc_html( $title ); ?></a>
</div>
