<?php
/**
 * Elementor Vehicle Video template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$this->add_render_attribute( 'cd_vehicle_video', 'id', 'cd_vehicle_video-' . $this->get_id() );

$title       = ( isset( $settings['title'] ) && ! empty( $settings['title'] ) ) ? $settings['title'] : esc_html__( 'Vehicle video', 'cardealer-helper' );
$button_type = isset( $settings['button_type'] ) ? $settings['button_type'] : 'default';

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}

$this->add_render_attribute( 'cd_vehicle_video', 'class', 'cd-vehicle-video cd-video-button ' . $button_type );
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_video' ); ?>>
	<?php
	$video_link = get_post_meta( $post_id, 'video_link', true );
	if ( ! empty( $video_link ) ) {
		?>
		<div class="play-video popup-gallery default">
			<a class="popup-youtube" href="<?php echo esc_url( $video_link ); ?>" title="<?php echo esc_attr( get_the_title() ); ?>"> <i class="fas fa-play"></i> <?php echo esc_html( $title ); ?></a>
		</div>
		<?php
	}
	?>
</div>
