<?php
/**
 * Video Elementor widget template
 *
 * @package car-dealer-helper
 */

$video_link        = isset( $settings['video_link'] ) ? $settings['video_link'] : '';
$video_position    = isset( $settings['video_position'] ) ? $settings['video_position'] : '';
$video_image_title = esc_html__( 'Video Img', 'cardealer-helper' );

if ( ! $video_link ) {
	if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'If "Video URL" is not set, the widget content will not be rendered. Please enter Video URL to display widget content.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
	}
	return;
}
$this->add_render_attribute( 'cdhl_video', 'class', 'play-video popup-gallery ' . $video_position );
$this->add_render_attribute( 'cdhl_video_outer', 'class', 'video-info text-center' );
$this->add_render_attribute(
	[
		'cdhl_video_popup' => [
			'class' => 'popup-video',
			'href'  => $video_link,
		],
	]
);
wp_enqueue_script( 'cardealer-shortcodes-js' );
?>
<div <?php $this->print_render_attribute_string( 'widget_wrapper' ); ?>>
	<div <?php $this->print_render_attribute_string( 'cdhl_video' ); ?>>
		<div <?php $this->print_render_attribute_string( 'cdhl_video_outer' ); ?>>
			<?php
			if ( cardealer_lazyload_enabled() ) {
				if ( isset( $settings['video_img']['url'] ) && $settings['video_img']['url'] ) {
					$video_image       = $settings['video_img']['url'];
					$video_image_title = ( isset( $settings['video_img']['alt'] ) &&  $settings['video_img']['alt'] ) ? $settings['video_img']['alt'] : $video_image_title;
				} else {
					$video_image = trailingslashit( CDHL_URL ) . 'images/bg/07.jpg';
				}
				$this->add_render_attribute(
					[
						'cdhl_video_image' => [
							'class'    => 'img-responsive center-block cardealer-lazy-load',
							'src'      => LAZYLOAD_IMG,
							'data-src' => $video_image,
							'alt'      => $video_image_title,
						],
					]
				);
				?>
				<img <?php $this->print_render_attribute_string( 'cdhl_video_image' ); ?>>
				<?php
			} else {
				if ( isset( $settings['video_img']['id'] ) && $settings['video_img']['id'] ) {
					echo wp_get_attachment_image( $settings['video_img']['id'], 'full', '', array( 'class' => 'img-responsive center-block' ) );
				} else {
					$video_img_arr = ( function_exists( 'cardealer_get_attachment_detail' ) ) ? cardealer_get_attachment_detail( $settings['video_img']['id'] ) : '';
					$this->add_render_attribute(
						[
							'cdhl_video_image' => [
								'class' => 'img-responsive center-block',
								'src'   => trailingslashit( CDHL_URL ) . 'images/bg/07.jpg',
								'alt'   => ( isset( $video_img_arr['alt'] ) && $video_img_arr['alt'] ) ? $video_img_arr['alt'] : $video_image_title,
							],
						]
					);
					?>
					<img <?php $this->print_render_attribute_string( 'cdhl_video_image' ); ?>>
					<?php
				}
			}
			?>
			<a <?php $this->print_render_attribute_string( 'cdhl_video_popup' ); ?>><i class="fas fa-play"></i></a>
		</div>
	</div>
</div>
