<?php
/**
 * Car request more info
 *
 * @author  TeamWP @Potenza Global Solutions
 * @package car-dealer-helper
 */
$year         = cardealer_get_field_label_with_tax_key( 'car_year' );
$make         = cardealer_get_field_label_with_tax_key( 'car_make' );
$model        = cardealer_get_field_label_with_tax_key( 'car_model' );
$trim         = cardealer_get_field_label_with_tax_key( 'car_trim' );
$vin_number   = cardealer_get_field_label_with_tax_key( 'car_vin_number' );
$stock_number = cardealer_get_field_label_with_tax_key( 'car_stock_number' );

if ( function_exists( 'acf_add_local_field_group' ) ) :
	acf_add_local_field_group(
		/**
		 * Filters the arguments of the request more information field group.
		 *
		 * @since 1.0
		 * @param array    $args    Arguments of the request more information field group.
		 * @visible        true
		 */
		apply_filters(
			'cardealer_acf_request_more_info',
			array(
				'key'                   => 'group_587f100a879e2',
				'title'                 => esc_html__( 'Request More Info', 'cardealer-helper' ),
				'fields'                => array(
					array(
						'key'               => 'field_591ed508ec90a',
						'label'             => esc_html__( 'User Information', 'cardealer-helper' ),
						'name'              => '',
						'type'              => 'tab',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => '',
							'id'    => '',
						),
						'placement'         => 'top',
						'endpoint'          => 0,
					),
					array(
						'key'               => 'field_587f101cc6fa1',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_first_name', esc_html__( 'First Name', 'cardealer-helper' ) ),
						'name'              => 'first_name',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-first_name dealer_forms',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_587f1027c6fa2',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_last_name', esc_html__( 'Last Name', 'cardealer-helper' ) ),
						'name'              => 'last_name',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-last_name dealer_forms',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_587f1035c6fa3',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_email', esc_html__( 'Email', 'cardealer-helper' ) ),
						'name'              => 'email',
						'type'              => 'email',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-email dealer_forms',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_587f103fc6fa4',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_mobile', esc_html__( 'Mobile', 'cardealer-helper' ) ),
						'name'              => 'mobile',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-mobile dealer_forms',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_587f1049c6fa5',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_address', esc_html__( 'Address', 'cardealer-helper' ) ),
						'name'              => 'address',
						'type'              => 'textarea',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-address dealer_forms',
							'id'    => '',
						),
						'default_value'     => '',
						'new_lines'         => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'rows'              => 4,
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_587f10cac6fa6',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_state', esc_html__( 'State', 'cardealer-helper' ) ),
						'name'              => 'state',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-state dealer_forms',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_587f10e9c6fa7',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_zip', esc_html__( 'Zip', 'cardealer-helper' ) ),
						'name'              => 'zip',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-zip dealer_forms',
							'id'    => '',
						),
						'default_value'     => '',
						'maxlength'         => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_587f10ffc6fa8',
						'label'             => cdhl_get_theme_option( 'cstfrm_lbl_preferred_contact', esc_html__( 'Preferred Contact', 'cardealer-helper' ) ),
						'name'              => 'contact',
						'type'              => 'radio',
						'instructions'      => esc_html__( 'Contact by Email or Phone', 'cardealer-helper' ),
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-contact  dealer_forms',
							'id'    => '',
						),
						'choices'           => array(
							'email' => cdhl_get_theme_option( 'cstfrm_lbl_email', esc_html__( 'Email', 'cardealer-helper' ) ),
							'phone' => cdhl_get_theme_option( 'cstfrm_lbl_phone', esc_html__( 'Phone', 'cardealer-helper' ) ),
						),
						'allow_null'        => 0,
						'other_choice'      => 0,
						'save_other_choice' => 0,
						'default_value'     => '',
						'layout'            => 'horizontal',
						'return_format'     => 'value',
						'disabled'          => array(
							'email',
							'phone',
						),
					),
					array(
						'key'               => 'field_591ed4f8ec909',
						'label'             => esc_html__( 'Vehicle Information', 'cardealer-helper' ),
						'name'              => '',
						'type'              => 'tab',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name- acf_field_name- acf_field_name-',
							'id'    => '',
						),
						'placement'         => 'top',
						'endpoint'          => 0,
					),
					array(
						'key'               => 'field_591e9a4a097c6',
						'label'             => $year,
						'name'              => 'car_year_inq',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-car_information acf_field_name-car_year_inq acf_field_name-car_year_inq acf_field_name-car_year_inq',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591ebf39dc275',
						'label'             => $make,
						'name'              => 'car_make_inq',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-car_information acf_field_name-car_make_inq acf_field_name-car_make_inq acf_field_name-car_make_inq',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591ebf37dc274',
						'label'             => $model,
						'name'              => 'car_model_inq',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-car_information acf_field_name-car_model_inq acf_field_name-car_model_inq acf_field_name-car_model_inq',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591ebf62dc276',
						'label'             => $trim,
						'name'              => 'car_trim_inq',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-car_information acf_field_name-car_trim_inq acf_field_name-car_trim_inq acf_field_name-car_trim_inq',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591e9a75097c7',
						'label'             => $vin_number,
						'name'              => 'vin_number',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-vin__stock_no acf_field_name-vin_stock_no acf_field_name-vin_number acf_field_name-vin_number acf_field_name-vin_number',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591e9a9f097c8',
						'label'             => $stock_number,
						'name'              => 'stock_number',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-car_price acf_field_name-car_price acf_field_name-stock_number acf_field_name-stock_number acf_field_name-stock_number',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591ebf93dc278',
						'label'             => esc_html__( 'Regular Price', 'cardealer-helper' ),
						'name'              => 'regular_price',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-regular_price acf_field_name-regular_price acf_field_name-regular_price',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
					array(
						'key'               => 'field_591ebf82dc277',
						'label'             => esc_html__( 'Sale Price', 'cardealer-helper' ),
						'name'              => 'sale_price',
						'type'              => 'text',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => 0,
						'wrapper'           => array(
							'width' => '',
							'class' => 'acf_field_name-sale_price acf_field_name-sale_price acf_field_name-sale_price',
							'id'    => '',
						),
						'default_value'     => '',
						'placeholder'       => '',
						'prepend'           => '',
						'append'            => '',
						'maxlength'         => '',
						'readonly'          => 1,
					),
				),
				'location'              => array(
					array(
						array(
							'param'    => 'post_type',
							'operator' => '==',
							'value'    => 'pgs_inquiry',
						),
					),
				),
				'menu_order'            => 0,
				'position'              => 'normal',
				'style'                 => 'default',
				'label_placement'       => 'left',
				'instruction_placement' => 'label',
				'hide_on_screen'        => array(
					0 => 'the_content',
					1 => 'featured_image',
				),
				'active'                => 1,
				'description'           => '',
				'menu_item_level'       => 'all',
			)
		)
	);

endif;
