<?php
/**
 * Vehicle detail data class.
 *
 * @package cardealer-helper/classes
 * @since   5.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class CarDealer_Vehicle_Detail_Data.
 *
 * @since   5.0.0
 */
class CarDealer_Vehicle_Detail_Data {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_filter( 'cardealer_vehicle_review_stamps_links_html', array( $this, 'review_stamp' ), 10, 3 );
	}

	function review_stamp( $links_html, $id, $review_stamp_data ) {

		if ( did_action( 'elementor/loaded' ) ) {
			if ( is_singular( 'cardealer_template' ) || \Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
				$links_html = '<a class="vehicle-review-stamp-link vehicle-review-stamp-popup" href="#" target="_blank"><img class="vehicle-review-stamp-img" src="' . trailingslashit( CDHL_URL ) . 'images/vehicle-detail-data/review-stamp.jpg' . '" alt="review-stamp"></a>';
			}
		}

		return $links_html;
	}

}

new CarDealer_Vehicle_Detail_Data();
