<?php
/**
 * Elementor Vehicle Price class.
 *
 * @package cardealer-helper/elementor
 * @since   5.0.0
 */

namespace Cdhl_Elementor\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

use Cdhl_Elementor\Widget_Controller\Widget_Controller;
use Cdhl_Elementor\Group_Controls;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor banner widget.
 *
 * Elementor widget that displays an banner.
 *
 * @since 5.0.0
 */
class Vehicle_Price extends Widget_Controller {

	/**
	 * Widget slug
	 *
	 * @var string
	 */
	protected $widget_slug = 'vehicle-price';

	/**
	 * Widget icon
	 *
	 * @var string
	 */
	protected $widget_icon = 'cdhl-widget-icon';

	/**
	 * Widget keywords
	 *
	 * @var array
	 */
	protected $keywords = array( 'cars', 'vehicle', 'detail', 'single', 'price' );

	/**
	 * Retrieve the widget title.
	 *
	 * @since 5.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Vehicle Price', 'cardealer-helper' );
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 5.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( CDHL_ELEMENTOR_VEHIVLE_SINGLE_CAT );
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 5.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'section_content_general',
			array(
				'label' => esc_html__( 'General', 'cardealer-helper' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'hide_sold_label',
			[
				'label'        => esc_html__( 'Hide Sold Label', 'cardealer-helper' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => esc_html__( 'Enable to hide sold label.', 'cardealer-helper' ),
				'label_on'     => esc_html__( 'Yes', 'cardealer-helper' ),
				'label_off'    => esc_html__( 'No', 'cardealer-helper' ),
				'return_value' => 'true',
			]
		);

		$this->add_control(
			'tax_label',
			[
				'label'       => esc_html__( 'Tax Label Type', 'cardealer-helper' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'default',
				'description' => esc_html__( 'Select label type.', 'cardealer-helper' ),
				'options'     => [
					'default'     => esc_html__( 'Default', 'cardealer-helper' ),
					'highlighted' => esc_html__( 'Highlighted', 'cardealer-helper' ),
				],
			]
		);

		$this->add_control(
			'tax_label_alignment',
			[
				'label'       => esc_html__( 'Alignment', 'cardealer-helper' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'left',
				'description' => esc_html__( 'Select alignment. Note: Not applicable in mobile view.', 'cardealer-helper' ),
				'options'     => [
					'left'  => esc_html__( 'Left', 'cardealer-helper' ),
					'right' => esc_html__( 'Right', 'cardealer-helper' ),
				],
			]
		);

		$this->end_controls_section();
	}
}
