<?php // phpcs:ignore WordPress.Files.FileName.NotHyphenatedLowercase
/**
 * Include the scripts and styles.
 *
 * @author  TeamWP @Potenza Global Solutions
 * @package car-dealer-helper/functions
 * @version 1.0.0
 */

add_action( 'admin_enqueue_scripts', 'cdhl_admin_enqueue_scripts' );
if ( ! function_exists( 'cdhl_admin_enqueue_scripts' ) ) {
	/**
	 * Add script and style in wp-admin side
	 *
	 * @param string $hook variable.
	 */
	function cdhl_admin_enqueue_scripts( $hook ) {
		global $car_dealer_options;

		// phpcs:disable WordPress.Security.NonceVerification.Recommended
		$google_maps_api_key = ( function_exists( 'cardealer_get_google_maps_api_key' ) ) ? cardealer_get_google_maps_api_key() : '';

		// Javascript.
		wp_register_script( 'chosen', trailingslashit( CDHL_URL ) . 'js/chosen/chosen.jquery.min.js', array( 'jquery-ui-widget' ), '1.7.0', true );
		wp_register_script( 'chosen-order', trailingslashit( CDHL_URL ) . 'js/chosen/chosen.order.jquery.min.js', array( 'jquery-ui-widget' ), '1.2.1', true );
		wp_register_script( 'cdhl-jquery-cars', trailingslashit( CDHL_URL ) . 'js/cars.js', array(), CDHL_VERSION, true );
		wp_register_script( 'cardealer-google-maps-apis', 'https//maps.googleapis.com/maps/api/js?key=' . $google_maps_api_key . '&libraries=drawing,places', array(), CDHL_VERSION, true );
		wp_register_script( 'cdhl-google-location-picker', trailingslashit( CDHL_URL ) . 'js/google-map/locationpicker/locationpicker.jquery.js', array( 'jquery', 'cardealer-google-maps-apis' ), '0.1.16', true );
		wp_register_script( 'cdhl-jquery-helper-admin', trailingslashit( CDHL_URL ) . 'js/cardealer-helper-admin.js', array( 'jquery-ui-core', 'jquery-ui-dialog', 'jquery-ui-autocomplete' ), CDHL_VERSION, true );

		if ( class_exists( 'ReduxFramework' ) ) {
			if ( isset( $_GET['cd_section'] ) && 'sample_data' === $_GET['cd_section'] ) {
				// Code for redux framework to set sample data tab active.
				$redux_sample_data_tab = "
				var tabID = jQuery('.redux-group-menu li.cd_sample_data').attr('id');
				var cd_tabID = tabID.slice(0, tabID.indexOf('_'));
				jQuery.cookie(
					'redux_current_tab', cd_tabID, {
						expires: 7,
						path: '/'
					}
				);";

				wp_add_inline_script( 'redux-js', $redux_sample_data_tab );
			}

			// Localize script for redux options search.
			$cdhl_redux_search_options = cdhl_redux_search_options();
			if ( $cdhl_redux_search_options ) {
				wp_localize_script( 'cdhl-jquery-helper-admin', 'cardealer_search_config', cdhl_redux_search_options() );
			}
		}

		wp_localize_script(
			'cdhl-jquery-helper-admin',
			'cdhl',
			array(
				'ajaxurl'           => admin_url( 'admin-ajax.php' ),
				'cdhl_url'          => CDHL_URL,
				'file_upload_nonce' => wp_create_nonce( 'file_upload' ),
			)
		);

		// Add message for pdf brochare.
		wp_localize_script(
			'cdhl-jquery-cars',
			'cars_pdf_message',
			array(
				'pdf_generated_message' => wp_kses(
					sprintf(
						'<div id="generate-pdf-notice" class="notice notice-success"><p>%1$s</p></div>',
						__( 'PDF generated successfully. Generated PDF is assigned to the <strong>PDF Brochure</strong> field.', 'cardealer-helper' )
					),
					array(
						'div'    => array(
							'id'    => true,
							'class' => true,
						),
						'p'      => array(),
						'strong' => array(),
					)
				),
				'download_pdf_str'      => esc_html__( 'Download PDF', 'cardealer-helper' ),
			)
		);

		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-widget' );
		wp_enqueue_script( 'jquery-ui-droppable' );
		wp_enqueue_script( 'jquery-ui-accordion' );
		wp_enqueue_script( 'jquery-ui-sortable' );
		wp_enqueue_script( 'jquery-ui-tooltip' );
		wp_enqueue_script( 'jquery-ui-tabs' );
		wp_enqueue_script( 'chosen' );
		wp_enqueue_script( 'chosen-order' );
		wp_enqueue_script( 'jquery-confirm' );
		wp_enqueue_script( 'cdhl-jquery-helper-admin' );

		// CSS.
		wp_enqueue_style( 'cdhl-css-helper-admin', trailingslashit( CDHL_URL ) . 'css/cardealer-helper-admin.css', array(), CDHL_VERSION );
		wp_enqueue_style( 'jquery-ui', trailingslashit( CDHL_URL ) . 'css/jquery-ui/jquery-ui.min.css', array(), '1.11.4' );
		wp_enqueue_style( 'chosen', trailingslashit( CDHL_URL ) . 'css/chosen/chosen.min.css', array(), '1.7.0' );
		wp_enqueue_style( 'jquery-confirm-bootstrap' );
		wp_enqueue_style( 'jquery-confirm' );
		wp_enqueue_style( 'cdhl-css-redux_admin', trailingslashit( CDHL_URL ) . 'css/cardealer_redux.css', array(), CDHL_VERSION );
	}
}
