<?php
/**
 * Visual Composer Shortcode
 *
 * @author  TeamWP @Potenza Global Solutions
 * @package car-dealer-helper/functions
 * @version 1.0.0
 */

if ( ! function_exists( 'cdhl_shortcodes_loader' ) ) {
	/**
	 * Shortcodes Loader
	 */
	function cdhl_shortcodes_loader() {
		$shortcodes_path = trailingslashit( CDHL_PATH ) . 'includes/shortcodes/';
		if ( is_dir( $shortcodes_path ) ) {

			include $shortcodes_path . 'class-cdhl-abstract-shortcode.php';

			// shortcodes List.
			$shortcodes = array(
				$shortcodes_path . 'button.php',
				$shortcodes_path . 'popup.php',
				$shortcodes_path . 'call-to-action.php',
				$shortcodes_path . 'cars_custom_filters.php',
				$shortcodes_path . 'cars-condition-carousel.php',
				$shortcodes_path . 'cars-search.php',
				$shortcodes_path . 'cars-type-search.php',
				$shortcodes_path . 'clients.php',
				$shortcodes_path . 'counter.php',
				$shortcodes_path . 'custom-menu.php',
				$shortcodes_path . 'feature-box.php',
				$shortcodes_path . 'icon.php',
				$shortcodes_path . 'image-slider.php',
				$shortcodes_path . 'list.php',
				$shortcodes_path . 'multi_tab.php',
				$shortcodes_path . 'newsletter.php',
				$shortcodes_path . 'opening_hours.php',
				$shortcodes_path . 'our-team.php',
				$shortcodes_path . 'pgs-cars-carousel.php',
				$shortcodes_path . 'quick_links.php',
				$shortcodes_path . 'recent-posts.php',
				$shortcodes_path . 'section_title.php',
				$shortcodes_path . 'share.php',
				$shortcodes_path . 'social_icons.php',
				$shortcodes_path . 'space.php',
				$shortcodes_path . 'testimonials.php',
				$shortcodes_path . 'timeline.php',
				$shortcodes_path . 'vc_row.php',
				$shortcodes_path . 'vertical_multi_tab.php',
				$shortcodes_path . 'video.php',
				$shortcodes_path . 'video-slider.php',
				$shortcodes_path . 'financing-calculator.php',
			);

			$can_use_vehicle_detail_shortcodes = false;
			if ( is_admin() ) {
				global $pagenow;
				if (
					'post.php' === $pagenow
					&& (
						(
							( isset( $_GET['action'] ) && 'edit' === $_GET['action'] )
							&& ( isset( $_GET['post'] ) && ! empty( $_GET['post'] ) && 'cardealer_template' === get_post_type( $_GET['post'] ) )
						)
						|| ( isset( $_GET['action'] ) && 'cardealer_templates_new_post' === $_GET['action'] )
						|| (
							( isset( $_GET['vc_action'] ) && 'vc_inline' === $_GET['vc_action'] )
							&& ( isset( $_GET['post_id'] ) && ! empty( $_GET['post_id'] ) && 'cardealer_template' === get_post_type( $_GET['post_id'] ) )
						)
					)
				) {
					$can_use_vehicle_detail_shortcodes = true;
				}
			} else {
				$can_use_vehicle_detail_shortcodes = true;
			}

			$can_use_vehicle_detail_shortcodes = true;

			// Cars detail shortcode
			$vehicle_detail_shortcodes = array(
				$shortcodes_path . 'vehicle-attribute.php',
				$shortcodes_path . 'vehicle-attributes.php',
				$shortcodes_path . 'vehicle-breadcrumb.php',
				$shortcodes_path . 'vehicle-buttons.php',
				$shortcodes_path . 'vehicle-compare-button.php',
				$shortcodes_path . 'vehicle-fuel-efficiency.php',
				$shortcodes_path . 'vehicle-gallery.php',
				$shortcodes_path . 'vehicle-wide-gallery.php',
				$shortcodes_path . 'vehicle-meta.php',
				$shortcodes_path . 'vehicle-price.php',
				$shortcodes_path . 'related-vehicles.php',
				$shortcodes_path . 'vehicle-review.php',
				$shortcodes_path . 'vehicle-share.php',
				$shortcodes_path . 'vehicle-short-description.php',
				$shortcodes_path . 'vehicle-subtitle.php',
				$shortcodes_path . 'vehicle-tabs.php',
				$shortcodes_path . 'vehicle-title.php',
				$shortcodes_path . 'vehicle-video-button.php',
			);

			if ( $can_use_vehicle_detail_shortcodes ) {
				$shortcodes = array_merge(
					$shortcodes,
					$vehicle_detail_shortcodes
				);
			}

			if ( cdhl_plugin_active_status( 'cardealer-promocode/cardealer-promocode.php' ) ) {
				$shortcodes = array_merge(
					$shortcodes,
					array(
						$shortcodes_path . 'promocode.php',
						$shortcodes_path . 'promocode-image.php',
					)
				);
			}

			if ( class_exists( 'CDFS_Wishlist' ) ) {
				$shortcodes = array_merge(
					$shortcodes,
					array(
						$shortcodes_path . 'vehicle-wishlist-button.php',
						$shortcodes_path . 'vehicle-seller-contact.php',
						$shortcodes_path . 'vehicle-seller-email.php',
						$shortcodes_path . 'vehicle-seller-whatsapp.php',
						$shortcodes_path . 'vehicle-seller-info.php',
						$shortcodes_path . 'class-cdfs-dealers-shortcode.php',
					)
				);
			}

			$shortcodes = apply_filters( 'cdhl_shortcodes_loader', $shortcodes );
			if ( ! empty( $shortcodes ) ) {
				foreach ( $shortcodes as $shortcode ) {
					include $shortcode;
				}
			}
		}
	}
}

cdhl_shortcodes_loader();

