<?php
/**
 * CarDealer Vehicle Fuel Efficiency Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_fuel_efficiency', 'cdhl_vehicle_fuel_efficiency_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_fuel_efficiency_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id'    => uniqid( 'cd_vehicle_fuel_efficiency' ),
			'element_title' => esc_html__( 'Fuel Efficiency', 'cardealer-helper' ),
			'title'         => esc_html__( 'Fuel Economy Rating', 'cardealer-helper' ),
			'description'   => esc_html__( 'Actual rating will vary with options, driving conditions, driving habits and vehicle condition', 'cardealer-helper' ),
			'css'           => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	$city_mpg      = get_post_meta( $post_id, 'city_mpg', true );
	$highway_mpg   = get_post_meta( $post_id, 'highway_mpg', true );
	$wrapper_class = 'cd-vehicle-fuel-efficiency' . vc_shortcode_custom_css_class( $atts['css'], ' ' );

	if ( ! $city_mpg && ! $highway_mpg ) {
		return;
	}

	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<?php
		if ( $atts['element_title'] ) {
			?>
			<h6 class="vehicle-element-title"><?php echo esc_html( $atts['element_title'] ); ?></h6>
			<?php					
		}
		?>
		<div class="details-form contact-2 details-weight">
			<div class="fuel-efficiency-detail">
				<?php
				if ( $atts['title'] ) {
					?>
					<div class="heading">
						<h6><?php echo esc_html( $atts['title'] ); ?></h6>
					</div>
					<?php
				}
				?>
				<div class="row">
					<?php
					if ( $city_mpg ) {
						?>
						<div class="col-xs-4">
							<label><?php echo esc_html__( 'City', 'cardealer-helper' ); ?></label>
							<span class="city_mpg"><?php echo esc_html( $city_mpg ); ?></span>
						</div>
						<?php
					}
					?>
					<div class="col-xs-4">
						<i class="glyph-icon flaticon-gas-station fa-3x"></i>
					</div>
					<?php
					if ( $highway_mpg ) {
						?>
						<div class="col-xs-4">
							<label><?php echo esc_html__( 'Highway', 'cardealer-helper' ); ?></label>
							<span class="highway_mpg"><?php echo esc_html( $highway_mpg ); ?></span>
						</div>
						<?php
					}
					if ( $atts['description'] ) {
						?>
						<div class="col-sm-12">
							<?php echo esc_html( $atts['description'] ); ?>
						</div>
						<?php
					}
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_fuel_efficiency_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {
		
		$params = array(
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Element Title', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter element title here', 'cardealer-helper' ),
				'param_name'  => 'element_title',
				'value'       => esc_html__( 'Fuel Efficiency', 'cardealer-helper' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Title', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter title here', 'cardealer-helper' ),
				'param_name'  => 'title',
				'value'       => esc_html__( 'Fuel Economy Rating', 'cardealer-helper' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Description', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter description here', 'cardealer-helper' ),
				'param_name'  => 'description',
				'value'       => esc_html__( 'Actual rating will vary with options, driving conditions, driving habits and vehicle condition', 'cardealer-helper' ),
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);
		
		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Fuel Efficiency', 'cardealer-helper' ),
				'description'             => esc_html__( 'Vehicle Fuel Efficiency', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_fuel_efficiency',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_fuel_efficiency' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_fuel_efficiency_shortcode_vc_map' );
