<?php
/**
 * CarDealer Vehicle Title Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_title', 'cdhl_vehicle_title_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_title_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id' => uniqid( 'cd_vehicle_title' ),
			'title_tag'  => 'h2',
			'transform'  => 'uppercase',
			'css'        => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	$wrapper_class = 'cd-vehicle-title' . vc_shortcode_custom_css_class( $atts['css'], ' ' );
	$wrapper_class .= ' text-transform-' . $atts['transform'];
	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<<?php echo esc_attr( $atts['title_tag'] ); ?> class="vehicle-title"><?php echo get_the_title( $post_id ); ?></<?php echo esc_attr( $atts['title_tag'] ); ?>>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_title_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {
		
		$params = array(
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Title Tag', 'cardealer-helper' ),
				'value'       => array(
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
				),
				'std'         => 'h2',
				'param_name'  => 'title_tag',
				'description' => esc_html__( 'Select title tag.', 'cardealer-helper' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Title transform', 'cardealer-helper' ),
				'value'       => array(
					esc_html__( 'Capitalize', 'cardealer-helper' ) => 'capitalize',
					esc_html__( 'Uppercase', 'cardealer-helper' )  => 'uppercase',
					esc_html__( 'Lowercase', 'cardealer-helper' )  => 'lowercase',
				),
				'std'         => 'uppercase',
				'param_name'  => 'transform',
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);
		
		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Title', 'cardealer-helper' ),
				'description'             => esc_html__( 'Vehicle Title', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_title',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_title' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_title_shortcode_vc_map' );
