<?php
/**
 * Adds Vehicle Make Widget.
 *
 * @package car-dealer-helper/widgets
 * @version 1.9.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * CDHL_Widget_Vehicle_Make_Logos class.
 *
 * @extends CDHL_Widget
 */
class CDFS_Widget_Vehicle_Seller_Info extends CDHL_Widget {

	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		$this->widget_id          = 'vehicle-seller-info';
		$this->widget_name        = esc_html__( 'CDFS - Vehicle Seller Info', 'cardealer-helper' );
		$this->widget_description = esc_html__( 'Display vehicle seller info.', 'cardealer-helper' );
		$this->widget_cssclass    = 'widget-cdfs-vehicle-seller-info';
		$this->settings           = array(
			'widget_notice' => array(
				'type'        => 'notice',
				'notice_type' => 'info',
				'label'       => esc_html__( 'Widget Notice', 'cardealer-helper' ),
				'message'     => esc_html__( 'This widget will display only on the vehicle details post (post type: cars).', 'cardealer-helper' ),
			),
			'show_title' => array(
				'type'        => 'checkbox',
				'std'         => 0,
				'label'       => esc_html__( 'Show Title', 'cardealer-helper' ),
			),
			'dealer_title'      => array(
				'type'  => 'text',
				'label' => esc_html__( 'Dealer Title', 'cardealer-helper' ),
				'std'   => esc_html__( 'Dealer Details', 'cardealer-helper' ),
				'desc'  => esc_html__( 'Enter the title to display the above seller information for users with the "Car Dealer" role.', 'cardealer-helper' ),
			),
			'user_title'      => array(
				'type'  => 'text',
				'label' => esc_html__( 'User Title', 'cardealer-helper' ),
				'std'   => esc_html__( 'User Details', 'cardealer-helper' ),
				'desc'  => esc_html__( 'Enter the title to display the above seller information for users other than the "Car Dealer" role.', 'cardealer-helper' ),
			),
			'show_phone' => array(
				'type'        => 'checkbox',
				'std'         => 1,
				'label'       => esc_html__( 'Show Phone', 'cardealer-helper' ),
				'is_disabled' => false,
			),
		);

		parent::__construct();
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {

		if ( ! is_singular( 'cars' ) ) {
			return;
		}


		$show_title   = ( isset( $instance['show_title'] ) ) ? $instance['show_title'] : 'no';
		$show_title   = filter_var( $show_title, FILTER_VALIDATE_BOOLEAN );
		$show_phone   = ( isset( $instance['show_phone'] ) ) ? $instance['show_phone'] : 'yes';
		$show_phone   = filter_var( $show_phone, FILTER_VALIDATE_BOOLEAN );
		$dealer_title = ( isset( $instance['dealer_title'] ) && ! empty( $instance['dealer_title'] ) ) ? $instance['dealer_title'] : esc_html__( 'Dealer Details', 'cardealer-helper' );
		$user_title   = ( isset( $instance['user_title'] ) && ! empty( $instance['user_title'] ) ) ? $instance['user_title'] : esc_html__( 'User Details', 'cardealer-helper' );
		$post_id      = get_the_ID();

		echo $args['before_widget']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE

		$seller_info_args = array(
			'wrapper_id'    => uniqid( 'cd-vehicle-seller-info-' ),
			'wrapper_class' => array(
				'cd-vehicle-seller-info',
				'cd-vehicle-seller-info-style-default',
			),
			'post_id'       => $post_id,
			'show_title'    => $show_title,
			'show_phone'    => $show_phone,
			'dealer_title'  => $dealer_title,
			'user_title'    => $user_title,
		);

		cdhl_vehicle_seller_info_html( $seller_info_args );

		echo $args['after_widget']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE
	}
}
