## Version 4.5.2 (November 07, 2022)
* Fixed: Fixed lead form popup issue.

## Version 4.5.1 (November 04, 2022)
* Fixed: Fixed fatal error when updating from very old version.
* Fixed: Fixed vehicle filter dropdown (with lot of items) formatting issue.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Various Minor code/formatting improvements and fixes.

## Version 4.5.0 (October 19, 2022)
* Added: Added PHP 8.1 compatibility.
* Fixed: Fixed issue where attribute is broken in cars list in some languages.
* Fixed: Fixed pagination issue when permalink structure is set to Plain.
* Fixed: Fixed PHP warnings and notices.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Various Minor code/formatting improvements and fixes.

## Version 4.4.0 (October 10, 2022)
* New: Redesigned "Add Car" page.
* New: Added new option to manage image upload limit in Add Car form.
* Fixed: Fixed the number of templates in the Car Dealer Templates dropdown.
* Fixed: Fixed fatal error in Pricing shortcode/widget when WooCommerce plugin is not installed/active.
* Fixed: Fixed fatal error in dealer dashboard when Subscriptio plugin is not installed/active.
* Fixed: Fixed delete icon showing in vehicle edit screen without review stamp selection.
* Fixed: Fixed vehicle image issue when editing a vehicle and adding an image that exceeds the permitted limit.
* Fixed: Fixed an issue removing vehicle review stamps when editing a vehicle.
* Fixed: Fixed an issue removing the vehicle PDF brochure when editing a vehicle.
* Fixed: Fixed an issue where the dealer/seller could enable "Pay Per Listing" items even after order cancellation.
* Fixed: Fixed button spacing issue in the WooCommerce My Account orders list.
* Fixed: Fixed P tag issue in vehicle excerpt on inventory page list view.
* Fixed: Fixed typo.
* Fixed: Fixed PHP warning.
* Updated: Updated code to display an alert when the selected image size is larger than the allowed size limit.
* Updated: Updated code to restrict negative or zero values in some theme option fields.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Various Minor code/formatting improvements and fixes.

## Version 4.3.1 (September 28, 2022)
* Fixed: Fixed header hide issue in the "Home Listing" home page.
* Fixed: Fixed carousel issue in the "Home Listing" home page.
* Updated: Updated WPML config file.
* Updated: Updated bundled plugins.
* Updated: Updated language files.

## Version 4.3.0 (September 15, 2022)
* New: Added "Advertise Item" feature for dealers/sellers to advertise their items.
* New: Added "Listing Payment" feature for dealers/sellers to pay for the new Add Car entry.
* New: Added vehicle view count in the Dealer Dashboard > My Items.
* Added: Added theme options for new features Advertise Item, Listing Payment.
* Added: Added theme option to show/hide dealer logo and name in the vehicle listing.
* Added: Added theme option to hide dealer name.
* Added: Added fix to display listing type in Dealer Dashboard > My Items for imported vehicles.
* Added: Added new label fields in the Fuel Economy widget.
* Fixed: Fixed issue with vehicle enable/disable when package subscription is expired.
* Fixed: Added fix for fatal error when Subscriptio plugin is not installed/activated.
* Fixed: Fixed fatal error when disabling the vehicle from the dealer dashboard.
* Fixed: Fixed listing layout in Dealer Dashboard vehicle listing.
* Fixed: fixed duplicate reCaptcha on the Add Car page when user is not logged in.
* Fixed: Fixed seller profile review design issue.
* Fixed: Fixed counter widget/shortcode not working correctly.
* Fixed: Fixed translation issue in the category list on the FAQ page.
* Fixed: Fixed "Add Car" button is not working in mobile view.
* Fixed: Fixed "Buy Online" button is not working in mobile view.
* Fixed: Fixed fatal error when disabling the vehicle from the dealer dashboard.
* Fixed: Fixed close icon for images on edit car page.
* Fixed: Fixed Redux Framework deprecated functions.
* Fixed: Fixed formatting issue on the "Sold Car" template.
* Fixed: Fixed listing type for old items or items added from the backend or import process.
* Fixed: Fixed vehicle enable/disable issue in the dealer dashboard for vehicles added by import and VINQuery.
* Fixed: Fixed button formatting issue on various WooCommerce - My Account pages.
* Fixed: Fixed vehicle enable/disable issue when subscription expires and vehicle status changes.
* Fixed: Fixed error message when enabling/disabling vehicle in the dealer dashboard.
* Fixed: Fixed vehicle listing formatting issue in Dealer Dashboard when listing layout is Grid.
* Fixed: Fixed vehicle listing formatting issue in seller profile
* Fixed: Fixed PHP Notice.
* Fixed: Fixed typo.
* Fixed: Fixed text domain.
* Updated: Updated backend dealer profile editing.
* Updated: Updated currency list and symbols.
* Updated: Made financial calculator error messages translatable.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Various Minor code/formatting improvements and fixes.

## Version 4.2.1 (June 07, 2022)
* Fixed: Fixed JS issue in v4.2.0.

## Version 4.2.0 (June 04, 2022)
* Added: Added dealer list shortcode.
* Fixed: Fixed PHP notice.
* Fixed: String translation issues.
* Fixed: Fixed minor formatting in the Car Dealer Studio.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Various Minor code/formatting improvements and fixes.

## Version 4.1.0 (May 27, 2022)
**Major CDFS plugin reconstruction to integrate new Dealer Dashboard, Public Profile, and Modern UI.**
* Added: Added new, improved, and advanced Dealer Dashboard.
* Added: Added new Wishlist feature.
* Added: Added new Wishlist in the dealer dashboard.
* Added: Added new Subscription list in the dealer dashboard.
* Added: Added new Profile management in the dealer dashboard.
* Added: Added new settings management in the dealer dashboard.
* Added: Added new public profile for dealer/sellers to display vehicles, reviews, location, social profiles, and contact details.
* Added: Added new dealer review feature for dealers.
* Added: Added new options to manage dealer dashboard settings.
* Added Widgets, WPBakery Shortcodes, and Elementor Widgets for Vehicle Seller WhatsApp Button.
* Added Widgets, WPBakery Shortcodes, and Elementor Widgets for Vehicle Seller Email Button.
* Added Widgets, WPBakery Shortcodes, and Elementor Widgets for Vehicle Seller Info.
* Added Widgets, WPBakery Shortcodes, and Elementor Widgets for Vehicle Seller Contact Form.
* Added: Added new theme options for Dealer Dashboard.
* Fixed: Fixed PHP notices.
* Fixed: Fixed fatal error when WooCommerce is not installed/activated.
* Fixed: Fixed typo and string translation.
* Fixed: Fixed comment form design issue on WooCommerce product page.
* Fixed: Fixed button design issue on the WooCommerce order detail page.
* Fixed: Fixed Buy Online button not working correctly on the vehicle detail page.
* Fixed: Fixed WooCommerce Order Tracking form design issue.
* Fixed: Fixed range-slider in vehicle filter not working correctly on mobile devices.
* Fixed: Fixed price display issue in the price range-slider.
* Fixed: Fixed text-domain.
* Fixed: Fixed Financing Calculator button issue in responsive view.
* Fixed: Fixed reCAPTCHA loading issue.
* Fixed: Fixed footer social icon display issue.
* Removed: Removed unused theme options.
* Updated: Updated dashboard into new and modern Dealer Dashboard.
* Updated: Updated WPML config file.
* Updated: Updated language files.
* Updated: Updated bundled plugins.
* Various Minor code/formatting improvements and fixes.

## Version 4.0.0 (April 11, 2022)
* New: "Car Dealer Templates", the WPBakery/Elementor template builder for vehicle pages.
* New: "Vehicle Detail" page builder in the "Car Dealer Templates".
* New: "Vehicle Detail Mobile" page builder in the "Car Dealer Templates".
* Added: New theme options section "Car Dealer Templates" to manage templates visibility on the vehicle detail page.
* Added: New theme option 'Vehicle layout Type' for vehicle single page template.
* Added: New theme option 'Hide Page Header' for vehicle single page template.
* Added: New option to select the vehicle template for individual vehicles.
* Added: Added hook to filter auto-complete search arguments.
* Added: Vehicle data support in the Yoast SEO.
* Added: New elements (WPBakery Shortcodes/Elementor Widgets) for vehicle detail page builder.
* Fixed: Elementor deprecated functions/methods notices.
* Fixed: Visibility issue with client logo images when the lazy load is enabled.
* Fixed: Print button/link not working on the vehicle detail page.
* Fixed: The reCAPTCHA is not working in lead forms on the vehicle detail page.
* Fixed: Social security number label issue in the financial lead form.
* Fixed: Breadcrumb title visibility issue on the inventory page.
* Fixed: Vehicle makes visibility issue in the Vehicle by Type widget Elementor.
* Fixed: Vehicle location tabs are not working.
* Fixed: Author page not displaying any author data.
* Fixed: Update the Owl Carousal lib to fix the broken structure in Firefox.
* Fixed: Fixed text domain.
* Updated: Updated language files.
* Updated: Updated bundled plugins.
* Various Minor code/formatting improvements and fixes.

## Version 3.9.1 (March 23, 2022)
* Fixed: Elementor deprecated functions/methods notices.
* Fixed: Map zoom level not working on the vehicle detail page.
* Fixed: "Owl Carousel" sliders design issue.
* Fixed: Stock is not updating properly for a vehicle for the "Sell Vehicle" feature.
* Updated: Updated bundled plugins.
* Various Minor code/formatting improvements and fixes.

## Version 3.9.0 (February 28, 2022)
* Added: Car Dealer Studio - To import the website sections with a single click for Elementor and WP Bakery builders.
* Added: Add new options to show/hide and change the "Read More" button label in the Call to Action shortcode/widget.
* Added: Added popup support for vehicle review stamps.
* Fixed: Image zoom not working in vehicle gallery on the vehicle detail page.
* Fixed: PHP Warnings and PHPCS issues.
* Fixed: Sortable not working for images in car front submission form.
* Fixed: Fixed login page alignment issue.
* Fixed: Fixed content display issue in Vehicles By Type shortcode/widget when Make tab is hidden.
* Updated: Added datepicker format support in the "Schedule Test Drive" lead form on the vehicle detail page.
* Updated: Separated VINQuery and PDF Generator from bundled plugins as add-ons.
* Updated: Minor JS improvements.
* Updated: Updated language file
* Updated: Updated bundled plugins.
* Various Minor code/formatting improvements and fixes.

## Version 3.8.2 (February 5, 2022)
* Fixed: Fixed slider arrow hide issue on Cars Condition Tabs shortcode.
* Fixed: Fixed lazyload not working properly.
* Fixed: Fixed content display issue in Vehicles By Type shortcode/widget when Make tab is hidden.
* Fixed: Fixed PHP notice in Elementor widget when lazyload is enabled.
* Removed: Removed unwanted codes.
* Updated: Set loop true by default in owl-carousel when lazyload enabled.
* Updated: Updated language files.
* Updated: Updated bundled plugins.
* Various Minor code/formatting improvements and fixes.

## Version 3.8.1 (February 1, 2022)
* Added: Added new parameter Partial VIN theme options for VINQuery.
* Updated: Updated language files.
* Updated: Updated bundled plugins.

## Version 3.8.0 (February 1, 2022)
* Added: Datepicker format support in the "Schedule Test Drive" lead form on the vehicle detail page.
* Added: Minified versions of CSS/JS files.
* Fixed: Broken structure in mobile view for vehicle inventory 'list' listing layout.
* Fixed: Slider-related elements not working properly in popup shortcode/widget for responsive layout.
* Fixed: Filters not working properly on the inventory page.
* Fixed: Car inquiry widget not working properly.
* Fixed: In 'Car Dealer - Vehicle Categories' widget 'Show hierarchy' option is not working.
* Fixed: 'Feature box slider' shortcode/Widget Style 5,6 hover color issue.
* Fixed: Fixed invalid result count on the category page when a filter with/without ajax.
* Fixed: Various console errors.
* Fixed: Vehicle filter issue on the vehicle category archive page redirecting to inventory page.
* Fixed: Fixed hooks for child theme extendible function added inside function_exists.
* Fixed: Page section padding issue Fix on top in Inventory Page.
* Fixed: List View spacing issue on Inventory Page.
* Fixed: Filters area design issue when 'Lazy Load' layout selected.
* Fixed: Broken header during page loading.
* Fixed: Nice Select dropdown issue when text is long.
* Fixed: Cart RTL design issue in the header.
* Fixed: Breadcrumb text break issue on the vehicle detail page.
* Fixed: Regular price not showing properly on compare popup when product is on sale.
* Fixed: Broken design when tabs clicked multiple times in 'Vehicles By Type' shortcode/Widget.
* Fixed: The first filter attribute is not visible when the year range slider is enabled in the 'Custom Filters' shortcode/Widget.
* Fixed: 'Custom Filters' shortcode/widget padding issue when Wide option selected.
* Updated: Assets ( CSS/JS ) separated and applied only to relevant sections/pages to improve the page speed and performance of the theme.
* Updated: FontAwesome from v5.12.0 to v5.15.4
* Updated: Woocommerce Order Page design Updated.
* Updated: 'Add Car' page design update.
* Updated: 2 Columns set for vehicle listing page in Tablet view.
* Updated: Updated language files.
* Various Minor code/formatting improvements and fixes.

## Version 3.7.1 (January 7, 2022)
* Fixed: Duplicate vehicle listing issue in lazyload layout for inventory page.
* Fixed: Filters not working properly on the inventory page.
* Fixed: Breadcrumb Enable/disable option not working properly in car detail page.
* Fixed: Broken structure when lazyload layout enabled for inventory page.
* Fixed: Image not visible in admin area of inventory archive page for PHP 8.0
* Updated: Updated bundled plugins.
* Various Minor code/formatting improvements and fixes.

## Version 3.7.0 (December 31, 2021)
* Added: New theme options "Listing Sidebar" and "Filters/Widgets in Off-canvas" for managing the sidebars for the inventory page.
* Added: Add new theme option "Enable Breadcrumb For Mobile" to enable/disable breadcrumb in the archive page for mobile view.
* Added: Added logo and sticky logo theme options in the WPML String Translation.
* Fixed: Page title issue on vehicle listing page when assigned as front page.
* Fixed: Compare popup broken layout issue in the mobile view.
* Fixed: Undefined function fatal error when Car Dealer theme is not active.
* Fixed: Link issue in the Vehicles By Type shortcode/element when permalink is not configured.
* Fixed: Added link on the Related Posts images.
* Fixed: All social icons are not visible in the team card in shortcode/Widget and team template.
* Updated: Remove unwanted listing layouts from the theme options for the inventory page. The user now can set Grid, List, and masonry layout and set sidebar using the "Listing Sidebar" theme option.
* Updated: Remove the Google+ share options as Google no longer supports it.
* Updated: Filter design update on inventory page layout, add sorting feature in mobile view same like a desktop. Now the user can do sorting as well while ordering by parameter.
* Updated: Update the sample data based on a new layout for inventory.
* Updated: Listing page Layout change, Price range slider removed from the top filters, user can set the filter widget in the sidebar.
* Updated: Updated language files.
* Updated: Updated bundled plugins.
* Various Minor code/formatting improvements and fixes.

## Version 3.6.0 (November 27, 2021)
* Added: Added counter speed field in the Counter shortcode.
* Added: Added option to change the button label and modal title for lead forms.
* Added: Added option to change field labels in Financial Calculator widget.
* Fixed: Fixed header logo design issue in some mobile devices.
* Fixed: Fixed Page Header display issue on the Home Inventory page where it's displaying when it's set to hide.
* Fixed: Fixed theme options design issue with the recent release of the Redux framework plugin.
* Fixed: Fixed formatting issue in Address content Text Widget.
* Fixed: Fixed row height issue in the vehicle compare table.
* Fixed: Fixed bug in the speed field in Counter shortcode.
* Fixed: Fixed text-domain.
* Fixed: Fixed string translation.
* Removed: Removed unwanted code left in previous updates.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Various Minor code/formatting improvements and fixes.

## Version 3.5.0 (October 12, 2021)
* Added: Added theme option to change the "Show Sidebar' label in the vehicle listing mobile view.
* Fixed: Fixed missing "Vehicle Listing Hover Effect" option in the inventory page settings.
* Fixed: Fixed issue with Potenza Custom Filters not working correctly with WPBakery.
* Fixed: Added fix to hide Price Range Slider widget from desktop view to prevent double price range slider.
* Fixed: Fixed fuzzy translations in language files in theme and theme's plugins.
* Fixed: Fixed vehicle gallery issue not displaying thumbnails in mobile view when layout 3 is selected for desktop view.
* Fixed: Fixed double button in the price range slider in the filter sorting section.
* Fixed: Fixed issue in the mobile layout when vehicle listing style is set to lazyload.
* Fixed: Fixed page breadcrumb issue on the vehicle listing mobile view.
* Fixed: Fixed header display issue on mobile when page header is set to the boxed header.
* Fixed: Fixed code where off-canvas is closing on filter selection in the vehicle listing mobile view.
* Fixed: Fixed issue where disabling "Add to Compare" on the vehicle detail page is not working.
* Fixed: Fixed issue with Mileage filter where it's not displaying selected value correctly.
* Fixed: Fixed typo.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Various minor code/formatting improvements and fixes.

## Version 3.4.0 (October 1, 2021)
* New: Added new layout "Modern 1" for desktop view for the vehicle details page.
* New: Added a new vehicle detail page mobile layout. The theme will display the new mobile layout by default in the mobile devices for all the vehicle detail page layouts.
* New: Added a new vehicle listing mobile layout with off-canvas filters and widgets. The theme will display the new mobile layout by default on the mobile devices for all vehicle listing layouts.
* New: Added new "Additional pages importer" in the "Sample Data" to import additional and shortcode/widgets demo pages.
* New: Added new Popup WPBakery shortcode and Elementor widget.
* Added: Added link support in the address in the topbar.
* Added: Added link support in the WhatsApp number in the topbar.
* Added: Added new theme options for new detail page layout "Modern 1" for desktop view.
* Added: Added a new theme option for the mobile layout to choose and order sections.
* Added: Added new theme option for the vehicle listing mobile layout to display widgets/filters in the off-canvas.
* Added: Added theme option to set custom image size vehicle listing and vehicle detail page.
* Added: Added new theme option to set header title on the vehicle details page.
* Added: Added a new option to choose the vehicle title's location on the vehicle details page.
* Added: Added new theme options to change tab labels on the vehicle details page.
* Fixed: Fixed undefined index notice when editing widget in new Gutenberg based widget editor.
* Fixed: Fixed issue in the theme setup wizard when two page-builder plugins are active.
* Fixed: Fixed breadcrumb title issue on Add Car page when the user is not login.
* Fixed: Added fix to change dealer in the vehicle editor in the admin panel.
* Fixed: Fixed icon issue in Trade-in Appraisal button in Elementor.
* Fixed: Fixed slider loading issue on the vehicle detail page.
* Fixed: Fixed blog image resize issue.
* Fixed: Fixed responsive menu issue.
* Fixed: Fixed issue with logo height when Imgify plugin used for WEBP image format.
* Fixed: Fixed responsive logo issue in Logo Center header.
* Fixed: Fixed Trade-in Appraisal form close button issue.
* Fixed: Fixed slider responsive view.
* Fixed: Fixed detail page responsive view.
* Fixed: Fixed notice in testimonial shortcode/widget when profile image is not set.
* Fixed: Fixed multiple slider range not working on a single page.
* Fixed: Fixed the social icons in the top bar not displaying properly when rearranged.
* Updated: Updated the "Sample Data" import flow to reimport home pages. If the page already exists, the theme will not reimport it. If you want to import the page, please rename the page before importing.
* Updated: Updated code to make open tab collapsible in the theme options.
* Updated: Updated code to re-import sample pages.
* Updated: Updated code for H tag improvement.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Various minor code/formatting improvements and fixes.

## Version 3.3.0 (August 20, 2021)
* Added: Created separate addon plugins for some theme features like PDF Generator, Promo Code, Import/export, Car Gurus, and Geo-Fencing.
* Added: Added title support in the Frontend Submission.
* Fixed: Fixed footer button color issue.
* Fixed: Fixed cour client carousel issue.
* Fixed: Fixed Contact Form 7 CSS/JS loading issue when Elementor is active.
* Fixed: Fixed issue in vehicle detail page where Google Map not showing with default values from Theme Options.
* Fixed: Fixed location tab on vehicle detail page not showing default location from Theme Options.
* Fixed: Fixed theme name and version in the Theme Options header.
* Fixed: Fixed issue with "Features & Options" and "Technical" tabs showing the same content.
* Updated: Moved some menus (for Promo Code, Geo-Fencing, and Import/export logs) under Car Dealer > More Feature.
* Updated: Updated icon for theme-options subsections.
* Updated: Redesigned and re-arranged Theme Options to make it clean and short.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Removed: Removed built-in Google Analytics feature permanently.
* Various Minor code/formatting improvements and fixes.

## Version 3.2.0 (August 11, 2021)
* Added: Added "Trade-In Appraisal" form.
* Added: Added theme option for "Trade-In Appraisal" lead form.
* Added: Added option to select attributes in the "Potenza Vehicles Search" shortcode.
* Added: Added "Label" options for both types in the "Potenza Vehicles By Type" shortcode.
* Added: Added image size selection option in the vehicle listing shortcodes.
* Added: Added option to hide price range field in the "Potenza Custom Filters" shortcode.
* Added: Added option to show/hide location field on the front in the "Potenza Vehicles Search" shortcode.
* Added: Added option to show/hide types in the "Potenza Vehicles By Type" shortcode.
* Fixed: Fixed "Recent Comments" widget design issue.
* Fixed: Fixed Vehicle Search shortcode design issue.
* Fixed: Fixed color picker issue in the Redux Options.
* Fixed: Fixed sell vehicle online fields in the frontend form.
* Fixed: Fixed theme options issue due to recent Redux Framework plugin releases.
* Fixed: Fixed typo.
* Fixed: Fixed various lead form design issues.
* Fixed: Fixed year and price range slider's alignment issue.
* Fixed: Removed duplicate search button label field in the Potenza Vehicles Search shortcode
* Fixed: Fixed typo.
* Updated: Added names for theme's custom image sizes to display in the Gutenberg blocks and “Add Image” modal.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Various Minor code/formatting improvements and fixes.

## Version 3.1.0 (July 24, 2021)
* Added: Added Review Stamps meta fields and removed Review Stamps taxonomy.
* Added: Added additional vehicle lat, lng, and address meta.
* Added: Added sell vehicle online functionality.
* Added: Added theme options for sell vehicles online.
* Fixed: Fixed Additional Attribute link in the theme options.
* Fixed: Fixed error on the front when import template in Elementor Pro.
* Fixed: Fixed image size issue in mobile view.
* Fixed: Fixed issue when address is empty on the vehicle detail page.
* Fixed: Fixed loader issue in Theme Options Demo Import.
* Fixed: Fixed minor design issue on the vehicle listing page.
* Fixed: Fixed price range issue in filters when adding vehicle from the frontend.
* Fixed: Fixed review stamp showing on the filter and compare filter selection.
* Fixed: Fixed review stamps issue in Related Vehicle responsive view.
* Fixed: Fixed shop page design issue.
* Fixed: Fixed sold image issue with Elementor.
* Fixed: Fixed typo.
* Fixed: Fixed vehicle condition and status not showing in related vehicles slider.
* Fixed: Fixed warning for the undefined key.
* Removed: Removed review stamps from compare.
* Updated: Add a condition to show/hide Sell car option based on theme option.
* Updated: Changed review stamp position in vehicle detail page.
* Updated: Updated WP All Import notice on CSV import page.
* Updated: Updated header and footer builder for Elementor Pro support.
* Updated: Updated register elementor locations for header and footer.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Various Minor code/formatting improvements and fixes.

## Version 3.0.0 (July 09, 2021)
* Added: Improvement in sample data import process.
* Added: Elementor page builder support.
* Added: New sample data for Elementor page builder similarly to WP Bakery.
* Added: 31 custom Elementor widgets.
* Added: 'Default demo' sample data for elementor.
* Added: 'Home 1' demo sample page for elementor.
* Added: 'Home 2' demo sample page for elementor.
* Added: 'Home 3' demo sample page for elementor.
* Added: 'Home 4' demo sample page for elementor.
* Added: 'Home 5' demo sample page for elementor.
* Added: 'Home 6' demo sample page for elementor.
* Added: 'Home 7' demo sample page for elementor.
* Added: 'Home 8' demo sample page for elementor.
* Added: 'Home 9' demo sample page for elementor.
* Added: 'Home 10' demo sample page for elementor.
* Added: 'Home Directory' demo sample page for elementor.
* Added: 'Car landing' demo sample page for elementor.
* Added: 'Car Service' demo sample page for elementor.
* Fixed: PHPCS issues.
* Fixed: Wrong escaping.
* Fixed: WP_Scripts::localize was called incorrectly
* Fixed: Insecure content issue in video slider shortcode/Widget.
* Fixed: Title Import issue for PDF templates during the sample data import.
* Fixed: Youtube video as background not working for page when WP Bakery is not active.
* Fixed: Plugin activation fail issue in the setup wizard.
* Fixed: Header - Max mega menu color customize issue fix.
* Fixed: Mobile menu glitch in responsive view on page load.
* Updated: Updated language files.
* Updated: Add options to choose the theme option and widget to import for the service page.
* Updated: Added option in the setup wizard to choose the page builder.
* Updated: Updated bundled plugins.
* Updated: Updated language files.
* Various Minor code/formatting improvements and fixes.

## Version 2.0.0 (June 19, 2021)
* Added: Added setting to manage Core (Built-in) Attributes labels. All the core/additional attributes are moved in Vehicle Inventory > Add/Edit Attributes.
* Added: Added Contact Form 7 mail-tag to add vehicle details in mails when using CF7 forms on the vehicle detail page.
* Added: Added new "Vehicle Categories" widget.
* Added: Added new "Vehicle Make (Brand) Logo" widget.
* Added: Added logo image in the Make attribute admin columns.
* Fixed: Fixed labels in various sections on the backend, frontend, mail as per new attributes structure.
* Fixed: Fixed various labels with singular and plural name issues.
* Fixed: Fixed issue in the mail with vehicle information.
* Fixed: Fixed translation issue with WPML.
* Fixed: Fixed label issue in PDF Generator and export fields.
* Fixed: Fixed WooCommerce imported not working correctly.
* Fixed: Fixed issue in vehicle compare where it's not showing price row correctly when there is no value.
* Fixed: Fixed translation Issue in Potenza Vehicle Search shortcode.
* Fixed: Fixed PDF Generator where Additional Attributes were not working correctly.
* Fixed: Fixed typo changes.
* Fixed: Fixed wrong text domain.
* Fixed: Fixed strings translation.
* Fixed: Fixed PHP 8 deprecated notices.
* Fixed: Vehicle listing page title is not working properly.
* Fixed: Added fix for the error in the Mileage attribute when there are no numeric values.
* Fixed: Tooltip not working after ajax call.
* Fixed: Fixed make widget feedback for searched make.
* Fixed: Singular and plural name issue for vehicle attribute.
* Fixed: Lazyload margin issue fix on the car inventory page.
* Fixed: Added fix for CF7 ajax form not working on vehicle single posts.
* Tweak: Moved all the core/additional attributes in Vehicle Inventory > Add/Edit Attributes.
* Tweak: Removed "Add New Attributes" menu in Vehicle Inventory in favor of "Add/Edit Attributes" menu.
* Tweak: Removed attributes from Vehicle Inventory Quick Edit.
* Tweak: Added support for translation in the CF7 form submission.
* Updated: Updated language files.
* Updated: Update lead form fields for translation in XML file.
* Updated: Updated bundled plugins.
* Various Minor code/formatting improvements and fixes.

## Version 1.10.1 (May 17, 2021)
* Fixed: Fixed additional attributes issue in vehicle filter.
* Updated: Updated bundled plugins.

## Version 1.10.0 (May 14, 2021)
* Added: Added "More Features" tab in the Car Dealer panel in the Dashboard.
* Added: Added various fixes for future update compatibility.
* Added: Added PDF Generator testing in the Car Dealer > Third-Party Testing.
* Fixed: Fixed PDF Generator to display error/notices.
* Fixed: Fixed height issue on inventory listing.
* Fixed: Fixed strings translation.
* Updated: Updated language files.
* Updated: Updated bundled plugins.
* Various other code/formatting improvements and fixes.

## Version 1.9.0 (Apr 30, 2021)
* Fixed: Fixed issue in CSV import.
* Fixed: Fixed notice in Site Health for PHP session open.
* Fixed: Fixed strings translation.
* Updated: Updated language files.
* Updated: Updated bundled plugins.
* Various other code/formatting improvements and fixes.

## Version 1.8.0 (Apr 23, 2021)
* Added: Added support for Admin Approval for new account registration.
* Added: Added theme option to set Vehicle Mileage range breakdown.
* Added: Added highest mileage value in the dropdown if maximum Vehicle Mileage range setting is less highest mileage value in attributes.
* Added: Added Label Color support vehicle condition attribute.
* Added: Added label color on vehicle condition taxonomy list table.
* Added: Added option in Potenza Vehicle Search shortcode to select conditions from vehicle condition attribute instead of default conditions.
* Added: Added vehicle title support in the vehicle export.
* Added: Added support (and theme option) to change field labels in the Custom/Lead Forms.
* Added: Added support to load default values from Site Settings for email, name, and subject in Custom/Lead Forms theme options.
* Added: Added custom label options in Potenza Vehicle Search shortcode for vehicle conditions.
* Added: Added Debug panel in the theme panel.
* Added: Added "Data Type" support in VINQuery import.
* Fixed: Fixed number slider, where it's showing the number in the wrong format.
* Fixed: Fixed phone number in header top bar to make it clickable.
* Fixed: Fixed active menu highlight issue.
* Fixed: Added function to replace emails in theme option with Site Settings email in Sample Data import process.
* Fixed: Fixed fields mapping issue when loading pre-mapped fields.
* Fixed: Fixed the mileage filter not working properly.
* Fixed: Fixed loader image display issue in various backend section.
* Updated: Moved "Custom Forms" settings to the "Lead Forms" tab.
* Updated: Updated field in "Email to Friend" form.
* Updated: Changed "<" to "≤" in the mileage dropdown option label.
* Updated: Updated notice/message in Vehicle CSV Import.
* Updated: Updated translation strings.
* Updated: Updated language files.
* Updated: Updated bundled plugins.
* Various other code/formatting improvements and fixes.

## Version 1.7.0 (Mar 13, 2021)
* Added: Added support to select fields on vehicle compare by drag-and-drop.
* Added: Added option to show/hide sections (with fields) in form on "Add Car" page.
* Added: Added new theme option to select a page as "Dealer Account" page.
* Added: Added new option to choose additional attributes to display on "Add Car" form.
* Fixed: Added fix for equal-height issue when vehicle inventory page is selected as Home page.
* Updated: Updated "Front Submission" theme option tabs with new options/fields.
* Updated: Theme options with instruction/notice.
* Updated: Language files.
* Updated: Updated bundled plugins.
* Various other code/formatting improvements and fixes.

## Version 1.6.0 (Feb 22, 2021)
* Added: New option page to add new attributes.
* Updated: Updated bundled plugins.
* Updated: Added hierarchical support in vehicle "Features & Options" attribute.
* Updated: Theme options with instruction/notice.
* Various other code/formatting improvements and fixes.

## Version 1.5.7 (Jan 26, 2021)
* Fixed: PDF generation issue with the Arabic language in the admin.
* Fixed: Google analytics issue with a script tag.
* Fixed: Redux Option CSS issue.
* Added: New option for display/hide 'Related Vehicle'.
* Updated: Updated bundled plugins.
* Various other code/formatting improvements and fixes.

## Version 1.5.6.3 (Nov 26, 2020)
* Fixed: Admin URL not working.
* Various other code/formatting improvements and fixes.

## Version 1.5.6.2 (Nov 18, 2020)
* Updated: Updated bundled plugins.
* Various other code/formatting improvements and fixes.

## Version 1.5.6.1 (Oct 07, 2020)
* Fixed: Header topbar link issues resolve.
* Fixed: Added fix to search form where it's not working correctly when the form is submitted directly.
* Fixed: Wordpress site health issue.
* Updated: Updated bundled plugins.
* Various other code/formatting improvements and fixes.

## Version 1.5.6 (Aug 01, 2020)
* Fixed: Filter not working properly based on a query string.
* Fixed: Broken theme options field for the latest version of the Redux framework plugin.
* Fixed: Theme options are not working with the latest version of the Redux framework plugin.
* Various other code/formatting improvements and fixes.

## Version 1.5.5.1 (July  15, 2020)
* Various other code/formatting improvements and fixes.

## Version 1.5.5 (July  10, 2020)
* Fixed PHPCS and escaping issues.
* Fixed: 'Potenza Vehicles By Type' shortcode not working correctly.
* Fixed: CSV import not working for the higher than 7.2 PHP version.
* Updated: Updated bundled plugins.
* Various other code/formatting improvements and fixes.

## Version 1.5.4.1 (July  01, 2020)
* Fixed: Plugin upgrade issues.

## Version 1.5.4 (June 30, 2020)
* Fixed PHPCS and escaping issues.
* Fixed: Map zoom issues.
* Fixed: Minor issue in the vehicle condition tab shortcode.
* Fixed: CSV import issues.
* Fixed: Google Analytics dashbord widget issues.
* Added: WPML support added for theme options.
* Added: Vehicle details page tabs hide/show option added.
* Updated: Updated bundled plugins.
* Updated: Language files.
* Various other code/formatting improvements and fixes.

## Version 1.5.3 (April 02, 2020)
* Updated: Language files.
* Various other code/formatting improvements and fixes.

## Version 1.5.2 (March 11, 2020)
* Fixed: Fixed "Warning" error in the Sample Data import panel.
* Updated: Updated bundled plugins.
* Various other code/formatting improvements and fixes.

## Version 1.5.1 (February 19, 2020)
* Fixed: Bundled plugin update issue.

## Version 1.5.0 (February 10, 2020)
* Fixed PHPCS.
* Added: Added Font Awesome 5 support.
* Added: Added layout color option in the Newsletter shortcode.
* Added: Added theme option for Back to Top button.
* Fixed: Added fix for shortcode filter dropdown issue.
* Fixed: Fixed Promo Code Message display issue.
* Fixed: Fixed input validation and sanitization.
* Fixed: Fixed inventory listing page title issue when selected custom page in the theme options.
* Fixed: Fixed inventory page title issue with same slug in different language in WPML.
* Fixed: Fixed multiple instances not working in the Multitab shortcode.
* Fixed: Fixed outdated WooCommerce templates.
* Fixed: Minor issue in the Video Slider shortcode.
* Tweak: Disabled hierarchical support from "Car Features & Options" taxonomy.
* Updated language translation files.
* Updated: Updated bundled plugins.
* Various other code/formatting improvements and fixes.

## Version 1.4.4 (December 14, 2019)
* Fixed: JavaScript error in WordPress 5.3.
* Updated: Updated bundled plugins.
* Various Minor code/formatting improvements and fixes.

## Version 1.4.3.3 (October 22, 2019)
* Updated: Bundled plugins to the latest version.
* Fixed: Masonry listing issue.
* Various Minor code/formatting improvements and fixes.

## Version 1.4.3.2 (July 29, 2019)
* Updated: Bundled plugins to the latest version.
* Various Minor code/formatting improvements and fixes.

## Version 1.4.3.1 (July 27, 2019)
* Fixed: WooCommerce function issue.
* Fixed: Menu shortcode issue.
* Updated: Car Dealer - Helper Library(V.1.2.6.1) Plugin bundled.
* Various Minor code/formatting improvements and fixes.

## Version 1.4.3 (July 27, 2019)
* Fixed: CSV import with vehicle status.
* Updated: Car Dealer - Helper Library(V.1.2.6) Plugin bundled.
* Various Minor code/formatting improvements and fixes.

## Version 1.4.2 (June 26, 2019)

* Fixed: String translation issues for 'Car Dealer - Front Submission' plugin.
* Fixed: Fixed Poylang plugin translation issue.
* Updated: Allow the all car 'Condition' to import during the 'Vehicle Import' import functionality.
* Fixed: Image size issue for Vehicles Carousel shortcode.
* Fixed: Translation issue for the footer social icons.
* Fixed: Language switcher design issue.
* Fixed: Car inventory listing page title issue.
* Updated: Car Dealer - Helper Library(V.1.2.5), Car Dealer - Front Submission(V.1.2.5), Advance custom fields pro(V5.8.1) and Plugin bundled.
* Various Minor code/formatting improvements and fixes.

## Version 1.4.1 (May 13, 2019)
* Added: Add vehicle button add in mobile(Front Submission).
* Fixed: Lazyload issue.
* Fixed: Design issues.
* Fixed: Vehicle category filter issue.
* Fixed: Reset filter issue in woocommerce single page variable product issue.
* Fixed: Vehicle location issue.
* Fixed: Plugin dependency.
* Fixed: Footer widget design issue.
* Updated: Car Dealer - Helper Library(V.1.2.4), Car Dealer - Front Submission(V.1.2.4), Advance custom fields pro(V5.7.13), Visual Composer(V5.7) Plugin bundled.
* Various Minor code/formatting improvements and fixes.

## Version 1.4 (January 21, 2019)
* Added: Vehicle classic list and classic grid style theme option.
* Added: Lazyload feature for images.
* Added: WhatsApp number option in Topbar.
* Added: Whatsapp share functionality.
* Added: Options for send dealer form emails(enable/disable mail formats).
* Added: PDF generator margin options - Top, Left, Right Bottom.
* Added: Theme option to activate dealer account(front submission plugin).
* Updated: Language files.
* Updated: Car Dealer - Helper Library(V.1.2.3), Car Dealer - Fronted Submission(V.1.2.3), Car Dealer - VINquery Import(V1.2) and Advance custom fields pro(V5.7.10) Plugin bundled.
* Optimized: Code and theme images.
* Fixed: Vehicle filter functionality with multi-language.
* Fixed: Sold vehicle page bugs.
* Fixed: Vehicles Carousel shortcode image issues with grid style.
* Fixed: Vehicles Search shortcode filter issue.
* Fixed: Client shortcode grid style issue.
* Fixed: VINQuery plugin import bugs.
* Fixed: Placeholder image responsive issue.
* Fixed: Price range step issue.
* Fixed: Max Mega Menu in mobile view issue.
* Fixed: Translation bug.
* Fixed: PHP Notice of get_the_excerpt function on the vehicle detail page.
* Fixed: RTL bugs.
* Fixed: Theme check plugin issues.
* Removed: WhatsApp URL theme option, additional code, and additional images.
* Various Minor code/formatting improvements and fixes.

## Version 1.3.3 (December 7, 2018)
* Fixed: Sold car page template bugs.
* Updated: Visual Composer(V5.6) Plugin bundled.

## Version 1.3.2 (November 17, 2018)
* Added: Theme options for select language switcher style vertical, horizontal and display styles.
* Added: Theme options for vehicle details page attributes to display and order.
* Added: Theme option to show/hide vehicle condition badges in the vehicle inventory list.
* Added: Theme option for WhatsApp link in site information theme options to display in topbar and footer.
* Added: Option to show/hide sold vehicles in Potenza Vehicles Conditions Tabs, Potenza Multi Tabs, Potenza Vehicle Carousel and Potenza Verticular Multi Tabs shortcodes.
* Updated: Language files.
* Removed: Additional files.
* Fixed: Bug of Newsletter form submit.
* Fixed: Permalink issue on sample data import from installation wizard.
* Fixed: Potenza Multi Tabs shortcode tab issue.
* Fixed: Design issues.
* Various Minor code/formatting improvements and fixes.

## Version 1.3.1 (October 27, 2018)
* Added: Language switcher theme option in topbar for multi language.
* Added: Additional theme options for placement of currency separator symbol.
* Added: Theme Option to disable compare option on vehicle single page.
* Updated: Set additional fields on team single page.
* Updated: Set loader on sorting section on vehicle listing page when filter is called.
* Updated: Car Dealer - Helper Library(V.1.2.1), Car Dealer - Fronted Submission(V.1.2.2), Advance custom fields pro(V5.7.7), Visual Composer(V5.5.5) Plugin bundled.
* Updated: Language files.
* Updated: Optimized Code.
* Fixed: Topbar display when no fields selected from admin.
* Fixed: Child theme stylesheet enqueue bug.
* Fixed: Pagination issue on dealer home page(front submission plugin).
* Fixed: Notice of woocommerce function.
* Fixed: Sticky header issue.
* Fixed: Vehicle sorting bug on inventory page.
* Fixed: Translation issues.
* Fixed: Design bug for compare model popup.
* Various Minor code/formatting improvements and fixes.


## Version 1.3 (September 18, 2018)
* Added: Theme setup wizard.
* Added: Smaller theme package - only 21 MB instead of 51.9 MB.
* Updated: Moved theme support panel to the theme from Car Dealer - Helper Library plugin.
* Updated: Car Dealer - Helper Library(V.1.2.0), Car Dealer - Fronted Submission(V.1.2.1), Advance custom fields pro(V5.7.6), Visual Composer(V5.5.4) Plugin bundled.
* Updated: Theme configuration requirements.
* Updated: Code refactored for new activation process and setup wizard.
* Updated: Updated bundled plugins and sample data installation process to load from the server.
* Updated: Language files.
* Removed: Theme welcome page on theme activation.
* Removed: Extra files.
* Fixed: Woocommerce deprecated notice.
* Fixed: Some page design issues.
* Fixed: Blog image not show issue with masonry view.
* Fixed: Vehicle archive page header title issue if page set as inventory page.
* Fixed: Import process vehicle title ordering issue.
* Fixed: Theme check plugin warnings.
* Fixed: Sample data bugs.
* Various Minor code/formatting improvements and fixes.

## Version 1.2.2 (August 30, 2018)
* Added: Single team page.
* Added: Testimonial listing page template and theme options.
* Added: Theme options for team page.
* Updated:  Advance custom fields pro(V5.7.3), Car Dealer - Helper Library(V.1.1.2), Car Dealer - VIN Import(V.1.0.1), Car Dealer - VINquery Import(V.1.0.1) Plugin bundled.
* Updated: Language files.
* Removed: Extra files.
* Fixed: Page options for pages.
* Fixed: Sample data contents.
* Fixed: Remove year drop down from filters if "year range slider" theme option is set.
* Fixed: Select box conflict(nice select) issue.
* Fixed: Schedule test drive form submission issue when 'no' option is selected for "Test Drive?".
* Various Minor code/formatting improvements and fixes.

## Version 1.2.1 (July 25, 2018)
* Added: New vehicle listing page layout(with masonry and lazyload).
* Added: Sample data for vehicle listing home page.
* Added: Three vehicle grid styles with masonry listing.
* Added : Theme option for back to top image.
* Added : VinQuery Import as a separate add-on to use VinQuery Import functionality for those who are already having VinQuery active account.
* Added: Pricing plans support for frontend vehicle submission of "Car Dealer - Fronted Submission" plugin.
* Added: "Subscriptio" plugin support.
* Updated: Optimized sample data installation.
* Updated: Displayed content of the page if set as inventory page.
* Updated: Bundle plugins with latest version.
* Updated: Language files.
* Fixed: Theme check issues.
* Various Minor code/formatting improvements and fixes.

## Version 1.2 (July 4, 2018)
* Added: CarGurus Feature.
* Added: AutoManager carfax import support for "WP All Import Pro" plugin.
* Added: Theme option for price range slider step.
* Added: Sample data for service category.
* Added: Sample data for Home 11 and Home 12.
* Added: GDPR Compliance.
* Updated: Features and options display on front.
* Updated: Bundle plugins with latest version.
* Updated: Template with new WooCommerce version.
* Updated: Language files.
* Various Minor code/formatting improvements and fixes.

## Version 1.1.1 (March 19, 2018)
* Added: An option to Add another phone number in theme option.
* Added: Option to enable/disable compare vehicle functionality.
* Added: Option for hiding hove effect on Vehicle listing page, Vehicle multi-tab, Vehicle slider short-code and related vehicle sections.
* Added: Option for rearranging filter position or remove the filter on Vehicle inventory listing page.
* Added: Option to change vehicle detail page slug.
* Added: Support for the decimal separator for countries using Arabic numerals with the decimal comma.
* Added: Support for custom car attribute output on car details page.
* Added: Display review stamp image in car detail page.
* Added: Additional social profile icons such as Medium, Flickr, and RSS.
* Added: Vehicle Category taxonomy to categories different vehicle and display different vehicle page template on front.
* Added: Year wise sorting option for vehicle inventory page.
* Fixed: Print media CSS property(output fixes) for car detail page.
* Fixed: RTL issue in carousel slider.
* Updated: Typo changes for the car to the vehicle in theme and plug-in.
* Updated: WooCommerce template file with latest version 3.3.3
* Various Minor code/formatting improvements and fixes.

## Version 1.1 (February 15, 2018)
* Updated:  Advance custom fields pro(V5.6.7), Cardealer Helper Library(V.1.0.7) Plugin bundled.
* Fixed: image size issue on detail page image popup
* Fixed: RTL issue with visual composer full-width content
* Fixed: Notice: Trying to get property of non-object debug error on 404 page
* Fixed: Add All custom filters in wp query like review steps, trims etc
* Fixed: Hide empty taxonomy name in search filter drop-down.
* Fixed: Related Vehicle slider sold image issue
* Removed: Discontinued Edmunds VIN Import functionality. They are not accepting new register for use Edmunds API for import vehicle using VIN so it's not part of the default install.
* Added: We have added Edmunds VIN Import as a separate add-on to use Edmunds VIN Import functionality for those who are already having Edmunds active account
* Added: We have added Cardealer Fronted Submission add-on for user/dealer can submit them vehicle in cardealer website.
* Various Minor code/formatting improvements and fixes.

## Version 1.0.7 (January 08, 2018)
* Added: Default sorting option for vehicle inventory page.
* Added: Sold vehicle inventory page template.
* Added: Integrate WooCommerce selling system in vehicle inventory section.
* Added: Option to change "sold out" image on sold vehicle.
* Fixed: User can set vehicle inventory page on home page.
* Fixed: Set fuel efficiency on full-width car detail page.
* Updated: Car dealer Helper Library(V.1.0.6) plugin bundled.
* Updated: Set vehicle inventory grid view common template for the user can customize easily using a child theme.
* Updated: Move Compare popup template in the theme template so, a user can change template as per requirements.
* Various minor code/formatting improvements and fixes.

## Version 1.0.6 (December 22, 2017)
* Added: Filters on car price HTML function for modifying HTML as per user needs.
* Added: js script to move the control on top after pagination Ajax call.
* Added: Italian language file.
* Updated: Bundle plugin that provides Visual composer (v5.4.5), car dealer helper library (v.1.0.5)
* Updated: Masonry blog style structure.
* Fixed: Exclude nice select dropdown for "car query API vehicle data plugin" drop-down.
* Fixed: Theme option -> title display issue for car inventory page fixed.
* Fixed: Currency symbol placement issue for price filter.
* Fixed: Car condition class in view type list.
* Various minor code/formatting improvements and fixes.

## Version 1.0.5 (November 17, 2017)
* Updated:  Bundle plugin that provides Advance custom fields pro (V5.6.5), Visual Composer (V5.4.2) and Car dealer Helper Library (V.1.0.4)
* Updated: Language file and add car details page static string (View, Compare, gallery etc.) in the language file.
* Updated: Car detail page form validation.
* Fixed: Car CSV file import process & set background process for import.
* Fixed: Theme option does not appear after plugin update.
* Fixed: Translation function.
* Fixed: iOS 11 Safari bootstrap modal text area outside of cursor.
* Fixed: Set price number format in price range slider.
* Fixed: Car archive page header setting option.
* Added: Set different site layout option for a particular page.
* Various minor code/formatting improvements and fixes.

## Version 1.0.4 (October 24, 2017)
* Fixed: Compare icon position.
* Fixed: Post author namespacing on the search page.
* Fixed: Date picker calendar design on vehicle details page.

## Version 1.0.3 (October 18, 2017)
* Complete code (PHP, JavaScript, and CSS) reconstruction and optimization for speed optimization.
* Set CSS priority for page speed optimization.
* Added: "Car Dealer - Helper Library" version update functionality.
* Added: German and French translations.
* Added: Instagram social icon.
* Added: custom 404 output.
* Added: GIF loader for all Ajax call in theme.
* Added: global content for Photoswipe slider.
* Added: loader in top bar search.
* Added: a minified source of JavaScript and CSS libraries.
* Added: optimized CF7 assets loading priority.
* Added: Google Analytics tracking code script from "CDHL Helper Plugin to Car Dealer theme.
* Fixed: check for an array to prevent error on for each call.
* Fixed: fix to display Compare icon in view size less than 992px.
* Fixed: "Currency symbol" function not defined.
* Fixed: "Custom Filter" show/hide issue on car listing sidebar view layout when car filter widget set in sidebar
* Fixed: "Recent Posts" widget's conflict with WooCommerce.
* Fixed: PDF display issue on car detail page.
* Fixed: PHP notice "Undefined variable: data_html" on filters.
* Fixed: WooCommerce mini cart mobile header issue.
* Fixed: admin logo blur issue.
* Fixed: blog page title display issue.
* Fixed: car mileage issue.
* Fixed: color customizer issue in dynamic CSS for the top bar.
* Fixed: header issue in sample data.
* Fixed: issue where YouTube video not working.
* Fixed: issue where it was causing a fatal error in dynamic CSS.
* Fixed: issue with video and audio in Masonry style.
* Fixed: mobile sticky issue.
* Fixed: mobile sticky logo font issue.
* Fixed: notice for the menu_cart variable.
* Fixed: schedule test drive calendar issue.
* Fixed: search icon not hiding in the menu.
* Fixed: share options on Car Details page.
* Fixed: show/hide sold cars on car listing page.
* Fixed: sticky logo color issue.
* Fixed: video background issue in the header.
* Fixed: Coming soon page countdown issue not working on safari browser.
* Removed: Simple Line icon font.
* Removed: default sidebar option on cars page.
* Removed: obsolete "Page Not Found!" subtitle from the title.
* Removed: obsolete codes.
* Removed: search form from Logo Center header type.
* Updated: Changed menu font size from em to px.
* Updated: JavaScript parameters for Post Gallery Slider.
* Updated: car details image template structure for Photoswipe support.
* Updated: default car listing layout.
* Updated: sample data car prices fix.
* Updated: optimize Custom Car Search filter code.
* Updated: bundled plugin "Car Dealer - Helper Library" v.1.0.3.
* Updated: bundled plugin "WPBakery Page Builder" v.5.3
* Updated: Some typo fixes added.
* Various Minor code/formatting improvements and fixes.

## Version 1.0.2 (September 12th, 2017)
* Added: Google Analytic Goal Feature.
* Added: Autocomplete search feature.
* Added: Options for hiding site tagline from theme option.
* Added: Address field to display in the top bar section.
* Added: Link in Potenza feature box visual composer element.
* Added: List of currency symbols.
* Added: Page setting option in Posts, Cars, and WooCommerce product post type.

* Fixed: Potenza custom search filter issue.
* Fixed: Custom post type language translate issue using PO/Mo file.
* Fixed: Add heading separator options in “Potenza section title” visual composer element.
* Fixed: Duplicate key issue in URL for vehicle search filter
* Fixed: YouTube and Vimeo video not loading in HTTPS website.
* Fixed: Site not working in IE browser.

* Update: Heading separator option from theme setting and set this option in "Potenza section title" in visual composer element.
* Update: "CarDealer Helper Library" Plugin
* Update: Minor code/formatting improvements and fixes.

## Version 1.0.1 (August 23, 2017)
* Update: "CarDealer Helper Library" Plugin (Language Support)
* Update: Minor code/formatting improvements and fixes.

## Version 1.0.0 (August 11, 2017)
* Initial Release
