/*================================================
[  Table of contents  ]
================================================
:: Menu Height
:: Document ready functions
	:: Search
	:: mega menu
======================================
[ End table content ]
======================================*/

( function( $ ) {
	"use strict";

	/*******************
	:: Menu Height
	*******************/

	jQuery(document).ready(function($) {

		/**************************************
		:: Search cars with autocomplte
		***************************************/

		// search-3
		if (jQuery('.search').size() > 0) {
			jQuery('.search-btn').on("click", function () {
				jQuery('.search').toggleClass("search-open");
				jQuery('.cardealer-auto-compalte ul').empty();
				jQuery('#menu-s').val('');
				return false;
			});
			$('.search-box .fa-search').on('click',function(){
				$('.searchform').submit();
			});
		}
		if(document.getElementById('menu-s')||document.getElementById('mobile-menu-s')){
			jQuery( '#menu-s,#mobile-menu-s' ).autocomplete({
				search: function(event, ui) {
					jQuery('.cardealer-auto-compalte ul').empty();
				},
				source: function( request, response ) {
					jQuery.ajax({
						url: cardealer_js.ajaxurl,
						type: 'POST',
						dataType: "json",
						data: {'action': 'pgs_auto_complate_search', 'ajax_nonce': cardealer_js.pgs_auto_complate_search_nonce, 'search': request.term},
						beforeSend: function(){
							jQuery('#menu-searchform').find('i.fa-search').after('<span class="cd-loader"></span>');
							jQuery('#menu-searchform').find('i.fa-search').hide();
						},
						success: function( resp ) {
							response( jQuery.map( resp, function( result ) {
								var return_data = {
									status: result.status,
									image: result.image,
									title: result.title,
									link_url: result.link_url,
									msg: result.msg
								};
								return return_data;
							}));
						}
					}).done( function(){
						jQuery('#menu-searchform').find('i.fa-search').show();
						jQuery('#menu-searchform').find('span.cd-loader').remove();
					});
				},
				minLength: 2,
			}).data( "ui-autocomplete" )._renderItem = function( ul, item ) {
				var html = '';
				if(item.status){
					html += '<a href="'+item.link_url+'">';
					html += '<div class="search-item-container">';
					if(item.image){
						html += item.image;
					}
					html += item.title;
					html += '</div>';
					html += '</a>';
				} else {
					html += item.msg;
				}
				return jQuery( "<li></li>" )
					.data( "ui-autocomplete-item", item )
					.append(html)
					.appendTo(jQuery('.cardealer-auto-compalte ul'));
			};
		}

		if(document.getElementById('s')){
			jQuery( '#s' ).autocomplete({
				search: function(event, ui) {
					jQuery('.cardealer-auto-compalte-default ul').empty();
				},
				source: function( request, response ) {
					jQuery.ajax({
						url: cardealer_js.ajaxurl,
						type: 'POST',
						dataType: "json",
						data: {'action': 'pgs_auto_complate_search', 'ajax_nonce': cardealer_js.pgs_auto_complate_search_nonce, 'search': request.term},
						beforeSend: function(){
							jQuery( '#s' ).after('<span class="cd-loader"></span>');
						},
						success: function( resp ) {
							response( jQuery.map( resp, function( result ) {
								var return_data = {
									status: result.status,
									image: result.image,
									title: result.title,
									link_url: result.link_url,
									msg: result.msg
								};
								return return_data;
							}));
						}
					}).done( function(){
						jQuery( '#s' ).parent().find('span.cd-loader').remove();
					});
				},
				minLength: 2,
			}).data( "ui-autocomplete" )._renderItem = function( ul, item ) {
				var html = '';
				if(item.status){
					html += '<a href="'+item.link_url+'">';
					html += '<div class="search-item-container">';
					if(item.image){
						html += item.image;
					}
					html += item.title;
					html += '</div>';
					html += '</a>';
				} else {
					html += item.msg;
				}
				return jQuery( "<li></li>" )
					.data( "ui-autocomplete-item", item )
					.append(html)
					.appendTo(jQuery('.cardealer-auto-compalte-default ul'));
			};
		}

		/*************************
		:: mega menu
		*************************/
		// Sticky Top bar setting
		var screen_width = screen.width;
		jQuery(document).scroll(function() {
			if( cardealer_js.sticky_topbar == true ) {
				var sticky = jQuery('.topbar'),
				scroll = jQuery(window).scrollTop();
				if (scroll >= 250 && screen_width > 992){
					sticky.addClass('topbar_fixed');
				} else {
					sticky.removeClass('topbar_fixed');
				}
			}
		});

		var $mobile_sticky_status = (cardealer_js.sticky_header_mobile == true)? true: false;
		var $desktop_sticky_status = (cardealer_js.sticky_header_desktop == true)? true: false;
		jQuery('#menu-1').megaMenu({
			// DESKTOP MODE SETTINGS
			logo_align          : 'left',		// align the logo left or right. options (left) or (right)
			links_align         : 'left',      	// align the links left or right. options (left) or (right)
			socialBar_align     : 'left',     	// align the socialBar left or right. options (left) or (right)
			searchBar_align     : 'right',    	// align the search bar left or right. options (left) or (right)
			trigger             : 'hover',    	// show drop down using click or hover. options (hover) or (click)
			effect              : 'fade',     	// drop down effects. options (fade), (scale), (expand-top), (expand-bottom), (expand-left), (expand-right)
			effect_speed        : 400,        	// drop down show speed in milliseconds
			sibling             : true,       	// hide the others showing drop downs if this option true. this option works on if the trigger option is "click". options (true) or (false)
			outside_click_close : true,       	// hide the showing drop downs when user click outside the menu. this option works if the trigger option is "click". options (true) or (false)
			top_fixed           : false,      	// fixed the menu top of the screen. options (true) or (false)
			sticky_header       : $desktop_sticky_status,// menu fixed on top when scroll down down. options (true) or (false)
			sticky_header_height: 250,  		// sticky header height top of the screen. activate sticky header when meet the height. option change the height in px value.
			menu_position       : 'horizontal', // change the menu position. options (horizontal), (vertical-left) or (vertical-right)
			full_width          : false,        // make menu full width. options (true) or (false)
			// MOBILE MODE SETTINGS
			mobile_settings     : {
				collapse            : true,     // collapse the menu on click. options (true) or (false)
				sibling             : true,     // hide the others showing drop downs when click on current drop down. options (true) or (false)
				scrollBar           : true,     // enable the scroll bar. options (true) or (false)
				scrollBar_height    : 400,      // scroll bar height in px value. this option works if the scrollBar option true.
				top_fixed           : false,    // fixed menu top of the screen. options (true) or (false)
				sticky_header       : $mobile_sticky_status,     // menu fixed on top when scroll down down. options (true) or (false)
				sticky_header_height: 200       // sticky header height top of the screen. activate sticky header when meet the height. option change the height in px value.
			}
		});

		if(document.getElementById('mega-menu-wrap-primary-menu')){
			jQuery('.menu-mobile-collapse-trigger').hide();
		}

	});

}( jQuery ) );
