<?php
/**
 * Template part.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package CarDealer
 */

// get the FAQ type.
$pgs_faq_type        = get_post_meta( get_the_ID(), 'faq_type', true );
$pgs_faq_type        = ( empty( $pgs_faq_type ) ) ? 'all' : $pgs_faq_type;
$faq_page_query_base = array(
	'post_type'      => 'faqs',
	'posts_per_page' => defined( 'PHP_INT_MAX' ) ? PHP_INT_MAX : -1,
);

$faq_categories = get_terms(
	array(
		'taxonomy'   => 'faq-category',
		'hide_empty' => true,
		'fields'     => 'ids',
	)
);

if ( 'all' !== $pgs_faq_type ) {
	$faq_categories_selected = get_post_meta( get_the_ID(), 'select_category', true );
}

$faq_categories                  = ( 'all' === $pgs_faq_type ) ? $faq_categories : $faq_categories_selected;
$faq_page_query_all_tab_taxquery = array(
	'tax_query' => array( // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_tax_query
		array(
			'taxonomy' => 'faq-category',
			'field'    => 'term_id',
			'terms'    => $faq_categories,
		),
	),
);

$faq_page_tabs_data_all_tab_query = array_merge( $faq_page_query_base, $faq_page_query_all_tab_taxquery );

if ( 'all' === $pgs_faq_type ) {
	$faq_page_tabs_data[] = array(
		'slug'  => 'all',
		'title' => esc_html__( 'All', 'cardealer' ),
		'query' => $faq_page_tabs_data_all_tab_query,
	);
}
$faq_page_query_term_taxquery = array();
$pgs_category_count           = 0;
if ( ! empty( $faq_categories ) ) {
	foreach ( $faq_categories as $faq_category ) {
		$faq_category_data = get_term_by( 'id', $faq_category, 'faq-category' );
		if ( isset( $faq_category_data->term_id ) && ! empty( $faq_category_data->term_id ) ) {
			$faq_page_query_term_taxquery = array(
				'tax_query' => array( // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_tax_query
					array(
						'taxonomy' => 'faq-category',
						'field'    => 'term_id',
						'terms'    => array( $faq_category_data->term_id ),
					),
				),
			);

			$faq_page_tabs_data[] = array(
				'slug'  => 'term_' . $faq_category_data->term_id,
				'title' => $faq_category_data->name,
				'query' => array_merge( $faq_page_query_base, $faq_page_query_term_taxquery ),
			);
			$pgs_category_count   = count( $faq_page_tabs_data );
		}
	}
}
?>
<div id="tabs" class="tabs_wrapper">
	<?php
	if ( $pgs_category_count > 1 || 'all' === $pgs_faq_type ) {
		?>
		<ul class="tabs text-center nav nav-tabs">
			<?php
			$faq_page_query_tab_sr = 1;
			foreach ( $faq_page_tabs_data as $faq_page_query ) {
				$activ = ( 1 === $faq_page_query_tab_sr ) ? 'active' : '';
				?>
				<li role="presentation" class="<?php echo esc_attr( $activ ); ?>">
					<a href="#tab_<?php echo esc_attr( $faq_page_query['slug'] ); ?>" aria-controls="tab_<?php echo esc_attr( $faq_page_query['slug'] ); ?>" role="tab" data-toggle="tab">
						<span aria-hidden="true"></span><?php echo esc_html( $faq_page_query['title'] );?>
					</a>
				</li>
				<?php
				$faq_page_query_tab_sr++;
			}
			?>
		</ul>
		<?php
	}
	$faq_page_query_tab_sr = 1;
	if ( isset( $faq_page_tabs_data ) && ! empty( $faq_page_tabs_data ) ) {
		?>
		<div class="tab-content">
			<?php
			foreach ( $faq_page_tabs_data as $faq_page_query ) {
				?>
				<div role="tabpanel" id="tab_<?php echo esc_attr( $faq_page_query['slug'] ); ?>" class="tabcontent accordion fade tab-pane <?php echo esc_attr( 1 === $faq_page_query_tab_sr ? ' active in' : '' ); ?>">
					<?php
					// The Query.
					$faq_query = new WP_Query( $faq_page_query['query'] );
					if ( $faq_query->have_posts() ) {
						while ( $faq_query->have_posts() ) {
							$faq_query->the_post();
							?>
							<div class="accordion-title">
								<a href="#"><?php the_title(); ?></a>
							</div>
							<div class="accordion-content">
								<?php the_content(); ?>
							</div>
							<?php
						}
						wp_reset_postdata();
					}
					?>
				</div>
				<?php
				$faq_page_query_tab_sr++;
			}
			?>
		</div>
		<?php
	}
	?>
</div>
