<?php
/**
 * Elementor Vehicle Title template.
 *
 * @package car-dealer-helper
 */

$this->add_render_attribute( 'cd_vehicle_attributes', 'id', 'cd_vehicle_attributes-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_attributes', 'class', 'cd-vehicle-attributes' );

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}

$this->add_render_attribute( 'cd_vehicle_attributes', 'class', 'layout-' . $settings['attribute_layout'] );
$this->add_render_attribute( 'cd_vehicle_attributes', 'class', $settings['style'] );
if ( 'horizontal' === $settings['attribute_layout'] ) {
	if ( isset( $settings['no_of_column'] ) && $settings['no_of_column'] ) {
		$this->add_render_attribute( 'cd_vehicle_attributes', 'class', 'column-' . $settings['no_of_column'] );
	}
}
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_attributes' ); ?>>
	<?php
	if ( isset( $settings['title'] ) && $settings['title'] ) {
		$this->add_render_attribute( 'cd_element_title', 'class', 'vehicle-element-title' );
		?>
		<h6 <?php $this->print_render_attribute_string( 'cd_element_title' ); ?>>
			<?php echo esc_html( $settings['title'] ); ?>
		</h6>
		<?php
	}
	cardealer_get_cars_attributes( $post_id ); ?>
</div>
