<?php
/**
 * Elementor Vehicle Title template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$this->add_render_attribute( 'cd_vehicle_fuel', 'id', 'cd_vehicle_fuel-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_fuel', 'class', 'cd-vehicle-fuel-efficiency' );

$this->add_render_attribute( 'cd_vehicle_fuel_detail_form', 'class', 'details-form contact-2 details-weight' );
$this->add_render_attribute( 'cd_vehicle_fuel_detail', 'class', 'fuel-efficiency-detail' );

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}

$title         = ( isset( $settings['title'] ) ) ? $settings['title'] : '';
$element_title = ( isset( $settings['element_title'] ) ) ? $settings['element_title'] : '';
$description   = ( isset( $settings['description'] ) ) ? $settings['description'] : '';
$city_mpg      = get_post_meta( $post_id, 'city_mpg', true );
$highway_mpg   = get_post_meta( $post_id, 'highway_mpg', true );

if ( ! $city_mpg && ! $highway_mpg ) {
	return;
}
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_fuel' ); ?>>
	<?php
	if ( $element_title ) {
		$this->add_render_attribute( 'cd_element_title', 'class', 'vehicle-element-title' );
		?>
		<h6 <?php $this->print_render_attribute_string( 'cd_element_title' ); ?>>
			<?php echo esc_html( $element_title ); ?>
		</h6>
		<?php
	}
	?>
	<div <?php $this->print_render_attribute_string( 'cd_vehicle_fuel_detail_form' ); ?>>
		<div <?php $this->print_render_attribute_string( 'cd_vehicle_fuel_detail' ); ?>>
			<?php
			if ( $title ) {
				?>
				<div class="heading">
					<h6><?php echo esc_html( $title ); ?></h6>
				</div>
				<?php
			}
			?>
			<div class="row">
				<?php
				if ( $city_mpg ) {
					?>
					<div class="col-xs-4">
						<label><?php echo esc_html__( 'City', 'cardealer-helper' ); ?></label>
						<span class="city_mpg"><?php echo esc_html( $city_mpg ); ?></span>
					</div>
					<?php
				}
				?>
				<div class="col-xs-4">
					<i class="glyph-icon flaticon-gas-station fa-3x"></i>
				</div>
				<?php
				if ( $highway_mpg ) {
					?>
					<div class="col-xs-4">
						<label><?php echo esc_html__( 'Highway', 'cardealer-helper' ); ?></label>
						<span class="highway_mpg"><?php echo esc_html( $highway_mpg ); ?></span>
					</div>
					<?php
				}
				if ( $description ) {
					?>
					<div class="col-sm-12">
						<?php echo esc_html( $description ); ?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
</div>
