<?php
/**
 * Elementor Vehicle Subtitle template.
 *
 * @package car-dealer-helper
 */

if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
	?>
	<div class="alert alert-danger" role="alert" style="margin: 0;">
		<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
		<p><?php esc_html_e( 'This elementor widget will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
	</div>
	<?php
	return;
}

$this->add_render_attribute( 'cd_vehicle_subtitle', 'id', 'cd_vehicle_subtitle-' . $this->get_id() );
$this->add_render_attribute( 'cd_vehicle_subtitle', 'class', 'cd-vehicle-subtitle' );

if ( class_exists( 'CDHL_CPT_Template' ) ) {
	$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
} else {
	$post_id = get_the_ID();
}
?>
<div <?php $this->print_render_attribute_string( 'cd_vehicle_subtitle' ); ?>>
	<?php cardealer_subtitle_attributes( $post_id ); ?>
</div>
