<?php
/**
 * Elementor Vehicle Attribute class.
 *
 * @package cardealer-helper/elementor
 * @since   5.0.0
 */

namespace Cdhl_Elementor\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

use Cdhl_Elementor\Widget_Controller\Widget_Controller;
use Cdhl_Elementor\Group_Controls;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor banner widget.
 *
 * Elementor widget that displays an banner.
 *
 * @since 5.0.0
 */
class Vehicle_Attribute extends Widget_Controller {

	/**
	 * Widget slug
	 *
	 * @var string
	 */
	protected $widget_slug = 'vehicle-attribute';

	/**
	 * Widget icon
	 *
	 * @var string
	 */
	protected $widget_icon = 'cdhl-widget-icon';

	/**
	 * Widget keywords
	 *
	 * @var array
	 */
	protected $keywords = array( 'cars', 'vehicle', 'detail', 'single', 'attribute', 'taxonomy' );

	/**
	 * Retrieve the widget title.
	 *
	 * @since 5.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Vehicle Attribute', 'cardealer-helper' );
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 5.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( CDHL_ELEMENTOR_VEHIVLE_SINGLE_CAT );
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 5.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'section_content_general',
			array(
				'label' => esc_html__( 'General', 'cardealer-helper' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'attribute_slug',
			[
				'label'       => esc_html__( 'Taxonomy Key', 'cardealer-helper' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'To find the taxonomy key go to Admin Panel > Vehicle Inventory > Add/Edit Attributes and get taxonomy key for the desired attribute.', 'cardealer-helper' )
				. "\r\n" . esc_html__( 'Important Note: The taxonomy key for "Feature & Option" is not allowed.', 'cardealer-helper' ),
			]
		);

		$this->add_control(
			'fallback_text',
			[
				'label'       => esc_html__( 'Fallback Text', 'cardealer-helper' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => 'N/A',
				'description' => esc_html__( 'Enter fallback text to show if the value is empty.', 'cardealer-helper' ),
			]
		);

		$this->add_control(
			'html_tag',
			[
				'label'   => esc_html__( 'HTML Tag', 'cardealer-helper' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'h1'   => 'h1',
					'h2'   => 'h2',
					'h3'   => 'h3',
					'h4'   => 'h4',
					'h5'   => 'h5',
					'h6'   => 'h6',
					'div'  => 'div',
					'span' => 'span',
					'p'    => 'p',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'transform',
			[
				'label'   => esc_html__( 'Text Transform', 'cardealer-helper' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'capitalize',
				'options' => [
					'capitalize' => esc_html__( 'Capitalize', 'cardealer-helper' ),
					'uppercase'  => esc_html__( 'Uppercase', 'cardealer-helper' ),
					'lowercase'  => esc_html__( 'Lowercase', 'cardealer-helper' ),
				],
			]
		);

		$this->end_controls_section();
	}
}
