<?php
/**
 * Elementor Vehicle Buttons class.
 *
 * @package cardealer-helper/elementor
 * @since   5.0.0
 */

namespace Cdhl_Elementor\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

use Cdhl_Elementor\Widget_Controller\Widget_Controller;
use Cdhl_Elementor\Group_Controls;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor banner widget.
 *
 * Elementor widget that displays an banner.
 *
 * @since 5.0.0
 */
class Vehicle_Buttons extends Widget_Controller {

	/**
	 * Widget slug
	 *
	 * @var string
	 */
	protected $widget_slug = 'vehicle-buttons';

	/**
	 * Widget icon
	 *
	 * @var string
	 */
	protected $widget_icon = 'cdhl-widget-icon';

	/**
	 * Widget keywords
	 *
	 * @var array
	 */
	protected $keywords = array( 'cars', 'vehicle', 'detail', 'single', 'buttons' );

	/**
	 * Retrieve the widget title.
	 *
	 * @since 5.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Vehicle Buttons', 'cardealer-helper' );
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 5.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( CDHL_ELEMENTOR_VEHIVLE_SINGLE_CAT );
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 5.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'section_content_general',
			array(
				'label' => esc_html__( 'General', 'cardealer-helper' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'show_buttons',
			array(
				'label'       => esc_html__( 'Show Buttons', 'cardealer-helper' ),
				'description' => esc_html__( 'If no button is selected, all buttons will be displayed.', 'cardealer-helper' ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple'    => true,
				'options'     => apply_filters( 'cdhl_vehicle_buttons_option', array() ),
			)
		);

		$this->add_control(
			'style',
			array(
				'label'       => esc_html__( 'Style', 'cardealer-helper' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => [
					'style-1' => esc_html__( 'Style 1', 'cardealer-helper' ),
					'style-2' => esc_html__( 'Style 2', 'cardealer-helper' ),
				],
				'default'     => 'style-1',
				'description' => esc_html__( 'Select button style.', 'cardealer-helper' ),
			)
		);

		$this->add_control(
			'alignment',
			array(
				'label'       => esc_html__( 'Alignment', 'cardealer-helper' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => [
					'inline'    => esc_html__( 'Inline', 'cardealer-helper' ),
					'fullwidth' => esc_html__( 'Full Width', 'cardealer-helper' ),
				],
				'default'     => 'inline',
				'description' => esc_html__( 'Select alignment.', 'cardealer-helper' ),
				'condition' => [
					'style' => 'style-1',
				],
			)
		);

		$this->add_control(
			'color',
			array(
				'label'   => esc_html__( 'Color', 'cardealer-helper' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'default' => esc_html__( 'Default', 'cardealer-helper' ),
					'dark'    => esc_html__( 'Dark', 'cardealer-helper' ),
					'theme'   => esc_html__( 'Theme', 'cardealer-helper' ),
				],
				'description' => esc_html__( 'Select button color scheme.', 'cardealer-helper' ),
				'default' => 'default',
				'condition' => [
					'style' => 'style-1',
				],
			)
		);

		$this->add_control(
			'button_type',
			[
				'label'   => esc_html__( 'Button Type', 'cardealer-helper' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'cardealer-helper' ),
					'rounded' => esc_html__( 'Rounded', 'cardealer-helper' ),
				],
				'description' => esc_html__( 'Select button type.', 'cardealer-helper' ),
				'condition' => [
					'style' => 'style-2',
				],
			]
		);

		$this->end_controls_section();
	}
}
