<?php
/**
 * Shortcode abstract class.
 *
 * @package car-dealer-helper/shortcodes
 */

/**
 * Abstract_Shortcode class.
 */
abstract class CDHL_Abstract_Shortcode {
	/**
	 * Class instance.
	 *
	 * @var Abstract_Shortcode
	 */
	private static $instances;

	/**
	 * Constructor function.
	 */
	private function __construct() {
		// add_action( 'init', array( $this, 'add_shortcode' ) );
		add_shortcode( $this->get_shortcode_name(), array( $this, 'display_shortcode' ) );
		add_action( 'vc_before_init', array( &$this, 'vc_before_init' ) );
	}

	/**
	 * Function get_shortcode_name.
	 *
	 * @return string
	 */
	abstract public function get_shortcode_name(): string;

	/**
	 * Function get_shortcode_title.
	 *
	 * @return string
	 */
	abstract public function get_shortcode_title(): string;

	public function get_shortcode_slug(): string {
		$shortcode_slug = sanitize_title_with_dashes( $this->get_shortcode_name() );
		$shortcode_slug = str_replace( array( '_' ), '-', $shortcode_slug );
        return $shortcode_slug;
    }

	public function get_shortcode_id( $prefix = '' ): string {
		$slug = $this->get_shortcode_slug();
		return uniqid( $prefix . "$slug-" );
    }

	/**
	 * Function add_shortcode.
	 *
	 * @return void
	 */
	final public function add_shortcode(): void {
		add_shortcode( $this->get_shortcode_name(), array( $this, 'display_shortcodex' ) );
	}

	/**
	 * Function display_shortcode.
	 *
	 * @param array $attributes Attributes.
	 * @return string
	 */
	abstract public function display_shortcode( $attributes ): string;

	/**
	 * Function vc_before_init.
	 *
	 * @return void
	 */
	public function vc_before_init(): void {
		$this->vc_fields();
	}

	/**
	 * Function display_shortcode.
	 *
	 * @param array $attributes Attributes.
	 * @return string
	 */
	abstract public function vc_fields(): void;

	/**
	 * Function get_instance.
	 *
	 * @return Abstract_Shortcode
	 */
	final public static function get_instance(): Abstract_Shortcode {
		return self::init();
	}

	/**
	 * Init function.
	 *
	 * @return static
	 */
	final public static function &init() {
		$class = static::class;
		if ( ! isset( self::$instances[ $class ] ) ) {
			self::$instances[ $class ] = new $class();
		}

		return self::$instances[ $class ];
	}

}
