<?php
/**
 * CarDealer Vehicle Financing Calculator Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_financing_calculator', 'cdhl_financing_calculator_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_financing_calculator_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id'          => uniqid( 'cd_financing_calculator' ),
			'description'         => '',
			'rate'                => '',
			'button_text'         => '',
			'loan_period_label'   => '',
			'interest_rate_label' => '',
			'down_payment_label'  => '',
			'loan_amount_label'   => '',
			'title'               => esc_html__( 'Financing Calculator', 'cardealer-helper' ),
			'loan_amount_label'   => '',
			'css'                 => '',
		),
		$atts
	);

	$wrapper_class = 'cd-financing-calculator' . vc_shortcode_custom_css_class( $atts['css'], ' ' );
	wp_enqueue_script( 'cardealer-financing-calculator' );
	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<?php
		$loan_amount_label   = esc_html__( 'Loan Amount', 'cardealer-helper' );
		$down_payment_label  = esc_html__( 'Down Payment', 'cardealer-helper' );
		$interest_rate_label = esc_html__( 'Interest Rate (%)', 'cardealer-helper' );
		$loan_period_label   = esc_html__( 'Period (Month)', 'cardealer-helper' );
		$button_text         = esc_html__( 'Estimate Payment', 'cardealer-helper' );

		$loan_amount_label   =  ( ! empty( $atts['loan_amount_label'] ) ) ? $atts['loan_amount_label'] : $loan_amount_label;
		$down_payment_label  =  ( ! empty( $atts['down_payment_label'] ) ) ? $atts['down_payment_label'] : $down_payment_label;
		$interest_rate_label =  ( ! empty( $atts['interest_rate_label'] ) ) ? $atts['interest_rate_label'] : $interest_rate_label;
		$loan_period_label   =  ( ! empty( $atts['loan_period_label'] ) ) ? $atts['loan_period_label'] : $loan_period_label;
		$button_text         =  ( ! empty( $atts['button_text'] ) ) ? $atts['button_text'] : $button_text;
		?>
		<div class="news-letter">
			<?php
			if ( $atts['title'] ) {
				?>
				<h6 class="vehicle-element-title"><?php echo esc_html( $atts['title'] ); ?></h6>
				<?php					
			}
			if ( $atts['description'] ) {
				echo '<p>' . esc_html( $atts['description'] ) . '</p>';
			}
			?>
			<form class="financing-calculator" id="<?php echo esc_attr( $atts['element_id'] ); ?>">
				<div class="form-group">
					<label><?php echo esc_html( $loan_amount_label ); ?>*</label>
					<input type="text" name="loan_amount" id="loan-amount-<?php echo esc_attr( $atts['element_id'] ); ?>" value="" class="form-control"/>
				</div>
				<div class="form-group">
					<label><?php echo esc_html( $down_payment_label ); ?>*</label>
					<input type="text" name="down_payment" id="down-payment-<?php echo esc_attr( $atts['element_id'] ); ?>" class="form-control"/>
				</div>
				<div class="form-group">
					<label><?php echo esc_html( $interest_rate_label ); ?>*</label>
					<input type="text" name="interest_rate" id="interest-rate-<?php echo esc_attr( $atts['element_id'] ); ?>" class="form-control" value="<?php echo esc_attr( $atts['rate'] ); ?>"/>
				</div>
				<div class="form-group">
					<label><?php echo esc_html( $loan_period_label ); ?>*</label>
					<input type="text" name="period" id="period-<?php echo esc_attr( $atts['element_id'] ); ?>" class="form-control" />
				</div>
				<div class="form-group">
					<label><?php esc_html_e( 'Payment', 'cardealer-helper' ); ?></label>
					<div class="cal_text payment-box">
						<div id="txtPayment-<?php echo esc_attr( $atts['element_id'] ); ?>"></div>
					</div>
				</div>
				<div class="form-group">
					<a class="button red do_calculator" href="javascript:void(0);" data-form-id="<?php echo esc_attr( $atts['element_id'] ); ?>"><?php echo esc_html( $button_text ); ?></a>
					<a class="button red do_calculator_clear" href="javascript:void(0);" data-form-id="<?php echo esc_attr( $atts['element_id'] ); ?>"><?php echo esc_html__( 'clear', 'cardealer-helper' ); ?></a>
				</div>
			</form>
		</div>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_financing_calculator_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {
		
		$params = array(
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Title', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter title here', 'cardealer-helper' ),
				'param_name'  => 'title',
				'value'       => esc_html__( 'Financing Calculator', 'cardealer-helper' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Description', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter description here', 'cardealer-helper' ),
				'param_name'  => 'description',

			),
			array(
				'type'             => 'cd_number_min_max',
				'heading'          => esc_html__( 'Rate (%)', 'cardealer-helper' ),
				'param_name'       => 'rate',
				'min'              => '1',
				'max'              => '100',
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Loan Amount Field Label', 'cardealer-helper' ),
				'param_name'  => 'loan_amount_label',
				'value'       => esc_html__( 'Loan Amount', 'cardealer-helper' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Down Payment Field Label', 'cardealer-helper' ),
				'param_name'  => 'down_payment_label',
				'value'       => esc_html__( 'Down Payment', 'cardealer-helper' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Interest Rate Field Label', 'cardealer-helper' ),
				'param_name'  => 'interest_rate_label',
				'value'       => esc_html__( 'Interest Rate (%)', 'cardealer-helper' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Loan Period Label', 'cardealer-helper' ),
				'param_name'  => 'loan_period_label',
				'value'       => esc_html__( 'Period (Month)', 'cardealer-helper' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Estimate Payment Button Label', 'cardealer-helper' ),
				'param_name'  => 'button_text',
				'value'       => esc_html__( 'Estimate Payment', 'cardealer-helper' ),
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);
		
		vc_map(
			array(
				'name'                    => esc_html__( 'Financing Calculator', 'cardealer-helper' ),
				'description'             => esc_html__( 'Financing Calculator', 'cardealer-helper' ),
				'base'                    => 'cd_financing_calculator',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_financing_calculator' ),
				'category'                => esc_html__( 'Potenza', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_financing_calculator_shortcode_vc_map' );
