<?php
/**
 * CarDealer Vehicle Buttons Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_buttons', 'cdhl_vehicle_buttons_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_buttons_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id'   => uniqid( 'cd_vehicle_buttons' ),
			'show_buttons' => '',
			'style'        => 'style-1',
			'alignment'    => 'inline',
			'button_type'  => 'default',
			'color'        => 'default',
			'css'          => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	$wrapper_class = 'cd-vehicle-buttons' . vc_shortcode_custom_css_class( $atts['css'], ' ' );
	$wrapper_class .= ' cd-vehicle-buttons-' . $atts[ 'style' ];

	if ( 'style-1' === $atts['style'] ) {
		$wrapper_class .= ' cd-vehicle-buttons-color-' . $atts[ 'color' ];
		$wrapper_class .= ' cd-vehicle-buttons-alignment-' . $atts[ 'alignment' ];
	} elseif( 'style-2' === $atts['style'] ) {
		$wrapper_class .= ' cd-vehicle-buttons-type-' . $atts[ 'button_type' ];
	}

	$show_buttons = ( ! empty ( $atts['show_buttons'] ) ) ? explode( ',', $atts['show_buttons'] ) : '';

	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<?php cardealer_display_vehicle_buttons( $show_buttons ); ?>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_buttons_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {

		$params = array(
			array(
				'type'        => 'checkbox',
				'heading'     => esc_html__( 'Show Buttons', 'cardealer-helper' ),
				'description' => esc_html__( 'If no button is selected, all buttons will be displayed.', 'cardealer-helper' ),
				'param_name'  => 'show_buttons',
				'value'       => array_flip( apply_filters( 'cdhl_vehicle_buttons_option', array() ) ),
				'save_always' => true,
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Style', 'cardealer-helper' ),
				'param_name'  => 'style',
				'value'       => array_flip( array(
					'style-1' => esc_html__( 'Style 1', 'cardealer-helper' ),
					'style-2' => esc_html__( 'Style 2', 'cardealer-helper' ),
				) ),
				'std'         => 'style-1',
				'save_always' => true,
				'description' => esc_html__( 'Select button style.', 'cardealer-helper' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Alignment', 'cardealer-helper' ),
				'param_name'  => 'alignment',
				'value'       => array_flip( array(
					'inline'    => esc_html__( 'Inline', 'cardealer-helper' ),
					'fullwidth' => esc_html__( 'Full Width', 'cardealer-helper' ),
				) ),
				'std'         => 'inline',
				'save_always' => true,
				'description' => esc_html__( 'Select alignment.', 'cardealer-helper' ),
				'dependency'  => array(
					'element' => 'style',
					'value'   => array( 'style-1' ),
				),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Color', 'cardealer-helper' ),
				'param_name'  => 'color',
				'value'       => array_flip( array(
					'default' => esc_html__( 'Default', 'cardealer-helper' ),
					'dark'    => esc_html__( 'Dark', 'cardealer-helper' ),
					'theme'   => esc_html__( 'Theme', 'cardealer-helper' ),
				) ),
				'std'         => 'default',
				'save_always' => true,
				'description' => esc_html__( 'Select color scheme.', 'cardealer-helper' ),
				'dependency'  => array(
					'element' => 'style',
					'value'   => array( 'style-1' ),
				),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Button Type', 'cardealer-helper' ),
				'param_name'  => 'button_type',
				'value'       => array_flip( array(
					'default' => esc_html__( 'Default', 'cardealer-helper' ),
					'rounded' => esc_html__( 'Rounded', 'cardealer-helper' ),
				) ),
				'std'         => 'default',
				'save_always' => true,
				'description' => esc_html__( 'Select button type.', 'cardealer-helper' ),
				'dependency'  => array(
					'element' => 'style',
					'value'   => array( 'style-2' ),
				),
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);

		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Buttons', 'cardealer-helper' ),
				'description'             => esc_html__( 'Vehicle Buttons', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_buttons',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_buttons' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_buttons_shortcode_vc_map' );
