<?php
/**
 * CarDealer Vehicle Gallery Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_gallery', 'cdhl_vehicle_gallery_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_gallery_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'image_size'   => 'car_single_slider',
			'video_button' => false,
			'no_margin'    => false,
			'sold_badge'   => false,
			'element_id'   => uniqid( 'cd_vehicle_gallery_' ),
			'css'          => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	$wrapper_class = 'vehicle-gallery' . vc_shortcode_custom_css_class( $atts['css'], ' ' );
	if ( isset( $atts['no_margin'] ) && true === (bool) $atts['no_margin'] ) {
		$wrapper_class .= ' no-margin';
	}
	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<div class="slider-slick">
			<?php
			if ( function_exists( 'get_field' ) ) {
				?>
				<div class="cars-image-gallery my-gallery">
					<?php
					do_action( 'before_image_gallery_slider', $post_id );
					if ( isset( $atts['sold_badge'] ) && true === (bool) $atts['sold_badge'] ) {
						echo cardealer_vehicle_sold_label( $post_id );
					}
					?>
					<div class="slider slider-for detail-big-car-gallery">
						<?php
						$i      = 0;
						$images = get_field( 'car_images', $post_id );
						if ( ! empty( $images ) ) {
							foreach ( $images as $image ) {
								$image_url    = isset( $image['url'] ) ? $image['url'] : '';
								$image_width  = isset( $image['width'] ) ? $image['width'] : '';
								$image_height = isset( $image['height'] ) ? $image['height'] : '';
								$imag_alt     = ( isset( $image['alt'] ) && $image['alt'] ) ? $image['alt'] : get_the_title();
								?>
								<figure>
									<img src="<?php echo esc_url( $image['sizes'][$atts['image_size']] ); ?>" class="img-responsive ps-car-listing" id="pscar-<?php echo esc_attr( $i++ ); ?>" alt="<?php echo esc_attr( $imag_alt ); ?>"  data-src="<?php echo esc_url( $image_url ); ?>" data-width="<?php echo esc_attr( $image_width ); ?>" data-height="<?php echo esc_attr( $image_height ); ?>"/>
								</figure>
								<?php
							}
						} else {
							echo wp_kses_post( cardealer_get_cars_image( 'large', $post_id ) );
						}
						?>
					</div>
					<?php
					if ( isset( $atts['video_button'] ) && true === (bool) $atts['video_button'] ) {
						echo cardealer_vehicle_image_gallery_video_button( $post_id );
					}
					?>
				</div>
				<div class="slider slider-nav">
					<?php
					$images = get_field( 'car_images', $post_id );
					if ( $images ) {
						?>
						<?php
						foreach ( $images as $image ) {
							$imag_alt = ( isset( $image['alt'] ) && $image['alt'] ) ? $image['alt'] : get_the_title();
							?>
							<img class="img-responsive" src="<?php echo esc_url( $image['sizes']['car_thumbnail'] ); ?>" alt="<?php echo esc_attr( $imag_alt ); ?>">
							<?php
						}
					}
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_gallery_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {
		$params = array(
			array(
				'type'        => 'checkbox',
				'heading'     => esc_html__( 'Display Video Button', 'cardealer-helper' ),
				'param_name'  => 'video_button',
				'description' => esc_html__( 'Check the checkbox to add video button.', 'cardealer-helper' ),
			),
			array(
				'type'        => 'checkbox',
				'heading'     => esc_html__( 'No Margin', 'cardealer-helper' ),
				'param_name'  => 'no_margin',
				'description' => esc_html__( 'Check the checkbox to remove margin between the images.', 'cardealer-helper' ),
			),
			array(
				'type'        => 'checkbox',
				'heading'     => esc_html__( 'Display Sold Badge', 'cardealer-helper' ),
				'param_name'  => 'sold_badge',
				'description' => esc_html__( 'Check the checkbox to add sold badge.', 'cardealer-helper' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Image Size', 'cardealer-helper' ),
				'param_name'  => 'image_size',
				'description' => wp_kses(
					sprintf(
						__( 'To know more about image size and add your custom image size, please refer to <a href="%s" target="_blank" rel="noopener">this document</a>.', 'cardealer-helper' ),
						'https://developer.wordpress.org/reference/functions/add_image_size/'
					),
					array(
						'a' => array(
							'href'   => true,
							'target' => true,
							'rel'    => true,
						),
					)
				),
				'value'       => array_flip( cardealer_get_all_registered_image_size_array() ),
				'std'         => 'car_single_slider',
				'admin_label' => true,
				'save_always' => true,
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);

		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Gallery', 'cardealer-helper' ),
				'description'             => esc_html__( 'Vehicle Gallery', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_gallery',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_gallery' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_gallery_shortcode_vc_map' );
