<?php
/**
 * CarDealer Vehicle Price Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_price', 'cdhl_vehicle_price_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_price_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id'          => uniqid( 'cd_vehicle_price' ),
			'tax_label_alignment' => 'left',
			'hide_sold_label'     => false,
			'tax_label'           => 'default',
			'css'                 => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	$wrapper_class = 'cd-vehicle-price' . vc_shortcode_custom_css_class( $atts['css'], ' ' );
	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<?php
		$class = 'text-' . $atts['tax_label_alignment'];
		$class .= ' text-label-' . $atts['tax_label'];
		if ( isset( $atts['hide_sold_label'] ) && true === (bool) $atts['hide_sold_label'] ) {
			$class .= ' hide-status';
		}
		cardealer_car_price_html( $class, $post_id );
		?>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_price_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {

		$params = array(
			array(
				'type'        => 'checkbox',
				'heading'     => esc_html__( 'Hide Sold Label', 'cardealer-helper' ),
				'param_name'  => 'hide_sold_label',
				'description' => esc_html__( 'Check the checkbox to hide sold label.', 'cardealer-helper' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Tax Label Type', 'cardealer-helper' ),
				'param_name'  => 'tax_label',
				'value'       => array_flip( array(
					'default'     => esc_html__( 'Default', 'cardealer-helper' ),
					'highlighted' => esc_html__( 'Highlighted', 'cardealer-helper' ),
				) ),
				'std'     => 'default',
				'save_always' => true,
				'description' => esc_html__( 'Select label type.', 'cardealer-helper' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Alignment', 'cardealer-helper' ),
				'param_name'  => 'tax_label_alignment',
				'value'       => array_flip( array(
					'left'  => esc_html__( 'Left', 'cardealer-helper' ),
					'right' => esc_html__( 'Right', 'cardealer-helper' ),
				) ),
				'std'         => 'left',
				'save_always' => true,
				'description' => esc_html__( 'Select alignment. Note: Not applicable in mobile view.', 'cardealer-helper' ),
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);

		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Price', 'cardealer-helper' ),
				'description'             => esc_html__( 'Vehicle Price', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_price',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_price' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_price_shortcode_vc_map' );
