<?php
/**
 * CarDealer Vehicle Video Button Shortcode
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package car-dealer-helper
 */

add_shortcode( 'cd_vehicle_video_button', 'cdhl_vehicle_video_button_shortcode' );

/**
 * Shortcode HTML.
 *
 * @param array $atts .
 */
function cdhl_vehicle_video_button_shortcode( $atts ) {
	$atts = shortcode_atts(
		array(
			'element_id'  => uniqid( 'cd_video_button' ),
			'title'       => esc_html__( 'Vehicle video', 'cardealer-helper' ),
			'button_type' => 'default',
			'alignment'   => 'inline',
			'css'         => '',
		),
		$atts
	);

	if ( ! is_singular( 'cars' ) && ! is_singular( CDHL_CPT_Template::CPT ) ) {
		?>
		<div class="alert alert-danger" role="alert" style="margin: 0;">
			<h4 class="alert-heading"><?php esc_html_e( 'Important Note', 'cardealer-helper' ); ?></h4>
			<p><?php esc_html_e( 'This shortcode will only work on single vehicle page.', 'cardealer-helper' ); ?></p>
		</div>
		<?php
		return;
	}

	if ( class_exists( 'CDHL_CPT_Template' ) ) {
		$post_id = CDHL_CPT_Template::get_post_id( 'vehicle_detail' );
	} else {
		$post_id = get_the_ID();
	}

	$wrapper_class = 'cd-video-button ' . $atts['button_type'] . ' ' . $atts['alignment'] . vc_shortcode_custom_css_class( $atts['css'], ' ' );
	ob_start();
	?>
	<div id="<?php echo esc_attr( $atts['element_id'] ); ?>" class="<?php echo esc_attr( $wrapper_class ); ?>">
		<?php
		$video_link = get_post_meta( $post_id, 'video_link', true );
		if ( ! empty( $video_link ) ) {
			?>
			<div class="play-video popup-gallery default">
				<a class="popup-youtube" href="<?php echo esc_url( $video_link ); ?>" title="<?php echo esc_attr( get_the_title() ); ?>"> <i class="fas fa-play"></i> <?php echo esc_html( $atts['title'] ); ?></a>
			</div>
			<?php
		}
		?>
	</div>
	<?php
	return ob_get_clean();
}

/**
 * Shortcode mapping.
 *
 * @return void
 */
function cdhl_vehicle_video_button_shortcode_vc_map() {
	if ( function_exists( 'vc_map' ) ) {
		$params = array(
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Title', 'cardealer-helper' ),
				'description' => esc_html__( 'Enter title here', 'cardealer-helper' ),
				'param_name'  => 'title',
				'value'       => esc_html__( 'Vehicle video', 'cardealer-helper' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Video Button Type', 'cardealer-helper' ),
				'param_name'  => 'button_type',
				'value'       => array_flip( array(
					'default' => esc_html__( 'Default', 'cardealer-helper' ),
					'rounded' => esc_html__( 'Rounded', 'cardealer-helper' ),
				) ),
				'std'     => 'default',
				'save_always' => true,
				'description' => esc_html__( 'Select button type.', 'cardealer-helper' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Alignment', 'cardealer-helper' ),
				'param_name'  => 'alignment',
				'value'       => array_flip( array(
					'inline'    => esc_html__( 'Inline', 'cardealer-helper' ),
					'fullwidth' => esc_html__( 'Full Width', 'cardealer-helper' ),
				) ),
				'std'         => 'inline',
				'save_always' => true,
				'description' => esc_html__( 'Select alignment.', 'cardealer-helper' ),
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'cardealer-helper' ),
				'param_name' => 'css',
				'group'      => esc_html__( 'Design Options', 'cardealer-helper' ),
			),
		);

		vc_map(
			array(
				'name'                    => esc_html__( 'Vehicle Video Button', 'cardealer-helper' ),
				'description'             => esc_html__( 'Vehicle Video Button', 'cardealer-helper' ),
				'base'                    => 'cd_vehicle_video_button',
				'class'                   => 'cardealer_helper_element_wrapper',
				'controls'                => 'full',
				'icon'                    => cardealer_vc_shortcode_icon( 'cd_vehicle_video_button' ),
				'category'                => esc_html__( 'Potenza Vehicle Detail', 'cardealer-helper' ),
				'show_settings_on_create' => true,
				'params'                  => $params,
			)
		);
	}
}
add_action( 'vc_before_init', 'cdhl_vehicle_video_button_shortcode_vc_map' );
