<?php
use Ballen\Distical\Calculator as DistanceCalculator;
use Ballen\Distical\Entities\LatLong;

function cdhl_distance_calculator( $from_lat = '', $from_lng = '', $to_lat = '', $to_lng = '', $unit = 'km' ) {
	$distance_length = false;
	if ( ! empty( $from_lat ) && ! empty( $from_lng ) && ! empty( $to_lat ) && ! empty( $to_lng ) ) {
		// Set our Lat/Long coordinates
		$from = new LatLong(52.057941, 1.147172);
		$to   = new LatLong(51.507608, -0.127822);

		$from = new LatLong( $from_lat, $from_lng );
		$to   = new LatLong( $to_lat, $to_lng );

		// Get the distance between these two Lat/Long coordinates...
		$distance_calculator = new DistanceCalculator( $from, $to );

		// You can then compute the distance.
		$distance = $distance_calculator->get();

		if ( 'nmi' === $unit ) {
			$distance_length = $distance->asNauticalMiles();
		} elseif ( 'mi' === $unit ) {
			$distance_length = $distance->asMiles();
		} else {
			$distance_length = $distance->asKilometres();
		}
	}
	return $distance_length;
}
