<?php

namespace App\Http\Controllers;

use DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
//use App\Account;
//use App\Advertiser;
use App\Advertiser;
use Auth;
use Cache;
use App\Http\Controllers\JsonController;
use Illuminate\Support\Facades\Mail;

class AdminjsonController extends Controller {

    public function __construct() {
        $this->session = SESSION::All();
        $this->user = Auth::User();
    }

    public function adminhome(Request $request) {

		$validate = $this->validateUser();
        
        if ($validate['status'] == 'failed') {
            Auth::logout();
            Session::flush();
            return redirect('/login');
        }
        
        $data = $this->getAllAdvlistWithSummary($request);
        
        return View("/admaccount1", ['advertiser_data' => $data]);
    }

    private function validateUser() {

        if (Auth::check()) {
            $this->user = Auth::User();
            if ($this->user->cannot('ADMIN_ALL') && $this->user->cannot('ADMIN_JSON_CONTROLLER_RIGHTS')) {
                return array('status' => 'failed', 'msg' => 'not_authorized');
            } else {
                return array("status" => "success");
            }
        } else {
            return array('status' => 'failed', 'msg' => 'guest');
        }
    }

    public function viewAllAds(Request $request) {
        $validate = $this->validateUser();
        if ($validate['status'] == 'failed') {
            return json_encode($validate);
        }
        $advertisersObj = $this->getUserAccountsAdvts();
        $advertisers = array_keys($advertisersObj);

        $params['advertisers'] = $advertisers;
        //'admin_status'=>$request->admin_status);
        switch ($request->admin_status) {
            case 'pending':
            case 'approved':
            case 'revision':
            case 'rejected':
                $params['admin_status'] = array($request->admin_status);
                break;
            case 'running':
            case 'pause':
            case 'scheduled':
            case 'insufficient_funds':
            case 'daily_cap_reached':
            case 'complete':
            case 'expired':
            case 'archived':
                $params['status'] = array($request->admin_status);
                break;
            case 'live':
                $params['status'] = array('running', 'pause', 'scheduled', 'insufficient_funds', 'daily_cap_reached');
                break;
        }

        $advAds = $this->getAdvsCampaigns($params);

        return View("/allads", ['advertiser_data' => $advAds, 'admin_status' => $request->admin_status]);
    }

    //below method will work for admin only
    //will define other methods for managers
    public function getAllAdvlistWithSummary($request) {
        $advertiser_data = array();
        $validate = $this->validateUser();
        if ($validate['status'] == 'failed') {
            return json_encode($validate);
        }
        $advertiser_data['status'] = 'success';
        if (!isset($request->start_date)) {
            $start_date = date('Y-m-d');
        } else {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start_date);
            $start_date = $dateTimeObj->format('Y-m-d');
        }

        if (!isset($request->end_date)) {
            $end_date = date('Y-m-d');
        } else {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end_date);
            $end_date = $dateTimeObj->format('Y-m-d');
        }

        $advertisersObj = $this->getUserAccountsAdvts();

        $advertiser_stats_detail = $this->getAdvertisersStatsSummary($start_date, $end_date);
        $campaigns_count_arr = $this->getAllCampaignsCountFromAdvertisersObj();

        $statsTotal = $this->getAdvertisersStatsTotal();
        $advertiser_data = array();
        $campListingPriority = config('app.campListingPriority');

        foreach ($campListingPriority as $priorityKey) {
            if (array_key_exists($priorityKey, $campaigns_count_arr['admin_status'])) {
                $typeCampaignArr = $campaigns_count_arr['admin_status'][$priorityKey];
                foreach ($typeCampaignArr as $advertiser_id => $count) {
                    $advertiser_data[$advertiser_id]['campaign_status'][$priorityKey] = $count;
                    if (count($advertiser_data[$advertiser_id]['campaign_status']) > 1)
                        continue;
                    $advertiser_array_row = $advertisersObj[$advertiser_id]->toArray();

                    $advertiser_data[$advertiser_id]['advertiser_id'] = $advertiser_array_row['advertiser_id'];
                    $advertiser_data[$advertiser_id]['company'] = $advertiser_array_row['company'];
                    $advertiser_data[$advertiser_id]['contact_name'] = $advertiser_array_row['contact_name'];
                    $advertiser_data[$advertiser_id]['contact_email'] = $advertiser_array_row['contact_email'];
                    $advertiser_data[$advertiser_id]['domain'] = $advertiser_array_row['advertiser_domain'];
                    $advertiser_data[$advertiser_id]['balance_left_dollar'] = $advertiser_array_row['balance_left_dollar'];
                    $advertiser_data[$advertiser_id]['balance_left_currency'] = $advertiser_array_row['balance_left_currency'];
                    $advertiser_data[$advertiser_id]['currency'] = $advertiser_array_row['currency'];
                    $advertiser_data[$advertiser_id]['status'] = $advertiser_array_row['status'];
                    if (array_key_exists($advertiser_id, $advertiser_stats_detail)) {
                        $advertiser_data[$advertiser_id]['impressions'] = $advertiser_stats_detail[$advertiser_id]['impressions'];
                        $advertiser_data[$advertiser_id]['clicks'] = $advertiser_stats_detail[$advertiser_id]['clicks'];
                        $advertiser_data[$advertiser_id]['conversions'] = $advertiser_stats_detail[$advertiser_id]['conversions'];
                        $advertiser_data[$advertiser_id]['spend'] = $advertiser_stats_detail[$advertiser_id]['spend'];
                        $advertiser_data[$advertiser_id]['spend_currency'] = $advertiser_stats_detail[$advertiser_id]['spend_currency'];
                        $advertiser_data[$advertiser_id]['cost_value'] = $advertiser_stats_detail[$advertiser_id]['cost_value'];
                        $advertiser_data[$advertiser_id]['cost_value_currency'] = $advertiser_stats_detail[$advertiser_id]['cost_value_currency'];
                    } else {
                        $advertiser_data[$advertiser_id]['impressions'] = 0;
                        $advertiser_data[$advertiser_id]['clicks'] = 0;
                        $advertiser_data[$advertiser_id]['conversions'] = 0;
                        $advertiser_data[$advertiser_id]['spend'] = 0;
                        $advertiser_data[$advertiser_id]['spend_currency'] = 0;
                        $advertiser_data[$advertiser_id]['cost_value'] = 0;
                        $advertiser_data[$advertiser_id]['cost_value_currency'] = 0;
                    }

                    //unset($advertisersObj[$advertiser_id]);
                }
            }
        }

        foreach ($advertisersObj as $advertiserObjRow) {
            $advertiser_id = $advertiserObjRow->advertiser_id;
            if (array_key_exists($advertiser_id, $advertiser_data))
                continue;
            // $advertiser_data[$advertiser_id] = $advertiserObjRow->toArray();

            $advertiser_array_row = $advertisersObj[$advertiser_id]->toArray();
            $advertiser_data[$advertiser_id]['advertiser_id'] = $advertiser_array_row['advertiser_id'];
            $advertiser_data[$advertiser_id]['company'] = $advertiser_array_row['company'];
            $advertiser_data[$advertiser_id]['contact_name'] = $advertiser_array_row['contact_name'];
            $advertiser_data[$advertiser_id]['contact_email'] = $advertiser_array_row['contact_email'];
            $advertiser_data[$advertiser_id]['domain'] = $advertiser_array_row['advertiser_domain'];
            $advertiser_data[$advertiser_id]['balance_left_dollar'] = $advertiser_array_row['balance_left_dollar'];
            $advertiser_data[$advertiser_id]['balance_left_currency'] = $advertiser_array_row['balance_left_currency'];
            $advertiser_data[$advertiser_id]['currency'] = $advertiser_array_row['currency'];
            $advertiser_data[$advertiser_id]['status'] = $advertiser_array_row['status'];

            if (array_key_exists($advertiser_id, $advertiser_stats_detail)) {
                $advertiser_data[$advertiser_id]['impressions'] = $advertiser_stats_detail[$advertiser_id]['impressions'];
                $advertiser_data[$advertiser_id]['clicks'] = $advertiser_stats_detail[$advertiser_id]['clicks'];
                $advertiser_data[$advertiser_id]['conversions'] = $advertiser_stats_detail[$advertiser_id]['conversions'];
                $advertiser_data[$advertiser_id]['spend'] = $advertiser_stats_detail[$advertiser_id]['spend'];
                $advertiser_data[$advertiser_id]['spend_currency'] = $advertiser_stats_detail[$advertiser_id]['spend_currency'];
                $advertiser_data[$advertiser_id]['cost_value'] = $advertiser_stats_detail[$advertiser_id]['cost_value'];
                $advertiser_data[$advertiser_id]['cost_value_currency'] = $advertiser_stats_detail[$advertiser_id]['cost_value_currency'];
            } else {
                $advertiser_data[$advertiser_id]['impressions'] = 0;
                $advertiser_data[$advertiser_id]['clicks'] = 450;
                $advertiser_data[$advertiser_id]['conversions'] = 0454;
                $advertiser_data[$advertiser_id]['spend'] = 0;
                $advertiser_data[$advertiser_id]['spend_currency'] = 0;
                $advertiser_data[$advertiser_id]['cost_value'] = 0;
                $advertiser_data[$advertiser_id]['cost_value_currency'] = 0;
            }
            $advertiser_data[$advertiser_id]['campaign_status'] = array();
        }

        $return['advertiser_data'] = array_values($advertiser_data);
        if (isset($campaigns_count_arr['total_running'])) {
            $return['active_campaigns'] = $campaigns_count_arr['total_running'];
        } else {
            $return['active_campaigns'] = 0;
        }
        $return['status'] = isset($campaigns_count_arr['status']) ?  $campaigns_count_arr['status'] ? $campaigns_count_arr['status'] :'' :'' ;

        $return['total_clicks'] = $statsTotal['total_clicks'];
        $return['total_spend'] = $statsTotal['total_spend'];
        $return['account_balance'] = $statsTotal['account_banance_dollar'];
        return json_encode($return);
    }

    public function advertiserCampaignsView(Request $request) {

        $validate = $this->validateUser();

        if($validate['status'] == 'failed') {
            Auth::logout();
            Session::flush();
            return redirect('/login');
        }

        $params = array();
        if (isset($request->advertiser_id) && $request->advertiser_id != 'all') {
            $params['advertiser_id'] = $request->advertiser_id;
        }

        if (isset($request->publisher_id)) {
            $params['publisher_id'] = $request->publisher_id;
        }


        if (isset($request->admin_status)) {
            $params['admin_status'] = $request->admin_status;
        }

        if (isset($request->pricing_modal) && $request->pricing_modal != 'All' ) {
            $params['campaign_pricing_model'] = $request->pricing_modal;
        }


        $campaignData = $this->getAdvertiserCampaigns($request);


        $campaignDataArray = json_decode($campaignData, true);
        $campaignData = $campaignDataArray['campaign_info'];
        $adpub_info = $campaignDataArray['adpub_info'];
        $cpaid_value = $this->getCPAidValue();
        $advertisersObj = $this->getUserAccountsAdvts();

        $params['advertisersObj'] = $advertisersObj;
        
        $params['publishers'] = $this->getAllPublishers();
        
        $params['campaignData'] = $campaignData;
        $params['adpub_info'] = $adpub_info;
        $params['cpaid_value'] = $cpaid_value;
        $params['request'] = $request;

        return View('admin_adv_campaigns', $params);
    }

    public function addDomianAdvertiser(Request $request) {

        $validate = $this->validateUser();
        if ($validate['status'] == 'failed') {
            return json_encode(array('status' => 'failed', 'msg' => 'Update failed'));
        }
        if (!empty($request->advid)) {
            $advertiserObj = $this->getUserAccountsAdvts();
            if (!array_key_exists($request->advid, $advertiserObj)) {
                return json_encode(array('status' => 'success', 'msg' => 'Update failed'));
            }
            $advDetail = \App\Advertiser::find($request->advid);
            if ($advDetail) {
                $advDetail->advertiser_domain = $request->cpmval;
                $advDetail->save();
                return json_encode(array('status' => 'success', 'msg' => 'Updated Successfully.'));
            }
        }
        return json_encode(array('status' => 'success', 'msg' => 'Update failed'));
    }

    public function getAdvertiserCampaigns(Request $request) {

        $campaignsData = array();
        if (Auth::check()) {
            $user = Auth::User();
            $advertiserObj = $this->getUserAccountsAdvts();

            if (isset($request->advertiser_id) && $request->advertiser_id!='all' && !array_key_exists($request->advertiser_id, $advertiserObj)) {
                return json_encode(false);
            }
            $params = array();

            if (!empty($request->advertiser_id) && $request->advertiser_id != 'all') {
                $params['advertisers'] = array($request->advertiser_id);
            } else {
                $params['advertisers'] = array_keys($advertiserObj);
            }


            if(!empty($request->campaign_pricing_model) && $request->campaign_pricing_model !='All'){
                $params['campaign_pricing_model'] = array($request->campaign_pricing_model);
            }

            switch ($request->admin_status) {
                case 'pending':
                case 'approved':
                case 'revision':
                case 'rejected':
                $params['admin_status'] = array($request->admin_status);
                break;
                case 'running':
                case 'pause':
                case 'scheduled':
                case 'insufficient_funds':
                case 'daily_cap_reached':
                case 'complete':
                case 'expired':
                case 'archived':
                $params['status'] = array($request->admin_status);
                break;
                case 'live':
                $params['status'] = array('running', 'pause', 'scheduled', 'insufficient_funds', 'daily_cap_reached');
                break;
                case 'all':
                default:
                $params['status'] = array('running', 'pause', 'scheduled', 'insufficient_funds', 'daily_cap_reached', 'pending', 'complete', 'expired', 'rejected', 'archived');
                break;
            }

            $advCampaigns = $this->getAdvsCampaigns($params);

            //$campaigns = $advCampaigns[$request->advertiser_id];
            if (isset($request->startdate)) {
                $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->startdate);
                $start = $dateTimeObj->format('Y-m-d');
            } else {
                $start = date('Y-m-d');
            }
            if (isset($request->enddate)) {
                $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->enddate);
                $end = $dateTimeObj->format('Y-m-d');
            } else {
                $end = date('Y-m-d');
            }
            $campaignsStats = $this->getCampaignsStatsSummary($start, $end, array("advertisers" => $params['advertisers']));

            $campListingPriority = config('app.campListingPriority');
            // print_r($campListingPriority);
            $pubAds = array();
            if (!empty($request->publisher_id) && $request->publisher_id != 'all') {
                $publisherObj = \App\Publisher::find($request->publisher_id);
                foreach($publisherObj->ads as $adrow){
                    $pubAds[] = $adrow->ad_id; 
                }
            }

            foreach ($campListingPriority as $priority_status) {
            
                foreach ($advCampaigns as $advertiser_id => $campaigns) {

                    foreach ($campaigns as $campaignRow) {
                        if ($campaignRow['admin_status'] == $priority_status) {

                            if (count($pubAds) && !in_array($campaignRow['ad_id'], $pubAds)) {
                                continue;
                            }

                            $campaignsData[$campaignRow['campaign_id']]['campaign_data'] = $campaignRow;
                            $allAds[] = $campaignRow['ad_id'];
                            if (isset($campaignsStats[$advertiser_id][$campaignRow['campaign_id']]) && !empty($campaignsStats[$advertiser_id][$campaignRow['campaign_id']])) {
                                $campaignsData[$campaignRow['campaign_id']]['stats'] = $campaignsStats[$advertiser_id][$campaignRow['campaign_id']];



                            } else {
                                //defualt reports display
                                $campaignsData[$campaignRow['campaign_id']]['stats']['impressions'] = 0;
                                $campaignsData[$campaignRow['campaign_id']]['stats']['clicks'] = 0;
                                $campaignsData[$campaignRow['campaign_id']]['stats']['conversions'] = 0;
                                $campaignsData[$campaignRow['campaign_id']]['stats']['spend'] = 0;
                                $campaignsData[$campaignRow['campaign_id']]['stats']['spend_currency'] = 0;
                                $campaignsData[$campaignRow['campaign_id']]['stats']['cost_value'] = 0;
                                $campaignsData[$campaignRow['campaign_id']]['stats']['cost_value_currency'] = 0;
                            }
                        }
                    }
                }
            }

            foreach ($advCampaigns as $advertiser_id => $campaigns) {
                foreach ($campaigns as $campaignRow) {
                    if (!in_array($campaignRow['admin_status'], $campListingPriority)) {

                        if (count($pubAds) && !in_array($campaignRow['ad_id'], $pubAds)) {
                            continue;
                        }
                        $campaignsData[$campaignRow['campaign_id']]['campaign_data'] = $campaignRow;
                        $allAds[] = $campaignRow['ad_id'];
                        if (isset($campaignsStats[$advertiser_id][$campaignRow['campaign_id']]) && !empty($campaignsStats[$advertiser_id][$campaignRow['campaign_id']])) {
                            $campaignsData[$campaignRow['campaign_id']]['stats'] = $campaignsStats[$advertiser_id][$campaignRow['campaign_id']];
                        } else {
                            $campaignsData[$campaignRow['campaign_id']]['stats']['impressions'] = 0;
                            $campaignsData[$campaignRow['campaign_id']]['stats']['clicks'] = 0;
                            $campaignsData[$campaignRow['campaign_id']]['stats']['conversions'] = 0;
                            $campaignsData[$campaignRow['campaign_id']]['stats']['spend'] = 0;
                            $campaignsData[$campaignRow['campaign_id']]['stats']['spend_currency'] = 0;
                            $campaignsData[$campaignRow['campaign_id']]['stats']['cost_value'] = 0;
                            $campaignsData[$campaignRow['campaign_id']]['stats']['cost_value_currency'] = 0;
                        }
                    }
                }
            }

            $ad_publishers = array();
            if (isset($allAds) && count($allAds)) {
                $ad_publishers = $this->getAdsPublishers(array('ads' => $allAds));
            }
        }

        $return['campaign_info'] = $campaignsData;
        $return['adpub_info'] = $ad_publishers;
        return json_encode($return);
    }

    public function reviewCampaignView(Request $request) {

        $validate = $this->validateUser();
        if ($validate['status'] == 'failed') {
            Auth::logout();
            Session::flush();
            return redirect('/login');
        }
        $error = false;
        if (!isset($request->advertiser_id) || empty($request->advertiser_id)) {
            $error = true;
        }
        if (!isset($request->campaign_id) || empty($request->campaign_id)) {
            $error = true;
        }
        if ($error == true) {
            echo "No advertiser / campaignid selected";
            exit;
        }
        $advertiserObj = $this->getUserAccountsAdvts();

        if (!array_key_exists($request->advertiser_id, $advertiserObj)) {
            echo "Access denied";
            exit;
        }
        $params = array();
        $params['advertisers'] = array($request->advertiser_id);
        $params['campaigns'] = array($request->campaign_id);
        $params['admin_status'] = array('pending');
        $advAds = $this->getAdvsCampaigns($params);

        if ($advAds) {
            $campaign_data = $advAds[$request->advertiser_id][$request->campaign_id];
            $creativeIds = $advAds[$request->advertiser_id][$request->campaign_id]['creative_ids'];
            $creative_groups = explode(",", $creativeIds);
            $creativeDetail = $this->getAdCreatives(array('creative_groups' => $creative_groups));
            return View("/reviewad", ['campaign_data' => $campaign_data, 'creative_groups' => $creativeDetail->toArray()]);
        }
    }

    public function reviewCampaignSave(Request $request) {
        $validate = $this->validateUser();
        if ($validate['status'] == 'failed') {
            Auth::logout();
            Session::flush();
            return json_encode($validate);
        }

        $error = false;
        if (!isset($request->advertiser_id) || empty($request->advertiser_id)) {
            $error = true;
        }
        if (!isset($request->campaign_id) || empty($request->campaign_id)) {
            $error = true;
        }
        $advertiserObj = $this->getUserAccountsAdvts();
        if (!array_key_exists($request->advertiser_id, $advertiserObj)) {
            $error = true;
        }
        if ($error == true) {
            return json_encode(array('status' => 'failed', 'msg' => 'not_authorized'));
        }
        $params = array();
        $params['advertisers'] = array($request->advertiser_id);
        $params['campaigns'] = array($request->campaign_id);
        $params['admin_status'] = array('pending');
        $advAds = $this->getAdvsCampaigns($params);
        $status['approved'] = 'approved';
        $email_data = array();
        $re = 0;
        $rj = 0;
        $ap = 0;
        if (!empty($request->image)) {
            $images = explode(",", $request->image);
            foreach ($images as $banner_key) {
                list($status, $group_id) = explode("_", $banner_key);
                $creativeGroup = \App\CreativeGroup::find($group_id);
                if ($status != 'ap') {
                    $email_data['images'][$status][${$status} ++]['url'] = config('app.cdnbaseurl') . "usr_images/" . $creativeGroup->file_name;
                } else {
                    ${$status} ++;
                }
            }
        }

        if (!empty($request->destination_url)) {
            ${$request->destination_url} ++;

            if ($request->destination_url != 'ap') {
                $email_data['destination_url'] = $request->destination_url;
            }
        }
        $email_data['comments'] = $request->comments;

        $adInfo = \App\Ads::find($advAds[$request->advertiser_id][$request->campaign_id]['ad_id']);
        $campInfo = \App\Campaigns::find($request->campaign_id);
        if ($re == 0 && $rj == 0 && $ap > 0) {
            $curdate = $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end_date);
            $ac_date_time = new \DateTime($adInfo->activate_date_time);
            $cur_date_time = new \DateTime("now");
            if ($cur_date_time >= $ac_date_time) {
                $adInfo->ad_status = 1;
                $adInfo->admin_status = 'approved';
                $campInfo->admin_status = 'approved';
                if ($campInfo->status == 'pending') {
                    $campInfo->status = 'running';
                }
            } else {
                $adInfo->ad_status = 1;
                $adInfo->admin_status = 'approved';
                $campInfo->admin_status = 'approved';
                $campInfo->status = 'scheduled';
            }
        } elseif ($rj > 0) {
            $adInfo->ad_status = 1;
            $adInfo->admin_status = 'rejected';
            $campInfo->admin_status = 'rejected';
        } elseif ($re > 0) {
            $adInfo->ad_status = 1;
            $adInfo->admin_status = 'revision';
            $campInfo->admin_status = 'revision';
        }
        $adInfo->save();
        $campInfo->save();
        $contact_email = $advAds[$request->advertiser_id][$request->campaign_id]['contact_email'];
        $contact_name = $advAds[$request->advertiser_id][$request->campaign_id]['contact_name'];

        if ($rj > 0 || $re > 0) {
            if ($rj > 0) {
                $subject = 'Admin rejected ' . $campInfo->campaign_name;
            } else {
                $subject = 'Admin suggested revision on ' . $campInfo->campaign_name;
            }
            //send revision or rejected mail to advertiser

            Mail::send('ad_revision_rejected', ['email_data' => $email_data, 'advertiser_data' => $advAds[$request->advertiser_id][$request->campaign_id]], function($message) use($contact_email, $contact_name, $subject) {

                $message->from(config('all.noreply_email'), 'Vola.ad')
                        //->to($contact_email, $contact_name)
                        ->to('manoj.y@collectcent.com', $contact_name)
                        ->subject($subject);
            });
        } else {
            $subject = "Admin approved " . $campInfo->campaign_name;
            Mail::send('ad_approved', ['email_data' => $email_data, 'advertiser_data' => $advAds[$request->advertiser_id][$request->campaign_id]], function($message) use($contact_email, $contact_name, $subject) {
                $message->from(config('all.noreply_email'), 'Vola.ad')
                        //->to($contact_email, $contact_name)
                        ->to('manoj.y@collectcent.com', $contact_name)
                        ->subject($subject);
            });
        }
        return json_encode(array('status' => 'success', 're' => $re, 'rj' => $rj, 'ap' => $ap));
    }

    private function getCPAidValue() {
        $cpaidvalueObj = \App\CpaidValue::get();
        $cpaIdArr = array();
        foreach ($cpaidvalueObj as $cpaidvalueRow) {
            $cpaIdArr[$cpaidvalueRow->cpa_id] = $cpaidvalueRow->cpa_value;
        }
        return $cpaIdArr;
    }

    private function getAdCreatives($params = array()) {

        $creative_group_model = new \App\CreativeGroup();
        if (isset($params['creative_groups']) && !empty($params['creative_groups'])) {
            $creative_group_model = $creative_group_model->whereIn('group_id', $params['creative_groups']);
        }
        if (isset($params['advertisers']) && !empty($params['advertisers'])) {
            $creative_group_model = $creative_group_model->whereIn('advertiser_id', $params['advertisers']);
        }
        $creativeDetails = $creative_group_model->get();
        return $creativeDetails;
    }

    public function statsView() {
        echo "coming soon";
        exit;
    }

    public function campaignView() {
        echo "coming soon";
        exit;
    }

    public function changeCampaignStatus(Request $request) {

        $user = Auth::User();
        $campaignDetail = \App\Campaigns::find($request->campaign_id);
        if ($campaignDetail) {
            $advertisersObj = $this->getUserAccountsAdvts();
            if (array_key_exists($campaignDetail->advertiser_id, $advertisersObj)) {

                switch ($request->action) {
                    case 'run':
                        if ($campaignDetail->status == 'pause' && ($user->can('ADMIN_ALL') || $user->can('RUN_CAMPAIGN'))) {
                            $campaignDetail->status = 'running';
                            $campaignDetail->save();
                            return json_encode(array('status' => 'success'));
                        }
                        break;
                    case 'pause':
                        if ($campaignDetail->status == 'running' && ($user->can('ADMIN_ALL') || $user->can('PAUSE_CAMPAIGN'))) {
                            $campaignDetail->status = 'pause';
                            $campaignDetail->save();
                            return json_encode(array('status' => 'success'));
                        } else {
                            return json_encode(array('status' => 'failed', 'msg' => 'not_authorized'));
                        }

                        break;
                    case 'approve':
                    case 'revise':
                    case 'reject':

                        if ($campaignDetail->status == 'pending' || $campaignDetail->admin_status == 'pending' && ($user->can('ADMIN_ALL') || $user->can('APPROVE_CAMPAIGN'))) {
                            switch ($request->action) {
                                case 'approve':$status = 'approved';
                                    break;
                                case 'revise':$status = 'revision';
                                    break;
                                case 'reject':$status = 'rejected';
                                    break;
                            }
                            $campaignDetail->status = $status;
                            $campaignDetail->admin_status = $status;

                            $campaignDetail->save();
                            $ads = $campaignDetail->ads;
                            if ($ads) {
                                foreach ($ads as $ad) {
                                    $ad->admin_status = $status;
                                    $ad->save();
                                }
                            }
                            return json_encode(array('status' => 'success'));
                        } else {
                            return json_encode(array('status' => 'failed', 'msg' => 'not_authorized'));
                        }
                        break;
                }
            }
        }
        return json_encode(array("status" => "failed"));
    }

    //request params:: publishers:comma separated publisher_id, campaign_id:campagn_id
    public function addAds2Publishers(Request $request) {

        $pubsArr = $request->publishers;

        $camInfo = \App\Campaigns::find($request->campaign_id);
        $counter = 0;
        if ($camInfo && $advertiser = $camInfo->advertiser) {
            if ($advertiser) {
                //getting advertiserobj for this session
                $advertisersObj = $this->getUserAccountsAdvts();
                //checking if advertiser belongs to this session user
                if (array_key_exists($advertiser->advertiser_id, $advertisersObj)) {

                    $campaignAds = $camInfo->ads;
                    //getting all campaign ads
                    if ($campaignAds) {
                        $updated_pubs = array();

                        foreach ($campaignAds as $adObj) {

                            $existingPublishers = $adObj->publishers;
                            if (count($existingPublishers)) {
                                $existingPublishersArr = array_column($existingPublishers->toArray(), 'publisher_id');
                            } else {
                                $existingPublishersArr = array();
                            }

                            foreach ($pubsArr as $pubId) {
                                if (!in_array(trim($pubId), $existingPublishersArr)) {
                                    //insert publisher id in ad_publisher table
                                    $ad_pub_obj = new \App\AdPublisher();
                                    $ad_pub_obj->publisher_id = $pubId;
                                    $ad_pub_obj->ad_id = $adObj->ad_id;
                                    $ad_pub_obj->save();
                                    $updated_pubs[$pubId] = $pubId;
                                    $counter++;
                                }
                            }
                            foreach ($existingPublishersArr as $existingPubId) {
                                if (!in_array($existingPubId, $pubsArr)) {
                                    //echo " two  ";
                                    $ad_pub_obj = new \App\AdPublisher();
                                    $ad_pub_obj->where('publisher_id', '=', $existingPubId)
                                            ->where('ad_id', '=', $adObj->ad_id)
                                            ->delete();
                                    $updated_pubs[$existingPubId] = $existingPubId;
                                }
                            }
                        }

                        if (count($updated_pubs)) {
                            foreach ($updated_pubs as $pub_id) {
                                $pubInfo = \App\Publisher::find($pub_id);
                                if ($pubInfo) {
                                    $pubAds = $pubInfo->ads;
                                    if (count($pubAds)) {
                                        $pubAdIds = implode(",", array_column($pubAds->toArray(), 'ad_id'));
                                        $pubInfo->adids = $pubAdIds . ",";
                                        $pubInfo->save();
                                    } else {
                                        $pubInfo->adids = "";
                                        $pubInfo->save();
                                    }
                                }
                            }
                        }

                        return json_encode(array("status" => "success"));
                    }// end campaign ids
                }
            }
        }
        return json_encode(array("status" => "failed", "msg" => "not_authorized"));
    }

    public function getCampaignPublishers(Request $request) {
        $campaign = \App\Campaigns::find($request->campaign_id);
        $linkedPublishers = array();

        if ($campaign) {
            $campaignAds = $campaign->ads;
            foreach ($campaignAds as $adObj) {
                $adPublishers = $adObj->publishers;

                if ($adPublishers) {
                    $adPublisherArr = array_column($adPublishers->toArray(), 'publisher_id');
                    $linkedPublishers = array_merge($linkedPublishers, $adPublisherArr);
                }
            }
        }
        return json_encode($linkedPublishers);
    }

    public function getAllPublishers($return_type='keyvalue') {
        $publisherArr = array();
        $publishers = \App\Publisher::get();
        if ($publishers) {
            $publisherArr = $publishers->toArray();
            if ($return_type == 'keyvalue') {
                $publisherArr = array_column($publisherArr, 'company', 'publisher_id');
            }
        }
        return json_encode($publisherArr);
    }

    public function updateAdvertiserBasicInfo(Request $request) {

        $validate = $this->validateUser();
        if ($validate['status'] == 'failed') {
            return json_encode(array('status' => 'failed', 'msg' => 'Update failed'));
        }
        if (!empty($request->advertiser_id)) {
            $advertiserObj = $this->getUserAccountsAdvts();
            if (!array_key_exists($request->advertiser_id, $advertiserObj)) {
                return json_encode(array('status' => 'success', 'msg' => 'Update failed'));
            }
            $advDetail = \App\Advertiser::find($request->advertiser_id);

            $advDetail = \App\Advertiser::find($request->advertiser_id);

            $validator = Validator::make(
                            array(
                        'contact_name' => $request->contact_name,
                        'last_name' => $request->last_name,
                        'email_address' => $request->email_address,
                        'phone_number' => $request->phone_number,
                            ), array(
                        'contact_name' => 'required',
                        'last_name' => 'required',
                        'email_address' => 'required|email',
                        'phone_number' => 'required|number',
                            )
            );
            if ($validator->fails()) {
                return redirect(config('app.local_url') . "admin/advinfo/" . $request->advertiser_id)->withErrors($validator)->with(array('contact_name' => $request->contact_name, 'last_name' => $request->last_name, 'email_address' => $request->email_address, 'phone_number' => $request->phone_number))->withInput();
            }

            if ($advDetail) {

                $advDetail->advertiser_domain = $request->cpmval;
                $advDetail->save();

                return json_encode(array('status' => 'success', 'msg' => 'Updated Successfully.'));
            }
        }
    }

    private function updateAdvertiserBillingInfo(Request $request) {
        
    }

    private function getAdvertisersStatsSummary($start_date, $end_date, $accountsArr = array()) {

        $advertisersObj = $this->getUserAccountsAdvts();

        $advertisers = array_keys($advertisersObj);
        $advModel = new \App\hourlyStat();
        $advModel->whereIn('advertiser_id', $advertisers);
        $advreport = $advModel->whereBetween('stat_date', array($start_date, $end_date))
                ->selectRaw("advertiser_id,"
                        . "sum(hourly_stat.impression_count) as impressions,"
                        . "sum(hourly_stat.clicks_count) as clicks,"
                        . "sum(hourly_stat.conversions_count) as conversions,"
                        . "round(sum(revenue_value),3) as spend,"
                        . "round(sum(revenue_value_currency),3) as spend_currency,"
                        . "round(sum(cost_value),3) as cost_value,"
                        . "round(sum(cost_value_currency),3) as cost_value_currency")
                ->groupBy('advertiser_id')
                ->orderBy('stat_date', 'desc')
                ->get();
        if ($advreport != false) {

            $advreportArr = $advreport->toArray();
            $advertiserData = array();
            foreach ($advreportArr as $advReportRow) {
                $advertiserData[$advReportRow['advertiser_id']]['impressions'] = $advReportRow['impressions'];
                $advertiserData[$advReportRow['advertiser_id']]['clicks'] = $advReportRow['clicks'];
                $advertiserData[$advReportRow['advertiser_id']]['conversions'] = $advReportRow['conversions'];
                $advertiserData[$advReportRow['advertiser_id']]['spend'] = $advReportRow['spend'];
                $advertiserData[$advReportRow['advertiser_id']]['spend_currency'] = $advReportRow['spend_currency'];
                $advertiserData[$advReportRow['advertiser_id']]['cost_value'] = $advReportRow['cost_value'];
                $advertiserData[$advReportRow['advertiser_id']]['cost_value_currency'] = $advReportRow['cost_value_currency'];
            }
        }
        return $advertiserData;
    }

    //params:: array("advertisers"=>array(1,2,3),"campaigns"=>array(1,2,3))


    private function getCampaignsStatsSummary($start_date, $end_date, $params = array()) {

        // $statsModel = new \App\hourlyStat();
        $statsModel = new \App\Campaigns(); // new \App\AdactsStat();

         $condition=[];
        if (isset($params['advertisers']) && count($params['advertisers'])) {
            $statsModel = $statsModel->whereIn('advertiser_id', $params['advertisers']);
        }

        if (isset($params['campaigns']) && count($params['campaigns'])) {
            $statsModel = $statsModel->whereIn('campaign_id', $params['campaigns']);
        }
         $statData = $statsModel->leftjoin('adacts_stat', 'adacts_stat.vola_id', '=', 'dl_campaigns.campaign_id')
                   ->leftjoin('adacts_stat_summery', 'adacts_stat_summery.vola_id', '=', 'adacts_stat.vola_id')
                    ->leftJoin('smart_cpa_summery','smart_cpa_summery.id_advertiser_campaign', '=', 'dl_campaigns.remote_id');
                    $statsModel = $statData->whereDate(DB::raw("IF(dl_campaigns.campaign_pricing_model = 'CPM',adacts_stat.timestamp,smart_cpa_summery.date)"),'>=',$start_date)
                   ->whereDate(DB::raw("IF(dl_campaigns.campaign_pricing_model = 'CPM',adacts_stat.timestamp,smart_cpa_summery.date)"),'<=',$end_date)
                ->selectRaw("dl_campaigns.campaign_id,dl_campaigns.advertiser_id,"
                . "sum(IF(dl_campaigns.campaign_pricing_model = 'CPM',adacts_stat.impressions,0)) as  impressions,"
                . "sum(IF(dl_campaigns.campaign_pricing_model = 'CPM',
                                adacts_stat_summery.clicks_count , smart_cpa_summery.clickcount)) as clicks,"
                . "sum(IF(dl_campaigns.campaign_pricing_model = 'CPM',adacts_stat_summery.conversions_count,smart_cpa_summery.active_clickcount)) as conversions,"
                . "round(sum(IF(dl_campaigns.campaign_pricing_model = 'CPM',adacts_stat.spendings,0)),3) as spend,"
                . "round(sum(IF(dl_campaigns.campaign_pricing_model ='CPM',adacts_stat_summery.spendings,0)),3) as spend_currency,"
                . "round(sum(IF(dl_campaigns.campaign_pricing_model ='CPM',adacts_stat_summery.cr,0)),3) as cost_value,"
                . "round(sum(IF(dl_campaigns.campaign_pricing_model ='CPM',adacts_stat_summery.cr,0)),3) as cost_value_currency");
        $statsModel = $statsModel->groupBy('dl_campaigns.advertiser_id','smart_cpa_summery.date','adacts_stat.timestamp');
        $statsModel = $statsModel->groupBy('dl_campaigns.campaign_id');
        $stats = $statsModel->orderBy('adacts_stat.timestamp', 'desc')
                ->get();

        if ($stats != false) {
            $stats = $stats->toArray();
            $advertiserData = array();
            foreach ($stats as $campaignReportRow) {

                $advertiserData[$campaignReportRow['advertiser_id']][$campaignReportRow['campaign_id']]['impressions'] = $campaignReportRow['impressions'];
                $advertiserData[$campaignReportRow['advertiser_id']][$campaignReportRow['campaign_id']]['clicks'] = $campaignReportRow['clicks'];
                $advertiserData[$campaignReportRow['advertiser_id']][$campaignReportRow['campaign_id']]['conversions'] = $campaignReportRow['conversions'];
                $advertiserData[$campaignReportRow['advertiser_id']][$campaignReportRow['campaign_id']]['spend'] = $campaignReportRow['spend'];
                $advertiserData[$campaignReportRow['advertiser_id']][$campaignReportRow['campaign_id']]['spend_currency'] = $campaignReportRow['spend_currency'];
                $advertiserData[$campaignReportRow['advertiser_id']][$campaignReportRow['campaign_id']]['cost_value'] = $campaignReportRow['cost_value'];
                $advertiserData[$campaignReportRow['advertiser_id']][$campaignReportRow['campaign_id']]['cost_value_currency'] = $campaignReportRow['cost_value_currency'];
            }
        }

        return $advertiserData;
    }

    private function getAdvertisersStatsTotal() {

        $start_date = date('Y-m-d');
        $end_date = date('Y-m-d');
        $advertisersObj = $this->getUserAccountsAdvts();
        $advertisers = array();
        $total_arr = array();
        $total_arr['total_clicks'] = 0;
        $total_arr['total_conversions'] = 0;
        $total_arr['total_spend'] = 0;
        $total_arr['account_banance_dollar'] = 0;
        foreach ($advertisersObj as $advertisersObjRow) {
            $total_arr['account_banance_dollar'] += $advertisersObjRow->balance_left_dollar;
        }
        $advModel = new \App\hourlyStat();
        $advertisers = array_keys($advertisersObj);

        $advModel->whereIn('advertiser_id', $advertisers);
        $advreport = $advModel->whereBetween('stat_date', array($start_date, $end_date))
                ->selectRaw(
                        "sum(hourly_stat.impression_count) as impressions,"
                        . "sum(hourly_stat.clicks_count) as clicks,"
                        . "sum(hourly_stat.conversions_count) as conversions,"
                        . "round(sum(revenue_value),3) as spend,"
                        . "round(sum(revenue_value_currency),3) as spend_currency")
                ->get();

        if ($advreport != false) {
            $advreportArr = $advreport->toArray();
            foreach ($advreportArr as $advReportRow) {
                $total_arr['total_clicks'] = (!$advReportRow['clicks']) ? "0" : $advReportRow['clicks'];
                $total_arr['total_conversions'] = (!$advReportRow['conversions']) ? "0" : $advReportRow['conversions'];
                $total_arr['total_spend'] = (!$advReportRow['spend']) ? "0" : $advReportRow['spend'];
            }
        }
        return $total_arr;
    }

    private function getAllCampaignsForAccountsAdvt() {

        if (isset($this->advertisersCampaignsArr)) {
            return $this->advertisersCampaignsArr;
        }
        $advertiserObj = $this->getUserAccountsAdvts();
        $advertiserArr = array();

        foreach ($advertiserObj as $advertiserRow) {

            $advertiserArr[$advertiserRow->advertiser_id]['advertiser_info'] = $advertiserRow->toArray();
            $campaigns = $advertiserRo->Campaigns;
            if ($campaigns != false) {
                $advertiserArr[$advertiserRow->advertiser_id]['campaigns'] = $campaigns->toArray();
            } else {
                $advertiserArr[$advertiserRow->advertiser_id]['campaigns'] = array();
            }
        }
        $this->advertisersCampaignsArr = $advertiserArr;
        return $advertiserArr;
    }

    private function getUserAccountsAdvts() {

        if (isset($this->advertiserObj)) {
            return $this->advertiserObj;
        }

        $advertiserObj = array();

        if (Auth::check()) {
            $user = Auth::User();
            $roles = $user->roles;

            if ($roles[0]['role_slug'] == 'ADMIN') {
                $accountModel = new \App\Account();
                $accountModel = $accountModel->where('account_type', '=', 'ADVERTISER')->orderBy('account_id','=','ASC');
                /* if (is_array($accountsArr) && count($accountsArr)) {
                  $accountModel = $accountModel::whereIn('account_id', $accountArr);
                  } */
                $accountInfoObj = $accountModel->get();
            } else {
                $accountInfoObj = $user->accounts;
            }

            foreach ($accountInfoObj as $accountRow) {
                if ($accountRow->advertiser != false) {
                    $advertiserObj[$accountRow->advertiser->advertiser_id] = $accountRow->advertiser;
                }
            }

            $this->advertiserObj = $advertiserObj;
        }
        return $advertiserObj;
    }




    private function getAllCampaignsCountFromAdvertisersObj() {

        $advertisersObj = $this->getUserAccountsAdvts();
        $campaign_status_data = array();
        /* $campaign_status_data['pending'] = array();
          $campaign_status_data['revision'] = array();
          $campaign_status_data['approved'] = array();
          $campaign_status_data['rejected'] = array();
          $campaign_status_data['running'] = array();
          $campaign_status_data['scheduled'] = array();
          $campaign_status_data['insufficient_funds'] = array();
          $campaign_status_data['daily_cap_reached'] = array();
          $campaign_status_data['pause'] = array();
         */

        $campaign_status_data['total_running'] = 0;
        $campaign_status_data['total_live'] = 0;

        foreach ($advertisersObj as $advertiserRow) {
            $campaigns = $advertiserRow->Campaigns;
            if ($campaigns !== false) {
                foreach ($campaigns as $campaign) {
                    if ($campaign->status == 'running') {
                        $campaign_status_data['total_running'] ++;
                    }
                    switch ($campaign->admin_status) {
                        case 'pending':
                            if (!isset($campaign_status_data['admin_status']['pending'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['admin_status']['pending'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['admin_status']['pending'][$advertiserRow->advertiser_id] +=1;
                            break;
                        case 'revision':
                            if (!isset($campaign_status_data['admin_status']['revision'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['admin_status']['revision'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['admin_status']['revision'][$advertiserRow->advertiser_id] +=1;

                            break;
                        case 'approved':
                            if (!isset($campaign_status_data['admin_status']['approved'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['admin_status']['approved'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['admin_status']['approved'][$advertiserRow->advertiser_id] +=1;
                            if ($campaign->status && $campaign->status == 'running') {
                                if (!isset($campaign_status_data['status']['running'][$advertiserRow->advertiser_id])) {
                                    $campaign_status_data['status']['running'][$advertiserRow->advertiser_id] = 0;
                                }
                                $campaign_status_data['status']['running'][$advertiserRow->advertiser_id] +=1;

                                if (!isset($campaign_status_data['status']['live'][$advertiserRow->advertiser_id])) {
                                    $campaign_status_data['status']['live'][$advertiserRow->advertiser_id] = 0;
                                }
                                $campaign_status_data['status']['live'][$advertiserRow->advertiser_id] += 1;
                            }

                            break;
                        case 'rejected':
                            if (!isset($campaign_status_data['admin_status']['rejected'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['admin_status']['rejected'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['admin_status']['rejected'][$advertiserRow->advertiser_id] +=1;
                            break;
                    }

                    switch ($campaign->status) {
                        case 'scheduled':
                            if (!isset($campaign_status_data['status']['scheduled'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['status']['scheduled'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['status']['scheduled'][$advertiserRow->advertiser_id] +=1;
                            $campaign_status_data['total_live'] ++;

                            if (!isset($campaign_status_data['status']['live'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['status']['live'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['status']['live'][$advertiserRow->advertiser_id] += 1;
                            break;
                        case 'insufficient_funds':
                            if (!isset($campaign_status_data['status']['insufficient_funds'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['status']['insufficient_funds'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['status']['insufficient_funds'][$advertiserRow->advertiser_id] +=1;
                            $campaign_status_data['total_live'] ++;
                            if (!isset($campaign_status_data['status']['live'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['status']['live'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['status']['live'][$advertiserRow->advertiser_id] += 1;


                            break;
                        case 'daily_cap_reached':
                            if (!isset($campaign_status_data['daily_cap_reached'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['daily_cap_reached'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['daily_cap_reached'][$advertiserRow->advertiser_id] +=1;
                            $campaign_status_data['total_live'] ++;
                            if (!isset($campaign_status_data['status']['live'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['status']['live'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['status']['live'][$advertiserRow->advertiser_id] += 1;


                            break;
                        case 'pause':
                            if (!isset($campaign_status_data['status']['pause'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['status']['pause'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['status']['pause'][$advertiserRow->advertiser_id] +=1;
                            $campaign_status_data['total_live'] ++;
                            if (!isset($campaign_status_data['status']['live'][$advertiserRow->advertiser_id])) {
                                $campaign_status_data['status']['live'][$advertiserRow->advertiser_id] = 0;
                            }
                            $campaign_status_data['status']['live'][$advertiserRow->advertiser_id] += 1;

                            break;
                    }
                }
            }
        }
        return $campaign_status_data;
    }

    private function getAdvsCampaigns($params = array()) {
        $campaignData = array();
        $campaignModel = new \App\Campaigns();
        $campaignModel = $campaignModel->Join('ads', 'ads.campaign_id', '=', 'dl_campaigns.campaign_id');
        $campaignModel = $campaignModel->Join('dl_advertisers', 'dl_advertisers.advertiser_id', '=', 'dl_campaigns.advertiser_id');
        $campaignModel = $campaignModel->Join('targeting_channel_group', 'targeting_channel_group.owner_id', '=', 'dl_campaigns.advertiser_id');
        $campaignModel = $campaignModel->selectRaw("dl_campaigns.advertiser_id,"
                . "ads.ad_status,"
                . "ads.admin_status as admin_status_ad,"
                . "ads.ad_id,"
                . "ads.admin_cpm,"
                . "ads.current_cpm,"
                . "ads.destination_url,"
                . "ads.creative_ids,"
                . "dl_campaigns.*,"
                . "targeting_channel_group.*,"
                . "dl_advertisers.company,"
                . "dl_advertisers.advertiser_domain,"
                . "dl_advertisers.contact_name,"
                . "dl_advertisers.contact_email,"
                . "dl_advertisers.currency,"
                . "dl_advertisers.default_currency"
        );

        if (isset($params['advertisers']) && !empty($params['advertisers'])) {
            $campaignModel = $campaignModel->whereIn('dl_campaigns.advertiser_id', $params['advertisers']);
        }

        if (isset($params['campaigns']) && !empty($params['campaigns'])) {
            $campaignModel = $campaignModel->whereIn('dl_campaigns.campaign_id', $params['campaigns']);
        }

        if (isset($params['admin_status']) && !empty($params['admin_status'])) {
            $campaignModel = $campaignModel->whereIn('dl_campaigns.admin_status', $params['admin_status']);
        }

        if (isset($params['campaign_pricing_model']) && !empty($params['campaign_pricing_model'])) {
            $campaignModel = $campaignModel->where('dl_campaigns.campaign_pricing_model', 'like', $params['campaign_pricing_model']); //
        }

        if (isset($params['status']) && !empty($params['status'])) {
            $campaignModel = $campaignModel->whereIn('dl_campaigns.status', $params['status']);
        }
        $campaigns = $campaignModel->get();
        $campaignData = array();
        $allAds = array();
        if ($campaigns) {
            foreach ($campaigns as $campaign) {
                $campaignData[$campaign['advertiser_id']][$campaign['campaign_id']] = $campaign->toArray();
            }
            if (count($allAds)) {
                $adsPubs = $this->getAdsPublishers(array('ads' => $allAds));
            }
        }
        return $campaignData;
    }

    private function getAdsPublishers($params) {
        $adPubModel = new \App\AdPublisher();
        $adPubs = $adPubModel->whereIn('ad_id', $params['ads'])
                ->Join('publishers', 'publishers.publisher_id', '=', 'ad_publisher.publisher_id')
                ->orderBy('ad_id', 'desc')
                ->selectRaw("ad_publisher.ad_id,ad_publisher.publisher_id,publishers.company")
                ->get();
        $adPubs = $adPubs->toArray();
        $adpubdata = array();
        if (count($adPubs)) {
            foreach ($adPubs as $adPub) {
                $adpubdata[$adPub['ad_id']][] = $adPub;
            }
        }
        return $adpubdata;
    }

    private function getCountries() {
        $getAll = Cache::get('countries');
        if (!($getAll)) {
            $getAll = \App\Country::all();
            Cache::store('apc')->put('countries', $getAll, 36000);
        }
        return $getAll->toJson();
    }
    
    function adbvAccountView(Request $request){
        
        if(!Auth::check()) {
		return redirect('/login');	
		}
		
        $user = Auth::User();
        $advertiserInfo = \App\Advertiser::find($request->advertiser_id);
        $accounts_id = $advertiserInfo->account_id;
        $paymentTransactionadvt = \App\PaymentTransaction::with(['advertiser_details'])->where('account_id',$accounts_id)->get();
        return View('/adbvAccountView',compact('paymentTransactionadvt','accounts_id'));
		
	}
	
	function allstats(){
		return view('admin.allstats');
	}

}
