<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Validator;
use Auth;
use Hash;
use File;
use App\User;
use App\Account;
use App\IncludeExchanges;
use Detection\MobileDetect as MobileDetect;
use Illuminate\Support\Facades\Mail;
//Multiple category backend

class CreatadController extends Controller {

    public function __construct(){
        $this->middleware('auth');
        if (!Auth::check()) {
            return false;
        }
        $this->session = SESSION::All();
        if(isset($this->session['sessiondata']['accounts'])){
        $this->advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $this->advertiserdata = $this->advertiserdata->toArray();
        $this->currency = !empty($this->advertiserdata['currency']) ? $this->advertiserdata['currency'] : 'INR';
        }
        $this->mincampaignbudget = config('campaign.mincampaignbudget');
        $this->mindailycap = config('campaign.mindailycap');
    }



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        var_dump('id:', \Session::getId());
        return View('creat-ad');
    }

    /**
     * Show the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function create_ad(Request $request) {
		if (!Auth::check()) {
            return redirect('/login');
        
	}

	      $id = $request->invisible;
        $fldurl = $request->urlfld;
        $cook_key=$request->cook_key;
    	$detect = new MobileDetect();
	    $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        $session = Session::all();
        $accountid = $session['sessiondata']['accounts'][0]['account_id'];
        //$accountid=21;
        $userAdv = \App\Advertiser::where('account_id', '=', $accountid)->get()->first();
        $currentBal=0.00;

        if(!empty($userAdv) && isset($userAdv['account_id'])) {
            if (trim($userAdv['currency']) == '') {
                return redirect("/setcurrency");
            }
            $currentBal=$userAdv['balance_left_currency'];
        }

     

        $IncludeExchangesvalue= IncludeExchanges::select('id','exchangeID','popup','adult')->where('popup','=','1')->orderby('id','desc')->get();
         $IncludeExchanges_select=  $IncludeExchangesvalue->toArray();

       
      
        $adv_id = $session['sessiondata']['accounts'][0]['advertiser_id'];

        $raw=DB::select(DB::raw("select group_concat(concat('{label:','\"',webpage_name,' \"',',','value:','\"',url,'\"}')) as urls from advertiser_webpage where webpage_name not in ('','NULL') and advertiser_id=$adv_id"));
        
        if(trim($raw[0]->urls)!=''){
            $rn=substr(trim($raw[0]->urls),-1);
            if($rn=='}'){
        $srtrowurl=$raw[0]->urls;
            }else{
        $srtrowurl=$raw[0]->urls.'"}';
            }
        }else{
          $srtrowurl='';
        }
        if (isset($id) && $id != "") {
            if ($id != '0_0_0') {
                $valueArr = explode("-", $id);

                    $contextOptions = [
    'ssl' => [
        'verify_peer' => false,
        'verify_peer_name' => false,
        'allow_self_signed' => true
    ]
];

            $sslContext = stream_context_create($contextOptions);
                $json_url = url("json-data/get-iab-categories");
                $json = file_get_contents($json_url,false,$sslContext);
                $data = json_decode($json, true);
                //$typeCat = $valueArr[2];
                $catid = $valueArr[0];
                $cc=explode("B",$catid);
                $catid=isset($cc[1])?$cc[1]:'';
                $subcatid = isset($valueArr[1])?$valueArr[1]:'';
                //$categories = $data[];
                $categories=isset($data[0][$valueArr[0]])?$data[0][$valueArr[0]]:'';
                $subcategories = isset($data[$valueArr[0]][$id])?$data[$valueArr[0]][$id]:'';
                // dd($catid);

		if ($deviceType == 'computer') {
              	 
		 return view('creat-ad', ['categories' => $categories, 'subcategories' => $subcategories, 'catid' => $catid,
                    'subcatid' => $subcatid, 'advcurrency' => $this->currency, 'catbindid' => $id, 'fldurl' => $fldurl,'suggestions'=>$srtrowurl,'cook_key'=>$cook_key,'current_bal'=>$currentBal,'IncludeExchanges_select'=>$IncludeExchanges_select]);
			}else{
			 return view('mob-creat-ad', ['categories' => $categories, 'subcategories' => $subcategories, 'catid' => $catid,
                    'subcatid' => $subcatid, 'advcurrency' => $this->currency, 'catbindid' => $id, 'fldurl' => $fldurl,'suggestions'=>$srtrowurl,'cook_key'=>$cook_key,'current_bal'=>$currentBal,'IncludeExchanges_select'=>$IncludeExchanges_select]);

			}
            } else {
		if ($deviceType == 'computer') {
	
                return view('creat-ad', ['categories' => '', 'subcategories' => '', 'catid' => '',
                    'subcatid' => '', 'advcurrency' => $this->currency, 'catbindid' => $id, 'fldurl' => $fldurl,'suggestions'=>$srtrowurl,'cook_key'=>$cook_key,'current_bal'=>$currentBal,'IncludeExchanges_select'=>$IncludeExchanges_select]);
                			}else{
			return view('mob-creat-ad', ['categories' => '', 'subcategories' => '', 'catid' => '',
                    'subcatid' => '', 'advcurrency' => $this->currency, 'catbindid' => $id, 'fldurl' => $fldurl,'suggestions'=>$srtrowurl,'cook_key'=>$cook_key,'current_bal'=>$currentBal,'IncludeExchanges_select' => $IncludeExchanges_select]);
			}
            }
        } else {
            return redirect('creat-ad')->with('error_login', 'No data Found');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function create_ad_pages(Request $request) {
        //
        $data = Session::all();
        $id = $request->input_data;
        return response()->json(['name' => $id]); // Bob
        //
            //
          // return redirect('/creat-ad')->with('valuse',$this->create_add());
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        //
    }

    /**
     * submit the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function editAdSubmit(Request $request) {
        if (!Auth::check()) {
            return redirect('/login');
        }
        $post = $request->all();
    
        $creativeId = array();
        $sessiondata = Session::get('sessiondata');
        $advertiserId = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
        $subcategories=[];
        // if(isset($request->subcategories)){
        foreach($request->subcategories as $subcat){
            $subcatv=explode("-", $subcat);
            array_push($subcategories, $subcatv[1]);
        }
        $subcategories=implode(",", $subcategories);
    // }


        $destinationPath = public_path('themes/usr_images');
        //$images = $post["img"];
        if (trim($post["previous_img"]) != '') {
            $nameArr[] = $post["previous_img"];
        } else {
            $nameArr = array();
        }
        if (trim($post["previous_dm"]) != '') {
            $dmArr[] = $post["previous_dm"];
        } else {
            $dmArr = array();
        }
        if (trim($post["previous_ext"]) != '') {
            $extArr[] = $post["previous_ext"];
        } else {
            $extArr = array();
        }
        $sessiondata = Session::get('sessiondata');

        $startdate  =   date('Y-m-d H:i:s');

        $enddate  =   date('Y-m-d H:i:s',strtotime("+1 year"));

        //if image found then edited
       if (isset($post['imgcrp1']) && trim($post['imgcrp1'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp1'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
        if (isset($post['imgcrp2']) && trim($post['imgcrp2'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp2'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
         if (isset($post['imgcrp3']) && trim($post['imgcrp3'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp3'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
        if (isset($post['imgcrp4']) && trim($post['imgcrp4'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp4'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
        if (isset($post['imgcrp5']) && trim($post['imgcrp5'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp5'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
        if (isset($post['imgcrp6']) && trim($post['imgcrp6'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp6'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
        if (isset($post['imgcrp7']) && trim($post['imgcrp7'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp7'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
        if (isset($post['imgcrp8']) && trim($post['imgcrp8'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp8'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
        if (isset($post['imgcrp9']) && trim($post['imgcrp9'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp9'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
         if (isset($post['imgcrp10']) && trim($post['imgcrp10'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp10'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
         if (isset($post['imgcrp11']) && trim($post['imgcrp11'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp11'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
         if (isset($post['imgcrp12']) && trim($post['imgcrp12'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp12'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
         if (isset($post['imgcrp13']) && trim($post['imgcrp13'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp13'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
         if (isset($post['imgcrp14']) && trim($post['imgcrp14'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp14'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
         if (isset($post['imgcrp15']) && trim($post['imgcrp15'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp15'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
        if (isset($post['imgcrp16']) && trim($post['imgcrp16'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp16'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
        if (isset($post['imgcrp17']) && trim($post['imgcrp17'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp17'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
        if (isset($post['imgcrp18']) && trim($post['imgcrp18'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp18'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
         if (isset($post['imgcrp19']) && trim($post['imgcrp19'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp19'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }
        if (isset($post['imgcrp20']) && trim($post['imgcrp20'])!= '') {
                $crtid=$this->imgaddUpload($post['imgcrp20'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }

        }


       //check time scheduling for the edit ads
       $scheduling_arr=array();
       //######################################
        if(trim($post['date_wise'])=='all_days'){
                    $scheduling_arr["everyday"] ='SUN,MON,TUE,WED,THU,FRI,SAT';
                    if(trim($post['date_wise_hours'])=='1'){
                            $scheduling_arr["sunhour"] = '0' ;
                            $scheduling_arr["monhour"] = '0';
                            $scheduling_arr["tuehour"] = '0';
                            $scheduling_arr["wedhour"] = '0';
                            $scheduling_arr["thuhour"] = '0';
                            $scheduling_arr["frihour"] = '0';
                            $scheduling_arr["sathour"] = '0';
                            $scheduling_arr["sunhour2"] = '23' ;
                            $scheduling_arr["monhour2"] = '23';
                            $scheduling_arr["tuehour2"] = '23';
                            $scheduling_arr["wedhour2"] = '23';
                            $scheduling_arr["thuhour2"] = '23';
                            $scheduling_arr["frihour2"] = '23';
                            $scheduling_arr["sathour2"] = '23';
                            $scheduling_arr["sunmin"] = '01' ;
                            $scheduling_arr["monmin"] = '01' ;
                            $scheduling_arr["tuemin"] = '01' ;
                            $scheduling_arr["wedmin"] = '01' ;
                            $scheduling_arr["thumin"] = '01' ;
                            $scheduling_arr["frimin"] = '01' ;
                            $scheduling_arr["satmin"] = '01' ;
                            $scheduling_arr["sunmin2"] = '59' ;
                            $scheduling_arr["monmin2"] = '59' ;
                            $scheduling_arr["tuemin2"] = '59' ;
                            $scheduling_arr["wedmin2"] = '59' ;
                            $scheduling_arr["thumin2"] = '59' ;
                            $scheduling_arr["frimin2"] = '59' ;
                            $scheduling_arr["satmin2"] = '59' ;
                    }else{
                        $scheduling_arr["sunhour"] = isset($post['sunhour']) ? $post['sunhour'] : "" ;
                        $scheduling_arr["monhour"] = isset($post['monhour']) ? $post['monhour'] : "" ;
                        $scheduling_arr["tuehour"] = isset($post['tuehour']) ? $post['tuehour'] : "" ;
                        $scheduling_arr["wedhour"] = isset($post['wedhour']) ? $post['wedhour'] : "" ;
                        $scheduling_arr["thuhour"] = isset($post['thuhour']) ? $post['thuhour'] : "" ;
                        $scheduling_arr["frihour"] = isset($post['frihour']) ? $post['frihour'] : "" ;
                        $scheduling_arr["sathour"] = isset($post['sathour']) ? $post['sathour'] : "" ;
                        $scheduling_arr["sunhour2"] = isset($post['sunhour2']) ? $post['sunhour2'] : "" ;
                        $scheduling_arr["monhour2"] = isset($post['monhour2']) ? $post['monhour2'] : "" ;
                        $scheduling_arr["tuehour2"] = isset($post['tuehour2']) ? $post['tuehour2'] : "" ;
                        $scheduling_arr["wedhour2"] = isset($post['wedhour2']) ? $post['wedhour2'] : "" ;
                        $scheduling_arr["thuhour2"] = isset($post['thuhour2']) ? $post['thuhour2'] : "" ;
                        $scheduling_arr["frihour2"] = isset($post['frihour2']) ? $post['frihour2'] : "" ;
                        $scheduling_arr["sathour2"] = isset($post['sathour2']) ? $post['sathour2'] : "" ;
                        $scheduling_arr["sunmin"] = isset($post['sunmin']) ? $post['sunmin'] : "" ;
                        $scheduling_arr["monmin"] = isset($post['monmin']) ? $post['monmin'] : "" ;
                        $scheduling_arr["tuemin"] = isset($post['tuemin']) ? $post['tuemin'] : "" ;
                        $scheduling_arr["wedmin"] = isset($post['wedmin']) ? $post['wedmin'] : "" ;
                        $scheduling_arr["thumin"] = isset($post['thumin']) ? $post['thumin'] : "" ;
                        $scheduling_arr["frimin"] = isset($post['frimin']) ? $post['frimin'] : "" ;
                        $scheduling_arr["satmin"] = isset($post['satmin']) ? $post['satmin'] : "" ;
                        $scheduling_arr["sunmin2"] = isset($post['sunmin2']) ? $post['sunmin2'] : "" ;
                        $scheduling_arr["monmin2"] = isset($post['monmin2']) ? $post['monmin2'] : "" ;
                        $scheduling_arr["tuemin2"] = isset($post['tuemin2']) ? $post['tuemin2'] : "" ;
                        $scheduling_arr["wedmin2"] = isset($post['wedmin2']) ? $post['wedmin2'] : "" ;
                        $scheduling_arr["thumin2"] = isset($post['thumin2']) ? $post['thumin2'] : "" ;
                        $scheduling_arr["frimin2"] = isset($post['frimin2']) ? $post['frimin2'] : "" ;
                        $scheduling_arr["satmin2"] = isset($post['satmin2']) ? $post['satmin2'] : "" ;
                    }
                }
                if(trim($post['date_wise'])=='mon_fri'){
                    $scheduling_arr["everyday"] ='MON,TUE,WED,THU,FRI';
                    if(trim($post['date_wise_hours'])=='1'){

                            $scheduling_arr["monhour"] = '0';
                            $scheduling_arr["tuehour"] = '0';
                            $scheduling_arr["wedhour"] = '0';
                            $scheduling_arr["thuhour"] = '0';
                            $scheduling_arr["frihour"] = '0';
                            $scheduling_arr["monhour2"] = '23';
                            $scheduling_arr["tuehour2"] = '23';
                            $scheduling_arr["wedhour2"] = '23';
                            $scheduling_arr["thuhour2"] = '23';
                            $scheduling_arr["frihour2"] = '23';
                            $scheduling_arr["monmin"] = '01' ;
                            $scheduling_arr["tuemin"] = '01' ;
                            $scheduling_arr["wedmin"] = '01' ;
                            $scheduling_arr["thumin"] = '01' ;
                            $scheduling_arr["frimin"] = '01' ;
                            $scheduling_arr["monmin2"] = '59' ;
                            $scheduling_arr["tuemin2"] = '59' ;
                            $scheduling_arr["wedmin2"] = '59' ;
                            $scheduling_arr["thumin2"] = '59' ;
                            $scheduling_arr["frimin2"] = '59' ;

                    }else{

                        $scheduling_arr["monhour"] = isset($post['monhour']) ? $post['monhour'] : "" ;
                        $scheduling_arr["tuehour"] = isset($post['tuehour']) ? $post['tuehour'] : "" ;
                        $scheduling_arr["wedhour"] = isset($post['wedhour']) ? $post['wedhour'] : "" ;
                        $scheduling_arr["thuhour"] = isset($post['thuhour']) ? $post['thuhour'] : "" ;
                        $scheduling_arr["frihour"] = isset($post['frihour']) ? $post['frihour'] : "" ;
                        $scheduling_arr["monhour2"] = isset($post['monhour2']) ? $post['monhour2'] : "" ;
                        $scheduling_arr["tuehour2"] = isset($post['tuehour2']) ? $post['tuehour2'] : "" ;
                        $scheduling_arr["wedhour2"] = isset($post['wedhour2']) ? $post['wedhour2'] : "" ;
                        $scheduling_arr["thuhour2"] = isset($post['thuhour2']) ? $post['thuhour2'] : "" ;
                        $scheduling_arr["frihour2"] = isset($post['frihour2']) ? $post['frihour2'] : "" ;
                        $scheduling_arr["monmin"] = isset($post['monmin']) ? $post['monmin'] : "" ;
                        $scheduling_arr["tuemin"] = isset($post['tuemin']) ? $post['tuemin'] : "" ;
                        $scheduling_arr["wedmin"] = isset($post['wedmin']) ? $post['wedmin'] : "" ;
                        $scheduling_arr["thumin"] = isset($post['thumin']) ? $post['thumin'] : "" ;
                        $scheduling_arr["frimin"] = isset($post['frimin']) ? $post['frimin'] : "" ;
                        $scheduling_arr["monmin2"] = isset($post['monmin2']) ? $post['monmin2'] : "" ;
                        $scheduling_arr["tuemin2"] = isset($post['tuemin2']) ? $post['tuemin2'] : "" ;
                        $scheduling_arr["wedmin2"] = isset($post['wedmin2']) ? $post['wedmin2'] : "" ;
                        $scheduling_arr["thumin2"] = isset($post['thumin2']) ? $post['thumin2'] : "" ;
                        $scheduling_arr["frimin2"] = isset($post['frimin2']) ? $post['frimin2'] : "" ;

                    }
                }
                if(trim($post['date_wise'])=='sat_sun'){
                    $scheduling_arr["everyday"] ='SUN,SAT';
                    if(trim($post['date_wise_hours'])=='1'){
                        $scheduling_arr["sunhour"] = "0" ;
                        $scheduling_arr["sathour"] = "0" ;
                        $scheduling_arr["sunhour2"] = "23" ;
                        $scheduling_arr["sathour2"] = "23" ;
                        $scheduling_arr["sunmin"] = "01" ;
                        $scheduling_arr["sunmin2"] = "59" ;
                        $scheduling_arr["satmin"] = "01" ;
                        $scheduling_arr["satmin2"] = "59" ;
                    }else{
                        $scheduling_arr["sunhour"] = isset($post['sunhour']) ? $post['sunhour'] : "" ;
                        $scheduling_arr["sathour"] = isset($post['sathour']) ? $post['sathour'] : "" ;
                        $scheduling_arr["sunhour2"] = isset($post['sunhour2']) ? $post['sunhour2'] : "" ;
                        $scheduling_arr["sathour2"] = isset($post['sathour2']) ? $post['sathour2'] : "" ;
                        $scheduling_arr["sunmin"] = isset($post['sunmin']) ? $post['sunmin'] : "" ;
                        $scheduling_arr["sunmin2"] = isset($post['sunmin2']) ? $post['sunmin2'] : "" ;
                        $scheduling_arr["satmin"] = isset($post['satmin']) ? $post['satmin'] : "" ;
                        $scheduling_arr["satmin2"] = isset($post['satmin2']) ? $post['satmin2'] : "" ;
                    }
                }


            if(isset($post['startdate']) && trim($post['startdate'])!='' ) {

                $scheduling_arr["startdate"] = $post['startdate'];
                $startdate  =   date('Y-m-d',strtotime($post['startdate']))." 00:01:00";
                
                if(isset($post['enddate']) && trim($post['enddate'])!='' ) {
                $scheduling_arr["enddate"] = $post['enddate'];
                $enddate    =   date('Y-m-d',strtotime($post['enddate']))." 23:59:00";
                
                }else{
                    $scheduling_arr["enddate"] = date('Y-m-d',strtotime("+2 years "));
                    $enddate    =   date('Y-m-d',strtotime("+2 years "))." 00:00:00";
                }

            }
        $camModel = \App\Campaigns::find($post['campaign_id']);

      

        $camModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
        $camModel->campaign_name = $post['adname'];
        $camModel->for_gaid = $post['for_gaid'];
        $camModel->iab_categories = "";
        $camModel->adomain = (isset($post['adomain'])) ? $post['adomain'] : "";
//         $camModel->state_city=( $post['state_city'] != "" ) ? trim($post['state_city']) : "";
        // $camModel->device_custom=isset($post['devicedn']) && ($post['devicedn']!=" ") ? $post['devicedn'] : "mobile";
        // $dvcdn=isset($post['devicedn'])&&($post['devicedn']!='')? $post['devicedn']:'';
        if(isset($post['devicedn']))
        {
        $camModel->device_custom=implode(',',$post['devicedn']);
        }
            if(isset($post['include_exchanges']))
        {

        $IncludeExchanges=implode(',',$post['include_exchanges']); 
    }else{
	$IncludeExchanges='';
}

      
         //convert currency to USD if other than usd
            if ($this->currency != 'USD') {
                $paymentControllerObj = new PaymentController();
                $adbudget = $camModel->campaign_budget = $paymentControllerObj->convertCurrency($post['total_budget_dp'], $this->currency, 'USD');
                $camModel->daily_budget = $paymentControllerObj->convertCurrency($post['total_budgetd_dp'], $this->currency, 'USD');
                $camModel->hourly_budget = $paymentControllerObj->convertCurrency($post['total_budgetc_hp'], $this->currency, 'USD');
                $camModel->min_unit_price = $paymentControllerObj->convertCurrency($post['total_budgetc_dp'], $this->currency, 'USD');
            } else {
                $adbudget = $camModel->campaign_budget = $post['total_budget_dp'];
                $camModel->daily_budget = $post['total_budgetd_dp'];
                $camModel->hourly_budget = $post['total_budgetc_hp'];
                $camModel->min_unit_price = $post['total_budgetc_dp'];
            }


            $camModel->campaign_budget_currency = $post['total_budget_dp'] . ":" . $this->currency;
            $camModel->daily_budget_currency = $post['total_budgetd_dp'] . ":" . $this->currency;
            $camModel->hourly_budget = $post['total_budgetc_hp'] . ":" . $this->currency;
            $camModel->min_unit_price_currency = $post['total_budgetc_dp'] . ":" . $this->currency;

        $camModel->admin_remarks = "";
        $camModel->time_zone = "";
        if(!isset($startdate)){
           $startdate  =   date('Y-m-d H:i:s');
        }
         if(!isset($enddate)){
           $enddate  =   date('Y-m-d H:i:s',strtotime("+1 year"));
        }
        $camModel->activate_date_time = $startdate;
        $camModel->expire_date_time = $enddate;
 
        $camModel->create_date_time = date("Y-m-d H:i:s");
        $camModel->update_date_time = 'NOW()';
        $camModel->adv_cat_id = isset($post['cat_id'])?$post['cat_id']:0;
        $camModel->adv_subcat_id = isset($subcategories)?$subcategories:'0';
        $camModel->campaign_pricing_model=$post['pricing_model'];
        $camModel->campaign_ad_type=$post['ad_type'];
        $camModel->campaign_vertical=$post['vertical'];
        $camModel->campaign_creative_type=$post['creative_type'];
        $camModel->js_width=$post['js_width'];
        $camModel->js_height=$post['js_height'];
        $camModel->js_tag=$post['js_tag'];
        $camModel->video_protocol=$post['video_protocol'];
        $camModel->video_tag=$post['video_tag'];
        $camModel->connection_type=$post['connection_type'];
        $camModel->ip_range=$post['ip_range'];
       // $camModel->deliverytype=$post['bidparams'];
	    $camModel->adomain=$post['adomain'];
          $camModel->include_exchange=$IncludeExchanges;
        $camModel->campaing_taffic_type=isset($post['campaing_taffic_type'])?$post['campaing_taffic_type']:'mainstream';
        $camModel->kpidvalue=$post['kpivalue'];
        $camModel->cap_value=$post['cap_value'];
        $camModel->revenue_type = $post['revenue_type'];    
        $select_freq_option=$post['frequtype'];
        $select_freq_value= isset($post['frequtypevalue']) ? $post['frequtypevalue'] : '0';
        $freqvalue = array($select_freq_option=>$select_freq_value);
        $camModel->frequtype= json_encode($freqvalue);
        $camModel->page_id = $this->getPageIdFromUrl($post['url'], $this->getAdvId($sessiondata['accounts'][0]['account_id']));
        $camModel->scheduling = ($scheduling_arr) ? json_encode( $scheduling_arr ) : "";
	//impression url
	$camModel->impression_url=isset($post['impression_url'])?$post['impression_url']:'';

        $Videobanner=[];
                $count_v=1;
                foreach ($request->file('video_banner') as $media ) {
                     if (!empty($media)) {
                        $image_name="banner";
                        $filename = time()."_".$image_name."_".$count_v.".jpg";
                        $media->move($destinationPath.'/'.$advertiserId , $filename);
                        $Videobanner[] = $filename;
                     }
                     $count_v++;
                }  

                $video_banner = implode(', ',$Videobanner);
                $camModel->video_banner_file=$video_banner;

        //campaign model
        //##############

        if ($camModel->save()) {

            //deduct campaign budget from adv wallet
            //######################################

            $this->deductBalanceOnEdit($post['initial_total_budget'], $post['total_budget_dp'], $camModel->advertiser_id);

            $adsModel = \App\Ads::find($post['ad_id']);
            $adsModel->campaign_id = $camModel->campaign_id;
            $adsModel->content_type = "image";
            $crtvids='';
           /* if(trim($adsModel->creative_ids)!='')
            {*/
                if(!empty($creativeId))
                {
                    $crtvids=implode(",", $creativeId);
                    if(trim($adsModel->creative_ids)!=''){
                    $crtvids = $crtvids.','.trim($adsModel->creative_ids);
                    }
                }else
                {
                    $crtvids = trim($adsModel->creative_ids);
                }
           /* } */


            $adsModel->creative_ids = $crtvids;
            $adsModel->ad_html = '<a href="__SERVERHTTPURL__/CR/c?cc=__CC__"><img src="__CDNURL__/__DIMENSION__/__IMAGENAME__"/></a> <img src="__SERVERHTTPURL__/ImpressionHandler/Handler?cc=__CC__" />';
            $adsModel->ad_json = "";
            $adsModel->ad_vast_url = "";
            $adsModel->destination_url = $post['url'];
            $adsModel->alt = "";
            $adsModel->description = (isset($post['text_area_value'])) ? $post['text_area_value'] : "";
//                      $adsModel->ad_status = "0";
            $adsModel->ad_budget = $post['total_budget_dp'];
            $adsModel->ad_targeting_methods = "";
            $adsModel->ad_method_plugins = "";
            $adsModel->alternate_filename = "";
            $adsModel->alternate_content_type = "";
            $adsModel->admin_status = "pending";
            $adsModel->admin_remarks = "";
            //$adsModel->iab_attributes="";
            //$adsModel->iab_categories="";
            $adsModel->time_zone = "";
            //$adsModel->activate_date_time="";
            //$adsModel->expire_date_time="";
            $adsModel->create_date_time = date("Y-m-d H:i:s");

            $adsModel->update_date_time = date("Y-m-d H:i:s");


            if ($adsModel->save()) {
                 if(isset($post['country']) && trim($post['country'])!='worldwide'){

                     if (isset($post['country_group_id']) && trim($post['country_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['country_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['country_targetting_id']) && trim($post['country_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['country_targetting_id']);
                        $assocModel->delete();
                    }
                    if (isset($post['state_group_id']) && trim($post['state_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['state_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['state_targetting_id']) && trim($post['state_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['state_targetting_id']);
                        $assocModel->delete();
                    }
                    if (isset($post['city_group_id']) && trim($post['city_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['city_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['city_targetting_id']) && trim($post['city_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['city_targetting_id']);
                        $assocModel->delete();
                    }
                       if(isset($post['savecountry'])  && trim($post['savecountry']) != 'custom') {
                        $assocModel = new \App\AdChannelGroupAssoc;
                        $targModel = new \App\TargettingChannelGroup;
                        $targModel->channel_type = "advertiser";
                        $targModel->owner_id = $advertiserId;
                        $targModel->logical = "EQU";
                        $targModel->type = "COUNTRY";
                        $targModel->data = $post['savecountry'];
                        $targModel->create_date_time = date("Y-m-d H:i:s");
                        $targModel->update_date_time = date("Y-m-d H:i:s");

                            if ($targModel->save()) {

                                $assocModel->ad_id = $adsModel->ad_id;
                                $assocModel->channel_id = $targModel->channel_group_id;
                                $assocModel->last_update = date("Y-m-d H:i:s");
                                $assocModel->create_date = date("Y-m-d H:i:s");
                                $assocModel->status = "1";
                                $assocModel->save();
                            }
                       }
                       if(trim($post['country'])=='INDIA'){
                           if(trim($post['pincode_select_type'])=='3'){
                               if(trim($post['selected_city_option'])=='2'){
                                   $cityModel = new \App\Cities;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntry=array();
                                    if ($pos === false) {
                                          $incntry[] =trim($post['savecountry']);

                                    }else{
                                          $incounrty=trim($post['savecountry']);
                                        $incntry=  explode(',', $incounrty);
                                    }
                                    $final_arrayct = array();
                                 $statedts='';
                                 $cityData = $cityModel::select('city_iso')
                                                 ->where('top_city',1)
                                                 ->whereIn('country_iso3',$incntry)
                                                 ->orderBy('city_iso', 'asc')
                                                 ->get();


                                    if (count($cityData) > 0) {

                                         foreach ($cityData as $key => $value) {

                                             $final_arrayct[] = $value->city_iso;

                                         }
                                     }



                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                            if(trim($post['selected_city_option'])=='3'){
                                $cityModel = new \App\Cities;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntry=array();
                                if ($pos === false) {
                                       $incntry[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntry=  explode(',', $incounrty);

                                }
                                $cityData = $cityModel::select('city_iso')
                                                 ->where('metro_city',1)
                                                 ->whereIn('country_iso3',$incntry)
                                                 ->orderBy('city_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($cityData) > 0) {

                                         foreach ($cityData as $key => $value) {

                                             $final_arrayct[] = $value->city_iso;

                                         }
                                     }
                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                            }
                             if(trim($post['selected_city_option'])=='1'){
                                $cityModel = new \App\Cities;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntry=array();
                                if ($pos === false) {
                                       $incntry[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntry=  explode(',', $incounrty);

                                }
                                $cityData = $cityModel::select('city_iso')
                                                 ->where('metro_city',1)
                                                 ->whereIn('country_iso3',$incntry)
                                                 ->orderBy('city_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($cityData) > 0) {

                                         foreach ($cityData as $key => $value) {

                                             $final_arrayct[] = $value->city_iso;

                                         }
                                     }
                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                            }
                            if(trim($post['selected_city_option'])=='state_custome'){

                                  $statedts=trim($post['country_city_iso']);
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                                if(trim($post['selected_state_option'])=='2'){
                                    $regionStateModel = new \App\StatezipCode;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntrys=array();
                                if ($pos === false) {
                                       $incntrys[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntrys =  explode(',', $incounrty);

                                }

                                $regionStateData = $regionStateModel::select('region_iso')
                                                 ->where('top_region',1)
                                                 ->whereIn('country_iso3',$incntrys)
                                                 ->orderBy('region_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($regionStateData) > 0) {

                                         foreach ($regionStateData as $key => $value) {

                                             $final_arrayct[] = $value->region_iso;

                                         }
                                     }
                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "STATE";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }

                                }
                                 if(trim($post['selected_state_option'])=='1'){
                                    $regionStateModel = new \App\StatezipCode;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntrys=array();
                                if ($pos === false) {
                                       $incntrys[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntrys =  explode(',', $incounrty);

                                }

                                $regionStateData = $regionStateModel::select('region_iso')
                                                 ->whereIn('country_iso3',$incntrys)
                                                 ->orderBy('region_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($regionStateData) > 0) {

                                         foreach ($regionStateData as $key => $value) {

                                             $final_arrayct[] = $value->region_iso;

                                         }
                                     }
                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "STATE";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }

                                }
                                 if(trim($post['selected_state_option'])=='city_state_custome'){
                                     $statedts=trim($post['country_state_iso']);
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "STATE";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                                 }
                           }
                            // For Pin Code upload csv
                           if(trim($post['pincode_select_type'])=='2'){
                               $pin='';
                               if(isset($post['FileUpload']))
                                        {
                                        //Import uploaded file to Database
                                        $handle = fopen($_FILES['FileUpload']['tmp_name'], "r");

                                        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                                                foreach($data as $key=>$val){
                                                    if($val!="")
                                                    {
                                                    $pin .=$val.',';
                                                    }
                                                }
                                            }
                                        $pin=substr($pin,0,strlen($pin)-1);

                                        fclose($handle);
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                            $targModel = new \App\TargettingChannelGroup;


                                            $targModel->channel_type = "advertiser";
                                            $targModel->owner_id = $advertiserId;
                                            $targModel->logical = "EQU";
                                            $targModel->type = "PIN";
                                            $targModel->data = $pin;
                                            $targModel->create_date_time = date("Y-m-d H:i:s");
                                            $targModel->update_date_time = date("Y-m-d H:i:s");

                                            if ($targModel->save()) {

                                                $assocModel->ad_id = $adsModel->ad_id;
                                                $assocModel->channel_id = $targModel->channel_group_id;
                                                $assocModel->last_update = date("Y-m-d H:i:s");
                                                $assocModel->create_date = date("Y-m-d H:i:s");
                                                $assocModel->status = "1";

                                                $assocModel->save();
                                            }
                                        }
                           }
                           // for pin code input
                           if(trim($post['pincode_select_type'])=='1'){
                               $pin='';
                               if(isset($post['pinc']) && trim($post['pinc'])!='')
                                        {
                                          $pin=trim($post['pinc']);
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                            $targModel = new \App\TargettingChannelGroup;


                                            $targModel->channel_type = "advertiser";
                                            $targModel->owner_id = $advertiserId;
                                            $targModel->logical = "EQU";
                                            $targModel->type = "PIN";
                                            $targModel->data = $pin;
                                            $targModel->create_date_time = date("Y-m-d H:i:s");
                                            $targModel->update_date_time = date("Y-m-d H:i:s");

                                            if ($targModel->save()) {

                                                $assocModel->ad_id = $adsModel->ad_id;
                                                $assocModel->channel_id = $targModel->channel_group_id;
                                                $assocModel->last_update = date("Y-m-d H:i:s");
                                                $assocModel->create_date = date("Y-m-d H:i:s");
                                                $assocModel->status = "1";

                                                $assocModel->save();
                                            }
                                        }
                           }

                        }
                        if(trim($post['country'])=='custom'){
                             if(trim($post['pincode_select_type'])=='3'){
                               if(trim($post['selected_city_option'])=='2'){
                                    $cityModel = new \App\Cities;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntry=array();
                                if ($pos === false) {
                                       $incntry[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntry=  explode(',', $incounrty);
                                }

                                $cityData = $cityModel::select('city_iso')
                                                 ->where('top_city',1)
                                                 ->whereIn('country_iso3',$incntry)
                                                 ->orderBy('city_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($cityData) > 0) {

                                         foreach ($cityData as $key => $value) {

                                             $final_arrayct[] = $value->city_iso;

                                         }
                                     }
                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                        }
                        if(trim($post['selected_city_option'])=='state_custome'){

                                  $statedts=trim($post['country_city_iso']);
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                               // for state
                               if(trim($post['selected_state_option'])=='2'){
                                    $regionStateModel = new \App\StatezipCode;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntrys=array();
                                if ($pos === false) {
                                       $incntrys[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntrys=  explode(',', $incounrty);

                                }

                                $regionStateData = $regionStateModel::select('region_iso')
                                                 ->where('top_region',1)
                                                 ->whereIn('country_iso3',$incntrys)
                                                 ->orderBy('region_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($regionStateData) > 0) {

                                         foreach ($regionStateData as $key => $value) {

                                             $final_arrayct[] = $value->region_iso;

                                         }
                                     }

                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "STATE";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                               if(trim($post['selected_state_option'])=='city_state_custome'){

                                  $statedts=trim($post['country_state_iso']);
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "STATE";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                           }
                        }
                     else {
                    if (isset($post['country_group_id']) && trim($post['country_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['country_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['country_targetting_id']) && trim($post['country_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['country_targetting_id']);
                        $assocModel->delete();
                    }
                    if (isset($post['state_group_id']) && trim($post['state_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['state_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['state_targetting_id']) && trim($post['state_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['state_targetting_id']);
                        $assocModel->delete();
                    }
                    if (isset($post['city_group_id']) && trim($post['city_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['city_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['city_targetting_id']) && trim($post['city_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['city_targetting_id']);
                        $assocModel->delete();
                    }
                }


                if (isset($post['devicedn']) && $post['devicedn'] != 'all') {
                            if (isset($post['device_group_id']) && trim($post['device_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['device_group_id']);
                        $targModel->delete();
                                }
                                if (isset($post['device_targetting_id']) && trim($post['device_targetting_id']) != '') {
                                    $assocModel = \App\AdChannelGroupAssoc::find($post['device_targetting_id']);
                                    $assocModel->delete();
                                }
                           if (isset($post['devicefactor_group_id']) && trim($post['devicefactor_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['devicefactor_group_id']);
                        $targModel->delete();
                                }
                                if (isset($post['devicefactor_targetting_id']) && trim($post['devicefactor_targetting_id']) != '') {
                                    $assocModel = \App\AdChannelGroupAssoc::find($post['devicefactor_targetting_id']);
                                    $assocModel->delete();
                                }
                        if($post['devicedn']=='smart_phone'){

                            $assocModel = new \App\AdChannelGroupAssoc;
                                    $targModel = new \App\TargettingChannelGroup;


                                    $targModel->channel_type = "advertiser";
                                    $targModel->owner_id = $advertiserId;
                                    $targModel->logical = "EQU";
                                    $targModel->type = "DEVICEFACTOR";
                                    $targModel->data = "Smartphone";
                                    $targModel->create_date_time = date("Y-m-d H:i:s");
                                    $targModel->update_date_time = date("Y-m-d H:i:s");

                                    if ($targModel->save()) {

                                        $assocModel->ad_id = $adsModel->ad_id;
                                        $assocModel->channel_id = $targModel->channel_group_id;
                                        $assocModel->last_update = date("Y-m-d H:i:s");
                                        $assocModel->create_date = date("Y-m-d H:i:s");
                                        $assocModel->status = "1";

                                        $assocModel->save();
                                    }
                        }
                        if($post['devicedn']=='featured_phone'){

                            $assocModel = new \App\AdChannelGroupAssoc;
                                    $targModel = new \App\TargettingChannelGroup;


                                    $targModel->channel_type = "advertiser";
                                    $targModel->owner_id = $advertiserId;
                                    $targModel->logical = "EQU";
                                    $targModel->type = "DEVICEFACTOR";
                                    $targModel->data = "Feature Phone";
                                    $targModel->create_date_time = date("Y-m-d H:i:s");
                                    $targModel->update_date_time = date("Y-m-d H:i:s");

                                    if ($targModel->save()) {

                                        $assocModel->ad_id = $adsModel->ad_id;
                                        $assocModel->channel_id = $targModel->channel_group_id;
                                        $assocModel->last_update = date("Y-m-d H:i:s");
                                        $assocModel->create_date = date("Y-m-d H:i:s");
                                        $assocModel->status = "1";

                                        $assocModel->save();
                                    }
                        }
                        if($post['devicedn']=='tablet'){

                                    $assocModel = new \App\AdChannelGroupAssoc;
                                    $targModel = new \App\TargettingChannelGroup;
                                    $targModel->channel_type = "advertiser";
                                    $targModel->owner_id = $advertiserId;
                                    $targModel->logical = "EQU";
                                    $targModel->type = "DEVICEFACTOR";
                                    $targModel->data = "Tablet";
                                    $targModel->create_date_time = date("Y-m-d H:i:s");
                                    $targModel->update_date_time = date("Y-m-d H:i:s");

                                    if ($targModel->save()) {

                                        $assocModel->ad_id = $adsModel->ad_id;
                                        $assocModel->channel_id = $targModel->channel_group_id;
                                        $assocModel->last_update = date("Y-m-d H:i:s");
                                        $assocModel->create_date = date("Y-m-d H:i:s");
                                        $assocModel->status = "1";

                                        $assocModel->save();
                                    }
                        }
                         if($post['devicedn']=='custom_device'){
                            if (isset($post['device']) && trim($post['device']) != '') {
                                $assocModel = new \App\AdChannelGroupAssoc;
                                    $targModel = new \App\TargettingChannelGroup;


                                    $targModel->channel_type = "advertiser";
                                    $targModel->owner_id = $advertiserId;
                                    $targModel->logical = "EQU";
                                    $targModel->type = "DEVICE";
                                    $targModel->data = $post['device'];
                                    $targModel->create_date_time = date("Y-m-d H:i:s");
                                    $targModel->update_date_time = date("Y-m-d H:i:s");

                                    if ($targModel->save()) {

                                        $assocModel->ad_id = $adsModel->ad_id;
                                        $assocModel->channel_id = $targModel->channel_group_id;
                                        $assocModel->last_update = date("Y-m-d H:i:s");
                                        $assocModel->create_date = date("Y-m-d H:i:s");
                                        $assocModel->status = "1";

                                        $assocModel->save();
                                    }
                            }
                        }

                    }
                    else{
                        if(isset($post['device_group_id']) && trim($post['device_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['device_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['device_targetting_id']) && trim($post['device_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['device_targetting_id']);
                        $assocModel->delete();
                    }
                     if (isset($post['devicefactor_group_id']) && trim($post['devicefactor_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['devicefactor_group_id']);
                        $targModel->delete();
                                }
                                if (isset($post['devicefactor_targetting_id']) && trim($post['devicefactor_targetting_id']) != '') {
                                    $assocModel = \App\AdChannelGroupAssoc::find($post['devicefactor_targetting_id']);
                                    $assocModel->delete();
                                }
                    }


                if (isset($post['os']) && trim($post['os']) != '') {


                    if (isset($post['os_group_id'])) {
                        $targModel = \App\TargettingChannelGroup::findOrNew($post['os_group_id']);
                    }

                    $targModel->channel_type = "advertiser";
                    $targModel->owner_id = $post['advertiser_id'];
                    $targModel->logical = "EQU";
                    $targModel->type = "OS";
                    $targModel->data = $post['os'];

                    $targModel->update_date_time = date("Y-m-d H:i:s");

                    if ($targModel->save()) {


                        if (isset($post['os_targetting_id'])) {
                            $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['os_targetting_id']);
                        }
                        $assocModel->ad_id = $adsModel->ad_id;
                        $assocModel->channel_id = $targModel->channel_group_id;
                        $assocModel->last_update = date("Y-m-d H:i:s");

                        $assocModel->status = "1";

                        $assocModel->save();
                    }
                } else {
                    if (isset($post['os_group_id']) && trim($post['os_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['os_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['os_targetting_id']) && trim($post['os_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['os_targetting_id']);
                        $assocModel->delete();
                    }
                }

                if (isset($post['osv']) && trim($post['osv']) != '') {

                    if (isset($post['osv_group_id'])) {
                        $targModel = \App\TargettingChannelGroup::findOrNew($post['osv_group_id']);
                    }

                    $targModel->channel_type = "advertiser";
                    $targModel->owner_id = $post['advertiser_id'];
                    $targModel->logical = "EQU";
                    $targModel->type = "OSV";
                    $targModel->data = $post['osv'];

                    $targModel->update_date_time = date("Y-m-d H:i:s");

                    if ($targModel->save()) {

                        if (isset($post['osv_targetting_id'])) {
                            $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['osv_targetting_id']);
                        }
                        $assocModel->ad_id = $adsModel->ad_id;
                        $assocModel->channel_id = $targModel->channel_group_id;
                        $assocModel->last_update = date("Y-m-d H:i:s");

                        $assocModel->status = "1";

                        $assocModel->save();
                    }
                } else {
                    if (isset($post['osv_group_id']) && trim($post['osv_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['osv_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['osv_targetting_id']) && trim($post['osv_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['osv_targetting_id']);
                        $assocModel->delete();
                    }
                }

                if (isset($post['browser']) && trim($post['browser']) != '') {


                    if (isset($post['browser_group_id'])) {
                        $targModel = \App\TargettingChannelGroup::findOrNew($post['browser_group_id']);
                    }
                    $targModel->channel_type = "advertiser";
                    $targModel->owner_id = $post['advertiser_id'];
                    $targModel->logical = "EQU";
                    $targModel->type = "BROWSER";
                    $targModel->data = $post['browser'];

                    $targModel->update_date_time = date("Y-m-d H:i:s");

                    if ($targModel->save()) {


                        if (isset($post['browser_targetting_id'])) {
                            $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['browser_targetting_id']);
                        }

                        $assocModel->ad_id = $adsModel->ad_id;
                        $assocModel->channel_id = $targModel->channel_group_id;
                        $assocModel->last_update = date("Y-m-d H:i:s");

                        $assocModel->status = "1";

                        $assocModel->save();
                    }
                } else {
                    if (isset($post['browser_group_id']) && trim($post['browser_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['browser_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['browser_targetting_id']) && trim($post['browser_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['browser_targetting_id']);
                        $assocModel->delete();
                    }
                }




                if (isset($post['browserc']) && trim($post['browserc']) != '') {


                    if (isset($post['browserv_group_id'])) {
                        $targModel = \App\TargettingChannelGroup::findOrNew($post['browserv_group_id']);
                    }
                    $targModel->channel_type = "advertiser";
                    $targModel->owner_id = $post['advertiser_id'];
                    $targModel->logical = "EQU";
                    $targModel->type = "BROWSERV";
                    $targModel->data = $post['browserc'];

                    $targModel->update_date_time = date("Y-m-d H:i:s");

                    if ($targModel->save()) {


                        if (isset($post['browserv_targetting_id'])) {
                            $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['browserv_targetting_id']);
                        }

                        $assocModel->ad_id = $adsModel->ad_id;
                        $assocModel->channel_id = $targModel->channel_group_id;
                        $assocModel->last_update = date("Y-m-d H:i:s");

                        $assocModel->status = "1";

                        $assocModel->save();
                    }
                } else {
                    if (isset($post['browserv_group_id']) && trim($post['browserv_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['browserv_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['browserv_targetting_id']) && trim($post['browserv_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['browserv_targetting_id']);
                        $assocModel->delete();
                    }
                }

                 //for language
                    if (isset($post['language_tag']) && trim($post['language_tag']) != '') {

                        $assocModel = new \App\AdChannelGroupAssoc;
                        $targModel = new \App\TargettingChannelGroup;


                        $targModel->channel_type = "advertiser";
                        $targModel->owner_id = $advertiserId;
                        $targModel->logical = "EQU";
                        $targModel->type = "LANGUAGE";
                        $targModel->data = $post['language_tag'];
                        $targModel->create_date_time = date("Y-m-d H:i:s");
                        $targModel->update_date_time = date("Y-m-d H:i:s");

                        if ($targModel->save()) {

                            $assocModel->ad_id = $adsModel->ad_id;
                            $assocModel->channel_id = $targModel->channel_group_id;
                            $assocModel->last_update = date("Y-m-d H:i:s");
                            $assocModel->create_date = date("Y-m-d H:i:s");
                            $assocModel->status = "1";

                            $assocModel->save();
                        }
                    }

                if (isset($post['tele']) && trim($post['tele']) != '') {

                    if (isset($post['tele_group_id'])) {
                        $targModel = \App\TargettingChannelGroup::findOrNew($post['tele_group_id']);
                    }

                    $targModel->channel_type = "advertiser";
                    $targModel->owner_id = $post['advertiser_id'];
                    $targModel->logical = "EQU";
                    $targModel->type = "OPERATOR";
                    $targModel->data = $post['tele'];

                    $targModel->update_date_time = date("Y-m-d H:i:s");

                    if ($targModel->save()) {

                        if (isset($post['tele_targetting_id'])) {
                            $assocModel = \App\AdChannelGroupAssoc::findOrNew($post['tele_targetting_id']);
                        }

                        $assocModel->ad_id = $adsModel->ad_id;
                        $assocModel->channel_id = $targModel->channel_group_id;
                        $assocModel->last_update = date("Y-m-d H:i:s");
                        $assocModel->status = "1";
                        $assocModel->save();
                    }
                } else {
                    if (isset($post['tele_group_id']) && trim($post['tele_group_id']) != '') {
                        $targModel = \App\TargettingChannelGroup::find($post['tele_group_id']);
                        $targModel->delete();
                    }
                    if (isset($post['tele_targetting_id']) && trim($post['tele_targetting_id']) != '') {
                        $assocModel = \App\AdChannelGroupAssoc::find($post['tele_targetting_id']);
                        $assocModel->delete();
                    }
                }
            } //ads entry to the database
        } // campaign entry to the database

        return redirect('myaccount')->with('success_ad', 'Congrats! Your Ad has been edited successfully and has been sent to Admin for approval. It would be made live soon.');

        //dd( DB::getQueryLog() );
        //foreach closed
        //echo "<pre>";print_r( $post );
    }

    /**
     * submit the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function createAdSubmit(Request $request) {
        if (!Auth::check()) {
            return redirect('/login');
        }
        $post = $request->all();  

        $subcategories=[];
        // if(isset($request->subcategories)){
        foreach($request->subcategories as $subcat){
            $subcatv=explode("-", $subcat);
            array_push($subcategories, $subcatv[1]);
        }
    // }
        $subcategories=implode(",", $subcategories);

        $destinationPath = public_path('themes/usr_images');
        $sessiondata = Session::get('sessiondata');
        $advertiserId = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
        $resultk = DB::table('dl_advertisers')->select('balance_left_currency')->where('advertiser_id', $advertiserId)->get();
        $balance_left_currency = $resultk[0]->balance_left_currency;
        if(floatval($balance_left_currency) < floatval($post['total_budgetd_dp'])){
            return redirect('creat-ad')->with('error_ad', 'Your account has negative balance. Please add funds to your account before creating a new Ad.');
        }


        $creativeId = array();
        $validator = Validator::make(
                        array(
                    'currency' => $request->currency,
                    'total_budget' => $request->total_budget_dp,
                    'daily_budget' => $request->total_budgetd_dp,
                    'cpc' => $request->total_budgetc_dp,
                        ), array(
                    'currency' => 'required',
                    'total_budget' => 'required|min:' . $this->mincampaignbudget[$this->currency],
                    'daily_budget' => 'required|min:' . $this->mindailycap[$this->currency],
                        )
        );

       


        if (trim($post['imgcrp1'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp1'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
        if (trim($post['imgcrp2'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp2'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
         if (trim($post['imgcrp3'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp3'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
         if (trim($post['imgcrp4'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp4'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
         if (trim($post['imgcrp5'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp5'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
         if (trim($post['imgcrp6'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp6'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
        if (trim($post['imgcrp7'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp7'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
        if (trim($post['imgcrp8'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp8'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
        if (trim($post['imgcrp9'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp9'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
        if (trim($post['imgcrp10'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp10'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
        if (trim($post['imgcrp11'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp11'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
         if (trim($post['imgcrp12'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp12'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
        if (trim($post['imgcrp13'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp13'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
        if (trim($post['imgcrp14'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp14'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
       if(trim($post['imgcrp15'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp15'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
        if(trim($post['imgcrp16'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp16'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
        if(trim($post['imgcrp17'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp17'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
       if(trim($post['imgcrp18'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp18'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
         if(trim($post['imgcrp19'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp19'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }
         if(trim($post['imgcrp20'])!= '') {
                    $crtid=$this->imgaddUpload($post['imgcrp20'],$advertiserId);
                    if($crtid!=0){
                        $creativeId[] = $crtid;
                    }
        }

  
        if (true) {
            //date_wise
             $startdate  =   date('Y-m-d H:i:s');
             $enddate  =   date('Y-m-d H:i:s',strtotime("+1 year"));
            if(isset($post['date_wise']) && trim($post['date_wise'])!=''){
                if(trim($post['date_wise'])=='all_days'){
                    $scheduling_arr["everyday"] ='SUN,MON,TUE,WED,THU,FRI,SAT';
                    if(trim($post['date_wise_hours'])=='1'){
                            $scheduling_arr["sunhour"] = '0' ;
                            $scheduling_arr["monhour"] = '0';
                            $scheduling_arr["tuehour"] = '0';
                            $scheduling_arr["wedhour"] = '0';
                            $scheduling_arr["thuhour"] = '0';
                            $scheduling_arr["frihour"] = '0';
                            $scheduling_arr["sathour"] = '0';
                            $scheduling_arr["sunhour2"] = '23' ;
                            $scheduling_arr["monhour2"] = '23';
                            $scheduling_arr["tuehour2"] = '23';
                            $scheduling_arr["wedhour2"] = '23';
                            $scheduling_arr["thuhour2"] = '23';
                            $scheduling_arr["frihour2"] = '23';
                            $scheduling_arr["sathour2"] = '23';
                            $scheduling_arr["sunmin"] = '01' ;
                            $scheduling_arr["monmin"] = '01' ;
                            $scheduling_arr["tuemin"] = '01' ;
                            $scheduling_arr["wedmin"] = '01' ;
                            $scheduling_arr["thumin"] = '01' ;
                            $scheduling_arr["frimin"] = '01' ;
                            $scheduling_arr["satmin"] = '01' ;
                            $scheduling_arr["sunmin2"] = '59' ;
                            $scheduling_arr["monmin2"] = '59' ;
                            $scheduling_arr["tuemin2"] = '59' ;
                            $scheduling_arr["wedmin2"] = '59' ;
                            $scheduling_arr["thumin2"] = '59' ;
                            $scheduling_arr["frimin2"] = '59' ;
                            $scheduling_arr["satmin2"] = '59' ;
                    }else{
                        $scheduling_arr["sunhour"] = isset($post['sunhour']) ? $post['sunhour'] : "" ;
                        $scheduling_arr["monhour"] = isset($post['monhour']) ? $post['monhour'] : "" ;
                        $scheduling_arr["tuehour"] = isset($post['tuehour']) ? $post['tuehour'] : "" ;
                        $scheduling_arr["wedhour"] = isset($post['wedhour']) ? $post['wedhour'] : "" ;
                        $scheduling_arr["thuhour"] = isset($post['thuhour']) ? $post['thuhour'] : "" ;
                        $scheduling_arr["frihour"] = isset($post['frihour']) ? $post['frihour'] : "" ;
                        $scheduling_arr["sathour"] = isset($post['sathour']) ? $post['sathour'] : "" ;
                        $scheduling_arr["sunhour2"] = isset($post['sunhour2']) ? $post['sunhour2'] : "" ;
                        $scheduling_arr["monhour2"] = isset($post['monhour2']) ? $post['monhour2'] : "" ;
                        $scheduling_arr["tuehour2"] = isset($post['tuehour2']) ? $post['tuehour2'] : "" ;
                        $scheduling_arr["wedhour2"] = isset($post['wedhour2']) ? $post['wedhour2'] : "" ;
                        $scheduling_arr["thuhour2"] = isset($post['thuhour2']) ? $post['thuhour2'] : "" ;
                        $scheduling_arr["frihour2"] = isset($post['frihour2']) ? $post['frihour2'] : "" ;
                        $scheduling_arr["sathour2"] = isset($post['sathour2']) ? $post['sathour2'] : "" ;
                        $scheduling_arr["sunmin"] = isset($post['sunmin']) ? $post['sunmin'] : "" ;
                        $scheduling_arr["monmin"] = isset($post['monmin']) ? $post['monmin'] : "" ;
                        $scheduling_arr["tuemin"] = isset($post['tuemin']) ? $post['tuemin'] : "" ;
                        $scheduling_arr["wedmin"] = isset($post['wedmin']) ? $post['wedmin'] : "" ;
                        $scheduling_arr["thumin"] = isset($post['thumin']) ? $post['thumin'] : "" ;
                        $scheduling_arr["frimin"] = isset($post['frimin']) ? $post['frimin'] : "" ;
                        $scheduling_arr["satmin"] = isset($post['satmin']) ? $post['satmin'] : "" ;
                        $scheduling_arr["sunmin2"] = isset($post['sunmin2']) ? $post['sunmin2'] : "" ;
                        $scheduling_arr["monmin2"] = isset($post['monmin2']) ? $post['monmin2'] : "" ;
                        $scheduling_arr["tuemin2"] = isset($post['tuemin2']) ? $post['tuemin2'] : "" ;
                        $scheduling_arr["wedmin2"] = isset($post['wedmin2']) ? $post['wedmin2'] : "" ;
                        $scheduling_arr["thumin2"] = isset($post['thumin2']) ? $post['thumin2'] : "" ;
                        $scheduling_arr["frimin2"] = isset($post['frimin2']) ? $post['frimin2'] : "" ;
                        $scheduling_arr["satmin2"] = isset($post['satmin2']) ? $post['satmin2'] : "" ;
                    }
                }
                if(trim($post['date_wise'])=='mon_fri'){
                    $scheduling_arr["everyday"] ='MON,TUE,WED,THU,FRI';
                    if(trim($post['date_wise_hours'])=='1'){

                            $scheduling_arr["monhour"] = '0';
                            $scheduling_arr["tuehour"] = '0';
                            $scheduling_arr["wedhour"] = '0';
                            $scheduling_arr["thuhour"] = '0';
                            $scheduling_arr["frihour"] = '0';
                            $scheduling_arr["monhour2"] = '23';
                            $scheduling_arr["tuehour2"] = '23';
                            $scheduling_arr["wedhour2"] = '23';
                            $scheduling_arr["thuhour2"] = '23';
                            $scheduling_arr["frihour2"] = '23';
                            $scheduling_arr["monmin"] = '01' ;
                            $scheduling_arr["tuemin"] = '01' ;
                            $scheduling_arr["wedmin"] = '01' ;
                            $scheduling_arr["thumin"] = '01' ;
                            $scheduling_arr["frimin"] = '01' ;
                            $scheduling_arr["monmin2"] = '59' ;
                            $scheduling_arr["tuemin2"] = '59' ;
                            $scheduling_arr["wedmin2"] = '59' ;
                            $scheduling_arr["thumin2"] = '59' ;
                            $scheduling_arr["frimin2"] = '59' ;

                    }else{

                        $scheduling_arr["monhour"] = isset($post['monhour']) ? $post['monhour'] : "" ;
                        $scheduling_arr["tuehour"] = isset($post['tuehour']) ? $post['tuehour'] : "" ;
                        $scheduling_arr["wedhour"] = isset($post['wedhour']) ? $post['wedhour'] : "" ;
                        $scheduling_arr["thuhour"] = isset($post['thuhour']) ? $post['thuhour'] : "" ;
                        $scheduling_arr["frihour"] = isset($post['frihour']) ? $post['frihour'] : "" ;
                        $scheduling_arr["monhour2"] = isset($post['monhour2']) ? $post['monhour2'] : "" ;
                        $scheduling_arr["tuehour2"] = isset($post['tuehour2']) ? $post['tuehour2'] : "" ;
                        $scheduling_arr["wedhour2"] = isset($post['wedhour2']) ? $post['wedhour2'] : "" ;
                        $scheduling_arr["thuhour2"] = isset($post['thuhour2']) ? $post['thuhour2'] : "" ;
                        $scheduling_arr["frihour2"] = isset($post['frihour2']) ? $post['frihour2'] : "" ;
                        $scheduling_arr["monmin"] = isset($post['monmin']) ? $post['monmin'] : "" ;
                        $scheduling_arr["tuemin"] = isset($post['tuemin']) ? $post['tuemin'] : "" ;
                        $scheduling_arr["wedmin"] = isset($post['wedmin']) ? $post['wedmin'] : "" ;
                        $scheduling_arr["thumin"] = isset($post['thumin']) ? $post['thumin'] : "" ;
                        $scheduling_arr["frimin"] = isset($post['frimin']) ? $post['frimin'] : "" ;
                        $scheduling_arr["monmin2"] = isset($post['monmin2']) ? $post['monmin2'] : "" ;
                        $scheduling_arr["tuemin2"] = isset($post['tuemin2']) ? $post['tuemin2'] : "" ;
                        $scheduling_arr["wedmin2"] = isset($post['wedmin2']) ? $post['wedmin2'] : "" ;
                        $scheduling_arr["thumin2"] = isset($post['thumin2']) ? $post['thumin2'] : "" ;
                        $scheduling_arr["frimin2"] = isset($post['frimin2']) ? $post['frimin2'] : "" ;

                    }
                }
                if(trim($post['date_wise'])=='sat_sun'){
                    $scheduling_arr["everyday"] ='SUN,SAT';
                    if(trim($post['date_wise_hours'])=='1'){
                        $scheduling_arr["sunhour"] = "0" ;
                        $scheduling_arr["sathour"] = "0" ;
                        $scheduling_arr["sunhour2"] = "23" ;
                        $scheduling_arr["sathour2"] = "23" ;
                        $scheduling_arr["sunmin"] = "01" ;
                        $scheduling_arr["sunmin2"] = "59" ;
                        $scheduling_arr["satmin"] = "01" ;
                        $scheduling_arr["satmin2"] = "59" ;
                    }else{
                        $scheduling_arr["sunhour"] = isset($post['sunhour']) ? $post['sunhour'] : "" ;
                        $scheduling_arr["sathour"] = isset($post['sathour']) ? $post['sathour'] : "" ;
                        $scheduling_arr["sunhour2"] = isset($post['sunhour2']) ? $post['sunhour2'] : "" ;
                        $scheduling_arr["sathour2"] = isset($post['sathour2']) ? $post['sathour2'] : "" ;
                        $scheduling_arr["sunmin"] = isset($post['sunmin']) ? $post['sunmin'] : "" ;
                        $scheduling_arr["sunmin2"] = isset($post['sunmin2']) ? $post['sunmin2'] : "" ;
                        $scheduling_arr["satmin"] = isset($post['satmin']) ? $post['satmin'] : "" ;
                        $scheduling_arr["satmin2"] = isset($post['satmin2']) ? $post['satmin2'] : "" ;
                    }
                }
            }

            if(isset($post['date_from_toady_dates']) && trim($post['date_from_toady_dates'])!='' ) {

                $scheduling_arr["startdate"] = $post['date_from_toady_dates'];
                // /$startdate  =   date('Y-m-d',strtotime($post['date_from_toady_dates']))." 00:01:00";
                $starthour_startmin= " ".isset($post['starthour']).":".isset($post['startmin']).":00";
                $startdate  =   date('Y-m-d',strtotime($post['date_from_toady_dates'])).$starthour_startmin;

                if(isset($post['forevere_dates']) && trim($post['forevere_dates'])!='' ) {
                $scheduling_arr["enddate"] = $post['forevere_dates'];
                $endhour_endmin= " ". isset($post['endhour']).":".isset($post['endmin']).":00";
                $enddate    =   date('Y-m-d',strtotime($post['forevere_dates'])).$endhour_endmin;
                }else{
                    $scheduling_arr["enddate"] = date('Y-m-d',strtotime("+2 years "));
                   $enddate    =   date('Y-m-d',strtotime("+2 years "))." 23:59:00";
                }

            }
               //IncludeExchanges 
           if(isset($post['include_exchanges']))
        {

        $IncludeExchanges=implode(',',$post['include_exchanges']); 
    }else{
    $IncludeExchanges='';
}
            $adsModel = new \App\Ads;
            $camModel = new \App\Campaigns;
            $camModel->for_gaid = $post['for_gaid'];
            $camModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
            $camModel->campaign_name = $post['adname'];
            $camModel->iab_categories = "";
            $camModel->adomain = (isset($post['adomain'])) ? $post['adomain'] : "";
            $camModel->campaign_pricing_model=$post['pricing_model'];
            $camModel->campaign_ad_type=$post['ad_type'];
            $camModel->campaign_vertical=$post['vertical'];
            $camModel->campaign_creative_type=$post['creative_type'];
            $camModel->js_width=$post['js_width'];
            $camModel->js_height=$post['js_height'];
            $camModel->js_tag=$post['js_tag'];
            $camModel->video_protocol=$post['video_protocol'];
            $camModel->video_tag=$post['video_tag'];
            $camModel->connection_type=$post['connection_type'];
            $camModel->ip_range=$post['ip_range'];
            //$camModel->deliverytype=$post['bidparams'];
	            $camModel->adomain=$post['adomain'];
                      $camModel->include_exchange=$IncludeExchanges;
            $camModel->campaing_taffic_type=isset($post['campaing_taffic_type'])?$post['campaing_taffic_type']:'mainstream';
            $camModel->cap_value=$post['cap_value'];
            $camModel->kpidvalue=$post['kpivalue'];
            $select_freq_option=$post['frequtype'];
            $select_freq_value= isset($post['frequtypevalue']) ? $post['frequtypevalue'] : '0';
            $freqvalue = array($select_freq_option=>$select_freq_value);
            $camModel->frequtype= json_encode($freqvalue);
              	 $camModel->impression_url=isset($post['impression_url'])?$post['impression_url']:'';
            //                    $camModel->priority="";
            //                    $camModel->weight="";
            //                    $camModel->target_impressions="";
            //                    $camModel->target_clicks="";
            //                    $camModel->target_conversions="";
            //convert currency to USD if other than usd
            if ($this->currency != 'USD') {
                $paymentControllerObj = new PaymentController();
                $adbudget = $camModel->campaign_budget = $paymentControllerObj->convertCurrency($post['total_budget_dp'], $this->currency, 'USD');
                $camModel->daily_budget = $paymentControllerObj->convertCurrency($post['total_budgetd_dp'], $this->currency, 'USD');
                $camModel->hourly_budget = $paymentControllerObj->convertCurrency($post['total_budgetc_hp'], $this->currency, 'USD');

                $camModel->min_unit_price = $paymentControllerObj->convertCurrency($post['total_budgetc_dp'], $this->currency, 'USD');
            } else {
                $adbudget = $camModel->campaign_budget = $post['total_budget_dp'];
                $camModel->daily_budget = $post['total_budgetd_dp'];
                $camModel->hourly_budget = $post['total_budgetc_hp'];
                $camModel->min_unit_price = $post['total_budgetc_dp'];
            }
            $camModel->campaign_budget_currency = $post['total_budget_dp'] . ":" . $this->currency;
            $camModel->daily_budget_currency = $post['total_budgetd_dp'] . ":" . $this->currency;
            $camModel->hourly_budget = $post['total_budgetd_dp'] . ":" . $this->currency;
            $camModel->min_unit_price_currency = $post['total_budgetc_dp'] . ":" . $this->currency;

            // $camModel->total_spend="";
            $camModel->revenue_type = $post['revenue_type'];
            $camModel->status = "pending";
            $camModel->admin_status = "pending";
            $camModel->admin_remarks = "";
            $camModel->time_zone = "";
            // $camModel->impressions="";
            // $camModel->clicks="";
            // $camModel->conversions="";
            // $camModel->amount="";
            $startdate  =   isset($post['date_from_toady_dates'])?$post['date_from_toady_dates']: date('Y-m-d H:i:s');
          $enddate    =   isset($post['forevere_dates'])?$post['forevere_dates']:  date('Y-m-d H:i:s',strtotime("+1 year"));
           if(!isset($startdate)){
            $startdate  =   date('Y-m-d H:i:s');
         }
          if(!isset($enddate)){
            $enddate  =   date('Y-m-d H:i:s',strtotime("+1 year"));
        }


        $camModel->activate_date_time = $startdate;
        $camModel->expire_date_time = $enddate;
       // $camModel->state_city=( $post['state_city'] != "" ) ? trim($post['state_city']) : "";
        if(isset($post['devicedn']))
        {
         $devicedn=implode(',',$post['devicedn']);
         // $camModel->device_custom=($devicedn!= "" ) ? trim($post['devicedn']) : "";
            $camModel->device_custom=($devicedn!= "" ) ? trim($devicedn) : "mobile";
        
        }

            //                    $camModel->targeting_methods="";
            //                    $camModel->methods_plugins="";
         


          
            $camModel->create_date_time = date("Y-m-d H:i:s");
            $camModel->update_date_time = date("Y-m-d H:i:s");
            $camModel->adv_cat_id = isset($post['cat_id'])?$post['cat_id']:'';
            $camModel->adv_subcat_id = isset($subcategories)?$subcategories:'0';
            $camModel->page_id = $this->getPageIdFromUrl($post['url'], $this->getAdvId($sessiondata['accounts'][0]['account_id']));
            $camModel->scheduling = ($scheduling_arr) ? json_encode( $scheduling_arr ) : "";
             $Videobanner=[];
                $count_v=1;
                foreach ($request->file('video_banner') as $media ) {
                     if (!empty($media)) {
                        $image_name="banner";
                        $filename = time()."_".$image_name."_".$count_v.".jpg";
                        $media->move($destinationPath.'/'.$advertiserId , $filename);
                        $Videobanner[] = $filename;
                     }
                     $count_v++;
                }  

                $video_banner = implode(', ',$Videobanner);
                $camModel->video_banner_file=$video_banner;
                                 
            if ($camModel->save()) {
                //deduct campaign budget from adv wallet
                //######################################
                if($post['total_budget_dp']!='unlimited')
                $this->deductBalance($post['total_budget_dp'], $advertiserId);
                $adsModel->campaign_id = $camModel->campaign_id;
                $adsModel->content_type = "image";
                $adsModel->creative_ids = implode(",", $creativeId);
                $adsModel->ad_html = '';
                $adsModel->ad_json = "";
                $adsModel->ad_vast_url = "";
                $adsModel->destination_url = $post['url'];
                $adsModel->alt = "";
                $adsModel->description = (isset($post['text_area_value'])) ? $post['text_area_value'] : "";
                $adsModel->ad_status = "0";
                $adsModel->ad_budget = $adbudget; //$post['total_budget'];
                $adsModel->ad_targeting_methods = "";
                $adsModel->ad_method_plugins = "";
                $adsModel->alternate_filename = "";
                $adsModel->alternate_content_type = "";
                $adsModel->admin_status = "pending";
                $adsModel->admin_remarks = "";

                // $adsModel->iab_attributes="";
                // $adsModel->iab_categories="";
                $adsModel->time_zone = "";
                // $adsModel->activate_date_time="";
                // $adsModel->expire_date_time="";
                $adsModel->create_date_time = date("Y-m-d H:i:s");
                $adsModel->update_date_time = date("Y-m-d H:i:s");

                if ($adsModel->save()) {

                    if(isset($post['country']) && trim($post['country'])!='worldwide')
                    {
                         if(isset($post['savecountry'])  && trim($post['savecountry']) != 'custom') {

                            $assocModel = new \App\AdChannelGroupAssoc;
                            $targModel = new \App\TargettingChannelGroup;
                            $targModel->channel_type = "advertiser";
                            $targModel->owner_id = $advertiserId;
                            $targModel->logical = "EQU";
                            $targModel->type = "COUNTRY";
                            $targModel->data = $post['savecountry'];
                            $targModel->create_date_time = date("Y-m-d H:i:s");
                            $targModel->update_date_time = date("Y-m-d H:i:s");

                            if ($targModel->save()) {
                                $assocModel->ad_id = $adsModel->ad_id;
                                $assocModel->channel_id = $targModel->channel_group_id;
                                $assocModel->last_update = date("Y-m-d H:i:s");
                                $assocModel->create_date = date("Y-m-d H:i:s");
                                $assocModel->status = "1";
                                $assocModel->save();
                                }
                            }
                        if(trim($post['country'])=='INDIA'){
                            if(trim($post['pincode_select_type'])=='3'){
                               if(trim($post['selected_city_option'])=='2'){
                                    $cityModel = new \App\Cities;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntry=array();
                                if ($pos === false) {
                                      $incntry[] =trim($post['savecountry']);

                                }else{
                                      $incounrty=trim($post['savecountry']);
                                    $incntry=  explode(',', $incounrty);
                                }


                                 $final_arrayct = array();
                                 $statedts='';
                                 $cityData = $cityModel::select('city_iso')
                                                 ->where('top_city',1)
                                                 ->whereIn('country_iso3',$incntry)
                                                 ->orderBy('city_iso', 'asc')
                                                 ->get();


                                    if (count($cityData) > 0) {

                                         foreach ($cityData as $key => $value) {

                                             $final_arrayct[] = $value->city_iso;

                                         }
                                     }



                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;
                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                               if(trim($post['selected_city_option'])=='3'){
                                    $cityModel = new \App\Cities;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntry=array();
                                if ($pos === false) {
                                       $incntry[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntry=  explode(',', $incounrty);

                                }

                                $cityData = $cityModel::select('city_iso')
                                                 ->where('metro_city',1)
                                                 ->whereIn('country_iso3',$incntry)
                                                 ->orderBy('city_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($cityData) > 0) {

                                         foreach ($cityData as $key => $value) {

                                             $final_arrayct[] = $value->city_iso;

                                         }
                                     }
                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                                if(trim($post['selected_city_option'])=='1'){
                                    $cityModel = new \App\Cities;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntry=array();
                                if ($pos === false) {
                                       $incntry[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntry=  explode(',', $incounrty);

                                }

                                $cityData = $cityModel::select('city_iso')
                                                 ->whereIn('country_iso3',$incntry)
                                                 ->orderBy('city_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($cityData) > 0) {

                                         foreach ($cityData as $key => $value) {

                                             $final_arrayct[] = $value->city_iso;

                                         }
                                     }
                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }

                               if(trim($post['selected_city_option'])=='state_custome'){

                                  $statedts=trim($post['country_city_iso']);
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                               // for state
                               if(trim($post['selected_state_option'])=='2'){
                                    $regionStateModel = new \App\StatezipCode;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntrys=array();
                                if ($pos === false) {
                                       $incntrys[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntrys =  explode(',', $incounrty);

                                }

                                $regionStateData = $regionStateModel::select('region_iso')
                                                 ->where('top_region',1)
                                                 ->whereIn('country_iso3',$incntrys)
                                                 ->orderBy('region_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($regionStateData) > 0) {

                                         foreach ($regionStateData as $key => $value) {

                                             $final_arrayct[] = $value->region_iso;

                                         }
                                     }


                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "STATE";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }

                                if(trim($post['selected_state_option'])=='1'){
                                    $regionStateModel = new \App\StatezipCode;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntrys=array();
                                if ($pos === false) {
                                       $incntrys[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntrys =  explode(',', $incounrty);

                                }

                                $regionStateData = $regionStateModel::select('region_iso')
                                                 ->whereIn('country_iso3',$incntrys)
                                                 ->orderBy('region_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($regionStateData) > 0) {

                                         foreach ($regionStateData as $key => $value) {

                                             $final_arrayct[] = $value->region_iso;

                                         }
                                     }


                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "STATE";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                               if(trim($post['selected_state_option'])=='city_state_custome'){

                                  $statedts=trim($post['country_state_iso']);
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "STATE";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";
                                             $assocModel->save();
                                         }
                                     }
                               }
                           }
                           // For Pin Code upload csv
                           if(trim($post['pincode_select_type'])=='2'){
                               $pin='';
                               if(isset($post['FileUpload']))
                                        {
                                        //Import uploaded file to Database
                                        $handle = fopen($_FILES['FileUpload']['tmp_name'], "r");

                                        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                                                foreach($data as $key=>$val){
                                                    if($val!=""){
                                                    $pin .=$val.',';
                                                    }
                                                }
                                            }
                                        $pin=substr($pin,0,strlen($pin)-1);

                                        fclose($handle);
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                            $targModel = new \App\TargettingChannelGroup;


                                            $targModel->channel_type = "advertiser";
                                            $targModel->owner_id = $advertiserId;
                                            $targModel->logical = "EQU";
                                            $targModel->type = "PIN";
                                            $targModel->data = $pin;
                                            $targModel->create_date_time = date("Y-m-d H:i:s");
                                            $targModel->update_date_time = date("Y-m-d H:i:s");

                                            if ($targModel->save()) {

                                                $assocModel->ad_id = $adsModel->ad_id;
                                                $assocModel->channel_id = $targModel->channel_group_id;
                                                $assocModel->last_update = date("Y-m-d H:i:s");
                                                $assocModel->create_date = date("Y-m-d H:i:s");
                                                $assocModel->status = "1";

                                                $assocModel->save();
                                            }
                                        }
                           }
                           // for pin code input
                           if(trim($post['pincode_select_type'])=='1'){
                               $pin='';
                               if(isset($post['pinc']) && trim($post['pinc'])!='')
                                        {
                                          $pin=trim($post['pinc']);
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                            $targModel->channel_type = "advertiser";
                                            $targModel->owner_id = $advertiserId;
                                            $targModel->logical = "EQU";
                                            $targModel->type = "PIN";
                                            $targModel->data = $pin;
                                            $targModel->create_date_time = date("Y-m-d H:i:s");
                                            $targModel->update_date_time = date("Y-m-d H:i:s");

                                            if ($targModel->save()) {

                                                $assocModel->ad_id = $adsModel->ad_id;
                                                $assocModel->channel_id = $targModel->channel_group_id;
                                                $assocModel->last_update = date("Y-m-d H:i:s");
                                                $assocModel->create_date = date("Y-m-d H:i:s");
                                                $assocModel->status = "1";

                                                $assocModel->save();
                                            }
                                        }
                           }

                        }
                       if(trim($post['country'])=='custom'){
                           if(trim($post['pincode_select_type'])=='3'){
                               if(trim($post['selected_city_option'])=='2'){
                                    $cityModel = new \App\Cities;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntry=array();
                                if ($pos === false) {
                                       $incntry[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntry=  explode(',', $incounrty);
                                }

                                $cityData = $cityModel::select('city_iso')
                                                 ->where('top_city',1)
                                                 ->whereIn('country_iso3',$incntry)
                                                 ->orderBy('city_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($cityData) > 0) {

                                         foreach ($cityData as $key => $value) {

                                             $final_arrayct[] = $value->city_iso;

                                         }
                                     }
                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                               if(trim($post['selected_city_option'])=='state_custome'){

                                  $statedts=trim($post['country_city_iso']);
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "CITY";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                               // for state
                               if(trim($post['selected_state_option'])=='2'){
                                    $regionStateModel = new \App\StatezipCode;
                                     $pos = strpos(trim($post['savecountry']), ',');
                                     $incntrys=array();
                                if ($pos === false) {
                                       $incntrys[] =trim($post['savecountry']);
                                }else{

                                     $incounrty=trim($post['savecountry']);
                                    $incntrys=  explode(',', $incounrty);

                                }

                                $regionStateData = $regionStateModel::select('region_iso')
                                                 ->where('top_region',1)
                                                 ->whereIn('country_iso3',$incntrys)
                                                 ->orderBy('region_iso', 'asc')
                                                 ->get();
                                 $final_arrayct = array();
                                 $statedts='';
                                     if (count($regionStateData) > 0) {

                                         foreach ($regionStateData as $key => $value) {

                                             $final_arrayct[] = $value->region_iso;

                                         }
                                     }

                                     if(count($final_arrayct)>1){
                                         $statedts=implode(",",$final_arrayct);
                                     }
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "STATE";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                               if(trim($post['selected_state_option'])=='city_state_custome'){

                                  $statedts=trim($post['country_state_iso']);
                                     if(trim($statedts)!=''){
                                         $assocModel = new \App\AdChannelGroupAssoc;
                                         $targModel = new \App\TargettingChannelGroup;


                                         $targModel->channel_type = "advertiser";
                                         $targModel->owner_id = $advertiserId;
                                         $targModel->logical = "EQU";
                                         $targModel->type = "STATE";
                                         $targModel->data = $statedts;
                                         $targModel->create_date_time = date("Y-m-d H:i:s");
                                         $targModel->update_date_time = date("Y-m-d H:i:s");

                                         if ($targModel->save()) {

                                             $assocModel->ad_id = $adsModel->ad_id;
                                             $assocModel->channel_id = $targModel->channel_group_id;
                                             $assocModel->last_update = date("Y-m-d H:i:s");
                                             $assocModel->create_date = date("Y-m-d H:i:s");
                                             $assocModel->status = "1";

                                             $assocModel->save();
                                         }
                                     }
                               }
                           }
                       }
                       /* Custom Country and State,City done*/

                    }




                                    $assocModel = new \App\AdChannelGroupAssoc;
                                    $targModel = new \App\TargettingChannelGroup;
                                    $targModel->channel_type = "advertiser";
                                    $targModel->owner_id = $advertiserId;
                                    $targModel->logical = "EQU";
                                    $targModel->type = "DEVICEFACTOR";
                                    $targModel->data = isset($devicedn)?$devicedn:'';
                                    $targModel->create_date_time = date("Y-m-d H:i:s");
                                    $targModel->update_date_time = date("Y-m-d H:i:s");

                                    if ($targModel->save()) {

                                        $assocModel->ad_id = $adsModel->ad_id;
                                        $assocModel->channel_id = $targModel->channel_group_id;
                                        $assocModel->last_update = date("Y-m-d H:i:s");
                                        $assocModel->create_date = date("Y-m-d H:i:s");
                                        $assocModel->status = "1";

                                        $assocModel->save();
                                    }
                        


                    // if(isset($post['devicedn']) && trim($post['devicedn']) != 'all') {

                    //     if(trim($post['devicedn'])=='smart_phone'){

                    //         $assocModel = new \App\AdChannelGroupAssoc;
                    //                 $targModel = new \App\TargettingChannelGroup;


                    //                 $targModel->channel_type = "advertiser";
                    //                 $targModel->owner_id = $advertiserId;
                    //                 $targModel->logical = "EQU";
                    //                 $targModel->type = "DEVICEFACTOR";
                    //                 $targModel->data = "Smartphone";
                    //                 $targModel->create_date_time = date("Y-m-d H:i:s");
                    //                 $targModel->update_date_time = date("Y-m-d H:i:s");

                    //                 if ($targModel->save()) {

                    //                     $assocModel->ad_id = $adsModel->ad_id;
                    //                     $assocModel->channel_id = $targModel->channel_group_id;
                    //                     $assocModel->last_update = date("Y-m-d H:i:s");
                    //                     $assocModel->create_date = date("Y-m-d H:i:s");
                    //                     $assocModel->status = "1";

                    //                     $assocModel->save();
                    //                 }
                    //     }
                    //     if(trim($post['devicedn'])=='featured_phone'){

                    //         $assocModel = new \App\AdChannelGroupAssoc;
                    //                 $targModel = new \App\TargettingChannelGroup;


                    //                 $targModel->channel_type = "advertiser";
                    //                 $targModel->owner_id = $advertiserId;
                    //                 $targModel->logical = "EQU";
                    //                 $targModel->type = "DEVICEFACTOR";
                    //                 $targModel->data = "Feature Phone";
                    //                 $targModel->create_date_time = date("Y-m-d H:i:s");
                    //                 $targModel->update_date_time = date("Y-m-d H:i:s");

                    //                 if ($targModel->save()) {

                    //                     $assocModel->ad_id = $adsModel->ad_id;
                    //                     $assocModel->channel_id = $targModel->channel_group_id;
                    //                     $assocModel->last_update = date("Y-m-d H:i:s");
                    //                     $assocModel->create_date = date("Y-m-d H:i:s");
                    //                     $assocModel->status = "1";

                    //                     $assocModel->save();
                    //                 }
                    //     }
                    //     if(trim($post['devicedn'])=='tablet'){

                    //         $assocModel = new \App\AdChannelGroupAssoc;
                    //                 $targModel = new \App\TargettingChannelGroup;


                    //                 $targModel->channel_type = "advertiser";
                    //                 $targModel->owner_id = $advertiserId;
                    //                 $targModel->logical = "EQU";
                    //                 $targModel->type = "DEVICEFACTOR";
                    //                 $targModel->data = "Tablet";
                    //                 $targModel->create_date_time = date("Y-m-d H:i:s");
                    //                 $targModel->update_date_time = date("Y-m-d H:i:s");

                    //                 if ($targModel->save()) {

                    //                     $assocModel->ad_id = $adsModel->ad_id;
                    //                     $assocModel->channel_id = $targModel->channel_group_id;
                    //                     $assocModel->last_update = date("Y-m-d H:i:s");
                    //                     $assocModel->create_date = date("Y-m-d H:i:s");
                    //                     $assocModel->status = "1";

                    //                     $assocModel->save();
                    //                 }
                    //     }
                    //      if(trim($post['devicedn'])=='custom_device'){
                    //         if (isset($post['device']) && trim($post['device']) != '') {
                    //             $assocModel = new \App\AdChannelGroupAssoc;
                    //                 $targModel = new \App\TargettingChannelGroup;


                    //                 $targModel->channel_type = "advertiser";
                    //                 $targModel->owner_id = $advertiserId;
                    //                 $targModel->logical = "EQU";
                    //                 $targModel->type = "DEVICE";
                    //                 $targModel->data = $post['device'];
                    //                 $targModel->create_date_time = date("Y-m-d H:i:s");
                    //                 $targModel->update_date_time = date("Y-m-d H:i:s");

                    //                 if ($targModel->save()) {

                    //                     $assocModel->ad_id = $adsModel->ad_id;
                    //                     $assocModel->channel_id = $targModel->channel_group_id;
                    //                     $assocModel->last_update = date("Y-m-d H:i:s");
                    //                     $assocModel->create_date = date("Y-m-d H:i:s");
                    //                     $assocModel->status = "1";

                    //                     $assocModel->save();
                    //                 }
                    //         }
                    //     }

                    // }

                    if (isset($post['os']) && trim($post['os']) != '') {

                        $assocModel = new \App\AdChannelGroupAssoc;
                        $targModel = new \App\TargettingChannelGroup;


                        $targModel->channel_type = "advertiser";
                        $targModel->owner_id = $advertiserId;
                        $targModel->logical = "EQU";
                        $targModel->type = "OS";
                        $targModel->data = $post['os'];
                        $targModel->create_date_time = date("Y-m-d H:i:s");
                        $targModel->update_date_time = date("Y-m-d H:i:s");

                        if ($targModel->save()) {

                            $assocModel->ad_id = $adsModel->ad_id;
                            $assocModel->channel_id = $targModel->channel_group_id;
                            $assocModel->last_update = date("Y-m-d H:i:s");
                            $assocModel->create_date = date("Y-m-d H:i:s");
                            $assocModel->status = "1";

                            $assocModel->save();
                        }
                    }


                    if (isset($post['osv']) && trim($post['osv']) != '') {

                        $assocModel = new \App\AdChannelGroupAssoc;
                        $targModel = new \App\TargettingChannelGroup;


                        $targModel->channel_type = "advertiser";
                        $targModel->owner_id = $advertiserId;
                        $targModel->logical = "EQU";
                        $targModel->type = "OSV";
                        $targModel->data = $post['osv'];
                        $targModel->create_date_time = date("Y-m-d H:i:s");
                        $targModel->update_date_time = date("Y-m-d H:i:s");

                        if ($targModel->save()) {

                            $assocModel->ad_id = $adsModel->ad_id;
                            $assocModel->channel_id = $targModel->channel_group_id;
                            $assocModel->last_update = date("Y-m-d H:i:s");
                            $assocModel->create_date = date("Y-m-d H:i:s");
                            $assocModel->status = "1";

                            $assocModel->save();
                        }
                    }

                    if (isset($post['browser']) && trim($post['browser']) != '') {

                        $assocModel = new \App\AdChannelGroupAssoc;
                        $targModel = new \App\TargettingChannelGroup;


                        $targModel->channel_type = "advertiser";
                        $targModel->owner_id = $advertiserId;
                        $targModel->logical = "EQU";
                        $targModel->type = "BROWSER";
                        $targModel->data = $post['browser'];
                        $targModel->create_date_time = date("Y-m-d H:i:s");
                        $targModel->update_date_time = date("Y-m-d H:i:s");

                        if ($targModel->save()) {

                            $assocModel->ad_id = $adsModel->ad_id;
                            $assocModel->channel_id = $targModel->channel_group_id;
                            $assocModel->last_update = date("Y-m-d H:i:s");
                            $assocModel->create_date = date("Y-m-d H:i:s");
                            $assocModel->status = "1";

                            $assocModel->save();
                        }
                    }

                    if (isset($post['browserc']) && trim($post['browserc']) != '') {

                        $assocModel = new \App\AdChannelGroupAssoc;
                        $targModel = new \App\TargettingChannelGroup;


                        $targModel->channel_type = "advertiser";
                        $targModel->owner_id = $advertiserId;
                        $targModel->logical = "EQU";
                        $targModel->type = "BROWSERV";
                        $targModel->data = $post['browserc'];
                        $targModel->create_date_time = date("Y-m-d H:i:s");
                        $targModel->update_date_time = date("Y-m-d H:i:s");

                        if ($targModel->save()) {

                            $assocModel->ad_id = $adsModel->ad_id;
                            $assocModel->channel_id = $targModel->channel_group_id;
                            $assocModel->last_update = date("Y-m-d H:i:s");
                            $assocModel->create_date = date("Y-m-d H:i:s");
                            $assocModel->status = "1";

                            $assocModel->save();
                        }
                    }
                    //for language
                    if (isset($post['language_tag']) && trim($post['language_tag']) != '') {

                        $assocModel = new \App\AdChannelGroupAssoc;
                        $targModel = new \App\TargettingChannelGroup;


                        $targModel->channel_type = "advertiser";
                        $targModel->owner_id = $advertiserId;
                        $targModel->logical = "EQU";
                        $targModel->type = "LANGUAGE";
                        $targModel->data = $post['language_tag'];
                        $targModel->create_date_time = date("Y-m-d H:i:s");
                        $targModel->update_date_time = date("Y-m-d H:i:s");

                        if ($targModel->save()) {

                            $assocModel->ad_id = $adsModel->ad_id;
                            $assocModel->channel_id = $targModel->channel_group_id;
                            $assocModel->last_update = date("Y-m-d H:i:s");
                            $assocModel->create_date = date("Y-m-d H:i:s");
                            $assocModel->status = "1";

                            $assocModel->save();
                        }
                    }

                    if (isset($post['tele']) && trim($post['tele']) != '') {

                        $assocModel = new \App\AdChannelGroupAssoc;
                        $targModel = new \App\TargettingChannelGroup;


                        $targModel->channel_type = "advertiser";
                        $targModel->owner_id = $advertiserId;
                        $targModel->logical = "EQU";
                        $targModel->type = "OPERATOR";
                        $targModel->data = $post['tele'];
                        $targModel->create_date_time = date("Y-m-d H:i:s");
                        $targModel->update_date_time = date("Y-m-d H:i:s");

                        if ($targModel->save()) {

                            $assocModel->ad_id = $adsModel->ad_id;
                            $assocModel->channel_id = $targModel->channel_group_id;
                            $assocModel->last_update = date("Y-m-d H:i:s");
                            $assocModel->create_date = date("Y-m-d H:i:s");
                            $assocModel->status = "1";

                            $assocModel->save();
                        }
                    }
                } //ads entry to the database
            } // campaign entry to the database

            //add same campagain details 

             // $advertiser_campagin = new \App\AdvertiserCampaigns;
             //    $advertiser_campagin->id_advertiser=$advertiserId;
             //    $advertiser_campagin->cc_unique_id=""; //null
             //    $advertiser_campagin->name=$post['adname'];
             //    $advertiser_campagin->offername="";
             //    $advertiser_campagin->url=$postp['url'];
             //    $advertiser_campagin->cpa="";
             //    $advertiser_campagin->create_time="";
             //    $advertiser_campagin->id_op="";
             //    $advertiser_campagin->id_opmultiple="";
             //    $advertiser_campagin->cr_goal="";
             //    $advertiser_campagin->status="";
             //    $advertiser_campagin->usdinr="";
             //    $advertiser_campagin->type="";
             //    $advertiser_campagin->margin="";
             //    $advertiser_campagin->campaign_type="";
             //    $advertiser_campagin->auto_select_for_pub="";
             //    $advertiser_campagin->cpc="";
             //    $advertiser_campagin->live="";
             //    $advertiser_campagin->is_live="";
             //    $advertiser_campagin->ads_cat="";
             //    $advertiser_campagin->backup_status="";
             //    $advertiser_campagin->backup_id="";
             //    $advertiser_campagin->is_offerwall="";
             //    $advertiser_campagin->budget="";
             //    $advertiser_campagin->daily_budget="";
             //    $advertiser_campagin->created_at="";
             //    $advertiser_campagin->start_date="";  
             //    $advertiser_campagin->end_date="";
             //    $advertiser_campagin->country_code=$post['savecountry_iso'];
             //    $advertiser_campagin->country_codemultiple="";
             //    $advertiser_campagin->os_type="";
             //    $advertiser_campagin->incent_type="";
             //    $advertiser_campagin->is_moi="";
             //    $advertiser_campagin->payout_type=""; 
             //    $advertiser_campagin->payout_currency="";
             //    $advertiser_campagin->is_smart="";
             //    $advertiser_campagin->perm_status="";
             //    $advertiser_campagin->preview="";
             //    $advertiser_campagin->api_id="";  
             //    $advertiser_campagin->api_type="";
             //    $advertiser_campagin->campaign_advertiser="";
             //    $advertiser_campagin->special_instructions="";
             //    $advertiser_campagin->other_promotional="";
             //    $advertiser_campagin->advtrackinglink="";
             //    $advertiser_campagin->vertical="";
             //    $advertiser_campagin->waitage_type="";
             //    $advertiser_campagin->waitage_percentege="";
             //    $advertiser_campagin->cap_count_click="";
             //    $advertiser_campagin->cap_count_conversions="";
             //    $advertiser_campagin->exclude_network="";
             //    $advertiser_campagin->include_network="";
             //    $advertiser_campagin->lastupdate="";
             //    $advertiser_campagin->waitage_time="";
             //    $advertiser_campagin->notify_adoffer="";
             //    $advertiser_campagin->is_desktop="";
             //    $advertiser_campagin->offer_type="";  
             //    $advertiser_campagin->flowoffer="";
             //    $advertiser_campagin->is_fraud="";
             //    $advertiser_campagin->exclude_siteid="";
             //    $advertiser_campagin->include_siteid="";
             //    $advertiser_campagin->exclude_browser="";
             //    $advertiser_campagin->include_browser="";
             //    $advertiser_campagin->exclude_os="";
             //    $advertiser_campagin->include_os="";
             //    $advertiser_campagin->exclude_referrer="";
             //    $advertiser_campagin->include_referrer="";
             //    $advertiser_campagin->promotional_medium="";  
             //    $advertiser_campagin->platform="";    
             //    $advertiser_campagin->device=""; 
             //    $advertiser_campagin->restricted_medium="";
             //    $advertiser_campagin->allowed_medium="";
             //    $advertiser_campagin->openfor_alldays="";
             //    $advertiser_campagin->day_schedule="";    
             //    $advertiser_campagin->exclude_publisher="";
             //    $advertiser_campagin->image_url="";   
             //    $advertiser_campagin->accept_operator="";
             //    $advertiser_campagin->publisher_cpa="";



        } else { 
        // image update to database
            return redirect('creat-ad')->with('error_ad', 'Image not uploaded!');
        }

        $contact_email = array();
        $adminEmail = $this->getAdminEmail();
        foreach($adminEmail as $email){
		   array_push($contact_email,trim($email->email_address));
		}
		$contact_name = 'Vola';
        $subject = 'A new campaign is added';

        Mail::send('create_ad_email_template', [], function($message) use($contact_email, $contact_name, $subject) {
					$message->from('no-reply@collectcent.com', 'Vola.ad')
                        ->to($contact_email, $contact_name)
                        ->subject($subject);
         });

        return redirect('myaccount')->with('success_ad', 'Congrats! Your Ad has been created successfully and has been sent to Admin for approval. It would be made live soon. ');
    }

    public function destroy_ad(Request $request) {
        $check_campagin_id = $request->check_ad;
        $campaignsArchived = array();
        $counter = 0;
        $result['status'] = 'failed';
        $result['message'] = 'Unknown error';
        if ($this->session['sessiondata']['accounts'][0]['account_type'] == 'ADVERTISER' || $this->session['sessiondata']['accounts'][0]['account_type'] == 'ADMIN') {
            if ($check_campagin_id) {

                $check_campagin_id = rtrim(str_replace(array("null,", ",null"), "", $check_campagin_id), ',');
                $check_campagin_ar = explode(",", $check_campagin_id);
                $adsModel = new \App\Ads();
                foreach ($check_campagin_ar as $value) {

                    $campaignObj = \App\Campaigns::find($value);
                    if ($this->session['sessiondata']['accounts'][0]['account_type'] == 'ADVERTISER' &&
                            $campaignObj !== NULL && $campaignObj->advertiser_id == $this->advertiserdata['advertiser_id']) {
                        $campaignObj->status = 'archived';
                        $campaignsArchived[] = $campaignObj->campaign_name;
                        $campaignObj->save();
                        $counter++;
                        $adsModel::where('campaign_id', '=', $value)->update(['ad_status' => '0']);
                    } else if ($this->session['sessiondata']['accounts'][0]['account_type'] == 'ADMIN' &&
                            $campaignObj !== NULL) {
                        $campaignObj->status = 'archived';
                        $campaignsArchived[] = $campaignObj->campaign_name;
                        $campaignObj->save();
                        $counter++;
                        $adsModel::where('campaign_id', '=', $value)->update(['ad_status' => '0']);
                    } else {
                        $result['status'] = 'false';
                        $result['message'] = 'Unknown error';
                    }
                }
                if (count($campaignsArchived) > 0) {
                    $result['status'] = 'success';
                    $result['message'] = "Following advertisements have been archived.<br />" . implode("<br />", $campaignsArchived);
                    return json_encode($result);
                }
            }
        }
        return json_encode($result);
    }

    //make function for Active ad
    public function make_active_ad(Request $request) {

        $canNotActivate = array('expired', 'rejected', 'archived', 'daily_cap_reached', 'pending', 'complete');
        $adminCanActivate = array('pending');
        $returnMessage = array();
        $check_campagin_id = $request->check_ad;
        $advertiser_id = $request->advertiser_id;
        $this->middleware('auth');
        $failed = true;
        $counter = 0;
        $campaignsActivated = array();
        if ($check_campagin_id) {

            $check_campagin_id = rtrim(str_replace(array("null,", ",null"), "", $check_campagin_id), ',');
            $check_campagin_ar = explode(",", $check_campagin_id);
            $campaignModel = new \App\Campaigns();
            $adsModel = new \App\Ads();

            foreach ($check_campagin_ar as $value) {
                $campaignObj = \App\Campaigns::find($value);
                if ($campaignObj !== NULL && $this->session['sessiondata']['roles'][0]['role_slug'] == 'ADVERTISER' &&
                        $campaignObj->advertiser_id == $this->advertiserdata['advertiser_id']) {
                    if (in_array($campaignObj->status, $canNotActivate)) {
                        $result['status'] = 'failed';
                        $result['message'] = "You do not have permission to activate advertisement";
                        return json_encode($result);
                    }
                    $campaignObj->status = 'running';
                    $campaignsActivated[] = $campaignObj->campaign_name;
                    $campaignObj->save();
                    $counter++;
                    //echo " hello ";
                    //exit;
                    $adsModel::where('campaign_id', '=', $value)->update(['ad_status' => '1']);
                } else if ($campaignObj !== NULL && $this->session['sessiondata']['roles'][0]['role_slug'] == 'ADMIN') {

                    if (in_array($campaignObj->status, $canNotActivate) && !in_array($campaignObj->status, $adminCanActivate)) {
                        $result['status'] = 'failed';
                        $result['message'] = "You do not have permission to activate advertisement";
                        return json_encode($result);
                    }
                    $campaignObj->status = 'running';
                    $campaignObj->admin_status = 'approved';
                    $campaignsActivated[] = $campaignObj->campaign_name;
                    $campaignObj->save();
                    $counter++;
                    $adsModel::where('campaign_id', '=', $value)->update(['ad_status' => '1', 'admin_status' => 'approved']);
                }
            }
            if (count($campaignsActivated) > 0) {
                $result['status'] = 'success';
                $result['message'] = "Following advertisements have been activated.<br />" . implode("<br />", $campaignsActivated);
                return json_encode($result);
            }
        }
        $result['status'] = 'false';
        $result['message'] = 'Unknown error';
        return json_encode($result);
    }

    //make function for pause ad

    public function make_pause_ad(Request $request) {
        $canPause = array('running');
        $returnMessage = array();
        $check_campagin_id = $request->check_ad;
        $this->middleware('auth');
        $failed = true;
        $counter = 0;
        $campaignsActivated = array();
        if ($check_campagin_id) {

            $check_campagin_id = rtrim(str_replace(array("null,", ",null"), "", $check_campagin_id), ',');
            $check_campagin_ar = explode(",", $check_campagin_id);
            $campaignModel = new \App\Campaigns();
            $adsModel = new \App\Ads();

            foreach ($check_campagin_ar as $value) {
                $campaignObj = \App\Campaigns::find($value);
                if ($campaignObj !== NULL && $this->session['sessiondata']['roles'][0]['role_slug'] == 'ADVERTISER' &&
                        $campaignObj->advertiser_id == $this->advertiserdata['advertiser_id']) {
                    if (!in_array($campaignObj->status, $canPause)) {
                        $campaignsActivated[] = "You do not have permission to pause " . $campaignObj->campaign_name;
                    } else {
                        $campaignObj->status = 'pause';
                        $campaignsActivated[] = $campaignObj->campaign_name;
                        $campaignObj->save();
                        $counter++;
                        $adsModel::where('campaign_id', '=', $value)->update(['ad_status' => '0']);
                        ////print_r($campaignObj->toArray());
                    }
                } else if ($campaignObj !== NULL && $this->session['sessiondata']['roles'][0]['role_slug'] == 'ADMIN') {

                    if (!in_array($campaignObj->status, $canPause)) {
                        $campaignsActivated[] = "You do not have permission to pause " . $campaignObj->campaign_name;
                    } else {
                        $campaignObj->status = 'pause';
                        $campaignsActivated[] = $campaignObj->campaign_name;
                        $campaignObj->save();
                        $counter++;
                        $adsModel::where('campaign_id', '=', $value)->update(['ad_status' => '0']);
                    }
                }
            }
            if (count($campaignsActivated) > 0 && $counter) {
                $result['status'] = 'success';
                $result['message'] = "Following advertisements have been paused.<br />" . implode("<br />", $campaignsActivated);
                return json_encode($result);
            } else {
                $result['status'] = 'false';
                $result['message'] = implode("<br />", $campaignsActivated);
            }
        }
        $result['status'] = 'false';
        $result['message'] = 'Unknown error';
        return json_encode($result);
    }

    public function change_cpc(Request $request) {

        $check_campagin_id = $request->check_ad;
        $new_cpc = $request->new_cpc;
        if ($this->session['sessiondata']['roles'][0]['role_slug'] == 'ADVERTISER' || $this->session['sessiondata']['roles'][0]['role_slug'] == 'ADMIN') {

            if ($check_campagin_id) {

                $check_campagin_id = rtrim(str_replace(array("null,", ",null"), "", $check_campagin_id), ',');
                $check_campagin_ar = explode(",", $check_campagin_id);
                $campaignModel = new \App\Campaigns();
                $cpcarrv = config('campaign.mincpcrate');


                $adv_currency = (!empty($this->session['sessiondata']['accounts'][0]['adv_currency'])) ? $this->session['sessiondata']['accounts'][0]['adv_currency'] : 'USD';
                if(floatval($new_cpc) > floatval($cpcarrv[$adv_currency]) || floatval($new_cpc) == floatval($cpcarrv[$adv_currency])){
                foreach ($check_campagin_ar as $value) {
                    $campaignObj = \App\Campaigns::find($value);
                    $advObj = $campaignObj->advertiser;
                    //if($this->session['sessiondata']['accounts'][0]['account_type'] == 'ADMIN' ||$advObj->advertiser_id== )
                    if ($adv_currency == 'USD') {
                        if(floatval($campaignObj->daily_budget) > floatval($new_cpc)){
                             $campaignModel::where('campaign_id', '=', $value)->update(['min_unit_price' => $new_cpc, 'min_unit_price_currency' => $new_cpc]);
                        }else{
                            return 'Sorry, cost per click should not be greater than daily budget';
                        }

                    } else {
                       // $new_cpc_usd = PaymentController::convertCurrency($new_cpc, $adv_currency, 'USD');
			$paymentControllerObj = new PaymentController();
                        $new_cpc_usd = $paymentControllerObj->convertCurrency($new_cpc, $adv_currency, 'USD');
                       if(floatval($campaignObj->hourly_budget) > floatval($new_cpc)){
                        $campaignModel::where('campaign_id', '=', $value)->update(['min_unit_price' => $new_cpc_usd, 'min_unit_price_currency' => $new_cpc]);
                       }else{
                           return 'Sorry, cost per click should not be greater than daily budget';
                       }
                    }
                }

                return "success";
            }else{
                return 'Sorry, cost per click should be minimum '.$cpcarrv[$adv_currency].' '.$adv_currency;
            }
            }
        } else {
            return "unknown error";
            //not allowed to update records
        }


        return "not success";
    }

    public function change_budget(Request $request) {

        $mincampaignbudgetArr = config('campaign.mincampaignbudget');
        $check_campagin_id = $request->check_ad;
        $new_budget = $request->new_budget;

        if ($this->session['sessiondata']['roles'][0]['role_slug'] == 'ADVERTISER' || $this->session['sessiondata']['roles'][0]['role_slug'] == 'ADMIN') {

            if ($check_campagin_id) {
                $adv_currency = (!empty($this->session['sessiondata']['accounts'][0]['adv_currency'])) ? $this->session['sessiondata']['accounts'][0]['adv_currency'] : 'USD';
                $mincampaignbudgetArr = config('campaign.mincampaignbudget');
                if (isset($mincampaignbudgetArr[$adv_currency]) && $mincampaignbudgetArr[$adv_currency] > $new_budget) {
                    return 'Campaign budget should be minimum ' . $adv_currency . ' ' . $mincampaignbudgetArr[$adv_currency];
                }

                //if (($request->edittype) && $request->edittype == 'deduct') {

                $result = DB::table('hourly_stat')->where('campaign_id', $check_campagin_id)
                        ->selectRaw("campaign_id,"
                                . "sum(revenue_value_currency) as spend")
                        ->get();
                if (is_array($result)) {
                    $spend = $result[0]->spend;

                    if ($new_budget < $spend) {
                        return 'Spend exceeded from your balance !';
                    }
                }
                $campaignObj = \App\Campaigns::find($check_campagin_id);

                    if ($campaignObj !== NULL) {
                        $advObj = $campaignObj->advertiser;
                        $budgetDiff = $new_budget - $campaignObj->campaign_budget_currency;
                        if ($budgetDiff > $advObj->balance_left_currency) {
                            return 'Budget exceeded your balance !';
                        }
                        $advObj->balance_left_currency = $advObj->balance_left_currency - $budgetDiff;
                        $campaignObj->campaign_budget_currency = $new_budget;
                        if ($advObj->currency == 'USD') {
                            $advObj->balance_left_dollar = $advObj->balance_left_currency;
                            if(floatval($new_budget) > floatval($campaignObj->daily_budget)){
                            $campaignObj->campaign_budget = $new_budget;
                            }else{
                               return 'Sorry, Total Budget should not be lower than daily budget';
                            }
                        } else {
                           // $advObj->balance_left_dollar = PaymentController::convertCurrency($advObj->balance_left_currency, $advObj->currency, 'USD');
                           // $campaignObj->campaign_budget = PaymentController::convertCurrency($campaignObj->campaign_budget_currency, $advObj->currency, 'USD');
			$paymentControllerObj = new PaymentController();
                           $new_budget2 = $paymentControllerObj->convertCurrency($advObj->campaign_budget_currency, $advObj->currency, 'USD');
                            if(floatval($new_budget2) > floatval($campaignObj->hourly_budget)){
                                 $advObj->balance_left_dollar = $paymentControllerObj->convertCurrency($advObj->balance_left_currency, $advObj->currency, 'USD');
                            $campaignObj->campaign_budget = $new_budget2;
                            }else{
                                 return 'Sorry, Total Budget should not be lower than daily budget';
                            }
                        }
                        $advObj->save();
                        $campaignObj->save();
                        return "success";
                    }
                }
            }
            return "not success";
        }

    /*
      get ads running info in json format
     *  */

    public function createCopyAd(Request $request) {
        if (!Auth::check()) {
            return redirect('/login');
        }
//        echo "<pre>";print_r($this->session);die;
//        $request->advertiser_id = 22;
//        $request->check_ad = 1;

        $destinationPath = public_path('themes/usr_images');
        $check_campagin_id = $request->check_ad;
//        $advertiserId = $request->advertiser_id;

        if ($check_campagin_id > 0) {

            //getting the stat records
            $camModel = new \App\Campaigns();
            $adModel = new \App\Ads();
            $creativeModel = new \App\CreativeGroup();
            $targModel = new \App\TargettingChannelGroup();
            $assocModel = new \App\AdChannelGroupAssoc();


            $filenames = $group_ids = array();
            $camModel = $camModel::find($check_campagin_id);
            $camModel = $camModel->replicate();
            $camModel->status = "pending";
            $camModel->admin_status = "pending";
           $advertiserId =  $camModel->advertiser_id;
            //check for the advertiser balance
            $result = DB::table('dl_advertisers')->select('balance_left_dollar')->where('advertiser_id', $camModel->advertiser_id)->get();
            $balance_left_dollar = $result[0]->balance_left_dollar;

            if ($camModel->campaign_budget > $balance_left_dollar) {
                //return  '';
                return 'Budget exceeded from your balance !';
            }

            if ($camModel->save()) {

                //get related ads###########

                $adData = $adModel::where("campaign_id", "=", $check_campagin_id)->first();
                $ad_id = $adData->ad_id;
                $adData = $adData->replicate();

                //replicate creative groups entry#############

                $creativeModel = $creativeModel::where("group_id", "=", $adData->creative_ids)->get();
                foreach ($creativeModel as $key => $value) {


                    $creative = new \App\CreativeGroup();
                    $creative->save();
                    $creative->file_name = str_replace($value->group_id . "_", $creative->group_id . "_", $value->file_name);
                    $creative->save();
                    $group_ids[] = $creative->group_id;
                    $filenames [$creative->group_id] = $value->file_name;
//                echo "<pre>";print_r($targModel->channel_group_id." ##### ".$copyAssoc->ad_targetting_group_id);
                }


                //save replicated ads with update##############

                $adData->creative_ids = implode(",", $group_ids);
                $adData->campaign_id = $camModel->campaign_id;
                $adData->ad_status = 0;
                $adData->admin_status = "pending";
                $adData->save();

                //replicate associated targetting options############

                $assocMulti = $assocModel::where("ad_id", "=", $ad_id)->get();
                foreach ($assocMulti as $key => $value) {

                    $targModel = $targModel::where("channel_group_id", "=", $value->channel_id)->first()->replicate();
                    $targModel->save();

                    $copyAssoc = new \App\AdChannelGroupAssoc();
                    $copyAssoc->ad_id = $adData->ad_id;
                    $copyAssoc->channel_id = $targModel->channel_group_id;
                    $copyAssoc->save();
//                echo "<pre>";print_r($targModel->channel_group_id." ##### ".$copyAssoc->ad_targetting_group_id);
                }

                if ($filenames && $group_ids) {

                    foreach ($filenames as $key => $name) {

                        $name = trim($name);
                        if ($name != '') {

                            $name_arr = explode("_", $name);
                            $new_name = $key . "_" . $name_arr[1];
                            $command = "cp $destinationPath/$name $destinationPath/$advertiserId/$new_name";
                            $source="$destinationPath/$name";
                            $destination="$destinationPath/$advertiserId/$new_name";
                            File::copy($source,$destination);
                            // @exec($command, $output);
//                       echo "<pre>";print_r($command);
                            // $command = "chmod 0777 $destinationPath/$advertiserId/$new_name";
                            // @exec($command, $output);
//                       echo "<pre>";print_r($name."####".$new_name);
                        }
                    }
                }

                //deduct balance from advertiser account
                $this->deductBalance($camModel->campaign_budget, $camModel->advertiser_id);

                //echo "<pre>";print_r($filenames);die;
                return "success";
            } else {

                return "not success";
            }
        } else {

            return "not success";
        }

        return "not success";
    }

    public function editad(Request $request) {



        if (!Auth::check()) {
            return redirect('/login');
        }
         $detect = new MobileDetect();
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
         $session = Session::all();
        $adv_id = $session['sessiondata']['accounts'][0]['advertiser_id'];

         $cmpid = $request->campaign_id;

         $camModel = new \App\Campaigns();
         $camModel = $camModel::find($cmpid);
              

            $campaign_pricing_model=$camModel->campaign_pricing_model;
         $campaign_ad_type=$camModel->campaign_ad_type;
         $campaign_vertical=$camModel->campaign_vertical;
         
            $include_exchanges = explode(',', $camModel->include_exchange);
        

         if(isset($adv_id) && $cmpid != '' && $adv_id!='' && ($adv_id==trim($camModel->advertiser_id)))
            {
             $picdata = array();
            $json_urlv = url('creat-ad/get-detail?campaign_id=' . $cmpid);
            $jsonv = file_get_contents($json_urlv);
            $data = json_decode($jsonv, true);

            $creativeidAr = array();
            if (isset($_REQUEST['grpid'])) {
                $creativeids = $_REQUEST['grpid'];
            } else {
                $creativeids = $data[0]['creative_ids'];
            }

            if (trim($creativeids) != '') {
                $pos = strpos($creativeids, ",");
                if ($pos !== false) {
                    $creativeidsArr = explode(",", $creativeids);
                    foreach ($creativeidsArr as $key => $val) {
                        $creativeidAr[] = trim($val);
                    }
                } else {
                    $creativeidAr[] = trim($creativeids);
                }

                $creativeModel = new \App\CreativeGroup();
                $picdata = $creativeModel->whereIn('group_id', $creativeidAr)->get();

            }

            $json_url = url("json-data/get-iab-categories");
            
            $json = file_get_contents($json_url);
            
            $datacat = json_decode($json, true);
            
            $typeCat = 0;

            $catid = $data[0]['adv_cat_id'];

            $subcatid = $data[0]['adv_subcat_id'];

            $categories = isset($datacat[0]['IAB'.$catid])?$datacat[0]['IAB'.$catid]:'';

            $subcategories = isset($datacat['IAB'.$catid]['IAB'.$catid.'-'.$subcatid])?$datacat['IAB'.$catid]['IAB'.$catid.'-'.$subcatid]:'';
            

            if($campaign_pricing_model === "Smart CPA"){
            $get_all_op_cnt = new \App\Operators2s;
             $get_all_op_cnt = $get_all_op_cnt->get();   
             $final_array=array();
             foreach ($get_all_op_cnt as $key => $value) {
             $final_array[$value['id']]=$value['country_code3'];
            }
        }else{
              $get_all_op_cnt_adact = new \App\Operator;
             $get_all_op_cnt_adact = $get_all_op_cnt_adact->get();   
             $final_array=array();
             foreach ($get_all_op_cnt_adact as $key => $value) {
             $final_array[$value['operator_id']]=$value['country_name_iso2'];
            }


        }

            
            $raw=DB::select(DB::raw("select group_concat(concat('{label:','\"',webpage_name,' \"',',','value:','\"',url,'\"}')) as urls from advertiser_webpage where webpage_name not in ('','NULL') and advertiser_id=".$adv_id));
            if(trim($raw[0]->urls)!=''){
            $rn=substr(trim($raw[0]->urls),-1);
            if($rn=='}'){
        $srtrowurl=$raw[0]->urls;
            }else{
               $srtrowurl=$raw[0]->urls.'"}';
            }
        }else{
          $srtrowurl='';
        }

        $IncludeExchangesvalue= IncludeExchanges::select('id','exchangeID','popup','adult')->where('popup','=','1')->get();
         $IncludeExchanges_select=  $IncludeExchangesvalue->toArray();
               
         	if($deviceType=='computer'){

            return View('edit-ad', ['camdata' => $camModel,
                    'cmpid' => $cmpid, 
                    'pricing_model' => $campaign_pricing_model,
                    'campaign_ad_type' => $campaign_ad_type,
                    'campaign_ad_vertical'=>$campaign_vertical,
                    'vertical'=>$campaign_vertical,
                    'dataval' => $data,
                    'categories' => $categories,
                    'subcategories' => $subcategories,
                    'catid' => $catid, 
                    'subcatid' => $subcatid, 
                    'picdata' => $picdata,
                    'suggestions'=>$srtrowurl, 
                    'all_op_cnt' =>$final_array,
                    'include_exc' =>$include_exchanges,
                    'IncludeExchanges_select' =>$IncludeExchanges_select,
                    'advcurrency' => $this->currency]);
         			}
			else{
			 return View('mob-edit-ad', ['camdata' => $camModel,
                'cmpid' => $cmpid,
                'pricing_model' => $campaign_pricing_model,
                'campaign_ad_type' => $campaign_ad_type,
                'campaign_ad_vertical'=>$campaign_vertical,
                'dataval' => $data,
                'categories' => $categories,
                'subcategories' => $subcategories,
                'catid' => $catid,
                'subcatid' => $subcatid,
                'picdata' => $picdata,
                'suggestions'=>$srtrowurl,
                 'all_op_cnt' =>$final_array,
                  'include_exc' =>$include_exchanges,
                  'IncludeExchanges_select' =>$IncludeExchanges_select,
                'advcurrency' => $this->currency]
                );

			}

            }else{

             return redirect('myaccount')->withErrors(['msg', 'This campaign is not linked to your account. Please recheck and submit again. ']);
         }



    }

    public function getPubReport() {

        //var_dump('id:', \Session::getId());
        return View("/pubadmaccount");
    }

    public function getIoList(Request $request) {
        $take =  $request->ids ;
        //var_dump('id:', \Session::getId());
        return View("/ioList");
    }

    public function getIoReport()
    {
        return View("/ioadmaccount");
    }


    public function getReport(Request $request) {
        $campaign_id=isset($request->campaign_id)?$request->campaign_id:'-1';
            $this->sessionRefresh();
            $detect = new MobileDetect();
		$deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
		$session = Session::all();
        $tzObj = new \DateTimeZone($session['sessiondata']['user_timezone']);
        $dateTimeObj = new \DateTime('now', $tzObj);
        $currency = $this->getCurrencyFromAccount($session['sessiondata']['accounts'][0]['account_id']);
        $campagins = \App\Campaigns::select('campaign_id as id','campaign_name as text')
                        ->where('advertiser_id', $this->advertiserdata['advertiser_id'])
                        ->where('status',"!=", "archived")
                        ->get()->toArray();

        if($deviceType=='computer'){
                     return View('reports_tab', [ 'campaign_id' => $campaign_id,'campagins' => $campagins ,'currency' => $session['sessiondata']['accounts'][0]['adv_currency'],
            'dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone']]);
                }else{
                     return View('mob-reports_tab', [ 'campaign_id' => $campaign_id , 'campagins' => $campagins , 'currency' => $session['sessiondata']['accounts'][0]['adv_currency'],
            'dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone']]);

                }


    }

    public function editProfileDetail(Request $request) {
        if (!Auth::check()) {
            return redirect('/login');
        }
        $post = $request->all();
        $user_email = Session::get('UserEmail');
        $userModel = new \App\User();
        $userData = $userModel::where('email_address', '=', $user_email)->first();

        $name = trim($post['name']);
        $pos = strpos($name, ' ');
        if ($pos === false) {
            $userData->first_name = $name;
            $userData->last_name='';
        } else {
            $expd = explode(' ', $name);
            $cnt = count($expd) - 1;
            if (!empty($expd[$cnt])) {
                $userData->last_name = $expd[$cnt];
            }
            $namestr = '';
            for ($v = 0; $v < count($expd) - 1; $v++) {
                $namestr .= $expd[$v];
            }
            $userData->first_name = $namestr;
        }


        $notify_me_json['out_of_fund'] = isset($post['out_of_fund']) ? 1 : 0;
        $notify_me_json['less_fund'] = isset($post['less_fund']) ? 1 : 0;
        $notify_me_json['less_amount'] = isset($post['less_amount']) ? $post['less_amount'] : 0;
        $notify_me_json['long_paused'] = isset($post['long_paused']) ? 1 : 0;
        $notify_me_json['refresh_picture'] = isset($post['refresh_picture']) ? 1 : 0;
        $notify_me_json['approve_rejected'] = isset($post['approve_rejected']) ? 1 : 0;
        $notify_me_json['report_mails'] = isset($post['report_mails']) ? 1 : 0;
        $notify_me_json['report_duration'] = isset($post['report_duration']) ? $post['report_duration'] : 0;
        // dd($notify_me_json);

        //
        //$userData->last_name = $post['last_name'];
        $userData->email_address = $post['email'];
        $userData->phone_number = $post['mobile'];
        $userData->phone_country_code = $post['phone_country'];
        $userData->country_id = $post['country'];
        $userData->utc_offset = $post['utc_offset'];
        $userData->user_timezone = $post['user_timezone'];
        $userData->company_name = $post['company_name'];
        $userData->notify_me_json = json_encode($notify_me_json);


        if (trim($post['cpwd']) != '' && trim($post['email']) != '' && trim($post['npwd']) != '') {
            if (Auth::attempt(['email_address' => $post['email'], 'password' => $post['cpwd']])) {

                $user = Auth::user();
                if ($user) {
//                Session::put('UserID', $user->user_id);
                    $userData->password = Hash::make($post['npwd']);
                } else {
                    return redirect('/myprofile')->with('error_pwd', 'Incorrect Current Password. Please recheck and submit again. ');
                }
            }
        }


        if ($userData->save()) {
             $session = Session::all();
            $default_account_id=$session['sessiondata']['accounts'][0]['account_id'];
            DB::table('dl_advertisers')
            ->where('account_id', $default_account_id)
            ->update(['contact_name' => $name,'contact_email'=>$post['email'],'contact_mobile'=>$post['mobile'],'contact_phone'=>$post['mobile']]);
            Session::forget('sessiondata');
            $this->sessionRefresh();
            return redirect("/myprofile")->with('status', 'Congrats! Your profile has been updated successfully.');
        }

        return redirect("/myprofile")->with('status', 'Profile not updated. Please try again. ');
    }

    public function check_balance_left_dollar(Request $request) {

        $sessiondata = Session::get('sessiondata');
        $advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
        $post_value = $request->post_value;
        $cam_id = $request->cam_id;


        if (($request->edittype) && $request->edittype == 'deduct') {
             $result = DB::table('hourly_stat')->where('campaign_id', $cam_id)
                        ->selectRaw("campaign_id,"
                                . "sum(revenue_value_currency) as spend")
                        ->get();
           // $result = DB::table('hourly_stat')->select("campaign_id,sum(revenue_value_currency) as spend")->where('campaign_id', $cam_id)->get();
            $spend = $result[0]->spend;
            if ($post_value > $spend) {
                //return  '';
                return 'Spend exceeded from your balance !';
            }
        } else {

            $result = DB::table('dl_advertisers')->select('balance_left_currency')->where('advertiser_id', $advertiser_id)->get();
            $balance_left_dollar = $result[0]->balance_left_currency;

            if ($post_value > $balance_left_dollar) {
                //return  '';
                return 'Budget exceeded from your balance !';
            }
        }


        return 1;
    }

    public function check_daily_left_dollar(Request $request) {

        $sessiondata = Session::get('sessiondata');
        $advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
        $post_value = $request->post_value;
        $campaign_id = $request->cam_id;

        $result = DB::table('hourly_stat')->where('campaign_id', $cam_id)
                        ->where('stat_date', date('Y-m-d'))
                        ->selectRaw("campaign_id,"
                                . "sum(revenue_currency) as spend")
                        ->get();
        //$result = DB::table('hourly_stat')->select("campaign_id,sum(revenue_currency) as spend")->where('stat_date', date('Y-m-d'))->where('campaign_id', $cam_id)->get();
        $spend = $result[0]->spend;
        if ($spend > $post_value) {
            //return  '';
            return 'Spend exceeded from your balance !';
        }

        return 1;
    }

    public function deductBalance($budget, $adv_id) {

        DB::update('update dl_advertisers set balance_left_currency = balance_left_currency-' . trim($budget) . ' where advertiser_id = ? limit 1', [$adv_id]);
    }

    public function deductBalanceOnEdit($initial_total_budget, $budget, $adv_id) {


        if ($initial_total_budget < $budget) {
            DB::update('update dl_advertisers set balance_left_currency = balance_left_currency-' . trim($budget - $initial_total_budget) . ' where advertiser_id = ? limit 1', [$adv_id]);
        } else {
            DB::update('update dl_advertisers set balance_left_currency = balance_left_currency+' . trim($initial_total_budget - $budget) . ' where advertiser_id = ? limit 1', [$adv_id]);
        }
    }

    public function getCurrencyFromAccount($account_id) {

        $data = \App\Advertiser::where('dl_advertisers.account_id', $account_id)
                        ->leftJoin('currency_database', 'currency_database.symbol', '=', 'dl_advertisers.default_currency')
                        ->selectRaw('currency_database.symbol')
                        ->take(1)->get();
        return ($data[0]->symbol) ? $data[0]->symbol : 0;
    }

    public function getAdvId($userId) {

        if ($userId) {

            $publisher = DB::table('dl_advertisers')->where('account_id', $userId)->first();
            if ($publisher->advertiser_id > 0) {

                return $publisher->advertiser_id;
            }
        }

        return null;
    }

    public function archive() {

        $session = Session::all();
        $tzObj = new \DateTimeZone($session['sessiondata']['user_timezone']);
        $dateTimeObj = new \DateTime('now', $tzObj);
        return View('archive_tab', ['currency' => $session['sessiondata']['accounts'][0]['adv_currency'], 'dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone']]);
    }

    //url insertion function for getting url id/page id
    #@param - url

    public function getPageIdFromUrl($url, $adv_id) {

        $webpage = \App\AdvertiserWebpage::firstOrNew(['url' => $url]);
        $webpage->advertiser_id = $adv_id;
        $webpage->url = $url;

        if ($webpage->save()) {

            return $webpage->page_id;
        }

        return 0;
    }

    public function adDetail(Request $request) {

        if (!Auth::check()) {
            return redirect('/login');
        }


        $cmpid = $request->campaign_id;
        $picdata = array();
        if ($cmpid != '') {
            $json_urlv = url('creat-ad/get-detail?campaign_id=' . $cmpid);
            $jsonv = file_get_contents($json_urlv);
            $data = json_decode($jsonv, true);
            $creativeidAr = array();
            if (isset($_REQUEST['grpid'])) {
                $creativeids = $_REQUEST['grpid'];
            } else {
                $creativeids = $data[0]['creative_ids'];
            }

            if (trim($creativeids) != '') {
                $pos = strpos($creativeids, ",");
                if ($pos !== false) {
                    $creativeidsArr = explode(",", $creativeids);
                    foreach ($creativeidsArr as $key => $val) {
                        $creativeidAr[] = trim($val);
                    }
                } else {
                    $creativeidAr[] = trim($creativeids);
                }

                $creativeModel = new \App\CreativeGroup();
                $picdata = $creativeModel->whereIn('group_id', $creativeidAr)->get();
            }



            $json_url = url("json-data/get-categories");
            $json = file_get_contents($json_url);

            $datacat = json_decode($json, true);
            $typeCat = 0;
            $catid = $data[0]['adv_cat_id'];
            $subcatid = $data[0]['adv_subcat_id'];
            $categories = $datacat[$typeCat][0][$catid];
            $subcategories = $datacat[$typeCat][$catid][$subcatid];

            return View('ad-detail', ['cmpid' => $cmpid, 'dataval' => $data, 'categories' => $categories, 'subcategories' => $subcategories, 'catid' => $catid, 'subcatid' => $subcatid, 'picdata' => $picdata]);
        } else {
            return redirect('myaccount');
        }
    }
    function folder_existd($folder,$advertiserId)
    {
        // Get canonicalized absolute pathname
        $pv=$folder.'/'.$advertiserId;
        $path = realpath($pv);

        // If it exist, check if it's a directory
        if($path !== false AND is_dir($path))
        {
            // Return canonicalized absolute pathname
            return $pv;
        }else{

            //  $success = exec("mkdir $pv");
            //  $success = exec("chmod -R 0777  $pv");
             $success = File::makeDirectory($pv);

             return $pv;
        }


    }
    function crtimg($requestImg,$grpid,$advertiserId) {

	$findme   = 'data:image/png';
	$pos = strpos($requestImg, $findme);
	 $upload_dir22 = public_path('themes/usr_images');

        $upload_dir=$this->folder_existd($upload_dir22,$advertiserId);

       // $upload_dir22 = public_path('themes/usr_images');
	$dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
	 $imageVal = getimagesize($requestImg);
	$chkdm = $imageVal[0] . 'X' . $imageVal[1];
	if (in_array($chkdm, $dmsarr)) {

       if ($pos === false) {
		$img = str_replace('data:image/jpeg;base64,', '', $requestImg);
                $img = str_replace(' ', '+', $img);
                 $data = base64_decode($img);

                $filenm=$grpid .'_'.$chkdm.'.jpg';

                $file = $upload_dir.'/' . $filenm;
                $success = file_put_contents($file, $data);
                chmod($file, 0777);
		return array($filenm,$chkdm,'jpg');
	}else{
		$img = str_replace('data:image/png;base64,', '', $requestImg);
                $img = str_replace(' ', '+', $img);
                $data = base64_decode($img);
                $filenm=$grpid .'_'.$chkdm.'.png';
                $file = $upload_dir .'/'. $filenm;
                $success = file_put_contents($file, $data);
                chmod($file, 0777);
		return array($filenm,$chkdm,'png');
	}

	}else{
	return array();
	}
    }

    function imgaddUpload($imgnm,$advertiserId)
    {
        if (trim($imgnm)!= '') {
                    // upload path
                    $creativeModel = new \App\CreativeGroup;

                    $creativeModel->advertiser_id = $advertiserId;
                    $creativeModel->content_type = "image";
                    $creativeModel->create_date_time = date('Y-m-d H:i:s');
                    $nameArr = "";
                    $dmArr = "";
                    $extArr = "";
                    if ($creativeModel->save()) {
                       $repsArr=$this->crtimg(trim($imgnm),$creativeModel->group_id,$advertiserId);
                       if(!empty($repsArr))
                       {
                            $nameArr = $advertiserId.'/'.$repsArr[0];
                            $dmArr = $repsArr[1];
                            $extArr = $repsArr[2];
                       }
                    }
                    $creativeModel->file_name = $nameArr;
                    $creativeModel->content_dimensions = $dmArr;
                    $creativeModel->content_extensions = $extArr;
                    $creativeModel->save();
                    return $creativeModel->group_id;


        }else{
            return 0;
        }
    }

    public function draftadsave(Request $request)
    {
        $sessiondata = Session::get('sessiondata');
        $advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);

        $campaignTempModel = new \App\CampaignTemp;
        $campaignTempModel->advertiser_id = $advertiser_id;
        $campaignTempModel->pcat_id = trim($request->pcat_id);
        $campaignTempModel->scat_id = trim($request->scat_id);
       $campaignTempModel->create_date_time = date('Y-m-d H:i:s');
       $campaignTempModel->update_date_time = date('Y-m-d H:i:s');
          $final_array=array();
                    if ($campaignTempModel->save()) {
                        $final_array['status']='success';
                        $final_array['campid'] = $campaignTempModel->id;
                    }else{
                       $final_array['status']='error';
                        $final_array['message']= 'not saved';
                    }
        //CampaignTemp
        //
                    return json_encode($final_array);
    }

    public function getAdminEmail(){
		$res =  DB::select('SELECT cf_users.email_address FROM cf_users WHERE cf_users.user_id IN (
                    SELECT role_user.user_id AS user_id
                    FROM role_user
                    WHERE role_user.role_id =1)');
		if($res){ return $res;}else{return false;}
    }




}
