<?php

namespace App\Http\Controllers; 

use Illuminate\Http\Request;
use Validator;
use Socialite;
use DB;
use Auth;
use Illuminate\Support\Facades\Mail; //TBD
use Illuminate\Mail\Mailer; //TBD
use Hash;
use App\User;
use App\Advertiser;
//use App\Role;
//use App\Account;
use Session;
use App\Http\Requests;
use App\Http\Controllers\Controller;

class LoginController extends Controller {
    /*     * find
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index() {
        if (Auth::check()) {
            return redirect("/");
            // The user is logged in...
        }

        $json_url = url("json-data/get-countries");
        $json = file_get_contents($json_url);
        $data = json_decode($json, true);

        $countryId = $this->getCountryId();
        return View('/login', ['countries' => $data])->with('country_id', $countryId);
    }

    /**
     * Show the form for login validated the users.
     * This function is use for validated the a user in login process
     * @return \Illuminate\Http\Response
     */
    public function validateUser(Request $request) {
        if ($request->email_address) {
            $validator = Validator::make(
                            array(
                        'email_address' => $request->email_address,
                            ), array(
                        'email_address' => 'required|email',
                            )
            );
            if ($validator->fails()) {
                $authkey = 'phone_number';
            } else {
                $authkey = 'email_address';
            }
        }
        if (Auth::attempt([$authkey => $request->email_address, 'password' => $request->password, 'is_active' => 1])) {
            $user = Auth::User();
            if ($user) {
                $sessdata = array();
                $sessdata['country_id'] = $user->country_id;
                $count = 0;
                foreach ($user->roles as $role) {
                    $sessdata['roles'][$count]['role_id'] = $role->id;
                    $sessdata['roles'][$count]['role_slug'] = $role->role_slug;
                    $count++;
                }
                $count = 0;

                foreach ($user->accounts as $accounts) {
                    $sessdata['accounts'][$count]['account_id'] = $accounts->account_id;
                    $sessdata['accounts'][$count]['account_type'] = $accounts->account_type;
                    switch ($accounts->account_type) {
                        case 'ADVERTISER':
                            $advertiser = $accounts->advertiser;
                            $advertiser = $advertiser->toArray();
                            $sessdata['accounts'][$count]['advertiser_id'] = $advertiser['advertiser_id'];
                            $sessdata['accounts'][$count]['adv_currency'] = $advertiser['currency'];
                            if (!empty($user->country_id)) {
                                $sessdata['country_id'] = $user->country_id;
                            } else {
                                $sessdata['country_id'] = $this->getCountryId();
                            }
                            if (empty($user->user_timezone)) {
                                $tz_data = \App\TimezoneData::where('iso3_country_code', $sessdata['country_id'])
                                        ->get()
                                        ->first();
                                $sessdata['user_timezone'] = $tz_data->zone_name;
                            } else {
                                $sessdata['user_timezone'] = $user->user_timezone;
                            }
                            // $tz = new \DateTimeZone($tz_data->zone_name);
                            //$datetime = new \DateTime('now', $tz);
                            //echo $datetime->format('T');
                            //echo $date->format('h:i')." ".$date->format("A").", ".$date->format('d-m-Y')." IST";
                            //echo  $datetime = new \DateTime('now', $tz);
                            break;
                        case 'PUBLISHER':
                            break;
                        case 'MANAGER':
                            break;
                        case 'ADMIN':
                            break;
                    }
                    $count++;
                }
                Session::put('UserID', $user->user_id);
                Session::put('UserEmail', $user->email_address);
                Session::put('sessiondata', $sessdata);
            }
            if (trim($request->refs) != '') {
                $refsd = trim($request->refs);
                return redirect('/' . $refsd);
            } else {
                return redirect('/myaccount');
            }
        } else {

            return redirect('/login')->with('error_login', 'Please provide valid email and password');
        }
    }

    /**
     * redirect to myaccount.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function user_accounts() {
        if (!Auth::check()) {
            return redirect('/login');
        }
        $session = Session::all();
        //$currency = $this->getCurrencyFromAccount($session['sessiondata']['accounts'][0]['account_id']);

        switch ($session['sessiondata']['roles'][0]['role_slug']) {
            case 'ADVERTISER':
                $tzObj = new \DateTimeZone($session['sessiondata']['user_timezone']);
                $dateTimeObj = new \DateTime('now', $tzObj);
              
		 $accountid = $session['sessiondata']['accounts'][0]['account_id'];
            //$accountid=21;
            $userAdv = Advertiser::where('account_id', '=', $accountid)->get()->first();
            
                if (!empty($userAdv) && isset($userAdv['account_id'])) {
                    if (trim($userAdv['currency']) == '') {
                        return redirect("/setcurrency");
                    }
                }
            
                return View("/myaccount", ['currency' => $session['sessiondata']['accounts'][0]['adv_currency'], 'dateTimeObj' => $dateTimeObj, 'user_timezone' => $session['sessiondata']['user_timezone']]); //advertiser account

                break;
            case 'MANAGER':
                return View("/advaccounts"); // list of advertiser accounts
                break;
            case 'ADMIN':
                return View("/admaccount"); // list of advertiser accounts
                break;
            case 'PUBLISHER':
                return View("/pubaccounts"); // list of advertiser accounts
                break;
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store() {
        // 
    }

    /*     * * Set user currency view
     * 

     */

    public function user_currencyview() {
        $json_url = url("json-data/get-timezone");
            $json = file_get_contents($json_url);

            $data = json_decode($json, true);
        
        return View("/setcurrency",['tzdatas'=>$data]);
    }

   public function setcurract(Request $request) {
        $curncy = trim($request->currency);
        
        $tmzone = trim($request->timezone);

        $session = Session::all();
        if($curncy!='' && $tmzone!='')
        {
            $tmArr=  explode("#", $tmzone);
            $utcoffset=$tmArr[1];
            $timezn=$tmArr[0];
            $userid=$session['UserID'];
            $advertiser_id=$session['sessiondata']['accounts'][0]['advertiser_id'];
            $account_id=$session['sessiondata']['accounts'][0]['account_id'];
            
            $user_model = \App\User::where('user_id', "=", $userid)
                ->update(['utc_offset' => $utcoffset,'user_timezone'=>$timezn]);
            
            
            $adv_model = \App\Advertiser::where('account_id', "=", $account_id)
                ->update(['currency' => $curncy,'default_currency'=>$curncy]);
            
            
             
            
            
             $sessdata = array();
                $sessdata['country_id'] = $session['sessiondata']['country_id'];
                
                    $sessdata['roles'][0]['role_id'] = $session['sessiondata']['roles'][0]['role_id'];
                    $sessdata['roles'][0]['role_slug'] = $session['sessiondata']['roles'][0]['role_slug'];
               
                    $sessdata['accounts'][0]['account_id'] = $session['sessiondata']['accounts'][0]['account_id'];
                    $sessdata['accounts'][0]['account_type'] = $session['sessiondata']['accounts'][0]['account_type'];
                    
                            $sessdata['accounts'][0]['advertiser_id'] = $session['sessiondata']['accounts'][0]['advertiser_id'];
                            $sessdata['accounts'][0]['adv_currency'] = $session['sessiondata']['accounts'][0]['adv_currency'];
                            $sessdata['user_timezone'] = $timezn;
                           
               
                Session::put('sessiondata', $sessdata);
            return redirect("/myaccount");
        }
        
    }

    /**
     * Show the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function create_user(Request $request) { // create advertiser
        
        $email = $request->email_address;
        $password = $request->password;
        $password = $request->password_confirmation;
        $phone = $request->phone_number;
        $captcha = $request->captcha;
        //$currency = $request->currency;
        $validator = Validator::make(
                        array(
                    'email_address' => $request->email_address,
                    'password' => $password = $request->password,
                    'password_confirmation' => $request->password_confirmation,
                    'phone_number' => $request->phone_number,
                    'phone_country_code' => $request->country_code,
                    'captcha' => $request->captcha,
                        //'currency'=>$request->currency,
                        ), array(
                    'email_address' => 'required|email|unique:cf_users',
                    'password' => 'required|confirmed|min:6',
                    'phone_number' => 'required|unique:cf_users',
                    'phone_country_code' => 'required',
                        //'currency'=>'required',
                        //'captcha'=>'required|captcha', 
                        )
        );

        /* $validator->after(function($validator) {

          $validator->errors()->add('captcha', 'Your input captcha is worng!');
          }); */

        if ($validator->fails()) {
            return redirect('/login')->withErrors($validator)->withInput();
        } else {
            $data = array(
                "email_address" => $email,
                "password" => Hash::make($password),
                'phone_number' => $request->phone_number,
                'phone_country_code' => $request->country_code,
            );

            $userw = User::where('email_address', '=', $email)->get()->first();
        //$user = User::whereConfirmationCode($confirmation_code)->first();

        if (!$userw) {
            /* create an account during sign up
              insert order
              1) cf_accounts
              2) cf_users -- dependency: cf_accounts->account_id
              3) user_role -- dependency: cf_users->user_id and roles->rolid=2 (for ADVERTISER)

             */
            $this->account_id = DB::table('cf_accounts')->insertGetId(array('account_type' => 'ADVERTISER'));
            if (!empty($this->account_id) && is_numeric($this->account_id)) {
                $data['default_account_id'] = $this->account_id;
                $confirmation_code = str_random(30);
                $data['activation_code'] = $confirmation_code;
                //$data['utc_offset'] = $this->getUtcOffset();
                //$data['country_code'] = $this->getCountryId();
                //$data['default_language'] = $this->getDefaultLanguage();

                $this->user_id = DB::table('cf_users')->insertGetId($data);
                if ($this->user_id && is_numeric($this->user_id)) {
                    DB::table('dl_advertisers')->insert(array('account_id' => $data['default_account_id'],
                        'contact_name' => $data['email_address'], 'contact_email' => $data['email_address'], 'contact_mobile' => $data['phone_number'], 'status' => 1));
                    DB::table('role_user')->insert(array('role_id' => 2, 'user_id' => $this->user_id));
                    DB::table('account_user')->insert(array('account_id' => $this->account_id, 'user_id' => $this->user_id));

                    Mail::send('email_verify', ['confirmation_code' => $confirmation_code], function($message) use ($email) {
                        //$message->to($email)
                        $message->from('no-reply@audiencenest.com', 'AudienceNest.com')
                                ->to($email, 'Advertiser')
                                ->subject('Complete your Sign Up process');
                    });

                    return redirect('/login')->with("success_singup", "Thanks for signing up. An account activation email has been sent to your email Id.");
                }
            }
            return redirect('/login')->with("error_after_loging", "Not Insert");
            }else
            {
               return redirect('/login')->with("error_after_loging", "The email address/phone number you have entered is already registered"); 
            }
        }
    }

    public function create_pub(Request $request) { // create advertiser

        /* uncomment the code to make it live
         * 
         *
          $email = $request->email_address;
          $password = $request->password;
          $password = $request->password_confirmation;
          $phone = $request->phone_number;
          $captcha = $request->captcha;
          $validator = Validator::make(
          array(
          'email_address' => $request->email_address,
          'password' => $password = $request->password,
          'password_confirmation' => $request->password_confirmation,
          'phone_number' => $request->phone_number,
          'captcha' => $request->captcha,
          'country_code' => $request->country_code,
          ), array(
          'email_address' => 'required|email|unique:cf_users',
          'password' => 'required|confirmed|min:6',
          'phone_number' => 'required|unique:cf_users',
          'country_code' => 'required',
          //'captcha'=>'required|captcha',
          )
          );


          if ($validator->fails()) {
          return redirect('/regpub')->withErrors($validator)->withInput();
          } else {
          $data = array(
          "email_address" => $email,
          "password" => Hash::make($password),
          'phone_number' => $request->phone_number,
          'phone_country_code' => $request->country_code,
          );


          /* create an account during sign up
          insert order
          1) cf_accounts
          2) cf_users -- dependency: cf_accounts->account_id
          3) user_role -- dependency: cf_users->user_id and roles->rolid=2 (for ADVERTISER)

         */
        /* end comment */

        $this->account_id = DB::table('cf_accounts')->insertGetId(array('account_type' => 'TRAFFICKER'));
        $data['email_address'] = 'newpub@gmail.com';

        if (!empty($this->account_id) && is_numeric($this->account_id)) {
            $data['default_account_id'] = $this->account_id;
            $confirmation_code = str_random(30);
            $data['activation_code'] = $confirmation_code;

            $this->user_id = DB::table('cf_users')->insertGetId($data);
            if ($this->user_id && is_numeric($this->user_id)) {
                DB::table('role_user')->insert(array('role_id' => 3, 'user_id' => $this->user_id));
                DB::table('account_user')->insert(array('account_id' => $this->account_id, 'user_id' => $this->user_id));
                /*
                  Mail::send('email_verify', ['confirmation_code'=>$confirmation_code], function($message) use ($email) {
                  //$message->to(Input::get('email_address'), Input::get('username'))
                  $message->from('admin@audience.nest','hello');
                  $message->to($email, 'Advertiser')
                  ->subject('Verify your Email address');
                  }); */

                //Flash::message('Thanks for signing up! Please check your email.');
                DB::table('publishers')->insertGetId(array('publisher_key' => 'keypub34567', 'company' => 'pubcompany',
                    'contact_email' => $data['email_address'], 'account_id' => $this->account_id));
                exit;
                //return redirect('/login')->with("success_singup", "Sing Up Successfull. Please check your mail to verify Email.");
            }
        }
        return redirect('/login')->with("error_after_loging", "Not Insert");
    }

    public function confirm(Request $request) {

        //$advertisers = DB::table('dl_advertisers')->get();
        $confirmation_code = $request->secretcd;


        if (!$confirmation_code) {
            throw new InvalidConfirmationCodeException;
        }
        $user = User::where('activation_code', '=', $confirmation_code)->get()->first();
        //$user = User::whereConfirmationCode($confirmation_code)->first();

        if (!$user) {
            //throw new InvalidConfirmationCodeException;
            return redirect('/login')->with("error_after_loging", "Sorry, this link may be expired or aleady used.");
        }

        $user->is_active = 1;
        $user->activation_code = null;
        $user->save();
        //return redirect('/login')->with("success_singup", "Your account has been verified successfully.");
        return redirect('/selcurrency')->with("success_singup", "Your account has been verified successfully.");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        //
    }

    /**
     * Logout the specified resource user.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function doLogout() {
        Auth::logout();
        Session::flush();
        return redirect('/login');
    }

    public function webpagecreation() {
        return View('/webpagecreation');
    }

    function getCountryId($ipAddress = "") {
        if ($ipAddress == "") {
            $ipAddress = $this->getIpAddress();
        }
        $countryId = "IND"; //TBD
       // $ipAddress = ip2long("204.147.128.0"); //TBD

        $ispModel = new \App\MaxmindData();
        $ispData = $ispModel::join('country', function( $join ) {
                    $join->on('maxmind_ip_pool.iso_country_code', '=', 'country.iso');
                })
                ->selectRaw("country.iso3")
                ->where("maxmind_ip_pool.long_higher_ip", ">=", $ipAddress)
                ->where("maxmind_ip_pool.long_lower_ip", "<=", $ipAddress)
                ->get();

        
        
     $ispData  =$ispData->toArray();
        if (isset($ispData[0]['iso3'])) {
            $countryId = $ispData[0]['iso3'];
        }
        return $countryId;
        
        
    }

    public function getDefaultLanguage() {

        return (Session::has("default_language")) ? Session::has("default_language") : 'en';
    }

    function getUtcOffset() {

        $ipAddress = $this->getIpAddress();

        $utcOffset = "+05:30:00"; //TBD
        $ipAddress = ip2long("204.147.128.0"); //TBD
        $ispModel = new \App\MaxmindData();
        $ispData = $ispModel::selectRaw("maxmind_ip_pool.utc_offset")
                ->where("maxmind_ip_pool.long_higher_ip", ">=", $ipAddress)
                ->where("maxmind_ip_pool.long_lower_ip", "<=", $ipAddress)
                ->get();

        if (isset($ispData[0]->utc_offset)) {
            $utcOffset = $ispData[0]->utc_offset;
        }
        return $utcOffset;
    }

    function getIpAddress() {
        // check for shared internet/ISP IP
        if (!empty($_SERVER['HTTP_CLIENT_IP']) && validate_ip($_SERVER['HTTP_CLIENT_IP'])) {
            return $_SERVER['HTTP_CLIENT_IP'];
        }

        // check for IPs passing through proxies
        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            // check if multiple ips exist in var
            if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'], ',') !== false) {
                $iplist = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
                foreach ($iplist as $ip) {
                    if (validate_ip($ip))
                        return $ip;
                }
            } else {
                if (validate_ip($_SERVER['HTTP_X_FORWARDED_FOR']))
                    return $_SERVER['HTTP_X_FORWARDED_FOR'];
            }
        }
        if (!empty($_SERVER['HTTP_X_FORWARDED']) && validate_ip($_SERVER['HTTP_X_FORWARDED']))
            return $_SERVER['HTTP_X_FORWARDED'];
        if (!empty($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']) && validate_ip($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']))
            return $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
        if (!empty($_SERVER['HTTP_FORWARDED_FOR']) && validate_ip($_SERVER['HTTP_FORWARDED_FOR']))
            return $_SERVER['HTTP_FORWARDED_FOR'];
        if (!empty($_SERVER['HTTP_FORWARDED']) && validate_ip($_SERVER['HTTP_FORWARDED']))
            return $_SERVER['HTTP_FORWARDED'];

        // return unreliable ip since all else failed
        return $_SERVER['REMOTE_ADDR'];
    }

    public function user_profile() {

        $uid = Session::get('UserEmail');
        $userModel = new \App\User();
        $userData = $userModel::where('email_address', '=', $uid)->first();

        if ($userData->user_id != '') {
            $json_url = url("json-data/get-profile?user_id=" . $userData->user_id);

            $json = file_get_contents($json_url);

            $datav = json_decode($json, true);
            $countryId = $this->getCountryId();


            return View("/myprofile", ['profiledata' => $datav, 'countryId' => $countryId]);
        } else {
            return redirect('/login');
        }
    }

    public function t_mailst() {

        $conversionModel = new \App\Conversionsmdb;


        $something = $conversionModel::where('id_conversion', '=', 1)->first();

        echo json_encode($something);
        //$something = DB::connection('mdb1')->select('select * from conversions limit 1');
        // echo json_encode($something);
        die();
        /* $confirmation_code='123456';
          $email='yogendra.d@collectcent.com';
          Mail::send('email_verify', ['confirmation_code'=>$confirmation_code], function($message) use ($email) {
          //$message->to($email)
          $message->from('admin@audiencenest.com','hello')
          ->to($email, 'Advertiser')
          ->subject('Verify your Email address');
          }); */
    }

    public function forgotPassSubmit(Request $request) {
        $email = $request->remail_address;

        $validator = Validator::make(
                        array(
                    'remail_address' => $request->remail_address,
                        ), array(
                    'remail_address' => 'required',
                        //'captcha'=>'required|captcha', 
                        )
        );

        if ($validator->fails()) {
            return redirect('/login')->withErrors($validator)->withInput();
        } else {
            $userModel = new \App\User();
            $userData = $userModel::where('email_address', '=', $email)->first();

            if ($userData->user_id != '') {
                $confirmation_code = str_random(30);
                $userRecoverModel = new \App\Recovers();

                $userRecoverModel->uid = $userData->user_id;
                $userRecoverModel->code = $confirmation_code;
                $userRecoverModel->save();
                Mail::send('email_forgot', ['confirmation_code' => $confirmation_code], function($message) use ($email) {
                    //$message->to($email)
                    $message->from('no-reply@audiencenest.com', 'Reset Account')
                            ->to($email, 'Advertiser')
                            ->subject('Reset Audiencenest Account ');
                });
                return redirect('/login')->with("success_singin", "Please cheeck your mailbox, we have sent reset account email.");
            } else {
                return redirect('/login')->with("error_singin", "Sorry, email address not exist.");
            }
        }
    }

    public function resetAcc(Request $request) {

        //$advertisers = DB::table('dl_advertisers')->get();
        $confirmation_code = $request->secretcd;


        if (!$confirmation_code) {
            return redirect('/login')->with("error_signin", "Sorry, please reset password.");
        }
        $recoverModel = new \App\Recovers;
        $user = $recoverModel::where('code', '=', $confirmation_code)->get()->first();
        //$user = User::whereConfirmationCode($confirmation_code)->first();

        if (!$user) {
            return redirect('/login')->with("error_signin", "Sorry, please reset password.");
        }
        $uid = $user->uid;

        return View("/reset-account", ['userid' => $uid, 'secretcd' => $confirmation_code]);
    }

    public function resetAccSubmit(Request $request) {

        //$advertisers = DB::table('dl_advertisers')->get();
        $confirmation_code = $request->secretcd;


        if (!$confirmation_code) {
            throw new InvalidConfirmationCodeException;
        }

        $recoverModel = new \App\Recovers;
        $user = $recoverModel::where('code', '=', $confirmation_code)->get()->first();
        $recoverid = $user->id;

        //$user = User::whereConfirmationCode($confirmation_code)->first();
        if (isset($user->uid)) {
            
        } else {

            return View("/reset-account", ['userid' => $uid, 'secretcd' => $confirmation_code]);
        }

        $uid = $user->uid;
        $password = $request->rpassword;
        $validator = Validator::make(
                        array(
                    'rpassword' => $request->rpassword,
                    'rpassword_confirmation' => $request->rpassword_confirmation,
                    'secretcd' => $request->secretcd,
                        ), array(
                    'rpassword' => 'required|confirmed|min:6',
                    'secretcd' => 'required',
                        //'captcha'=>'required|captcha', 
                        )
        );
        if ($validator->fails()) {
            return View("/reset-account", ['userid' => $uid, 'secretcd' => $confirmation_code])->withErrors($validator)->withInput();
        } else {
            $uModel = \App\User::find($uid);

            $uModel->password = Hash::make($password);
            $uModel->save();


            $urModel = \App\Recovers::find($recoverid);
            $urModel->delete();

            return redirect('/login')->with("success_singin", "Your account has been reset successfully.");
        }
    }

    public function getCurrencyFromAccount($account_id) {

        $data = Advertiser::where('dl_advertisers.account_id', $account_id)
                        ->leftJoin('currency_database', 'currency_database.symbol', '=', 'dl_advertisers.currency')
                        ->selectRaw('currency_database.symbol')
                        ->take(1)->get();
        return ($data[0]->symbol) ? $data[0]->symbol : 'INR';
    }

    /**
     * Obtain the user information from Facebook.
     *
     * @return Response
     */
    public function handleProviderFbCallback() {
        try {
            $user = Socialite::driver('facebook')->user();
        } catch (\Exception  $e) {
            return redirect('/login')->with("error_login", "Invalid request.");
        }

        $authUser = $this->findOrCreateUser($user);

        //$this->login($authUser, true);
        //return redirect()->route('home');
        return redirect('/myaccount');
    }

    /**
     * Return user if exists; create and return if doesn't
     *
     * @param $facebookUser
     * @return User
     */
    private function findOrCreateUser($facebookUser) {


        $authUser = User::where('email_address', $facebookUser->email)->first();

        if ($authUser) {
            $this->loginFbUser($facebookUser->id, $facebookUser->email);
        } else {
            $requestDtArr = array('email_address' => $facebookUser->email, 'facebook_id' => $facebookUser->id);
            $this->create_fbuser($requestDtArr);
        }




        /* return User::create([
          'name' => $facebookUser->name,
          'email' => $facebookUser->email,
          'facebook_id' => $facebookUser->id,
          'avatar' => $facebookUser->avatar
          ]); */
    }

    /**
     * Show the form for login fb users.
     * This function is use for the a fb user in login process
     * @return \Illuminate\Http\Response
     */
    public function loginFbUser($fbid, $fbemail) {

        if (Auth::attempt(['email_address' => $fbemail])) {
            $user = Auth::User();
            if ($user) {
                $sessdata = array();
                $sessdata['country_id'] = $user->country_id;
                $count = 0;
                foreach ($user->roles as $role) {
                    $sessdata['roles'][$count]['role_id'] = $role->id;
                    $sessdata['roles'][$count]['role_slug'] = $role->role_slug;
                    $count++;
                }
                $count = 0;

                foreach ($user->accounts as $accounts) {
                    $sessdata['accounts'][$count]['account_id'] = $accounts->account_id;
                    $sessdata['accounts'][$count]['account_type'] = $accounts->account_type;
                    
                     if (!empty($user->country_id)) {
                                $sessdata['country_id'] = $user->country_id;
                            } else {
                                $sessdata['country_id'] = $this->getCountryId();
                            }
                            if (empty($user->user_timezone)) {
                                $tz_data = \App\TimezoneData::where('iso3_country_code', $sessdata['country_id'])
                                        ->get()
                                        ->first();
                                $sessdata['user_timezone'] = $tz_data->zone_name;
                            } else {
                                $sessdata['user_timezone'] = $user->user_timezone;
                            }
                    
                    switch ($accounts->account_type) {
                        case 'ADVERTISER':
                            $advertiser = $accounts->advertiser;
                            $advertiser = $advertiser->toArray();
                            $sessdata['accounts'][$count]['advertiser_id'] = $advertiser['advertiser_id'];
                            $sessdata['accounts'][$count]['adv_currency'] = $advertiser['currency'];
                            break;
                        case 'PUBLISHER':
                            break;
                        case 'MANAGER':
                            break;
                        case 'ADMIN':
                            break;
                    }
                    $count++;
                }
                Session::put('UserID', $user->user_id);
                Session::put('UserEmail', $user->email_address);
                Session::put('sessiondata', $sessdata);
                if(trim($user->facebook_id)==''){
                    
                            User::where('user_id', $user->user_id)->update(['facebook_id'=>$fbid]);
                }
                
            }

            return redirect('/myaccount');
        } else {

            return redirect('/login')->with('error_login', 'Sorry, your account is not exist.');
        }
    }

    /**
     * Show the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     */
    public function create_fbuser($requestDt) { // create advertiser
        //print_r($request->all());
        //die();
        $email = $requestDt['email_address'];
        $characters = 'abcdefghjkmnpqrstuvwxyz23456789';
        $stringpwd = '';
        for ($i = 0; $i < 8; $i++) {
            $stringpwd .= $characters[rand(0, strlen($characters) - 1)];
        }

        $password = $stringpwd;
        // $password = $request->password_confirmation;
        //$phone = $request->phone_number;
        $fbid = $requestDt['facebook_id'];

        $data = array(
            "email_address" => $email,
            "password" => Hash::make($password),
            "is_active" => 1,
            "facebook_id" => $fbid
        );


        /* create an account during sign up
          insert order
          1) cf_accounts
          2) cf_users -- dependency: cf_accounts->account_id
          3) user_role -- dependency: cf_users->user_id and roles->rolid=2 (for ADVERTISER)

         */
        $this->account_id = DB::table('cf_accounts')->insertGetId(array('account_type' => 'ADVERTISER'));
        if (!empty($this->account_id) && is_numeric($this->account_id)) {
            $data['default_account_id'] = $this->account_id;

            //$data['utc_offset'] = $this->getUtcOffset();
            //$data['country_code'] = $this->getCountryId();
            //$data['default_language'] = $this->getDefaultLanguage();

            $this->user_id = DB::table('cf_users')->insertGetId($data);
            if ($this->user_id && is_numeric($this->user_id)) {
                DB::table('dl_advertisers')->insert(array('account_id' => $data['default_account_id'],
                    'contact_name' => $data['email_address'], 'contact_email' => $data['email_address'], 'status' => 1));
                DB::table('role_user')->insert(array('role_id' => 2, 'user_id' => $this->user_id));
                DB::table('account_user')->insert(array('account_id' => $this->account_id, 'user_id' => $this->user_id));

                Mail::send('email_welcome', ['pwds' => $stringpwd, 'email' => $email], function($message) use ($email) {
                    //$message->to($email)
                    $message->from('no-reply@audiencenest.com', 'Verify')
                            ->to($email, 'Advertiser')
                            ->subject('Welcome to Audiencenest - Your Account has been created successfully.');
                });

                $this->loginFbUser($fbid, $email);
            }
        }
        //return redirect('/login')->with("error_after_loging", "Not Insert");
    }

    /**
     * Obtain the user information from Google.
     *
     * @return Response
     */
    public function handleProviderGoogleCallback(Request $request) {
        
        
        
        try {
            $user = Socialite::driver('google')->user();
        } catch (\Exception  $e) {
            return redirect('/login')->with("error_login", "Invalid request.");
        }
        if(isset($request->error) && trim($request->error)!=''){
          return redirect('/login')->with("error_login", "Invalid request.");  
        }
        
       
       
        
        $authUser = $this->findOrCreateUserGoogle($user);

        //$this->login($authUser, true);
        //return redirect()->route('home');
        return redirect('/myaccount');
    }

    private function findOrCreateUserGoogle($googleUser) {
         $authUser = User::where('email_address', $googleUser->email)->first();
 
        if ($authUser){
            $this->loginGpUser($googleUser->id,$googleUser->email);
        }else{
            $requestDtArr=array('email_address'=>$googleUser->email,'google_id'=>$googleUser->id);
            $this->create_gpuser($requestDtArr);
        }

      
    }
    
    /**
     * Show the form for login Google Plus users.
     * This function is use for the a Google Plus user in login process
     * @return \Illuminate\Http\Response
     */
    public function loginGpUser($gpid,$gpemail) {
      
        if (Auth::attempt(['email_address' => $gpemail])) {
            $user = Auth::User();
            if ($user) {
                $sessdata = array();
                $sessdata['country_id'] = $user->country_id;
                $count = 0;
                foreach ($user->roles as $role) {
                    $sessdata['roles'][$count]['role_id'] = $role->id;
                    $sessdata['roles'][$count]['role_slug'] = $role->role_slug;
                    $count++;
                }
                $count = 0;

                foreach ($user->accounts as $accounts) {
                    $sessdata['accounts'][$count]['account_id'] = $accounts->account_id;
                    $sessdata['accounts'][$count]['account_type'] = $accounts->account_type;
                    
                     if (!empty($user->country_id)) {
                                $sessdata['country_id'] = $user->country_id;
                            } else {
                                $sessdata['country_id'] = $this->getCountryId();
                            }
                            if (empty($user->user_timezone)) {
                                $tz_data = \App\TimezoneData::where('iso3_country_code', $sessdata['country_id'])
                                        ->get()
                                        ->first();
                                $sessdata['user_timezone'] = $tz_data->zone_name;
                            } else {
                                $sessdata['user_timezone'] = $user->user_timezone;
                            }
                    
                    switch ($accounts->account_type) {
                        case 'ADVERTISER':
                            $advertiser = $accounts->advertiser;
                            $advertiser = $advertiser->toArray();
                            $sessdata['accounts'][$count]['advertiser_id'] = $advertiser['advertiser_id'];
                            $sessdata['accounts'][$count]['adv_currency'] = $advertiser['currency'];
                            break;
                        case 'PUBLISHER':
                            break;
                        case 'MANAGER':
                            break;
                        case 'ADMIN':
                            break;
                    }
                    $count++;
                }
                Session::put('UserID', $user->user_id);
                Session::put('UserEmail', $user->email_address);
                Session::put('sessiondata', $sessdata);
                if(trim($user->google_id)=='')
                {
                     User::where('user_id', $user->user_id)->update(['google_id'=>$gpid]);
                }
                
            }

            
                return redirect('/myaccount');
            
        } else {

            return redirect('/login')->with('error_login', 'Sorry, your account is not exist.');
        }
    }
    
    /**
     * Show the form for creating a new resource.
     * This function is use for create a user from google in singup
     * @return \Illuminate\Http\Response
     */
    public function create_gpuser($requestDt) { // create advertiser
        //print_r($request->all());
        //die();
        $email = $requestDt['email_address'];
        $characters = 'abcdefghjkmnpqrstuvwxyz23456789';
         $stringpwd = '';
        for ($i = 0; $i < 8; $i++) {
             $stringpwd .= $characters[rand(0, strlen($characters) - 1)];
        }
        
        $password = $stringpwd;
       // $password = $request->password_confirmation;
        //$phone = $request->phone_number;
        $fbid = $requestDt['google_id'];
      
            $data = array(
                "email_address" => $email,
                "password" => Hash::make($password),
                "is_active"=>1,
                "google_id" => $fbid
            );


            /* create an account during sign up
              insert order
              1) cf_accounts
              2) cf_users -- dependency: cf_accounts->account_id
              3) user_role -- dependency: cf_users->user_id and roles->rolid=2 (for ADVERTISER)
 
             */
            $this->account_id = DB::table('cf_accounts')->insertGetId(array('account_type' => 'ADVERTISER'));
            if (!empty($this->account_id) && is_numeric($this->account_id)) {
                $data['default_account_id'] = $this->account_id;
               
                //$data['utc_offset'] = $this->getUtcOffset();

                //$data['country_code'] = $this->getCountryId();
                //$data['default_language'] = $this->getDefaultLanguage();

                $this->user_id = DB::table('cf_users')->insertGetId($data);
                if ($this->user_id && is_numeric($this->user_id)) {
                    DB::table('dl_advertisers')->insert(array('account_id' => $data['default_account_id'],
                        'contact_name' => $data['email_address'], 'contact_email' => $data['email_address'],  'status' => 1));
                    DB::table('role_user')->insert(array('role_id' => 2, 'user_id' => $this->user_id));
                    DB::table('account_user')->insert(array('account_id' => $this->account_id, 'user_id' => $this->user_id));

                    Mail::send('email_welcome', ['pwds' => $stringpwd,'email'=>$email], function($message) use ($email) {
                        //$message->to($email)
                        $message->from('no-reply@audiencenest.com', 'Verify')
                                ->to($email, 'Advertiser')
                                ->subject('Welcome to Audiencenest - Your Account has been created successfully.');
                    });

                    $this->loginGpUser($fbid,$email);
                }
            }
            //return redirect('/login')->with("error_after_loging", "Not Insert");
        
    }

}
