<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Http\Requests;
use DB;
use App\Webpage;
use App\User;
use App\Account;
use Validator;
use Auth;
use Hash;

class CreatadThemesController extends Controller {

    public function __construct() {
        $this->middleware('auth');

        $this->session = SESSION::All();
        $this->advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
        $this->advertiserdata = $this->advertiserdata->toArray();
        $this->currency = !empty($this->advertiserdata['currency']) ? $this->advertiserdata['currency'] : 'INR';
        $this->mincampaignbudget = config('campaign.mincampaignbudget');
        $this->mindailycap = config('campaign.mindailycap');
    }

    public function index() {
        //  return View('/theme-creation');
    }

    public function themeCreation() {

        return View('/theme_creation');
    }

    public function CreateWebpage(Request $request) {
        if (!Auth::check() || $this->session['sessiondata']['accounts'][0]['account_type'] != 'ADVERTISER') {
            return redirect('/login');
        }
        $pagedata = false;
        if (!empty($request->pagedata)) {
            $pagedata = \App\AdvertiserWebpage::find($request->pagedata);
        }
        return View('/web-page-creation', ['session' => $this->session, 'request' => $request->toArray(), 'gdata' => $pagedata]);
    }

    public function CreateWebpageEdit(Request $request) {
        $pageid_encode = $request->pagedata;
        $pageid = base64_decode($pageid_encode);


        $getAll = \App\Webpage::where('url', $pageid_encode)->first();


        return View('/web-page-creation-edit', ["gdata" => $getAll]);
    }

    /**
     * Show the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     * Add form data in DB avd_wabpage
     * */
    public function addWebData(Request $request) {
        if (!Auth::check() || $this->session['sessiondata']['accounts'][0]['account_type'] != 'ADVERTISER') {
            return redirect('/login');
        }

        $appurl = config('app.webpage_base_url');
        $v_url = config('app.webpage_base_path');

        $backgound_courl = $request->bodybg;
        // $headerbg='background-color:'.$request->hbg.';';
        $headerbg1 = $request->hbg;
        $headertxt1 = $request->htxtc;

        $mcbg_courl1 = $request->mdbg;
        $mctxt_courl1 = $request->mdtxtc;

        $footerbg_courl1 = $request->ftbg;
        $footertxt_courl1 = $request->fttxtc;

        $webpage_name = $request->webpage_name;
        $headingtext = $request->our_service_main;
        $aboutus_content = $request->aboutus_content;
        $adv_phone = $request->adv_phone;
        $adv_email = $request->adv_email;
        $adv_address = $request->adv_address;
        $advertiser_id = $request->advertiser_id;

        $image_isflg = $request->uptype;
        $image_name = $request->mid_imagename_hidden;
        $youtube_url = $request->youtube_url;
        $catbind = $request->catbind;
        $campaign_id = $request->campaign_id;
        $grpid = $request->grpid;

        if (empty($request->page_id)) {
            $page_id = DB::table('advertiser_webpage')->insertGetId(array());
            $edit_page = false;
        } else {
            $webpageObj = \App\AdvertiserWebpage::find($request->page_id);
            if ($webpageObj == NULL)
                exit;
            $logoimageName = $webpageObj->mid_imagename;
            $edit_page = true;
            $page_id = $request->page_id . "_1"; //creating new folder which will be deleted once copied to old folder
        }

        $headerbg = 'background-color:' . $request->hbg . ';';
        $headertxt = 'color:' . $request->htxtc . ';';

        $mcbg_courl = 'background-color:' . $request->mdbg . ';';
        $mctxt_courl = 'color:' . $request->mdtxtc . ';';

        $footerbg_courl = 'background-color:' . $request->ftbg . ';';
        $footertxt_courl = 'color:' . $request->fttxtc . ';';

        $source_directory = $v_url . "advt_template/dynamicdata";
        $destination_directory = $v_url;
        $css_value = '';

        //$fldnm = "collectcent-wp_" . $advertiser_id;
        //$dsname = sha1($fldnm);

        $weburls = $appurl . $advertiser_id . "/" . $page_id;
        $destinationv = $destination_directory . $advertiser_id . "/" . $page_id;
        $destination = $destination_directory . $advertiser_id . '/' . $page_id . "/";
        $success = exec("cp -avr $source_directory  $destinationv");
        $success = exec("chmod -R 0777  $destinationv");
        if ($image_isflg == '1') {
            if (isset($request->logoimage)) {
                $image = $request->file('logoimage');
                $logoimageName = $image->getClientOriginalName();
                $logoimageExtension = $image->getClientOriginalExtension();

                $destinationPath = $destination . 'images/'; //upload path
                $destinationPath_logo = $destinationPath . '/logo/';
                $image_name = $logoimageName;
                $image->move($destinationPath_logo, $logoimageName);
            } else if ($edit_page == true) {
                $image_name = $logoimageName;
                //echo " one1 ".$page_id;exit;
                list($l, $r) = explode("_", $page_id);
                $sourceLogo = $destination_directory . $advertiser_id . '/' . $l . "/images/logo/*";
                $destinationPath_logo = $destination . 'images/logo/';
                //echo "cp -avr $sourceLogo " . $destinationPath_logo;

                if(!file_exists($destinationPath_logo)){
                    exec("mkdir -p ".$destinationPath_logo);
                }

                exec("cp -avr $sourceLogo " . $destinationPath_logo);

            }
        }

        $style = '';

        $indexfile = fopen($destination . "index.php", "w") or die("Unable to open file!");
        $txt = '<html><head><title>' . $webpage_name . '</title>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <script type="text/javascript" src="http://cdnjs.cloudflare.com/ajax/libs/jquery/2.0.3/jquery.min.js"></script>
        <script type="text/javascript" src="http://netdna.bootstrapcdn.com/bootstrap/3.3.4/js/bootstrap.min.js"></script>
        <link href="http://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css">
        <link href="http://pingendo.github.io/pingendo-bootstrap/themes/default/bootstrap.css" rel="stylesheet" type="text/css">
    </head>
 ' . $css_value . '
   <body style="background:' . $backgound_courl . ';" id="nvc4" ><div id="div_comp"><div class="navbar navbar-default navbar-static-top" style=" border-width: 0;' . $headerbg . $headertxt . '" id="nvc1" width="300px;" height="500px;" >
           <div class="container" style="width:auto;">
              <div class="navbar-header" style="width:100%;text-align:center;" >

                   <p style=" font-size: 18px;">
                 <span id="brand_name" ' . $style . '>' . $headingtext . '</span></p></div>
               </div></div>
         <div class="section col-md-12" id="nvc2"  style="' . $mcbg_courl . $mctxt_courl . ';">
           <div class="container">
                <div class="col-md-6 col-sm-6 col-lg-6 pull-left" style="width:48%;">
               <p id="aboutus_content_display">' . $aboutus_content . '</p></div>

                <div class="col-md-6 col-sm-6 col-lg-6 pull-left" style="width:48%;"><p id="logodisplay"> ';
        if ($image_isflg == '1') {
            $txt .= ' <img class="img-responsive" src="images/logo/' . $logoimageName . '"  style="display: block;height: auto;max-width: 50%;" alt="logo">';
        }
        if ($image_isflg == '0') {
            $txt .= ' <iframe width="122" height="118" src=' . $youtube_url . '  frameborder="0" allowfullscreen></iframe>';
        }

        $txt .= '</p></div>

       </div>
       </div>
       <footer class="section " id="nvc3" style="' . $footerbg_courl . $footertxt_courl . ';" >
         <div class="container" >
               <div class="row">
                   <div class="col-sm-3">
                       <h5><center>Contact Us</center></h5>
                        <p><center>Address: <span id="adv_address_details">' . $adv_address . '</span></center></p>
                        <p><center>Phone : <span id="adv_phone_number">' . $adv_phone . '</span></center></p>
                        <p><center>Email: <span id="adv_email_id">' . $adv_email . '</span></center></p>
      </div>
   </div>
          </div>
       </footer>
</div>
   </body>
   </html>';
        fwrite($indexfile, $txt);
        fclose($indexfile);
        $data = array(
            "webpage_name" => $webpage_name,
            "advertiser_id" => $advertiser_id,
            "body_bg_color" => $backgound_courl,
            "heading_bg_color" => $headerbg1,
            "heading_txt_color" => $headertxt1,
            "heading_text" => $headingtext,
            "mid_bg_color" => $mcbg_courl1,
            "mid_txt_color" => $mctxt_courl1,
            "mid_text" => $aboutus_content,
            "mid_image_isflg" => $image_isflg,
            "mid_imagename" => "$image_name",
            "mid_youtube_url" => "$youtube_url",
            "footer_bg_color" => $footerbg_courl1,
            "footer_txt_color" => $footertxt_courl1,
            "footer_phone" => $adv_phone,
            "footer_email" => $adv_email,
            "footer_address" => $adv_address,
            "added_date" => date('Y-m-d H:i:s'),
            "modified_date" => date('Y-m-d H:i:s'),
            'url' => $weburls
        );
        //$page_id = DB::table('advertiser_webpage')->insertGetId($data);

        $weburl = $appurl . $advertiser_id . "/" . $page_id;
        $destinationp = $destination_directory . $advertiser_id . "/" . $page_id;

        $success = exec("mv $destinationv  $destinationp");
        //$data = array('url' => $weburl);
        if ($edit_page === false) {
            DB::table('advertiser_webpage')->where('page_id', $page_id)->update($data);
        }

        if ($page_id != '') {
            //return view('/web-page-submit',['catbind'=>$catbind,'campaign_id'=>$campaign_id,'urlfld'=>$dsname]);
            return view('/web-page-preview', ['catbind' => $catbind, 'campaign_id' => $campaign_id, 'urlfld' => $page_id,
                'page_id' => $page_id, 'advertiser_id' => $advertiser_id, 'webpage_url' => $weburls, 'postdata' => $data]);
        } else {
            return redirect('/web-page-creation')->with("error", "Not Insert");
        }
    }

    function saveWebPage(Request $request) {

        if (!Auth::check() || $this->session['sessiondata']['accounts'][0]['account_type'] != 'ADVERTISER') {
            return redirect('/login');
        }
        print_r($request->page_id);
        list($l,)=explode("_",$request->page_id);
        $request->page_id = $l;

        $webpageObj = \App\AdvertiserWebpage::find($request->page_id);
        if ($webpageObj != NULL && $this->session['sessiondata']['accounts'][0]['advertiser_id'] == $webpageObj->advertiser_id) {
            if ($webpageObj->status == 'pending') {
                $webpageObj->status = 'live';
                $webpageObj->save();
            } else {

                $webpageObj->webpage_name = $request->webpage_name;
                $webpageObj->advertiser_id = $request->advertiser_id;
                $webpageObj->body_bg_color = $request->body_bg_color;
                $webpageObj->heading_bg_color = $request->heading_bg_color;
                $webpageObj->heading_txt_color = $request->heading_txt_color;
                $webpageObj->heading_text = $request->heading_text;
                $webpageObj->mid_bg_color = $request->mid_bg_color;
                $webpageObj->mid_txt_color = $request->mid_txt_color;
                $webpageObj->mid_text = $request->mid_text;
                $webpageObj->mid_image_isflg = $request->mid_image_isflg;
                $webpageObj->mid_imagename = $request->mid_imagename;
                $webpageObj->mid_youtube_url = $request->mid_youtube_url;
                $webpageObj->footer_bg_color = $request->footer_bg_color;
                $webpageObj->footer_txt_color = $request->footer_txt_color;
                $webpageObj->footer_phone = $request->footer_phone;
                $webpageObj->footer_email = $request->footer_email;
                $webpageObj->footer_address = $request->footer_address;
                //"added_date" => date('Y-m-d H:i:s'),
                $webpageObj->modified_date = date('Y-m-d H:i:s');

                //'url' => $weburls
                $webpageObj->save();
                exec("cp -arv " . config('app.webpage_base_path') . $webpageObj->advertiser_id . "/" . $webpageObj->page_id . "_1/* " . config('app.webpage_base_path') . $webpageObj->advertiser_id . "/" . $webpageObj->page_id);
            }
            if (isset($request->invisible) && !empty($request->invisible)) {
                return redirect("/create-ad1?invisible=" . $request->invisible . "&urlfld=" . urlencode($webpageObj->url));
            } else {
                return redirect('/manage-webpages');
            }
        }
    }

    function deleteWebPagePending(Request $request) {
        if (!Auth::check() || $this->session['sessiondata']['accounts'][0]['account_type'] != 'ADVERTISER') {
            return redirect('/login');
        }
        $webpageObj = \App\AdvertiserWebpage::find($request->page_id);
        //var_dump($webpageObj);exit;
        if ($webpageObj !== NULL && $this->session['sessiondata']['accounts'][0]['advertiser_id'] == $webpageObj->advertiser_id) {
            if ($webpageObj->status == 'pending') {
                $webpageObj->delete();
                exec("rm -rf " . config('app.webpage_base_path') . $webpageObj->advertiser_id . "/" . $webpageObj->page_id);
            } else {
                exec("rm -rf " . config('app.webpage_base_path') . $webpageObj->advertiser_id . "/" . $webpageObj->page_id . "_1");
            }
        }
        if (!empty($request->invisible)) {
            return redirect("/create-ad1?invisible=" . $request->invisible);
        } else {
            return redirect("/manage-webpages");
        }
    }

    /**
     * Show the form for creating a new resource.
     * This function is use for create a user in singup
     * @return \Illuminate\Http\Response
     * Add form data in DB avd_wabpage
     * */
    public function addWebDataEdit(Request $request) {

        $appurl = config('app.local_url');
        $v_url = config('app.v_url');

        $page_id = $request->page_id;
        $backgound_courl = $request->bodybg;
        // $headerbg='background-color:'.$request->hbg.';';
        $headerbg1 = $request->hbg;
        $headertxt1 = $request->htxtc;

        $mcbg_courl1 = $request->mdbg;
        $mctxt_courl1 = $request->mdtxtc;

        $footerbg_courl1 = $request->ftbg;
        $footertxt_courl1 = $request->fttxtc;

        $webpage_name = $request->webpage_name;
        $headingtext = $request->our_service_main;
        $aboutus_content = $request->aboutus_content;
        $adv_phone = $request->adv_phone;
        $adv_email = $request->adv_email;
        $adv_address = $request->adv_address;
        $advertiser_id = $request->advertiser_id;

        $image_isflg = $request->uptype;
        $image_name = $request->oldlogoimageex;
        $youtube_url = $request->youtube_url;
        $catbind = $request->catbind;
        $campaign_id = $request->campaign_id;
        $grpid = $request->grpid;








        $headerbg = 'background-color:' . $request->hbg . ';';
        $headertxt = 'color:' . $request->htxtc . ';';

        $mcbg_courl = 'background-color:' . $request->mdbg . ';';
        $mctxt_courl = 'color:' . $request->mdtxtc . ';';

        $footerbg_courl = 'background-color:' . $request->ftbg . ';';
        $footertxt_courl = 'color:' . $request->fttxtc . ';';



        $source_directory = $v_url . "advt_template/dynamicdata";
        $destination_directory = $v_url . 'public/';




        $css_value = '';

        $fldnm = "collectcent-wp_" . $page_id;

        $dsname = base64_encode($fldnm);
        $destinationv = $destination_directory . $dsname;
        $destination = $destination_directory . $dsname . '/';
        //$success = exec("cp -avr $source_directory  $destinationv");
        //$success = exec("chmod -R 0777  $destinationv");



        if ($image_isflg == '1') {
            $image = $request->file('logoimage');
            if (!empty($image)) {
                $logoimageName = $image->getClientOriginalName();
                $logo_rename = explode(".", $logoimageName);

                $logo_rename = $logo_rename[0] . $request->advertiser_id . '_' . DATE('Y-m-d h:i:s') . $logo_rename[1];
                $logoimageExtension = $image->getClientOriginalExtension();

                $destinationPath = $destination . 'images/'; // upload path
                $destinationPath_logo = $destinationPath . '/logo/';
                $image_name = $logoimageName;
                $image->move($destinationPath_logo, $logoimageName);
            } else {
                $logoimageName = $request->oldlogoimageex;
            }
        }

        $style = '';





        $indexfile = fopen($destination . "index.php", "w") or die("Unable to open file!");
        $txt = '<html><head><title>' . $webpage_name . '</title>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <script type="text/javascript" src="http://cdnjs.cloudflare.com/ajax/libs/jquery/2.0.3/jquery.min.js"></script>
        <script type="text/javascript" src="http://netdna.bootstrapcdn.com/bootstrap/3.3.4/js/bootstrap.min.js"></script>
        <link href="http://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css">
        <link href="http://pingendo.github.io/pingendo-bootstrap/themes/default/bootstrap.css" rel="stylesheet" type="text/css">
    </head>
 ' . $css_value . '
   <body style="background:' . $backgound_courl . ';" id="nvc4" ><div id="div_comp"><div class="navbar navbar-default navbar-static-top" style=" border-width: 0;' . $headerbg . $headertxt . '" id="nvc1" width="300px;" height="500px;" >
           <div class="container" style="width:auto;">
              <div class="navbar-header" style="width:100%;text-align:center;" >

                   <p style=" font-size: 18px;">
                 <span id="brand_name" ' . $style . '>' . $headingtext . '</span></p></div>
               </div></div>
         <div class="section col-md-12" id="nvc2"  style="' . $mcbg_courl . $mctxt_courl . ';">
           <div class="container">
                <div class="col-md-6 col-sm-6 col-lg-6 pull-left" style="width:48%;">
               <p id="aboutus_content_display">' . $aboutus_content . '</p></div>

                <div class="col-md-6 col-sm-6 col-lg-6 pull-left" style="width:48%;"><p id="logodisplay"> ';
        if ($image_isflg == '1') {
            $txt .= ' <img class="img-responsive" src="images/logo/' . $logoimageName . '"  style="display: block;height: auto;max-width: 50%;" alt="logo">';
        }
        if ($image_isflg == '0') {
            $txt .= ' <iframe width="122" height="118" src=' . $youtube_url . '  frameborder="0" allowfullscreen></iframe>';
        }

        $txt .= '</p></div>

       </div>
       </div>
       <footer class="section " id="nvc3" style="' . $footerbg_courl . $footertxt_courl . ';" >
         <div class="container" >
               <div class="row">
                   <div class="col-sm-3">
                       <h5><center>Contact Us</center></h5>
                        <p><center>Address: <span id="adv_address_details">' . $adv_address . '</span></center></p>
                        <p><center>Phone : <span id="adv_phone_number">' . $adv_phone . '</span></center></p>
                        <p><center>Email: <span id="adv_email_id">' . $adv_email . '</span></center></p>
      </div>
   </div>

          </div>
       </footer>
</div>
   </body>
   </html>';





        fwrite($indexfile, $txt);
        fclose($indexfile);


        $data = array(
            "webpage_name" => $webpage_name,
            "advertiser_id" => $advertiser_id,
            "body_bg_color" => $backgound_courl,
            "heading_bg_color" => $headerbg1,
            "heading_txt_color" => $headertxt1,
            "heading_text" => $headingtext,
            "mid_bg_color" => $mcbg_courl1,
            "mid_txt_color" => $mctxt_courl1,
            "mid_text" => $aboutus_content,
            "mid_image_isflg" => $image_isflg,
            "mid_imagename" => "$image_name",
            "mid_youtube_url" => "$youtube_url",
            "footer_bg_color" => $footerbg_courl1,
            "footer_txt_color" => $footertxt_courl1,
            "footer_phone" => $adv_phone,
            "footer_email" => $adv_email,
            "footer_address" => $adv_address,
            "modified_date" => date('Y-m-d H:i:s')
        );
        $vpage_id = $page_id;
        DB::table('advertiser_webpage')->where('page_id', $page_id)->update($data);


        if ($page_id != '') {
            if (trim($catbind) != '') {
                return view('/web-page-preview', ['catbind' => $catbind, 'campaign_id' => $campaign_id, 'urlfld' => $dsname, 'page_id' => $vpage_id]);
            }
            if (trim($campaign_id) != '') {
                return view('/web-page-preview', ['catbind' => $catbind, 'campaign_id' => $campaign_id, 'urlfld' => $dsname, 'page_id' => $vpage_id]);
            }
            if (trim($catbind) == '' && trim($campaign_id) == '') {
                return redirect('/manage-webpages')->with("success_add_data", "Success Full Page updated");
            }
        } else {
            return redirect('/manage-webpages')->with("error", "Not Insert");
        }
    }

    public function previewWebData(Request $request) {

        $advertiser_id = $request->advertiser_id;

        if (Auth::check() && $this->session['sessiondata']['accounts'][0]['account_type'] == 'ADVERTISER') {
            return redirect('/login');
        }

        $getAll = \App\Webpage::where('advertiser_id', $advertiser_id)
                ->where('page_id', $page_id)
                ->get();

        return View('/web-page-preview', ["success_add_page" => "Success Full Page created", "gdata" => $getAll, 'webpage_url' => $request->webpage_url]);
    }

    //banner genarte

    public function bannerCreateData(Request $request) {


        return View('/banner-page-creation');
    }

    public function bannerCreateDataEdit(Request $request) {


        return View('/banner-page-creation-edit');
    }

    public function bannerGenrate(Request $request) {

        $appurl = config('app.local_url');
        $v_url = config('app.v_url');

        $text_size = trim(str_replace('px', '', $request->text_size));
        $x = trim(str_replace('px', '', $request->banner_x));
        $y = trim(str_replace('px', '', $request->banner_y));
        $bg = trim(str_replace('rgb(', '', $request->back_ground_color));
        $bg = trim(str_replace(')', '', $bg));

        $txtcolor = trim(str_replace('rgb(', '', $request->text_color));
        $txtcolor = trim(str_replace(')', '', $txtcolor));
        $txtcolorArr = explode(",", $txtcolor);
        $newwidth = trim(str_replace("px", '', $request->image_width));
        $newheight = trim(str_replace("px", '', $request->image_hieghts));

        $textleft = trim(str_replace("px", '', $request->text_left));
        //$textleft = trim(str_replace("-",'',$textleft));
        $texttop = trim(str_replace("px", '', $request->text_top));
        //$texttop = trim(str_replace("-",'',$texttop));
        $texttopn = trim(str_replace("px", '', $request->text_top));



        $image_Top = trim(str_replace("px", '', $request->image_Top));
        $image_left = trim(str_replace("px", '', $request->image_left));


        $textcnt = trim($request->input_text);
        $oupfile = '';
        $upload_dir = $v_url . "public/banner_images/";
        $imagefrom = $request->imagefrom;
        // Case 1: From Computer
        if ($imagefrom == 'My Computer') {

            $img = $request->selected_image;

            $imgv = explode(',', $img);
            $ini = substr($imgv[0], 11);
            $types = explode(';', $ini);
            $type = $types[0];
            if ($type == 'png') {

                $img = str_replace('data:image/png;base64,', '', $img);
                $img = str_replace(' ', '+', $img);
                $data = base64_decode($img);
                $file = $upload_dir . uniqid() . '.png';
                $success = file_put_contents($file, $data);
                chmod($file, 0777);
                //$imagval=$file;
                //$images = array($imagval);
                list($width, $height) = getimagesize($file);
                $thumb = imagecreatetruecolor($newwidth, $newheight);
                $source = imagecreatefrompng($file);
                $filename2 = $upload_dir . uniqid() . '_1.png';
                $oupfile = uniqid() . '_2.png';
                $filename3 = $upload_dir . $oupfile;
                imagecopyresized($thumb, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
                $quality = 80;
                $q = 9 / 100;
                $quality*=$q;
                imagepng($thumb, $filename2, $quality);

                $thumbv = imagecreatetruecolor($x, $y);

                $bgArr = explode(",", $bg);

                $whit = imagecolorallocate($thumbv, $bgArr[0], $bgArr[1], $bgArr[2]);


                imagefill($thumbv, 0, 0, $whit);
                list($width, $height) = getimagesize($filename2);
                $sourcev = imagecreatefrompng($filename2);


                // Resize
                imagecopyresized($thumbv, $sourcev, $image_left, $image_Top, 0, 0, $width, $height, $width, $height);


                // Replace path by your own font path
                $font = $v_url . 'Roboto-Light.ttf';

                $grey = imagecolorallocate($thumbv, $txtcolorArr[0], $txtcolorArr[1], $txtcolorArr[2]);

                $pos = strpos($textleft, "-");
                if ($pos !== false) {
                    $textleft = trim(str_replace("-", '', $textleft));
                    $textleft1 = $image_left + ($textleft);
                } else {
                    $textleft1 = ($textleft);
                }

                $pos = strpos($texttop, "-");
                if ($pos !== false) {
                    $texttop = trim(str_replace("-", '', $texttop));
                    $texttop1 = ($texttop) * 3;
                } else {

                    $texttop1 = $texttop + 20;
                }
                $textleft1 = ($textleft) - 20;
                $texttop1 = ($texttop) - 20;
                imagettftext($thumbv, $text_size, 0, $textleft1, $texttop1, $grey, $font, $textcnt);



                $rtv = imagepng($thumbv, $filename3, $quality);
            } else {
                $img = str_replace('data:image/jpeg;base64,', '', $img);
                $img = str_replace(' ', '+', $img);
                $data = base64_decode($img);
                $file = $upload_dir . uniqid() . '.jpg';
                $success = file_put_contents($file, $data);
                chmod($file, 0777);
                //$imagval=$file;
                //$images = array($imagval);
                list($width, $height) = getimagesize($file);
                $thumb = imagecreatetruecolor($newwidth, $newheight);
                $source = imagecreatefromjpeg($file);
                $filename2 = $upload_dir . uniqid() . '_1.jpg';
                $oupfile = uniqid() . '_2.jpg';
                $filename3 = $upload_dir . $oupfile;
                imagecopyresized($thumb, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
                imagejpeg($thumb, $filename2, 100);
                $thumbv = imagecreatetruecolor($x, $y);

                $bgArr = explode(",", $bg);

                $whit = imagecolorallocate($thumbv, $bgArr[0], $bgArr[1], $bgArr[2]);


                imagefill($thumbv, 0, 0, $whit);
                list($width, $height) = getimagesize($filename2);
                $sourcev = imagecreatefromjpeg($filename2);


                // Resize
                imagecopyresized($thumbv, $sourcev, $image_left, $image_Top, 0, 0, $width, $height, $width, $height);


                // Replace path by your own font path
                $font = $v_url . 'Roboto-Light.ttf';

                $grey = imagecolorallocate($thumbv, $txtcolorArr[0], $txtcolorArr[1], $txtcolorArr[2]);

                $pos = strpos($textleft, "-");
                if ($pos !== false) {
                    $textleft = trim(str_replace("-", '', $textleft));
                    $textleft1 = $image_left + ($textleft);
                } else {
                    $textleft1 = ($textleft);
                }

                $pos = strpos($texttop, "-");
                if ($pos !== false) {
                    $texttop = trim(str_replace("-", '', $texttop));
                    $texttop1 = ($texttop) * 3;
                } else {

                    $texttop1 = $texttop + 20;
                }
                $textleft1 = ($textleft) - 20;
                $texttop1 = ($texttop) - 20;
                imagettftext($thumbv, $text_size, 0, $textleft1, $texttop1, $grey, $font, $textcnt);



                $rtv = imagejpeg($thumbv, $filename3, 100);
            }
        }
        // Case 2: From Picture Gallery
        if ($imagefrom == 'Picture Gallery') {
            $file = $v_url . 'public/' . $request->selected_image;

            $type = 'jpg';
            $imageVal = getimagesize($file);
            $width = $imageVal[0];
            $height = $imageVal[1];
            if ($imageVal['mime'] == 'image/jpeg') {
                $type = $extension = 'jpg';
            }
            if ($imageVal['mime'] == 'image/png') {
                $type = $extension = 'png';
            }


            if ($type == 'png') {



                list($width, $height) = getimagesize($file);
                $thumb = imagecreatetruecolor($newwidth, $newheight);
                $source = imagecreatefrompng($file);
                $filename2 = $upload_dir . uniqid() . '_1.png';
                $oupfile = uniqid() . '_2.png';
                $filename3 = $upload_dir . $oupfile;
                imagecopyresized($thumb, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
                $quality = 80;
                $q = 9 / 100;
                $quality*=$q;
                imagepng($thumb, $filename2, $quality);
                $thumbv = imagecreatetruecolor($x, $y);

                $bgArr = explode(",", $bg);

                $whit = imagecolorallocate($thumbv, $bgArr[0], $bgArr[1], $bgArr[2]);


                imagefill($thumbv, 0, 0, $whit);
                list($width, $height) = getimagesize($filename2);
                $sourcev = imagecreatefrompng($filename2);


                // Resize
                imagecopyresized($thumbv, $sourcev, $image_left, $image_Top, 0, 0, $width, $height, $width, $height);


                // Replace path by your own font path
                $font = $v_url . 'Roboto-Light.ttf';

                $grey = imagecolorallocate($thumbv, $txtcolorArr[0], $txtcolorArr[1], $txtcolorArr[2]);

                $pos = strpos($textleft, "-");
                if ($pos !== false) {
                    $textleft = trim(str_replace("-", '', $textleft));
                    $textleft1 = $image_left + ($textleft);
                } else {
                    $textleft1 = ($textleft);
                }

                $pos = strpos($texttop, "-");
                if ($pos !== false) {
                    $texttop = trim(str_replace("-", '', $texttop));
                    $texttop1 = ($texttop) * 3;
                } else {

                    $texttop1 = $texttop + 20;
                }
                $textleft1 = ($textleft) - 20;
                $texttop1 = ($texttop) - 20;
                imagettftext($thumbv, $text_size, 0, $textleft1, $texttop1, $grey, $font, $textcnt);



                $rtv = imagepng($thumbv, $filename3, $quality);
            } else {





                $thumb = imagecreatetruecolor($newwidth, $newheight);
                $source = imagecreatefromjpeg($file);
                $filename2 = $upload_dir . uniqid() . '_1.jpg';
                $oupfile = uniqid() . '_2.jpg';
                $filename3 = $upload_dir . $oupfile;
                imagecopyresized($thumb, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
                imagejpeg($thumb, $filename2, 100);
                $thumbv = imagecreatetruecolor($x, $y);

                $bgArr = explode(",", $bg);

                $whit = imagecolorallocate($thumbv, $bgArr[0], $bgArr[1], $bgArr[2]);


                imagefill($thumbv, 0, 0, $whit);
                list($width, $height) = getimagesize($filename2);
                $sourcev = imagecreatefromjpeg($filename2);


                // Resize
                imagecopyresized($thumbv, $sourcev, $image_left, $image_Top, 0, 0, $width, $height, $width, $height);


                // Replace path by your own font path
                $font = $v_url . 'Roboto-Light.ttf';

                $grey = imagecolorallocate($thumbv, $txtcolorArr[0], $txtcolorArr[1], $txtcolorArr[2]);

                // Add the text



                $pos = strpos($textleft, "-");
                if ($pos !== false) {
                    $textleft = trim(str_replace("-", '', $textleft));
                    $textleft1 = $image_left + ($textleft);
                } else {
                    $textleft1 = ($textleft) - 20;
                }

                $pos = strpos($texttop, "-");
                if ($pos !== false) {
                    $texttop = trim(str_replace("-", '', $texttop));
                    $texttop1 = ($texttop) * 3;
                } else {

                    $texttop1 = $texttop - 20;
                    //$texttop1=$texttop;
                }




                imagettftext($thumbv, $text_size, 0, $textleft1, $texttop1, $grey, $font, $textcnt);



                $rtv = imagejpeg($thumbv, $filename3, 100);
            }
        }

        // Case 3: From No Image
        if ($imagefrom == 'No Image') {
            $filename2 = $upload_dir . uniqid() . '_1.jpg';
            $oupfile = uniqid() . '_2.jpg';
            $filename3 = $upload_dir . $oupfile;
            $thumbv = imagecreatetruecolor($x, $y);

            $bgArr = explode(",", $bg);

            $whit = imagecolorallocate($thumbv, $bgArr[0], $bgArr[1], $bgArr[2]);


            imagefill($thumbv, 0, 0, $whit);


            // Replace path by your own font path
            $font = $v_url . 'Roboto-Light.ttf';

            $grey = imagecolorallocate($thumbv, $txtcolorArr[0], $txtcolorArr[1], $txtcolorArr[2]);

            // Add the text

            $textleft1 = $textleft;
            if ($y > 90) {
                $texttop1 = $texttopn;
            } else {
                $texttop1 = ceil(($texttop + $y) / 2);
            }

            $textleft1 = ($textleft) - 20;
            $texttop1 = ($texttop) - 20;

            imagettftext($thumbv, $text_size, 0, $textleft1, $texttop1, $grey, $font, $textcnt);



            $rtv = imagejpeg($thumbv, $filename3, 100);
        }
        echo $oupfile;
        //echo $filename3;
    }

    public function uploadBannerAdd(Request $request) {
        $post = $request->all();
        $olddestinationPath = public_path('banner_images');
        $destinationPath = public_path('images');
        // $images = $post["img"];
        $images1 = $post["imgcrp1"];
        $images2 = $post["imgcrp2"];
        $images3 = $post["imgcrp3"];
        $images4 = $post["imgcrp4"];
        $images5 = $post["imgcrp5"];
        $images6 = $post["imgcrp6"];
        $catbind = $_REQUEST['catbind'];
        $cook_key = $_REQUEST['cook_key'];

        $sessiondata = Session::get('sessiondata');
        $groupidArr = array();
        $nameArr = array();
        if (trim($images1) != '') {

            $imgArr = explode('banner_images/', $images1);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);


            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {

                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }


                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;

                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");

                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images2) != '') {

            $imgArr = explode('banner_images/', $images2);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }
                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;

                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");

                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images3) != '') {

            $imgArr = explode('banner_images/', $images3);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }
                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;

                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images4) != '') {

            $imgArr = explode('banner_images/', $images4);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }
                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;

                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images5) != '') {

            $imgArr = explode('banner_images/', $images5);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }
                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;

                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images6) != '') {

            $imgArr = explode('banner_images/', $images6);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }
                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;

                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }


        $upimg_groupid = implode(',', $groupidArr);


        $requestArr = array('upimg_groupid' => $upimg_groupid, 'catbind' => $catbind);



        $id = $catbind;
        if (isset($id) && $id != "") {
            $valueArr = explode("_", $id);
            if ($id != '0_0_0') {
                $json_url = url("json-data/get-categories");
                $json = file_get_contents($json_url);

                $data = json_decode($json, true);
                $typeCat = $valueArr[2];
                $catid = $valueArr[1];
                $subcatid = $valueArr[0];
                $categories = $data[$typeCat][0][$catid];
                $subcategories = $data[$typeCat][$catid][$subcatid];

                return view('creat-ads', ['categories' => $categories, 'subcategories' => $subcategories, 'catid' => $catid,
                    'subcatid' => $subcatid, 'advcurrency' => $this->currency, 'catbindid' => $id, 'upimg_groupid' => $upimg_groupid, 'upimg' => $nameArr, 'cook_key' => $cook_key]);
            } else {
                return view('creat-ads', ['categories' => '', 'subcategories' => '', 'catid' => '',
                    'subcatid' => '', 'advcurrency' => $this->currency, 'catbindid' => $id, 'upimg_groupid' => $upimg_groupid, 'upimg' => $nameArr, 'cook_key' => $cook_key]);
            }
        }
    }

    public function uploadBannerEdit(Request $request) {
        $post = $request->all();
        $olddestinationPath = public_path('banner_images');
        $destinationPath = public_path('images');
        // $images = $post["img"];
        $images1 = $post["imgcrp1"];
        $images2 = $post["imgcrp2"];
        $images3 = $post["imgcrp3"];
        $images4 = $post["imgcrp4"];
        $images5 = $post["imgcrp5"];
        $images6 = $post["imgcrp6"];
        //$catbind=$_REQUEST['catbind'];
        $campaign_id = $_REQUEST['campaign_id'];
        $group_id = $_REQUEST['grpid'];
        $upimgs = 0;

        $sessiondata = Session::get('sessiondata');
        $adsModel = \App\Ads::find($group_id);
        $ads_creativeids = $adsModel->creative_ids;
        $groupidArr = array();

        if (trim($images1) != '') {
            $imgArr = explode('banner_images/', $images1);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);


            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {

                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }


                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;


                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images2) != '') {

            $imgArr = explode('banner_images/', $images2);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }
                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;


                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images3) != '') {

            $imgArr = explode('banner_images/', $images3);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }
                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];
                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;


                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images4) != '') {

            $imgArr = explode('banner_images/', $images4);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }
                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];
                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;


                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images5) != '') {

            $imgArr = explode('banner_images/', $images5);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }
                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;


                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images6) != '') {

            $imgArr = explode('banner_images/', $images6);
            $imgName1 = trim($imgArr[1]);
            $curimg = $olddestinationPath . '/' . $imgName1;
            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($curimg);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                if ($imageVal['mime'] == 'image/jpeg') {
                    $extArr = $extension = 'jpg';
                }
                if ($imageVal['mime'] == 'image/png') {
                    $extArr = $extension = 'png';
                }
                $imageVal2 = getimagesize($curimg);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];
                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;


                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $successp = exec("cp $curimg $images1");

                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }

        if (!empty($groupidArr)) {

            if (trim($ads_creativeids) != '') {
                $group_ids = implode(',', $groupidArr);
                $group_ids = $ads_creativeids . ',' . $group_ids;
            } else {
                $group_ids = implode(',', $groupidArr);
            }




            if ($group_ids != '') {
                return redirect('edit-ad?campaign_id=' . $campaign_id . '&grpid=' . $group_ids . '&upimgs=1');
            }
        } else {
            return redirect('edit-ad?campaign_id=' . $campaign_id . '&grpid=' . $ads_creativeids);
        }
    }

    function imageCreateTransparent($x, $y, $bg) {
        $image = imagecreatetruecolor($x, $y);
        $bgArr = explode(",", $bg);

        $whit = imagecolorallocate($image, $bgArr[0], $bgArr[1], $bgArr[2]);
        imagefill($image, 0, 0, $whit);
        return $image;
    }

    function cropimage(Request $request) {
        $defult = 'themes/images/380x190.png';

        $srcp = 'd';


        return View('/crop_tool', ['banner' => $defult, 'srcp' => $srcp]);

        // return redirect('/crop_tool')->with('banner',$defult,'srcp',$srcp);
    }

    function cropimageedit(Request $request) {
        $defult = 'themes/images/380x190.png';

        $srcp = 'd';


        return View('/crop_tool_edit', ['banner' => $defult, 'srcp' => $srcp]);

        // return redirect('/crop_tool')->with('banner',$defult,'srcp',$srcp);
    }

    function cropimage_post(Request $request) {


        $defult = 'themes/images/banner_01.jpg';
        $isimg = $request->cropimage_data;
        $srcp = 'd';

        if (trim($isimg) != '') {
            $defult = trim($isimg);
            $srcp = 'b';
        }
        return View('/crop_tool', ['banner' => $defult, 'srcp' => $srcp]);

        //return redirect('/crop_tool')->with('banner',$defult,'srcp',$srcp);
    }

    public function banner_gallery(Request $request) {
        return View('/gallery');
    }

    public function getGallery(Request $request) {
        //return View('/gallery');
        if (isset($request->srch)) {
            $catname = $request->catid;

            $catArr = array('0' => 'zzz', '1' => 'Automobiles', '2' => 'Entertainment', '3' => 'Marketers', '4' => 'Restaurants', '5' => 'e-tailers', '6' => 'Real Estate', '7' => 'Personal/Services', '8' => 'Resell Items');

            //$catid = array_search($catname, $catArr);

            foreach ($catArr as $key => $value) {
                if (strpos(strtolower($value), strtolower($catname)) !== false) {
                    //results here
                    $catid = $key;
                    $catname = $value;
                }
            }

            if (isset($catid) && $catid != '') {
                $getAll = \App\BannerGallery::where('category_id', $catid)->get();
                //Model::where('column', 'LIKE', '%value%')->get();

                $dta = array('cdata' => $getAll, 'catname' => $catname);
                return json_encode($dta);
            } else {
                //return '0';
                $getAll = \App\BannerGallery::where('image_name', 'LIKE', '%' . $catname . '%')->get();
                //Model::where('column', 'LIKE', '%value%')->get();
                if (!empty($getAll)) {
                    $dta = array('cdata' => $getAll, 'catname' => 'Others');
                    return json_encode($dta);
                } else {
                    return '0';
                }
            }
        } else {
            $catid = $request->catid;
            $getAll = \App\BannerGallery::where('category_id', $catid)->get();
            return json_encode($getAll);
        }
    }

    public function uploadcrop(Request $request) {
        $post = $request->all();
        $destinationPath = public_path('images');
        // $images = $post["img"];
        $images1 = $post["imgcrp1"];
        $images2 = $post["imgcrp2"];
        $images3 = $post["imgcrp3"];
        $images4 = $post["imgcrp4"];
        $images5 = $post["imgcrp5"];
        $images6 = $post["imgcrp6"];
        $catbind = $_REQUEST['invisible'];
        $cook_key = $_REQUEST['cook_key'];
        $nameArr = array();

        $sessiondata = Session::get('sessiondata');
        $groupidArr = array();
        if (trim($images1) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images1);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images1);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images1 = str_replace('data:image/png;base64,', '', $images1);
                $img = str_replace(' ', '+', $images1);
                $data = base64_decode($img);

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;


                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $success1 = file_put_contents($images1, $data);
                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images2) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images2);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images2);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images2 = str_replace('data:image/png;base64,', '', $images2);
                $img = str_replace(' ', '+', $images2);
                $data = base64_decode($img);
                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;
                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images2 = $destinationPath . '/' . $fileName;
                $success2 = file_put_contents($images2, $data);
                $successp = exec("chmod -R 0777  $images2");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images3) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images3);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images3);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images3 = str_replace('data:image/png;base64,', '', $images3);
                $img = str_replace(' ', '+', $images3);
                $data = base64_decode($img);
                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;
                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images3 = $destinationPath . '/' . $fileName;
                $success2 = file_put_contents($images3, $data);
                $successp = exec("chmod -R 0777  $images3");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images4) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images4);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images4);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images4 = str_replace('data:image/png;base64,', '', $images4);
                $img = str_replace(' ', '+', $images4);
                $data = base64_decode($img);
                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;
                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images4 = $destinationPath . '/' . $fileName;
                $success2 = file_put_contents($images4, $data);
                $successp = exec("chmod -R 0777  $images4");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images5) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images5);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images5);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images5 = str_replace('data:image/png;base64,', '', $images5);
                $img = str_replace(' ', '+', $images5);
                $data = base64_decode($img);
                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;
                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images5 = $destinationPath . '/' . $fileName;
                $success2 = file_put_contents($images5, $data);
                $successp = exec("chmod -R 0777  $images5");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images6) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images6);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images6);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images6 = str_replace('data:image/png;base64,', '', $images6);
                $img = str_replace(' ', '+', $images6);
                $data = base64_decode($img);
                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;
                $nameArr[] = $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images6 = $destinationPath . '/' . $fileName;
                $success2 = file_put_contents($images6, $data);
                $successp = exec("chmod -R 0777  $images6");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }

        $upimg_groupid = implode(',', $groupidArr);




        $requestArr = array('upimg_groupid' => $upimg_groupid, 'catbind' => $catbind);



        $id = $catbind;
        if (isset($id) && $id != "") {
            if ($id != '0_0_0') {
                $valueArr = explode("_", $id);

                $json_url = url("json-data/get-categories");
                $json = file_get_contents($json_url);

                $data = json_decode($json, true);
                $typeCat = $valueArr[2];
                $catid = $valueArr[1];
                $subcatid = $valueArr[0];
                $categories = $data[$typeCat][0][$catid];
                $subcategories = $data[$typeCat][$catid][$subcatid];

                return view('creat-ads', ['categories' => $categories, 'subcategories' => $subcategories, 'catid' => $catid,
                    'subcatid' => $subcatid, 'advcurrency' => $this->currency, 'catbindid' => $id, 'upimg_groupid' => $upimg_groupid, 'upimg' => $nameArr, 'cook_key' => $cook_key]);
            } else {
                return view('creat-ads', ['categories' => '', 'subcategories' => '', 'catid' => '',
                    'subcatid' => '', 'advcurrency' => $this->currency, 'catbindid' => $id, 'upimg_groupid' => $upimg_groupid, 'upimg' => $nameArr, 'cook_key' => $cook_key]);
            }
        }
    }

    public function uploadcropedit(Request $request) {
        $post = $request->all();
        $destinationPath = public_path('images');
        // $images = $post["img"];
        $images1 = $post["imgcrp1"];
        $images2 = $post["imgcrp2"];
        $images3 = $post["imgcrp3"];
        $images4 = $post["imgcrp4"];
        $images5 = $post["imgcrp5"];
        $images6 = $post["imgcrp6"];
        $campaign_id = $_REQUEST['campaign_id'];
        $group_id = $_REQUEST['grpid'];
        //$cook_key=$_REQUEST['cook_key'];

        $sessiondata = Session::get('sessiondata');
        $adsModel = \App\Ads::find($group_id);
        $ads_creativeids = $adsModel->creative_ids;
        $groupidArr = array();

        if (trim($images1) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images1);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images1);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images1 = str_replace('data:image/png;base64,', '', $images1);
                $img = str_replace(' ', '+', $images1);
                $data = base64_decode($img);
                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;
                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images1 = $destinationPath . '/' . $fileName;
                $success1 = file_put_contents($images1, $data);
                $successp = exec("chmod -R 0777  $images1");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images2) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images2);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images2);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images2 = str_replace('data:image/png;base64,', '', $images2);
                $img = str_replace(' ', '+', $images2);
                $data = base64_decode($img);

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;
                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images2 = $destinationPath . '/' . $fileName;
                $success2 = file_put_contents($images2, $data);
                $successp = exec("chmod -R 0777  $images2");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images3) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images3);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images3);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images3 = str_replace('data:image/png;base64,', '', $images3);
                $img = str_replace(' ', '+', $images3);
                $data = base64_decode($img);

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;
                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images3 = $destinationPath . '/' . $fileName;
                $success2 = file_put_contents($images3, $data);
                $successp = exec("chmod -R 0777  $images3");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images4) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images4);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images4);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images4 = str_replace('data:image/png;base64,', '', $images4);
                $img = str_replace(' ', '+', $images4);
                $data = base64_decode($img);

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;
                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images4 = $destinationPath . '/' . $fileName;
                $success2 = file_put_contents($images4, $data);
                $successp = exec("chmod -R 0777  $images4");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images5) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images5);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images5);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images5 = str_replace('data:image/png;base64,', '', $images5);
                $img = str_replace(' ', '+', $images5);
                $data = base64_decode($img);

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;
                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images5 = $destinationPath . '/' . $fileName;
                $success2 = file_put_contents($images5, $data);
                $successp = exec("chmod -R 0777  $images5");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }
        if (trim($images6) != '') {

            $dmsarr = array('300X250', '180X150', '728X90', '160X600', '300X600', '320X50', '320X53', '300X50', '300X75', '216X36', '216X54', '168X28', '168X42', '120X20', '120X30', '88X31', '250X300', '320X480', '468X60', '480X320');
            $imageVal = getimagesize($images6);

            $chkdm = $imageVal[0] . 'X' . $imageVal[1];
            if (in_array($chkdm, $dmsarr)) {
                $extArr = $extension = 'png';
                $imageVal2 = getimagesize($images6);
                $dmArr = $imageVal2[0] . 'X' . $imageVal2[1];

                $images6 = str_replace('data:image/png;base64,', '', $images6);
                $img = str_replace(' ', '+', $images6);
                $data = base64_decode($img);

                $creativeModel = new \App\CreativeGroup;

                $creativeModel->advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
                $creativeModel->content_type = "image";
                $creativeModel->create_date_time = date('Y-m-d h:i:s');

                $creativeModel->save();
                $groupidArr[] = $creativeModel->group_id;
                $fileName = $creativeModel->group_id . '_' . $imageVal2[0] . 'X' . $imageVal2[1] . '.' . $extension; // renameing image

                $images6 = $destinationPath . '/' . $fileName;
                $success2 = file_put_contents($images6, $data);
                $successp = exec("chmod -R 0777  $images6");
                $creativeModel->file_name = $fileName;
                $creativeModel->content_dimensions = $dmArr;
                $creativeModel->content_extensions = $extArr;
                $creativeModel->save();
            }
        }

        if (!empty($groupidArr)) {

            if (trim($ads_creativeids) != '') {
                $group_ids = implode(',', $groupidArr);
                $group_ids = $ads_creativeids . ',' . $group_ids;
            } else {
                $group_ids = implode(',', $groupidArr);
            }

            if ($group_ids != '') {
                return redirect('edit-ad?campaign_id=' . $campaign_id . '&grpid=' . $group_ids . '&upimgs=1');
            }
        } else {
            return redirect('edit-ad?campaign_id=' . $campaign_id . '&grpid=' . $ads_creativeids);
        }
    }

    public function getAdvId($userId) {

        if ($userId) {

            $publisher = DB::table('dl_advertisers')->where('account_id', $userId)->first();
            if ($publisher->advertiser_id > 0) {

                return $publisher->advertiser_id;
            }
        }

        return null;
    }

    public function manage_webpages() {
        //need to code here
        return View('/manage-webpages');
    }

    public function getmywebpageList(Request $request) {

        if (Auth::check() && $this->session['sessiondata']['accounts'][0]['account_type'] == 'ADVERTISER') {
            $statModel = new \App\AdvertiserWebpage();
            $statData = $statModel->leftJoin('hourly_stat', 'advertiser_webpage.page_id', '=', 'hourly_stat.url_id')
                    ->leftJoin('dl_campaigns', 'dl_campaigns.page_id', '=', 'advertiser_webpage.page_id')
                    ->where('advertiser_webpage.advertiser_id', $this->advertiserdata['advertiser_id'])
                    ->where('advertiser_webpage.webpage_name', '!=', "")
                    ->where('advertiser_webpage.url', '!=', "")
                    ->where('advertiser_webpage.status', '=', "live")
                    ->selectRaw("dl_campaigns.campaign_name,"
                            . "advertiser_webpage.webpage_name,"
                            . "advertiser_webpage.page_id,"
                            . "advertiser_webpage.url,"
                            . "advertiser_webpage.added_date,"
                            . "advertiser_webpage.url,"
                            . "dl_campaigns.campaign_id, "
                            . "sum(impression_count) as imp, "
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3) as spend_currency"
                    )
                    ->groupBy('advertiser_webpage.page_id', 'dl_campaigns.campaign_id')
                    ->get();
            return $statData->toJson();
        }
        return "[]";
    }

    public function show_webpage(Request $request) {
        $webpageUrl = $request->weburl;
        return View('/show-webpage', ['weburl' => $webpageUrl]);
    }

}
