<?php

namespace App\Http\Controllers;

use DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use App\Account;
use Auth;

class JsonController extends Controller {

    public function __construct() {
        $this->session = SESSION::All();
        if (Auth::check() && $this->session['sessiondata']['accounts'][0]['account_type'] == 'ADVERTISER') {
            $this->advertiserdata = Account::find($this->session['sessiondata']['accounts'][0]['account_id'])->advertiser;
            $this->advertiserdata = $this->advertiserdata->toArray();
            $this->currency = !empty($this->advertiserdata['currency']) ? $this->advertiserdata['currency'] : 'USD';
            $this->currencyminarray = config('paymentgateway.currencyminarray');
            $this->currencymin = $this->currencyminarray[$this->currency];
            $this->advertiserdata['currencymin'] = $this->currencymin;
        }
    }

    /*
      get all categories in json format
     *
     */

    public function getCountries() {

        //$advertisers = DB::table('dl_advertisers')->get();
        $getAll = \App\Country::all();
        return $getAll->toJson();
//	print_r($getAll->toJson());
    }

    /*
      get all cities in json format
     *  */

    public function getAllCities(Request $request) {

        //$advertisers = DB::table('dl_advertisers')->get();
        // $q = $_GET["q"];
        $q = $request->q;

        $statModel = new \App\Cities;

        //$statData = $statModel::where('city', 'LIKE', '%'.$q.'%')->get();
        $statData = $statModel::where('country_iso', '=', $q)->get();
        $final_array = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                $sb = array();
                $sb['id'] = $value->city;
                $sb['name'] = $value->city;
                $final_array[] = $sb;
            }
        }

        return json_encode($final_array);
    }
    
    /*
      get Selected countries cities  in json format
     *  */

    public function getSelectedCities(Request $request) {

        //$advertisers = DB::table('dl_advertisers')->get();
        // $q = $_GET["q"];
        $q = $request->q;
        $pos = strpos($q, ',');
        $qArr=array();
        if($pos === false)
        {
            $qArr[]=$q;
        }  else {
            $qArr=  explode(',', $q);
        }

        $statModel = new \App\Cities;
        
        
               
        $statData = $statModel::whereIn('country_iso3', $qArr)->get();
                                //->groupBy('country_iso3')
                                //->all();
        $final_array = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                $sb = array();
                $sb['id'] = $value->city;
                $sb['name'] = $value->city;
                $sb['iso3'] = $value->country_iso3;
                $final_array[] = $sb;
            }
        }

        return json_encode($final_array);
    }
    

    /*
      get all categories in json format
     *  */

    public function getIabCategories() {

        //$advertisers = DB::table('dl_advertisers')->get();
        $getAll = \App\CfCategory::all();
        $final_array = array();
        if (count($getAll) > 0) {

            foreach ($getAll as $key => $value) {

                $value->iab_category_id = ($value->iab_category_id) ? $value->iab_category_id : $value->category_id;
                $value->iab_parent_id = ($value->iab_parent_id) ? $value->iab_parent_id : 0;
                $final_array[$value->iab_parent_id][$value->iab_category_id] = $value->description;
            }
        }

        return json_encode($final_array);
    }

    /*
      get all categories in json format
     *  */

    public function getCategories() {

        //$advertisers = DB::table('dl_advertisers')->get();
        $getAll = \App\AdvCategory::all();
        $final_array = array();
        if (count($getAll) > 0) {

            foreach ($getAll as $key => $value) {

                if ($value->type == "B")
                    $final_array[0][$value->parent_id][$value->id] = $value->description;
                else
                    $final_array[1][$value->parent_id][$value->id] = $value->description;
            }
        }
        //echo "<pre>";print_r($final_array);
        return json_encode($final_array);
    }

    /*
      get all devices in json format
     *  */

    public function getDevices(Request $request) {

        
        
        if(isset($request->q) && trim($request->q)!=''){
           $q = $request->q; 
        }else{
            $q = 'all';
        }
        $pos = strpos($q, ',');
        $qArr=array();
        if($pos === false)
        {
            $qArr[]=$q;
        }  else {
            $qArr=  explode(',', $q);
        }

        $statModel = new \App\Devices;
        
        if($q=='all' || $qArr[0]=='all'){
            $statData = $statModel::distinct()->select('device_brand')
                ->orderBy('device_brand','asc')
                ->get();
        }else{
               
        $statData = $statModel::whereIn('device_type', $qArr)->get();
                               
        }               
        $final_array = array();
         $final_array2 = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                $final_array[] = $value->device_brand;
            }
        }
        
               
        $statDatav = $statModel::distinct()->select('device_brand')
                ->orderBy('device_brand','asc')
                ->get();
         if (count($statDatav) > 0) {

            foreach ($statDatav as $key => $value) {
                
                if(in_array(trim($value->device_brand), $final_array)){
                $final_array2[$value->device_brand]='checked';
                }else{
                    $final_array2[$value->device_brand]='';
                }
            }
        }
        return json_encode($final_array2);
        
        
//$contents = Storage::disk('local')->get('target_data/device_list.include');
       // $contents = file('target_data/devicebrand_list.include');
//print_r( json_encode($contents) );
       // return json_encode($contents);
    }

    /*
      get all os in json format
     *  */

    public function getOs() {

//$contents = Storage::disk('local')->get('target_data/device_list.include');
        $contents = file('target_data/os_list.include');
//print_r( json_encode($contents) );
        return json_encode($contents);
    }

    /*
      get all osv in json format
     *  */

    public function getOsV() {
        
        //$contents = Storage::disk('local')->get('target_data/device_list.include');
        $contents = file('target_data/osv_list.include');
        //print_r( json_encode($contents) );
        return json_encode($contents);
    }

    /*
      get all browser in json format
     *  */

    public function getBrowser() {

        //$contents = Storage::disk('local')->get('target_data/device_list.include');
        $contents = file('target_data/browser_list.include');
        //print_r( json_encode($contents) );
        return json_encode($contents);
    }

    /*
      get all browser versions in json format
     *  */

    public function getBrowserV() {

        //$contents = Storage::disk('local')->get('target_data/device_list.include');
        $contents = file('target_data/browserv_list.include');
        //print_r( json_encode($contents) );
        return json_encode($contents);
    }

    /*
      get all browser in json format
     *  */

    public function getOperator(Request $request) {
        $country = $request->q;
        //$advertisers = DB::table('dl_advertisers')->get();

        if (trim($country) == '') {
            $country = 'IND';
        }

        $getAll = new \App\Operator;

        $pos = strpos($country, ',');
        if ($pos === false) {
            $statData = $getAll::where('country_name_iso3', '=', $country)->get();
        } else {
            $expd = explode(',', $country);

            $statData = $getAll::whereIn('country_name_iso3', $expd)->get();
        }

        return $statData->toJson();
//        print_r($statData->toJson());
    }

    /*
      get ads running info in json format
     *  */

    public function getReportInfoAdvertiser(Request $request) {
        if (!isset($this->advertiserdata)) {
            return false;
        }

        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Ymd');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Ymd');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Ymd');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Ymd');
        }

        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start . '000000' : date("Ymd") . '000000';
        $end = ( $request->end ) ? $request->end . '235959' : date("Ymd") . '235959';
        //getting the stat records
        if (!isset($request->groupby)) {
            $request->groupby = 1;
        }
        $statModel = new \App\hourlyStat();

        $statData = $statModel->join('dl_campaigns', 'hourly_stat.campaign_id', '=', 'dl_campaigns.campaign_id')
                ->leftJoin('advertiser_webpage', 'advertiser_webpage.page_id', '=', 'hourly_stat.url_id')
                ->where('hourly_stat.advertiser_id', $this->advertiserdata['advertiser_id'])
                ->where('hourly_stat.stat_date', '>=', $start)
                ->where('hourly_stat.stat_date', '<=', $end);
        if ($request->groupby == 2) {
            $statData = $statData->where('advertiser_webpage.webpage_name', '=', '')
                    ->where('advertiser_webpage.url', '!=', '')
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.min_unit_price,"
                            . "advertiser_webpage.url,"
                            . "dl_campaigns.min_unit_price_currency,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3)as spend_currency,"
                            . "dl_campaigns.campaign_budget,"
                            . "dl_campaigns.campaign_budget_currency,"
                            . "hourly_stat.ad_id, sum(impression_count) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "hourly_stat.revenue_value as spend,"
                            . "hourly_stat.revenue_value_currency as spend_currency,"
                            . "hourly_stat.stat_date")
                    ->groupBy('hourly_stat.stat_date','hourly_stat.url_id','dl_campaigns.campaign_id')
                    ->orderBy('hourly_stat.stat_date', 'desc')
                    ->orderBy('advertiser_webpage.url', 'asc')
                    ->orderBy('dl_campaigns.campaign_name', 'asc');

        } else if ($request->groupby == 3) {
            $statData = $statData->where('advertiser_webpage.webpage_name', '!=', '')
                    ->where('advertiser_webpage.url', '!=', '')
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "advertiser_webpage.webpage_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.min_unit_price,"
                            . "dl_campaigns.min_unit_price_currency,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3)as spend_currency,"
                            . "dl_campaigns.campaign_budget,"
                            . "dl_campaigns.campaign_budget_currency,"
                            . "hourly_stat.ad_id, sum(impression_count) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "hourly_stat.revenue_value as spend,"
                            . "hourly_stat.revenue_value_currency as spend_currency,"
                            . "hourly_stat.stat_date")
                    ->groupBy('hourly_stat.stat_date','hourly_stat.url_id','dl_campaigns.campaign_id')
                    ->orderBy('hourly_stat.stat_date', 'desc')
                    ->orderBy('advertiser_webpage.webpage_name', 'asc')
                    ->orderBy('dl_campaigns.campaign_name', 'asc');
        } else { //default
            $statData = $statData->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.min_unit_price,"
                            . "advertiser_webpage.url,"
                            . "dl_campaigns.min_unit_price_currency,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3)as spend_currency,"
                            . "dl_campaigns.campaign_budget,"
                            . "dl_campaigns.campaign_budget_currency,"
                            . "hourly_stat.ad_id, sum(impression_count) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "hourly_stat.revenue_value as spend,"
                            . "hourly_stat.revenue_value_currency as spend_currency,"
                            . "hourly_stat.stat_date")
                    //->groupBy('hourly_stat.url_id', 'hourly_stat.stat_date')
                    ->groupBy('dl_campaigns.campaign_id', 'hourly_stat.stat_date')
                    ->orderBy('hourly_stat.stat_date', 'desc')
                    ->orderBy('dl_campaigns.campaign_name', 'asc');
        }
        //$statData = $statData->get();
        $statData = $statData->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        return $statData->toJson();
    }

    /*
      get ads info for logged in advertiser in json format
     *  */

    public function getAdInfoAdvertiser(Request $request) {
        if (!isset($this->advertiserdata)) {
            return json_encode(false);
        }

        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }
        $take = ( $request->take ) ? $request->take : 10;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : '';
        $end = ( $request->end ) ? $request->end : '';

        //getting the stat records
        $statModel = new \App\Campaigns();
        if (trim($request->start) != '' && trim($request->end) != '') {
            $statData = $statModel::leftJoin('hourly_stat', function( $join)use($start, $end ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id')
                        ->where('hourly_stat.stat_date', '>=', $start)
                        ->where('hourly_stat.stat_date', '<=', $end);
                    })
                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
                    //->whereBetween("hourly_stat.stat_date", array($start, $end))
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.admin_status,"
                            . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
                            . "round(dl_campaigns.min_unit_price_currency,3) as min_unit_price_currency,"
                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget, "
                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget_currency,"
                            . "hourly_stat.ad_id, sum(impression_count) as imp, "
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3) as spend_currency"
                    )
                    ->groupBy('dl_campaigns.campaign_id')
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        } else {

            $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id')
                        ->where('hourly_stat.stat_date', '>=', $start)
                        ->where('hourly_stat.stat_date', '<=', $end);
                    })
                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
                    //->where('dl_campaigns.status', '!=', "complete")
                    ->whereBetween("hourly_stat.stat_date", array(date("Y-m-d"), date("Y-m-d")))
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "dl_campaigns.admin_status,"
                            . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
                            . "round(dl_campaigns.min_unit_price_currency,3) as min_unit_price_currency,"
                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget, "
                            . "round(dl_campaigns.campaign_budget_currency,3) as campaign_budget_currency, "
                            . "hourly_stat.ad_id, "
                            . "sum(impression_count) as imp, "
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3) as spend_currency")
                    ->groupBy('dl_campaigns.campaign_id')
                    //->take($take)
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        }
        return $statData->toJson();
    }

    public function getTotalAdReportAdvertiser(Request $request) {

        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->start = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        } else {
            $tzObj = new \DateTimeZone($this->session['sessiondata']['user_timezone']);
            $dateTimeObj = new \DateTime('now', $tzObj);
            $request->end = $dateTimeObj->format('d-m-Y');
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }
        $start = ( $request->start ) ? $request->start : '';
        $end = ( $request->end ) ? $request->end : '';

        //getting the stat records
        $statModel = new \App\Campaigns();
        if (trim($request->start) != '' && trim($request->end) != '') {
            $statData = $statModel::leftJoin('hourly_stat', function( $join)use($start, $end ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id')
                        ->where('hourly_stat.stat_date', '>=', $start)
                        ->where('hourly_stat.stat_date', '<=', $end);
                    })
                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.advertiser_id,"
                            . "dl_campaigns.status,"
                            . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
                            . "round(dl_campaigns.min_unit_price_currency,3) as min_unit_price_currency,"
                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget,"
                            . "round(dl_campaigns.campaign_budget_currency,3) as campaign_budget_currency,"
                            . "hourly_stat.ad_id, "
                            . "sum(impression_count) as imp, "
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3) as spend_currency"
                    )
                    ->groupBy("dl_campaigns.campaign_id")
                    ->get();
        } else {
            $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id');
                    })
                    ->where('dl_campaigns.advertiser_id', $this->advertiserdata['advertiser_id'])
//                ->where('dl_campaigns.status', '!=', "complete")
                    // ->whereBetween("hourly_stat.stat_date", array($start, $end))	
                    ->selectRaw("dl_campaigns.campaign_id,"
                            . "dl_campaigns.campaign_name,"
                            . "dl_campaigns.status,"
                            . "round(dl_campaigns.min_unit_price,3) as min_unit_price,"
                            . "round(dl_campaigns.min_unit_price_currency,3) as min_unit_price_currency,"
                            . "round(dl_campaigns.campaign_budget,3) as campaign_budget,"
                            . "round(dl_campaigns.campaign_budget_currency,3) as campaign_budget_currency,"
                            . "hourly_stat.ad_id,"
                            . "sum(impression_count) as imp,"
                            . "sum(clicks_count) as clicks,"
                            . "sum(conversions_count) as conversions,"
                            . "round(sum(revenue_value),3) as spend,"
                            . "round(sum(revenue_value_currency),3) as spend_currency"
                    )
                    ->groupBy("dl_campaigns.campaign_id")
                    ->get();
        }
        $campaign_data = array();
        $campaign_data['running_count'] = 0;
        $campaign_data['spend_currency'] = 0;
        $campaign_data['conversions'] = 0;
        $campaign_data['clicks'] = 0;
        $campaign_data['campaign_budget_currency'] = 0;
        $campaign_data['account_balance_currency'] = $this->advertiserdata['balance_left_currency'] = 0;
        $statData = $statData->toArray();
        foreach ($statData as $statRow) {
            if ($statRow['status'] == 'running') {
                $campaign_data['running_count'] ++;
            }
            $campaign_data['spend_currency'] += $statRow['spend_currency'];
            $campaign_data['campaign_budget_currency'] += $statRow['campaign_budget_currency'];
            $campaign_data['clicks'] += $statRow['clicks'];
            $campaign_data['conversions'] += $statRow['conversions'];
        }

        $stvdata = array('data' => $campaign_data);
        return json_encode($stvdata);
    }

    public function getAdminPubInfo(Request $request) {

        //echo "<pre>";print_r($request);die;
        if (isset($request->start) && !empty($request->start)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->start);
            $request->start = $dateTimeObj->format('Y-m-d');
        }

        if (isset($request->end) && !empty($request->end)) {
            $dateTimeObj = \DateTime::createFromFormat('d-m-Y', $request->end);
            $request->end = $dateTimeObj->format('Y-m-d');
        }

        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : "";
        $end = ( $request->end ) ? $request->end : "";

        //getting the stat records
        $statModel = new \App\Publisher();

        $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                    $join->on('publishers.publisher_id', '=', 'hourly_stat.publisher_id');
                });
//                ->where('hourly_stat.advertiser_id', Session::get('UserID'))


        if ($start != "" && $end != "")
            $statData = $statData->whereBetween("hourly_stat.stat_date", array($start, $end));

        $statData = $statData->selectRaw("sum(hourly_stat.request_count) as request_count,sum(hourly_stat.bid_count) as bid_count,sum(hourly_stat.win_count) as win_count,sum(hourly_stat.impression_count) as impression_count,publishers.company,hourly_stat.publisher_id")
                ->groupBy('publishers.publisher_id')
                ->where('hourly_stat.publisher_id', '!=', "NULL")
                //->take($take)
                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        //echo "<pre>";print_r( $statData->toJson() );die;
        return $statData->toJson();
    }

    public function getAdvPageInfo(Request $request) {

        //echo "<pre>";print_r($request);die;
        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : "";
        $end = ( $request->end ) ? $request->end : "";
        $adv_id = ( $request->adv_id ) ? $request->adv_id : 0;
        //getting the stat records
        $statModel = new \App\CampaignWebpage();


        if ($start != "" && $end != "") {

            $statData = $statModel::leftJoin('hourly_stat_page', function( $join ) {
                        $join->on('advertiser_webpage.page_id', '=', 'hourly_stat_page.page_id');
                    })->whereBetween("hourly_stat_page.stat_date", array($start, $end))
                    ->where("advertiser_webpage.advertiser_id", "=", $adv_id)
                    ->selectRaw("sum(hourly_stat_page.clicks_count) as total_clicks,advertiser_webpage.page_id")
                    ->groupBy('advertiser_webpage.page_id')
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        } else {

            $statData = $statModel::leftJoin('hourly_stat_page', function( $join ) {
                        $join->on('advertiser_webpage.page_id', '=', 'hourly_stat_page.page_id');
                    })->where("advertiser_webpage.advertiser_id", "=", $adv_id)
                    ->selectRaw("sum(hourly_stat_page.clicks_count) as total_clicks,advertiser_webpage.page_id")
                    ->groupBy('advertiser_webpage.page_id')
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        }

        return $statData->toJson();
    }

    public function getAdminAdInfo(Request $request) {

        //echo "<pre>";print_r($request);die;
        $take = ( $request->take ) ? $request->take : 10000;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : "";
        $end = ( $request->end ) ? $request->end : "";
        $all_live = ( $request->live == 1 ) ? 1 : 0;
        //getting the stat records
        $statModel = new \App\Campaigns();


        if ($start != "" && $end != "") {

            $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id');
                    })->leftJoin('ads', function( $join ) {
                        $join->on('ads.campaign_id', '=', 'hourly_stat.campaign_id');
                    })
                    ->whereBetween("hourly_stat.stat_date", array($start, $end))
                    ->selectRaw("dl_campaigns.campaign_id,dl_campaigns.campaign_name,dl_campaigns.status,round(dl_campaigns.min_unit_price,3) as min_unit_price,round(dl_campaigns.campaign_budget,3) as campaign_budget, hourly_stat.ad_id, sum(impression_count) as imp, sum(clicks_count) as clicks,round(sum(revenue_value),3) as spend, sum(conversions_count) as conv,ads.admin_cpm as adcpm,ads.current_cpm as curcpm,dl_campaigns.cpa_id as cpa_id,dl_campaigns.adomain as adomain,dl_campaigns.admin_status,ads.ad_status,ads.admin_status as admin_status_ad")
                    ->groupBy('dl_campaigns.campaign_id')
                    //->take($take)
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        } elseif ($all_live) {

            $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id');
                    })->leftJoin('ads', function( $join ) {
                        $join->on('ads.campaign_id', '=', 'hourly_stat.campaign_id');
                    })
                    ->where("dl_campaigns.status", "=", "running")
                    ->where("dl_campaigns.admin_status", "=", "approved")
                    ->where("ads.ad_status", "=", "1")
                    ->where("ads.admin_status", "=", "approved")
                    ->selectRaw("dl_campaigns.campaign_id,dl_campaigns.campaign_name,dl_campaigns.status,round(dl_campaigns.min_unit_price,3) as min_unit_price,round(dl_campaigns.campaign_budget,3) as campaign_budget, hourly_stat.ad_id, sum(impression_count) as imp, sum(clicks_count) as clicks,round(sum(revenue_value),3) as spend, sum(conversions_count) as conv,ads.admin_cpm as adcpm,ads.current_cpm as curcpm,dl_campaigns.cpa_id as cpa_id,dl_campaigns.adomain as adomain,dl_campaigns.admin_status,ads.ad_status,ads.admin_status as admin_status_ad")
                    ->groupBy('dl_campaigns.campaign_id')
                    //->take($take)
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        } else {

            $statData = $statModel::leftJoin('hourly_stat', function( $join ) {
                        $join->on('dl_campaigns.campaign_id', '=', 'hourly_stat.campaign_id');
                    })->leftJoin('ads', function( $join ) {
                        $join->on('ads.campaign_id', '=', 'hourly_stat.campaign_id');
                    })->selectRaw("dl_campaigns.campaign_id,dl_campaigns.campaign_name,dl_campaigns.status,round(dl_campaigns.min_unit_price,3) as min_unit_price,round(dl_campaigns.campaign_budget,3) as campaign_budget, hourly_stat.ad_id, sum(impression_count) as imp, sum(clicks_count) as clicks,round(sum(revenue_value),3) as spend, sum(conversions_count) as conv,ads.admin_cpm as adcpm,ads.current_cpm as curcpm,dl_campaigns.cpa_id as cpa_id,dl_campaigns.adomain as adomain,dl_campaigns.admin_status,ads.ad_status,ads.admin_status as admin_status_ad")
                    ->groupBy('dl_campaigns.campaign_id')
                    //->take($take)
                    ->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        }
        //echo "<pre>";print_r( $statData->toJson() );die;
        return $statData->toJson();
    }

    /*
      get ads running info in json format
     *  */

    public function geAdDetail(Request $request) {

        $campagin_id = $request->campaign_id;
        //$campagin_id=1; 
        //getting the stat records
        $camModel = new \App\Campaigns();

        $camData = $camModel::leftJoin('ads', function( $join ) {
                    $join->on('dl_campaigns.campaign_id', '=', 'ads.campaign_id');
                })->leftJoin('creative_groups', function( $join ) {
                    $join->on('creative_groups.group_id', '=', 'ads.creative_ids');
                })->leftJoin('ad_channel_group_assoc', function( $join ) {
                    $join->on('ad_channel_group_assoc.ad_id', '=', 'ads.ad_id');
                })->leftJoin('targeting_channel_group', function( $join ) {
                    $join->on('targeting_channel_group.channel_group_id', '=', 'ad_channel_group_assoc.channel_id');
                })
                ->where('dl_campaigns.campaign_id', $campagin_id)
                ->selectRaw("ad_channel_group_assoc.ad_targetting_group_id,dl_campaigns.*,ads.*,targeting_channel_group.*,creative_groups.*,creative_groups.update_date_time as creative_time,ads.creative_ids")
                ->get();

//        echo "<pre>";print_r( $camData );die;
        return $camData->toJson();
    }

    /*
      get ads running info in json format
     *  */

    public function getProfileDetail(Request $request) {

        $user_id = $request->user_id;
        $userModel = new \App\User();
        $statData = $userModel::where('user_id', '=', $user_id)->get();
        $final_array = array();
        if (count($statData) > 0) {
            foreach ($statData as $key => $val) {
                $final_array[] = $val['attributes'];
            }
        }
        //print_r($final_array);die;
        return json_encode($final_array);
    }

    /*
      get timezone data
     *  */

    public function getTimezoneData(Request $request) {

        $userModel = new \App\TimezoneData();
        $statData = $userModel::whereNotNull('id')->get();
        //print_r($final_array);die;
        return $statData->toJson();
    }

    public function getCountriesfil() {
        $q = $_GET["q"];
        $getAll = new \App\Country;

        $pos = strpos($q, ',');
        if ($pos === false) {
            $statData = $getAll::where('iso3', '=', $q)->get();
        } else {
            $expd = explode(',', $q);

            $statData = $getAll::whereIn('iso3', $expd)->get();
        }

        $final_array = '';
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
                // echo '<pre>';
                // print_r($value);die();
                // $final_array[]=$value;
                $final_array .='<option value="' . $value['iso'] . '">' . $value['name'] . '</option>';
            }
        }

        return $final_array;

//	print_r($getAll->toJson());
    }

    public function getCountriesName() {
        $q = $_GET["q"];
        $getAll = new \App\Country;

        $pos = strpos($q, ',');
        if ($pos === false) {
            $statData = $getAll::where('iso3', '=', $q)->get();
        } else {
            $expd = explode(',', $q);

            $statData = $getAll::whereIn('iso3', $expd)->get();
        }

        $final_array = array();
        if (count($statData) > 0) {

            foreach ($statData as $key => $value) {
// echo '<pre>';
// print_r($value);die();
                $final_array[] = $value;
            }
        }

        return $final_array;
    }

    /*
      get publisher report info in json format
     *  */

    public function getPubReport(Request $request) {

        //echo "<pre>";print_r($request);die;
        $take = ( $request->take ) ? $request->take : 10;
        $page = ( $request->page ) ? $request->page : 1;
        $start = ( $request->start ) ? $request->start : date("Y-m-d");
        $end = ( $request->end ) ? $request->end : date("Y-m-d");

        //$start='2016-02-10';
        //$end='2016-02-15';
        //getting the stat records
        $statModel = new \App\publisherStat();

        // $statData = $statModel::where('publisher_id', Session::get('UserID'))

        $statData = $statModel::where('publisher_id', $this->getPubID(Session::get('UserID')))
                ->whereBetween("stat_date", array($start, $end))
                ->selectRaw("sum(request_count) as request_count ,sum(bid_count) as bid_count,sum(impression_count) as impression_count,sum(win_count) as win_count,sum(clicks_count) as clicks_count,sum(total_win_cost) as total_cost,stat_date,ad_spot_key")
                ->groupBy('ad_spot_id')
                //->take($take)
                ->paginate($take, $columns = ['*'], $pageName = 'page', $page);

        //Session::get('UserID')
        //echo "<pre>";print_r( $statData );die;
        return $statData->toJson();
    }

    public function getTotalPubReport(Request $request) {

        $start = ( $request->start ) ? $request->start : date("Y-m-d");
        $end = ( $request->end ) ? $request->end : date("Y-m-d");

        //getting the stat records
        $statModel = new \App\publisherStat();

        $statData = $statModel::where('publisher_id', $this->getPubID(Session::get('UserID')))
                ->whereBetween("stat_date", array($start, $end))
                ->selectRaw("sum(request_count) as request_count ,sum(bid_count) as bid_count,sum(impression_count) as impression_count,sum(win_count) as win_count,sum(clicks_count) as clicks_count,sum(total_win_cost) as total_cost,stat_date,ad_spot_key")
                ->get();
        //->take($take)
        //->paginate($take, $columns = ['*'], $pageName = 'page', $page);
        //Session::get('UserID')
        //echo "<pre>";print_r( $statData );die;
        return $statData->toJson();
    }

    public function getPubId($userId) {

        if ($userId) {

            $publisher = DB::table('publishers')->where('account_id', $userId)->first();
            if ($publisher->publisher_id > 0) {

                return $publisher->publisher_id;
            }
        }

        return null;
    }

    public function delCreativeGroupItems(Request $request) {

        $group_id = $request->group_id;
        $previous_img = $request->previous_img;

        if ($group_id) {

            $group_model = new \App\CreativeGroup();
            $group_model::find($group_id);
            $group_model->file_name = '';
            $group_model->content_dimensions = '';
            $group_model->content_extensions = '';
            $group_model->save();
            return '{"status": "ok"}';
        }
    }

    public function adCpmCampaign(Request $request) {
        $cmpid = $request->cmpid;
        $cpmval = $request->cpmval;

        $adsModel = \App\Ads::where('campaign_id', "=", $cmpid)
                ->update(['admin_cpm' => $cpmval]);

        $str_status = array('status' => 'Updated Successfully.');

        return json_encode($str_status);
    }

    public function adCpaIdCampaign(Request $request) {
        $cmpid = $request->cmpid;
        $cpmval = $request->cpmval;

        $adsModel = \App\Campaigns::where('campaign_id', $cmpid)
                ->update(['cpa_id' => $cpmval]);

        $str_status = array('status' => 'Updated Successfully.');
        return json_encode($str_status);
    }

    public function editcheck_balance_left_dollar(Request $request) {
        $sessiondata = Session::get('sessiondata');
        $advertiser_id = $this->getAdvId($sessiondata['accounts'][0]['account_id']);
        $post_value = $request->post_value;

        $result = DB::table('dl_advertisers')->select('balance_left_currency')->where('advertiser_id', $advertiser_id)->get();
        
        if(!empty($result)){
        
        $balance_left_dollar = $result[0]->balance_left_currency;

        if ($post_value > $balance_left_dollar) {
            return 2;
        } else {
            
            return 1;
        }
        }else
        {
            return 2;
        }
        
       
    }

    public function adAdomianCampaign(Request $request) {

        $cmpid = $request->cmpid;
        $cpmval = $request->cpmval;

        $adsModel = \App\Campaigns::where('campaign_id', $cmpid)
                ->update(['adomain' => "'" . $cpmval . "'"]);

        $str_status = array('status' => 'Updated Successfully.');
        return json_encode($str_status);
    }
    
    
        public function getAdvId($userId) {

        if ($userId) {

            $publisher = DB::table('dl_advertisers')->where('account_id', $userId)->first();
            if ($publisher->advertiser_id > 0) {

                return $publisher->advertiser_id;
            }
        }

        return null;
    }

}
