<?php


if ( is_admin()  ){
    add_action( 'admin_print_styles-post.php', 'cmb2_render_icon_styles' );
    add_action( 'admin_print_styles-post-new.php', 'cmb2_render_icon_styles' );
    add_action( 'load-edit-tags.php', 'cmb2_render_icon_styles' );;

    add_action( 'admin_print_scripts-post-new.php', 'cmb2_render_icon_js' );
    add_action( 'admin_print_scripts-post.php', 'cmb2_render_icon_js' );
    add_action( 'load-edit-tags.php', 'cmb2_render_icon_js' );
}



/**
 * Load css for edit post
 */
function cmb2_render_icon_styles(){
    $url = get_template_directory_uri().'/inc/metabox-addons/icon/';
    wp_enqueue_style( 'semantic-icon', $url . 'icon.min.css' );
    wp_enqueue_style( 'cmb2-icon-type', $url . 'icon-admin.css' );
}

/**
 * Load js for edit post
 */
function cmb2_render_icon_js(){
    $url = get_template_directory_uri().'/inc/metabox-addons/icon/';
    wp_enqueue_script( 'cmb2-icon-type', $url . 'icon.js', array( 'jquery' ), 'true' );
    wp_localize_script( 'jquery', 'CMB2_ICON', array(
        'icons'=>  'american sign language interpreting icon,assistive listening systems icon,audio description icon,blind icon,braille icon,closed captioning icon,closed captioning outline icon,deaf icon,low vision icon,phone volume icon,question circle icon,question circle outline icon,sign language icon,tty icon,universal access icon,wheelchair icon,angle double down icon,angle double left icon,angle double right icon,angle double up icon,angle down icon,angle left icon,angle right icon,angle up icon,arrow alternate circle down icon,arrow alternate circle down outline icon,arrow alternate circle left icon,arrow alternate circle left outline icon,arrow alternate circle right icon,arrow alternate circle right outline icon,arrow alternate circle up icon,arrow alternate circle up outline icon,arrow circle down icon,arrow circle left icon,arrow circle right icon,arrow circle up icon,arrow down icon,arrow left icon,arrow right icon,arrow up icon,arrows alternate icon,arrows alternate horizontal icon,arrows alternate vertical icon,caret down icon,caret left icon,caret right icon,caret square down icon,caret square down outline icon,caret square left icon,caret square left outline icon,caret square right icon,caret square right outline icon,caret square up icon,caret square up outline icon,caret up icon,cart arrow down icon,chart line icon,chevron circle down icon,chevron circle left icon,chevron circle right icon,chevron circle up icon,chevron down icon,chevron left icon,chevron right icon,chevron up icon,cloud download icon,cloud upload icon,download icon,exchange icon,expand arrows alternate icon,external alternate icon,external square alternate icon,hand point down icon,hand point down outline icon,hand point left icon,hand point left outline icon,hand point right icon,hand point right outline icon,hand point up icon,hand point up outline icon,hand pointer icon,hand pointer outline icon,history icon,level down alternate icon,level up alternate icon,location arrow icon,long arrow alternate down icon,long arrow alternate left icon,long arrow alternate right icon,long arrow alternate up icon,mouse pointer icon,play icon,random icon,recycle icon,redo icon,redo alternate icon,reply icon,reply all icon,retweet icon,share icon,share square icon,share square outline icon,sign-in icon,sign-out icon,sign-in alternate icon,sign-out alternate icon,sort icon,sort alphabet down icon,sort alphabet up icon,sort amount down icon,sort amount up icon,sort down icon,sort numeric down icon,sort numeric up icon,sort up icon,sync icon,sync alternate icon,text height icon,text width icon,undo icon,undo alternate icon,upload icon,zoom-in icon,zoom-out icon,audio description icon,backward icon,circle icon,circle outline icon,closed captioning icon,closed captioning outline icon,compress icon,eject icon,expand icon,expand arrows alternate icon,fast backward icon,fast forward icon,file audio icon,file audio outline icon,file video icon,file video outline icon,film icon,forward icon,headphones icon,microphone icon,microphone slash icon,music icon,pause icon,pause circle icon,pause circle outline icon,phone volume icon,play icon,play circle icon,play circle outline icon,podcast icon,random icon,redo icon,redo alternate icon,rss icon,rss square icon,step backward icon,step forward icon,stop icon,stop circle icon,stop circle outline icon,sync icon,sync alternate icon,undo icon,undo alternate icon,video icon,volume down icon,volume off icon,volume up icon,address book icon,address book outline icon,address card icon,address card outline icon,archive icon,balance scale icon,birthday cake icon,book icon,briefcase icon,building icon,building outline icon,bullhorn icon,bullseye icon,calculator icon,calendar icon,calendar outline icon,calendar alternate icon,calendar alternate outline icon,certificate icon,chart area icon,chart bar icon,chart bar outline icon,chart line icon,chart pie icon,clipboard icon,clipboard outline icon,coffee icon,columns icon,compass icon,compass outline icon,copy icon,copy outline icon,copyright icon,copyright outline icon,cut icon,edit icon,edit outline icon,envelope icon,envelope outline icon,envelope open icon,envelope open outline icon,envelope square icon,eraser icon,fax icon,file icon,file outline icon,file alternate icon,file alternate outline icon,folder icon,folder outline icon,folder open icon,folder open outline icon,globe icon,industry icon,paperclip icon,paste icon,pen square icon,pencil alternate icon,percent icon,phone icon,phone square icon,phone volume icon,registered icon,registered outline icon,save icon,save outline icon,sitemap icon,sticky note icon,sticky note outline icon,suitcase icon,table icon,tag icon,tags icon,tasks icon,thumbtack icon,trademark icon,chess icon,chess bishop icon,chess board icon,chess king icon,chess knight icon,chess pawn icon,chess queen icon,chess rook icon,square full icon,archive icon,barcode icon,bath icon,bug icon,code icon,code branch icon,coffee icon,file icon,file outline icon,file alternate icon,file alternate outline icon,file code icon,file code outline icon,filter icon,fire extinguisher icon,folder icon,folder outline icon,folder open icon,folder open outline icon,keyboard icon,keyboard outline icon,microchip icon,qrcode icon,shield alternate icon,sitemap icon,terminal icon,user secret icon,window close icon,window close outline icon,window maximize icon,window maximize outline icon,window minimize icon,window minimize outline icon,window restore icon,window restore outline icon,address book icon,address book outline icon,address card icon,address card outline icon,american sign language interpreting icon,assistive listening systems icon,at icon,bell icon,bell outline icon,bell slash icon,bell slash outline icon,bullhorn icon,comment icon,comment outline icon,comment alternate icon,comment alternate outline icon,comments icon,comments outline icon,envelope icon,envelope outline icon,envelope open icon,envelope open outline icon,envelope square icon,fax icon,inbox icon,language icon,microphone icon,microphone slash icon,mobile icon,mobile alternate icon,paper plane icon,paper plane outline icon,phone icon,phone square icon,phone volume icon,rss icon,rss square icon,tty icon,wifi icon,desktop icon,download icon,hdd icon,hdd outline icon,headphones icon,keyboard icon,keyboard outline icon,laptop icon,microchip icon,mobile icon,mobile alternate icon,plug icon,power off icon,print icon,save icon,save outline icon,server icon,tablet icon,tablet alternate icon,tv icon,upload icon,dollar sign icon,euro sign icon,lira sign icon,money bill alternate icon,money bill alternate outline icon,pound sign icon,ruble sign icon,rupee sign icon,shekel sign icon,won sign icon,yen sign icon,bell icon,bell outline icon,bell slash icon,bell slash outline icon,calendar icon,calendar outline icon,calendar alternate icon,calendar alternate outline icon,calendar check icon,calendar check outline icon,calendar minus icon,calendar minus outline icon,calendar plus icon,calendar plus outline icon,calendar times icon,calendar times outline icon,clock icon,clock outline icon,hourglass icon,hourglass outline icon,hourglass end icon,hourglass half icon,hourglass start icon,stopwatch icon,adjust icon,clone icon,clone outline icon,copy icon,copy outline icon,crop icon,crosshairs icon,cut icon,edit icon,edit outline icon,eraser icon,eye icon,eye dropper icon,eye slash icon,eye slash outline icon,object group icon,object group outline icon,object ungroup icon,object ungroup outline icon,paint brush icon,paste icon,pencil alternate icon,save icon,save outline icon,tint icon,align center icon,align justify icon,align left icon,align right icon,bold icon,clipboard icon,clipboard outline icon,clone icon,clone outline icon,columns icon,copy icon,copy outline icon,cut icon,edit icon,edit outline icon,eraser icon,file icon,file outline icon,file alternate icon,file alternate outline icon,font icon,heading icon,i cursor icon,indent icon,italic icon,linkify icon,list icon,list alternate icon,list alternate outline icon,list ol icon,list ul icon,outdent icon,paper plane icon,paper plane outline icon,paperclip icon,paragraph icon,paste icon,pencil alternate icon,print icon,quote left icon,quote right icon,redo icon,redo alternate icon,reply icon,reply all icon,share icon,strikethrough icon,subscript icon,superscript icon,sync icon,sync alternate icon,table icon,tasks icon,text height icon,text width icon,th icon,th large icon,th list icon,trash icon,trash alternate icon,trash alternate outline icon,underline icon,undo icon,undo alternate icon,unlink icon,archive icon,clone icon,clone outline icon,copy icon,copy outline icon,cut icon,file icon,file outline icon,file alternate icon,file alternate outline icon,file archive icon,file archive outline icon,file audio icon,file audio outline icon,file code icon,file code outline icon,file excel icon,file excel outline icon,file image icon,file image outline icon,file pdf icon,file pdf outline icon,file powerpoint icon,file powerpoint outline icon,file video icon,file video outline icon,file word icon,file word outline icon,folder icon,folder outline icon,folder open icon,folder open outline icon,paste icon,save icon,save outline icon,sticky note icon,sticky note outline icon,genderless icon,mars icon,mars double icon,mars stroke icon,mars stroke horizontal icon,mars stroke vertical icon,mercury icon,neuter icon,transgender icon,transgender alternate icon,venus icon,venus double icon,venus mars icon,hand lizard icon,hand lizard outline icon,hand paper icon,hand paper outline icon,hand peace icon,hand peace outline icon,hand point down icon,hand point down outline icon,hand point left icon,hand point left outline icon,hand point right icon,hand point right outline icon,hand point up icon,hand point up outline icon,hand pointer icon,hand pointer outline icon,hand rock icon,hand rock outline icon,hand scissors icon,hand scissors outline icon,hand spock icon,hand spock outline icon,handshake icon,handshake outline icon,thumbs down icon,thumbs down outline icon,thumbs up icon,thumbs up outline icon,ambulance icon,h square icon,heart icon,heart outline icon,heartbeat icon,hospital icon,hospital outline icon,medkit icon,plus square icon,plus square outline icon,stethoscope icon,user md icon,wheelchair icon,adjust icon,bolt icon,camera icon,camera retro icon,clone icon,clone outline icon,compress icon,expand icon,eye icon,eye dropper icon,eye slash icon,eye slash outline icon,file image icon,file image outline icon,film icon,id badge icon,id badge outline icon,id card icon,id card outline icon,image icon,image outline icon,images icon,images outline icon,sliders horizontal icon,tint icon,ban icon,barcode icon,bars icon,beer icon,bell icon,bell outline icon,bell slash icon,bell slash outline icon,bug icon,bullhorn icon,bullseye icon,calculator icon,calendar icon,calendar outline icon,calendar alternate icon,calendar alternate outline icon,calendar check icon,calendar check outline icon,calendar minus icon,calendar minus outline icon,calendar plus icon,calendar plus outline icon,calendar times icon,calendar times outline icon,certificate icon,check icon,check circle icon,check circle outline icon,check square icon,check square outline icon,circle icon,circle outline icon,clipboard icon,clipboard outline icon,clone icon,clone outline icon,cloud icon,cloud download icon,cloud upload icon,coffee icon,cog icon,cogs icon,copy icon,copy outline icon,cut icon,database icon,dot circle icon,dot circle outline icon,download icon,edit icon,edit outline icon,ellipsis horizontal icon,ellipsis vertical icon,envelope icon,envelope outline icon,envelope open icon,envelope open outline icon,eraser icon,exclamation icon,exclamation circle icon,exclamation triangle icon,external alternate icon,external square alternate icon,eye icon,eye slash icon,eye slash outline icon,file icon,file outline icon,file alternate icon,file alternate outline icon,filter icon,flag icon,flag outline icon,flag checkered icon,folder icon,folder outline icon,folder open icon,folder open outline icon,frown icon,frown outline icon,hashtag icon,heart icon,heart outline icon,history icon,home icon,i cursor icon,info icon,info circle icon,language icon,magic icon,meh icon,meh outline icon,microphone icon,microphone slash icon,minus icon,minus circle icon,minus square icon,minus square outline icon,paste icon,pencil alternate icon,plus icon,plus circle icon,plus square icon,plus square outline icon,qrcode icon,question icon,question circle icon,question circle outline icon,quote left icon,quote right icon,redo icon,redo alternate icon,reply icon,reply all icon,rss icon,rss square icon,save icon,save outline icon,search icon,search minus icon,search plus icon,share icon,share alternate icon,share alternate square icon,share square icon,share square outline icon,shield alternate icon,sign-in icon,sign-out icon,signal icon,sitemap icon,sliders horizontal icon,smile icon,smile outline icon,sort icon,sort alphabet down icon,sort alphabet up icon,sort amount down icon,sort amount up icon,sort down icon,sort numeric down icon,sort numeric up icon,sort up icon,star icon,star outline icon,star half icon,star half outline icon,sync icon,sync alternate icon,thumbs down icon,thumbs down outline icon,thumbs up icon,thumbs up outline icon,times icon,times circle icon,times circle outline icon,toggle off icon,toggle on icon,trash icon,trash alternate icon,trash alternate outline icon,trophy icon,undo icon,undo alternate icon,upload icon,user icon,user outline icon,user circle icon,user circle outline icon,wifi icon,box icon,boxes icon,clipboard check icon,clipboard list icon,dolly icon,dolly flatbed icon,pallet icon,shipping fast icon,truck icon,warehouse icon,ambulance icon,anchor icon,balance scale icon,bath icon,bed icon,beer icon,bell icon,bell outline icon,bell slash icon,bell slash outline icon,bicycle icon,binoculars icon,birthday cake icon,blind icon,bomb icon,book icon,bookmark icon,bookmark outline icon,briefcase icon,building icon,building outline icon,car icon,coffee icon,crosshairs icon,dollar sign icon,eye icon,eye slash icon,eye slash outline icon,fighter jet icon,fire icon,fire extinguisher icon,flag icon,flag outline icon,flag checkered icon,flask icon,gamepad icon,gavel icon,gift icon,glass martini icon,globe icon,graduation cap icon,h square icon,heart icon,heart outline icon,heartbeat icon,home icon,hospital icon,hospital outline icon,image icon,image outline icon,images icon,images outline icon,industry icon,info icon,info circle icon,key icon,leaf icon,lemon icon,lemon outline icon,life ring icon,life ring outline icon,lightbulb icon,lightbulb outline icon,location arrow icon,low vision icon,magnet icon,male icon,map icon,map outline icon,map marker icon,map marker alternate icon,map pin icon,map signs icon,medkit icon,money bill alternate icon,money bill alternate outline icon,motorcycle icon,music icon,newspaper icon,newspaper outline icon,paw icon,phone icon,phone square icon,phone volume icon,plane icon,plug icon,plus icon,plus square icon,plus square outline icon,print icon,recycle icon,road icon,rocket icon,search icon,search minus icon,search plus icon,ship icon,shopping bag icon,shopping basket icon,shopping cart icon,shower icon,street view icon,subway icon,suitcase icon,tag icon,tags icon,taxi icon,thumbtack icon,ticket alternate icon,tint icon,train icon,tree icon,trophy icon,truck icon,tty icon,umbrella icon,university icon,utensil spoon icon,utensils icon,wheelchair icon,wifi icon,wrench icon,ambulance icon,band aid icon,dna icon,first aid icon,heart icon,heart outline icon,heartbeat icon,hospital icon,hospital outline icon,hospital symbol icon,pills icon,plus icon,stethoscope icon,syringe icon,thermometer icon,user md icon,weight icon,ambulance icon,anchor icon,archive icon,balance scale icon,bath icon,bed icon,beer icon,bell icon,bell outline icon,bicycle icon,binoculars icon,birthday cake icon,bomb icon,book icon,bookmark icon,bookmark outline icon,briefcase icon,bug icon,building icon,building outline icon,bullhorn icon,bullseye icon,bus icon,calculator icon,calendar icon,calendar outline icon,calendar alternate icon,calendar alternate outline icon,camera icon,camera retro icon,car icon,clipboard icon,clipboard outline icon,cloud icon,coffee icon,cog icon,cogs icon,compass icon,compass outline icon,copy icon,copy outline icon,cube icon,cubes icon,cut icon,envelope icon,envelope outline icon,envelope open icon,envelope open outline icon,eraser icon,eye icon,eye dropper icon,fax icon,fighter jet icon,file icon,file outline icon,file alternate icon,file alternate outline icon,film icon,fire icon,fire extinguisher icon,flag icon,flag outline icon,flag checkered icon,flask icon,futbol icon,futbol outline icon,gamepad icon,gavel icon,gem icon,gem outline icon,gift icon,glass martini icon,globe icon,graduation cap icon,hdd icon,hdd outline icon,headphones icon,heart icon,heart outline icon,home icon,hospital icon,hospital outline icon,hourglass icon,hourglass outline icon,image icon,image outline icon,images icon,images outline icon,industry icon,key icon,keyboard icon,keyboard outline icon,laptop icon,leaf icon,lemon icon,lemon outline icon,life ring icon,life ring outline icon,lightbulb icon,lightbulb outline icon,lock icon,lock open icon,magic icon,magnet icon,map icon,map outline icon,map marker icon,map marker alternate icon,map pin icon,map signs icon,medkit icon,microchip icon,microphone icon,mobile icon,mobile alternate icon,money bill alternate icon,money bill alternate outline icon,moon icon,moon outline icon,motorcycle icon,newspaper icon,newspaper outline icon,paint brush icon,paper plane icon,paper plane outline icon,paperclip icon,paste icon,paw icon,pencil alternate icon,phone icon,plane icon,plug icon,print icon,puzzle piece icon,road icon,rocket icon,save icon,save outline icon,search icon,shield alternate icon,shopping bag icon,shopping basket icon,shopping cart icon,shower icon,snowflake icon,snowflake outline icon,space shuttle icon,star icon,star outline icon,sticky note icon,sticky note outline icon,stopwatch icon,subway icon,suitcase icon,sun icon,sun outline icon,tablet icon,tablet alternate icon,tachometer alternate icon,tag icon,tags icon,taxi icon,thumbtack icon,ticket alternate icon,train icon,trash icon,trash alternate icon,trash alternate outline icon,tree icon,trophy icon,truck icon,tv icon,umbrella icon,university icon,unlock icon,unlock alternate icon,utensil spoon icon,utensils icon,wheelchair icon,wrench icon,bell icon,bell outline icon,bookmark icon,bookmark outline icon,bullhorn icon,camera icon,camera retro icon,cart arrow down icon,cart plus icon,certificate icon,credit card icon,credit card outline icon,gem icon,gem outline icon,gift icon,handshake icon,handshake outline icon,heart icon,heart outline icon,key icon,shopping bag icon,shopping basket icon,shopping cart icon,star icon,star outline icon,tag icon,tags icon,thumbs down icon,thumbs down outline icon,thumbs up icon,thumbs up outline icon,trophy icon,bookmark icon,bookmark outline icon,calendar icon,calendar outline icon,certificate icon,circle icon,circle outline icon,cloud icon,comment icon,comment outline icon,file icon,file outline icon,folder icon,folder outline icon,heart icon,heart outline icon,map marker icon,play icon,square icon,square outline icon,star icon,star outline icon,asterisk icon,certificate icon,circle notch icon,cog icon,compass icon,compass outline icon,crosshairs icon,life ring icon,life ring outline icon,snowflake icon,snowflake outline icon,spinner icon,sun icon,sun outline icon,sync icon,baseball ball icon,basketball ball icon,bowling ball icon,football ball icon,futbol icon,futbol outline icon,golf ball icon,hockey puck icon,quidditch icon,table tennis icon,volleyball ball icon,ban icon,battery empty icon,battery full icon,battery half icon,battery quarter icon,battery three quarters icon,bell icon,bell outline icon,bell slash icon,bell slash outline icon,calendar icon,calendar outline icon,calendar alternate icon,calendar alternate outline icon,calendar check icon,calendar check outline icon,calendar minus icon,calendar minus outline icon,calendar plus icon,calendar plus outline icon,calendar times icon,calendar times outline icon,cart arrow down icon,cart plus icon,exclamation icon,exclamation circle icon,exclamation triangle icon,eye icon,eye slash icon,eye slash outline icon,file icon,file outline icon,file alternate icon,file alternate outline icon,folder icon,folder outline icon,folder open icon,folder open outline icon,info icon,info circle icon,lock icon,lock open icon,minus icon,minus circle icon,minus square icon,minus square outline icon,plus icon,plus circle icon,plus square icon,plus square outline icon,question icon,question circle icon,question circle outline icon,shield alternate icon,shopping cart icon,sign in alternate icon,sign out alternate icon,thermometer empty icon,thermometer full icon,thermometer half icon,thermometer quarter icon,thermometer three quarters icon,thumbs down icon,thumbs down outline icon,thumbs up icon,thumbs up outline icon,toggle off icon,toggle on icon,unlock icon,unlock alternate icon,address book icon,address book outline icon,address card icon,address card outline icon,bed icon,blind icon,child icon,female icon,frown icon,frown outline icon,id badge icon,id badge outline icon,id card icon,id card outline icon,male icon,meh icon,meh outline icon,power off icon,smile icon,smile outline icon,street view icon,user icon,user outline icon,user circle icon,user circle outline icon,user md icon,user plus icon,user secret icon,user times icon,users icon,wheelchair icon,ambulance icon,bicycle icon,bus icon,car icon,fighter jet icon,motorcycle icon,paper plane icon,paper plane outline icon,plane icon,rocket icon,ship icon,shopping cart icon,space shuttle icon,subway icon,taxi icon,train icon,truck icon,wheelchair icon,archive icon,book icon,bookmark icon,bookmark outline icon,edit icon,edit outline icon,envelope icon,envelope outline icon,envelope open icon,envelope open outline icon,eraser icon,file icon,file outline icon,file alternate icon,file alternate outline icon,folder icon,folder outline icon,folder open icon,folder open outline icon,keyboard icon,keyboard outline icon,newspaper icon,newspaper outline icon,paper plane icon,paper plane outline icon,paperclip icon,paragraph icon,pen square icon,pencil alternate icon,quote left icon,quote right icon,sticky note icon,sticky note outline icon,thumbtack icon,500px icon,accessible icon icon,accusoft icon,adn icon,adversal icon,affiliatetheme icon,algolia icon,amazon icon,amazon pay icon,amilia icon,android icon,angellist icon,angrycreative icon,angular icon,app store icon,app store ios icon,apper icon,apple icon,apple pay icon,asymmetrik icon,audible icon,autoprefixer icon,avianex icon,aviato icon,aws icon,bandcamp icon,behance icon,behance square icon,bimobject icon,bitbucket icon,bitcoin icon,bity icon,black tie icon,blackberry icon,blogger icon,blogger b icon,bluetooth icon,bluetooth b icon,btc icon,buromobelexperte icon,buysellads icon,cc amazon pay icon,cc amex icon,cc apple pay icon,cc diners club icon,cc discover icon,cc jcb icon,cc mastercard icon,cc paypal icon,cc stripe icon,cc visa icon,centercode icon,chrome icon,cloudscale icon,cloudsmith icon,cloudversify icon,codepen icon,codiepie icon,connectdevelop icon,contao icon,cpanel icon,creative commons icon,css3 icon,css3 alternate icon,cuttlefish icon,d and d icon,dashcube icon,delicious icon,deploydog icon,deskpro icon,deviantart icon,digg icon,digital ocean icon,discord icon,discourse icon,dochub icon,docker icon,draft2digital icon,dribbble icon,dribbble square icon,dropbox icon,drupal icon,dyalog icon,earlybirds icon,edge icon,elementor icon,ember icon,empire icon,envira icon,erlang icon,ethereum icon,etsy icon,expeditedssl icon,facebook icon,facebook f icon,facebook messenger icon,facebook square icon,firefox icon,first order icon,firstdraft icon,flickr icon,flipboard icon,fly icon,font awesome icon,font awesome alternate icon,font awesome flag icon,fonticons icon,fonticons fi icon,fort awesome icon,fort awesome alternate icon,forumbee icon,foursquare icon,free code camp icon,freebsd icon,get pocket icon,gg icon,gg circle icon,git icon,git square icon,github icon,github alternate icon,github square icon,gitkraken icon,gitlab icon,gitter icon,glide icon,glide g icon,gofore icon,goodreads icon,goodreads g icon,google icon,google drive icon,google play icon,google plus icon,google plus g icon,google plus square icon,google wallet icon,gratipay icon,grav icon,gripfire icon,grunt icon,gulp icon,hacker news icon,hacker news square icon,hips icon,hire a helper icon,hooli icon,hotjar icon,houzz icon,html5 icon,hubspot icon,imdb icon,instagram icon,internet explorer icon,ioxhost icon,itunes icon,itunes note icon,jenkins icon,joget icon,joomla icon,js icon,js square icon,jsfiddle icon,keycdn icon,kickstarter icon,kickstarter k icon,korvue icon,laravel icon,lastfm icon,lastfm square icon,leanpub icon,less icon,linechat icon,linkedin icon,linkedin alternate icon,linode icon,linux icon,lyft icon,magento icon,maxcdn icon,medapps icon,medium icon,medium m icon,medrt icon,meetup icon,microsoft icon,mix icon,mixcloud icon,mizuni icon,modx icon,monero icon,napster icon,nintendo switch icon,node icon,node js icon,npm icon,ns8 icon,nutritionix icon,odnoklassniki icon,odnoklassniki square icon,opencart icon,openid icon,opera icon,optin monster icon,osi icon,page4 icon,pagelines icon,palfed icon,patreon icon,paypal icon,periscope icon,phabricator icon,phoenix framework icon,php icon,pied piper icon,pied piper alternate icon,pied piper pp icon,pinterest icon,pinterest p icon,pinterest square icon,playstation icon,product hunt icon,pushed icon,python icon,qq icon,quinscape icon,quora icon,ravelry icon,react icon,rebel icon,redriver icon,reddit icon,reddit alien icon,reddit square icon,rendact icon,renren icon,replyd icon,resolving icon,rocketchat icon,rockrms icon,safari icon,sass icon,schlix icon,scribd icon,searchengin icon,sellcast icon,sellsy icon,servicestack icon,shirtsinbulk icon,simplybuilt icon,sistrix icon,skyatlas icon,skype icon,slack icon,slack hash icon,slideshare icon,snapchat icon,snapchat ghost icon,snapchat square icon,soundcloud icon,speakap icon,spotify icon,stack exchange icon,stack overflow icon,staylinked icon,steam icon,steam square icon,steam symbol icon,sticker mule icon,strava icon,stripe icon,stripe s icon,studiovinari icon,stumbleupon icon,stumbleupon circle icon,superpowers icon,supple icon,telegram icon,telegram plane icon,tencent weibo icon,themeisle icon,trello icon,tripadvisor icon,tumblr icon,tumblr square icon,twitch icon,twitter icon,twitter square icon,typo3 icon,uber icon,uikit icon,uniregistry icon,untappd icon,usb icon,ussunnah icon,vaadin icon,viacoin icon,viadeo icon,viadeo square icon,viber icon,vimeo icon,vimeo square icon,vimeo v icon,vine icon,vk icon,vnv icon,vuejs icon,wechat icon,weibo icon,weixin icon,whatsapp icon,whatsapp square icon,whmcs icon,wikipedia w icon,windows icon,wordpress icon,wordpress simple icon,wpbeginner icon,wpexplorer icon,wpforms icon,xbox icon,xing icon,xing square icon,y combinator icon,yahoo icon,yandex icon,yandex international icon,yelp icon,yoast icon,youtube icon,youtube square icon'
    ) );
}




/**
 * Display Icon Type
 *
 * @param $field
 * @param $escaped_value
 * @param $object_id
 * @param $object_type
 * @param $field_type_object
 */
function cmb2_render_icon( $field, $escaped_value, $object_id, $object_type, $field_type_object ) {
    ?>
    <div class="cmb2-icon-picker">
        <?php
        //st_debug( $field_type_object );

        echo $field_type_object->input(
            array(
                'class' => 'cmb2-icon-value',
                'name'  => $field_type_object->_name( ),
                'id'    => $field_type_object->_id( ),
                'value' => $escaped_value,
                'type'  => 'hidden',
                'desc'  => '',
            )
        );

        ?>
        <div class="cmb2-icon-selected"><?php
            if ( $escaped_value != '' ){
                echo '<i class="'.esc_attr( $escaped_value ).'"> </i>';
            }
            ?></div>
        <input class="cmb2-search-icons" placeholder="<?php esc_attr_e( 'Search Icon', 'wp-coupon' ); ?>" type="text">
        <div class="cmb2-list-icons hide"></div>

    </div>

    <?php
    // st_debug( $field_type_object );
    if( $field->args['desc'] != '' ){
        echo '<p class="clear cmb2-metabox-description">'.balanceTags(  $field->args['desc'] ).'</p>';
    } ?>


    <?php
}
add_action( 'cmb2_render_icon', 'cmb2_render_icon', 10, 5 );