<?php
/**
 * Admin AJAX actions
 *
 * @since       1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Handle AJAX reset coupon stats action
 */
function affcoups_pro_admin_ajax_reset_coupon_stats_action() {

    // AJAX Call
    if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {

        $response = false;

        // Variables
        $coupon_id = ( isset ( $_POST['coupon_id'] ) && is_numeric( $_POST['coupon_id'] ) ) ? intval( $_POST['coupon_id'] ) : 0;

        if ( ! empty( $coupon_id ) ) {
            affcoups_pro_stats_reset_records( $coupon_id );
        }

        // response output
        echo $response;
    }

    // IMPORTANT: don't forget to "exit"
    exit;
}
add_action( 'wp_ajax_nopriv_affcoups_pro_admin_reset_coupon_stats_action', 'affcoups_pro_admin_ajax_reset_coupon_stats_action' );
add_action( 'wp_ajax_affcoups_pro_admin_reset_coupon_stats_action', 'affcoups_pro_admin_ajax_reset_coupon_stats_action' );
