<?php
/**
 * Statistics Class
 *
 * @since       1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! class_exists( 'Affcoups_Pro_Statistics' ) ) {

    class Affcoups_Pro_Stats {

        /**
         * Options
         *
         * @var array
         */
        public $options;

        /**
         * Affcoups_Pro_Statistics constructor.
         */
        public function __construct() {

            // Options
            $this->options = affcoups_get_options();

            // Hooks
            //add_action( 'admin_menu', array( &$this, 'add_admin_menu' ) );
        }

        /**
         * Add admin menu
         */
        function add_admin_menu() {

            // Source: https://codex.wordpress.org/Function_Reference/add_options_page
            add_submenu_page(
                'edit.php?post_type=affcoups_coupon',
                __( 'Affiliate Coupons - Statistics', 'affiliate-coupons-pro' ), // Page title
                __( 'Statistics', 'affiliate-coupons-pro' ), // Menu title
                'manage_options', // Capabilities
                'affcoups_stats', // Menu slug
                array( &$this, 'statistics_page' ) // Callback
            );

        }

        /**
         * Output the statistics page HTML
         */
        function statistics_page() {

            ?>
            <div class="affcoups affcoups-page affcoups-stats">
                <div class="wrap">
                    <h2 class="affcoups-page-headline"><?php _e( 'Affiliate Coupons', 'affiliate-coupons-pro' ); ?><small><?php _e( 'Statistics', 'affiliate-coupons-pro' ); ?></small></h2>

                </div>
            </div>
            <?php
        }
    }
}