<?php
/**
 * coupon export to CSV file
 *
 * @since       1.1.6
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

if ( isset($_GET['action'] ) && $_GET['action'] == 'download_csv'){
	// Handle CSV Export
  add_action( 'admin_init', 'affcoups_csv_export') ;
}

function affcoups_csv_export(){

    // Check for current user privileges 
  if( !current_user_can( 'manage_options' ) ){ return false; }
    // Check if we are in WP-Admin
  if( !is_admin() ){ return false; }

  // Nonce Check
  $nonce = isset( $_GET['_wpnonce'] ) ? $_GET['_wpnonce'] : '';
  if ( ! wp_verify_nonce( $nonce, 'download_csv' ) ) {
    die( 'Security check error' );
  }    
    ob_clean();
    ob_start();
    $filename = 'Affcoups_coupon_'.time().'.csv';
    $header_row = array(
      'coupon_post_title',	
      'coupon_post_content',	
      'image',	
      'discount',	
      'code',	
      'valid_from',
      'valid_until',	
      'url',	
      'description_title',	
      'description', 	
      'highlighted', 	
      'featured',	
      'click_to_reveal_disable',
      'category',	
      'type',	
      'vendor',	
      'vendor_image',	
      'vendor_url',	
      'vendor_description',      
      'original_price',  
      'discounted_price',  
    );
    $affcoups_coupons = get_posts([
      'post_type' => 'Affcoups_coupon',
      'post_status' => 'publish',
      'numberposts' => -1
      // 'order'    => 'ASC'
    ]);
    $fh = @fopen( 'php://output', 'w' );
    header( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
    header( 'Content-Description: File Transfer' );
    header( 'Content-type: text/csv' );
    header( "Content-Disposition: attachment; filename={$filename}" );
    header( 'Expires: 0' );
    header( 'Pragma: public' );
    fputcsv( $fh, $header_row );
    foreach ( $affcoups_coupons as $affcoup ) {
      $coupon_meta=get_post_meta($affcoup->ID);

      //retreive categories
      $categories=get_the_terms( $affcoup->ID,'affcoups_coupon_category');
      $affcoups_categories=array();
      if (is_array($categories) || is_object($categories)){
        foreach($categories as $category)
          array_push($affcoups_categories,$category->name);
      }
      $categories = implode(',', $affcoups_categories);

      //retreive types
      $types=get_the_terms( $affcoup->ID,'affcoups_coupon_type');
      $affcoups_types=array();
      if (is_array($types) || is_object($types)){
        foreach($types as $type)
          array_push($affcoups_types, $type->name);
      }
      $types = implode(',', $affcoups_types);
      
      //retreive coupon image      
      $image_attachment_id = (!empty($coupon_meta['affcoups_coupon_image'][0]))? ($coupon_meta['affcoups_coupon_image'][0]) : NULL;
      $image_title =NULL;
      if(!($image_attachment_id==NULL)){
        $image = get_post($image_attachment_id);
        $image_title= $image->post_title;
      }

      $discount = (!empty( $coupon_meta['affcoups_coupon_discount'][0]))? ($coupon_meta['affcoups_coupon_discount'][0]) : NULL;
      $code = (!empty( $coupon_meta['affcoups_coupon_code'][0]))? ($coupon_meta['affcoups_coupon_code'][0]) : NULL;
      $valid_from = (!empty( $coupon_meta['affcoups_coupon_valid_from'][0]))? ($coupon_meta['affcoups_coupon_valid_from'][0]) : NULL;
      if($valid_from!=NULL)
        $valid_from_date=date("Y-m-d",$valid_from);
      else
        $valid_from_date=NULL;
      $valid_until = (!empty( $coupon_meta['affcoups_coupon_valid_until'][0]))? ($coupon_meta['affcoups_coupon_valid_until'][0]) : NULL;
      if($valid_until!=NULL)
        $valid_until_date=date("Y-m-d",$valid_until);
      else
        $valid_until_date=NULL;
      $url = (!empty( $coupon_meta['affcoups_coupon_url'][0]))? ($coupon_meta['affcoups_coupon_url'][0]) : NULL;
      $title = (!empty( $coupon_meta['affcoups_coupon_title'][0]))? ($coupon_meta['affcoups_coupon_title'][0]) : NULL;
      $description = (!empty( $coupon_meta['affcoups_coupon_description'][0]))? ($coupon_meta['affcoups_coupon_description'][0]) : NULL;
      $highlighted = (!empty( $coupon_meta['affcoups_coupon_highlighted'][0]))? ($coupon_meta['affcoups_coupon_highlighted'][0]) : NULL;
      $featured = (!empty( $coupon_meta['affcoups_coupon_featured'][0]))? ($coupon_meta['affcoups_coupon_featured'][0]) : NULL;
      $click_to_reveal_disable = (!empty( $coupon_meta['affcoups_click_to_reveal_disable'][0]))? ($coupon_meta['affcoups_click_to_reveal_disable'][0]) : NULL;
      $coupon_post_content = apply_filters('the_content', $affcoup->post_content);
      $coupon_post_title   = apply_filters('the_title',$affcoup->post_title);
      $vendor=get_post($coupon_meta['affcoups_coupon_vendor'][0]);
      $vendor_name =  apply_filters('the_title',$vendor->post_title);
      $vendor_meta=get_post_meta($vendor->ID);
     // $vendor_image = $vendor_meta['affcoups_vendor_image'][0];
      $image_attachment_id = (!empty($vendor_meta['affcoups_vendor_image'][0]))? ($vendor_meta['affcoups_vendor_image'][0]) : NULL;
      $vendor_image =NULL;
      if(!($image_attachment_id==NULL)){
        $image = get_post($image_attachment_id);
        $vendor_image= $image->post_title;
      }

      $vendor_url = $vendor_meta['affcoups_vendor_url'][0];
      $vendor_description = $vendor_meta['affcoups_vendor_description'][0];
      $original_price = (!empty( $coupon_meta['affcoups_coupon_original_price'][0]))? ($coupon_meta['affcoups_coupon_original_price'][0]) : NULL;
      $discounted_price = (!empty( $coupon_meta['affcoups_coupon_discounted_price'][0]))? ($coupon_meta['affcoups_coupon_discounted_price'][0]) : NULL;

      $data_row = array(
        $coupon_post_title, //'title',	
        $coupon_post_content, // 'description'	
        $image_title, //'image'
        $discount,
        $code,
        $valid_from_date,
        $valid_until_date,
        $url,
        $title, //'description_title,
        $description,
        $highlighted,
        $featured,
        $click_to_reveal_disable,
        $categories,
        $types,
        $vendor_name,
        $vendor_image,
        $vendor_url,
        $vendor_description,
        $original_price,
        $discounted_price,
      );
      fputcsv( $fh, $data_row);
    }
    fclose( $fh );
    ob_end_flush();
    die();
  }
  ?>