<?php
/**
 * Manage Coupons
 *
 * @since       1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Row actions
 *
 * @param $actions
 * @param $post
 * @return mixed
 */
function affcoups_pro_coupon_posts_row_actions( $actions, $post ) {

    if ( isset( $post->post_type ) && 'affcoups_coupon' === $post->post_type ) {
        $actions['affcoups-reset-coupon-stats'] = '<a href="#" data-affcoups-reset-coupon-stats="' . $post->ID . '">' . __( 'Reset Statistics', 'affiliate-coupons-pro' ) . '</a>' . '<span class="affcoups-inline-success"><span class="dashicons dashicons-yes"></span></span>';
    }

    return $actions;
}
add_filter('post_row_actions', 'affcoups_pro_coupon_posts_row_actions', 10, 2);

/**
 * Add new columns
 *
 * @param $defaults
 *
 * @return mixed
 */
function affcoups_pro_coupon_posts_columns( $defaults ) {

	$defaults['affcoups_coupon_details']      = __( 'Details', 'affiliate-coupons-pro' );

	if ( ! affcoups_pro_stats_disabled() )
	    $defaults['affcoups_coupon_stats'] = __( 'Statistics', 'affiliate-coupons-pro' );

	return $defaults;
}
add_filter( 'affcoups_coupon_posts_columns', 'affcoups_pro_coupon_posts_columns', 10 );

/**
 * Add columns content
 *
 * @param $column_name
 * @param $postid
 */
function affcoups_pro_coupon_posts_columns_content( $column_name, $postid ) {

    $icon_styles = 'font-size: 15px; vertical-align: -20%;';

	if ( 'affcoups_coupon_details' === $column_name ) {

        $is_featured = get_post_meta( $postid, AFFCOUPS_PREFIX . 'coupon_featured', true );
        $is_highlighted = get_post_meta( $postid, AFFCOUPS_PREFIX . 'coupon_highlighted', true );
        $is_disable_click_to_reveal = get_post_meta( $postid, AFFCOUPS_PREFIX . 'click_to_reveal_disable', true );

        if ( '1' == $is_featured ) { ?>
            <p>
                <span class="dashicons dashicons-admin-post" style="<?php echo esc_html( $icon_styles ); ?>"></span> <?php _e('Featured', 'affiliate-coupons-pro' ); ?>
            </p>
            <?php
        }

        if ( '1' == $is_highlighted ) { ?>
            <p>
                <span class="dashicons dashicons-admin-customizer" style="<?php echo esc_html( $icon_styles ); ?>"></span> <?php _e('Highlighted', 'affiliate-coupons-pro'); ?>
            </p>
            <?php
        }

        if ( ! $is_featured && ! $is_highlighted )
            echo '<p>-</p>';

	} elseif ( 'affcoups_coupon_stats' === $column_name ) {

		?>
        <ul style="margin: 0;">
            <li>
                <span class="dashicons dashicons-visibility" style="<?php echo esc_html( $icon_styles ); ?>"></span> <?php _e('Views', 'affiliate-coupons-pro' ); ?>: <?php echo affcoups_pro_stats_get_count( $postid, 'view' ); ?>
            </li>
            <li>
                <span class="dashicons dashicons-clipboard" style="<?php echo esc_html( $icon_styles ); ?>"></span> <?php _e('Copies', 'affiliate-coupons-pro' ); ?>: <?php echo affcoups_pro_stats_get_count( $postid, 'copy' ); ?>
            </li>
            <li>
                <span class="dashicons dashicons-external" style="<?php echo esc_html( $icon_styles ); ?>"></span> <?php _e('Clicks', 'affiliate-coupons-pro' ); ?>: <?php echo affcoups_pro_stats_get_count( $postid, 'click' ); ?>
            </li>
        </ul>
		<?php
	}
}
add_action( 'affcoups_coupon_posts_columns_content', 'affcoups_pro_coupon_posts_columns_content', 10, 2 );
