<?php
/**
 * coupon uploader from CSV file
 *
 * @since       1.1.6
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

add_filter('views_edit-affcoups_coupon', 'affcoups_csv_upload',20);
function affcoups_csv_upload($views){
  
     // Check for current user privileges 
     if( !current_user_can( 'manage_options' ) ){ return false; }

     // Check if we are in WP-Admin
     if( !is_admin() ){ return false; }
 
?> 
  <div>
      <a href="<?php echo admin_url( 'admin.php?post_type=affcoups_coupon' ) ?>&action=download_csv&_wpnonce=<?php echo wp_create_nonce( 'download_csv' )?>" class="page-title-action"><?php _e('Export Coupons','Affcoups_coupon');?></a>
      <form action=" " method= "POST" enctype = "multipart/form-data">
      <label>Browse CSV file and add coupons in bulk</label></br>
      <a><input type="file" name="uploaded_file" style="width:180px";/></a>
      <a><input type="submit" name="upload" value="Bulk Add Coupons"/></a>
   </form>
   <ul class="subsubsub">
<?php  foreach($views as $view){ ?> 
           <a ><?php echo $view." | "; ?> </a> <?php }?>
</ul>
</div>
    <?php
    if (isset($_POST['upload'])){
        set_time_limit(0);
        if (!empty($_FILES['uploaded_file']['name'])){
            //$file_type = wp_check_filetype($_FILES['uploaded_file']['name']);
            $file_type = $_FILES['uploaded_file']['type'];
            if ('text/csv'== $file_type){
                $file_name = $_FILES['uploaded_file']['name'];
                $file_type = $_FILES['uploaded_file']['type'];
                $file_size = $_FILES['uploaded_file']['size'];
                $file_temp_loc = $_FILES['uploaded_file']['tmp_name'];
                $file_store = AFFCOUPS_PLUGIN_DIR.$file_name;

                if(move_uploaded_file($file_temp_loc, $file_store)){
                    $file = fopen($file_store,"r");
                    fgetcsv($file);
                    $csv_file_line=0;
                    while(! feof($file)){
                        $item=fgetcsv($file);
                        if(is_array($item))
                        $coupon= array(
                            'title'=>$item[0],	
                            'post_content'=>$item[1],	
                            'image'=>$item[2],	
                            'discount'=>$item[3],	
                            'code'=>$item[4],	
                            'valid_from'=>$item[5],
                            'valid_until'=>$item[6],	
                            'url'=>$item[7],	
                            'description_title'=>$item[8],	
                            'description'=>$item[9], 	
                            'highlighted'=>$item[10], 	
                            'featured'=>$item[11],	
                            'click_to_reveal_disable'=>$item[12],	
                            'category'=>$item[13],	
                            'type'=>$item[14],	
                            'vendor'=>$item[15],	
                            'vendor_image'=>$item[16],	
                            'vendor_url'=>$item[17],	
                            'vendor_description'=>$item[18],
                            'original_price'=>$item[19],
                            'discounted_price'=>$item[20],


                        );
                       
                        if(!empty($coupon['vendor'])){
                            //$vendor = $the_query->get_page_by_title($coupon['vendor'], OBJECT , AFFCOUPS_PREFIX .'vendor');
                           // $vendor = get_page_by_title($coupon['vendor'], OBJECT , AFFCOUPS_PREFIX .'vendor');
                           $new_vendor = array(
                            'title' => $coupon['vendor'],
                            'post_status' => 'publish',
                            'post_type'   => AFFCOUPS_PREFIX .'vendor'
                            );
                            $vendor=new WP_Query($new_vendor);
                           $vendor_id=0;
                            if($vendor->have_posts()) {
                                $vendor_id=$vendor->post->ID;
                            }else {
                                $new_vendor = array(
                                    'post_title' => $coupon['vendor'],
                                    'post_status' => 'publish',
                                    'post_type'   => AFFCOUPS_PREFIX .'vendor'
                                    );
                                $vendor_id = wp_insert_post( $new_vendor);
                                }
                                wp_reset_postdata();
                            $args = array(
                                    'title'    => pathinfo($coupon['vendor_image'],PATHINFO_FILENAME), 
                                    'post_type'      => 'attachment',
                                    'post_mime_type' => 'image',
                                    );
                            $images = get_posts($args);
                            $vendor_image = NULL;   
                            if(empty($images)) {
                                if(filter_var($coupon['vendor_image'], FILTER_VALIDATE_URL))
                                    $vendor_image = affcoups_imageupload($coupon['vendor_image'],$vendor_id);
                            }else 
                                $vendor_image = $images[0]->ID;  
                            if(!empty($vendor_image))
                                update_post_meta( $vendor_id , AFFCOUPS_PREFIX .'vendor_image', $vendor_image); 
                            $vendor = array(
                                'ID' => $vendor_id,
                                'post_status' => 'publish',
                                'meta_input' => array(
                                AFFCOUPS_PREFIX .'vendor_url'=>$coupon['vendor_url'], 
                                AFFCOUPS_PREFIX .'vendor_description'=>$coupon['vendor_description'],
                                ));

                            wp_update_post( $vendor );
                        }
                        
                        if(!empty($coupon['title'])){
                            $csv_file_line++;
                           // $aff_coupon = get_page_by_title($coupon['title'], OBJECT , AFFCOUPS_PREFIX .'coupon');
                           $new_coupon = array(
                            'title' => $coupon['title'],
                            'post_type'   => AFFCOUPS_PREFIX .'coupon'
                            );
                            $aff_coupons=new WP_Query($new_coupon);
                           $coupon_id=0;
                            if($aff_coupons->have_posts()) {
                                $coupon_id=$aff_coupons->post->ID;

                            }else{
                                    $new_coupon = array(
                                    'post_title' => $coupon['title'],
                                    'post_type'   => AFFCOUPS_PREFIX .'coupon'
                                    );
                                $coupon_id = wp_insert_post( $new_coupon );
                            }
                            wp_reset_postdata();

                            //Coupon Category and types
                            $categories= explode(',', esc_attr($coupon['category']));
                            foreach($categories as $category){
                                $coupon_category = get_term_by('name',$category , 'affcoups_coupon_category');
                                if(!empty($coupon_category))
                                    wp_set_post_terms($coupon_id, $coupon_category->term_id, 'affcoups_coupon_category', true );
                            }
                            $types = explode(',',esc_attr($coupon['type']));
                            foreach($types as $type){
                                $coupon_type = get_term_by('name', $type , 'affcoups_coupon_type');
                                if(!empty($coupon_type))
                                    wp_set_post_terms($coupon_id, $coupon_type->term_id, 'affcoups_coupon_type', true );
                            }    
                            // check and upload coupon image
                            if(!empty($coupon['image'])) {
                                $args = array(
                                            'title'    =>pathinfo($coupon['image'],PATHINFO_FILENAME), 
                                            'post_type'      => 'attachment',
                                            'post_mime_type' => 'image',
                                            );
                                $images = get_posts($args);
                               // $item[6] =preg_replace('/\s+/', '-', $item[6]);
                                $coupon_image = NULL; 
                                if(empty($images)){
                                    if (filter_var($coupon['image'], FILTER_VALIDATE_URL))
                                        $coupon_image = affcoups_imageupload($coupon['image'],$coupon_id);                                 
                                }else
                                    $coupon_image = $images[0]->ID;
                                if(!empty($coupon_image))
                                    update_post_meta( $coupon_id , AFFCOUPS_PREFIX .'coupon_image', $coupon_image);    
                            }

                              
                            $coupons = array(
                                        'ID' => $coupon_id,
                                        'post_content' =>$coupon['post_content'],
                                        'post_status' => 'publish',
                                        'meta_input' => array(
                                 AFFCOUPS_PREFIX .'coupon_vendor'=>$vendor_id,
                                 AFFCOUPS_PREFIX .'coupon_discount'=>$coupon['discount'],
                                 AFFCOUPS_PREFIX .'coupon_code'=>$coupon['code'],
                                 AFFCOUPS_PREFIX .'coupon_valid_from'=>strtotime($coupon['valid_from']),
                                 AFFCOUPS_PREFIX .'coupon_valid_until'=>strtotime($coupon['valid_until']),
                                 AFFCOUPS_PREFIX .'coupon_url'=>$coupon['url'],
                                 AFFCOUPS_PREFIX .'coupon_title'=>$coupon['description_title'],
                                 AFFCOUPS_PREFIX .'coupon_description'=>$coupon['description'],
                                 AFFCOUPS_PREFIX .'coupon_featured'=>$coupon['featured'],
                                 AFFCOUPS_PREFIX .'coupon_highlighted'=>$coupon['highlighted'],
                                 AFFCOUPS_PREFIX .'click_to_reveal_disable'=>$coupon['click_to_reveal_disable'],
                                 AFFCOUPS_PREFIX .'coupon_original_price'=>$coupon['original_price'],
                                 AFFCOUPS_PREFIX .'coupon_discounted_price'=>$coupon['discounted_price'],

                                ));
                           
                            wp_update_post( $coupons );
                        }else
                        { 
                            $title_missing=$csv_file_line+1;
                            echo "<p style='color:red'><strong>Coupon at line - $title_missing not uploaded/updated, Error! :Missing coupon title<strong></P> ";
                        }

                    }
                    fclose($file);
                    echo "<p style='color:green';><strong>'$csv_file_line' Coupons uploaded/updated Successfully!<strong></P> ";
                }else 
                    echo "\n Error \n ";
            }else
                echo "<p style='color:red'><strong>Selected file is not CSV file !<strong></P> ";
        }else
            echo "<p style='color:red'><strong>Select CSV file to upload Coupons !<strong></P> ";
    
    }
}




         

  // function to upload image          
       
function affcoups_imageupload($image_url,$coupon_id){
    $upload_dir = wp_upload_dir();
    if(!empty($image_url)){
        $image_data = file_get_contents( $image_url ); 
        $filename = basename( $image_url );      
        if ( wp_mkdir_p( $upload_dir['path'] ) ){
          $file = $upload_dir['path'] . '/' . $filename;
        }
        else {
          $file = $upload_dir['basedir'] . '/' . $filename;
        }
        file_put_contents( $file, $image_data );
        $wp_filetype = wp_check_filetype( $filename, null );
        $attachment = array(
          'post_parent'    => $coupon_id, 
          'post_mime_type' => $wp_filetype['type'],
          'post_title' => sanitize_file_name( $filename ),
          'post_content' => '',
          'post_status' => 'inherit'
        );
        $attach_id = wp_insert_attachment( $attachment, $file );
        require_once( ABSPATH . 'wp-admin/includes/image.php' );
        $attach_data = wp_generate_attachment_metadata( $attach_id, $file );
        wp_update_attachment_metadata( $attach_id, $attach_data );
        return $attach_id;
    }
}