<?php
/**
 * AJAX actions
 *
 * @since       1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Handle AJAX click tracking action
 */
function affcoups_pro_ajax_tracking_action() {

    // AJAX Call
    if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {

        $response = false;

        // Variables
        $type = ( isset( $_POST['type'] ) ) ? sanitize_text_field( $_POST['type'] ) : null;
        $coupon_id = ( isset ( $_POST['coupon_id'] ) ) ? $_POST['coupon_id'] : 0;
        $url = ( isset ( $_POST['url'] ) ) ? affcoups_remove_url_params( filter_var( $_POST['url'], FILTER_VALIDATE_URL, FILTER_FLAG_PATH_REQUIRED ) ) : null;

        if ( ! empty( $coupon_id ) || empty( $type ) ) {

            // Track multiple records
            if ( is_array( $coupon_id ) ) {

                foreach ( $coupon_id as $id ) {

                    $data = array(
                        'type' => $type,
                        'coupon_id' => ( is_numeric( $id ) ) ? intval( $id ) : 0,
                        'post_id' => ( ! empty( $url ) ) ? url_to_postid( $url ) : 0
                    );

                    $response = affcoups_pro_stats_record( $data );
                }

            // Track single records
            } else {

                $data = array(
                    'type' => $type,
                    'coupon_id' => ( is_numeric( $coupon_id ) ) ? intval( $coupon_id ) : 0,
                    'post_id' => ( ! empty( $url ) ) ? url_to_postid( $url ) : 0
                );

                $response = affcoups_pro_stats_record( $data );
            }
        }

        // response output
        echo $response;
    }

    // IMPORTANT: don't forget to "exit"
    exit;
}
add_action( 'wp_ajax_nopriv_affcoups_pro_tracking_action', 'affcoups_pro_ajax_tracking_action' );
add_action( 'wp_ajax_affcoups_pro_tracking_action', 'affcoups_pro_ajax_tracking_action' );

/**
 * Handle AJAX Search Filters action
 */
function affcoups_pro_ajax_search_filters_action() {

    //affcoups_debug_log( '' );
    //affcoups_debug_log( '------- AJAX SEARCH FILTERS START -------' );

    if ( affcoups_is_amp() ) {
        wp_send_json( array( 'error' => 'AMP template is not using search filters!' ) );
        return;
    }

    $ajax_args = array();

    if ( isset( $_POST['ajax_args'] ) ) {
        parse_str( $_POST['ajax_args'], $ajax_args ); // since @1.6.7.5 line updated to enable search in arabic language
    }

    if ( empty( $ajax_args ) ) {
        wp_send_json( array( 'error' => 'data is incorrect' ) );
        return;
    }
    $args = unserialize( base64_decode( _sanitize_text_fields( $ajax_args['affcoups_search_args'], true ) ) );
    $coupons = affcoups_get_coupons( $args );
    

    // Search bar
    if ( ! empty( $ajax_args['affcoups_search_query'] ) ) {
        $coupons = affcoups_pro_search_bar( $coupons, $ajax_args['affcoups_search_query'] );
    }

    // Coupon Types Dropdown
    if ( ! empty( $ajax_args['affcoups_search_type'] ) ) {
        $coupons = affcoups_pro_search_taxonomy( $coupons, $ajax_args['affcoups_search_type'], AFFCOUPS_COUPON_TYPE_TAXONOMY );
    }

    // Coupon Category Dropdown
    if ( ! empty( $ajax_args['affcoups_search_category'] ) ) {
        $coupons = affcoups_pro_search_taxonomy( $coupons, $ajax_args['affcoups_search_category'], AFFCOUPS_COUPON_CATEGORY_TAXONOMY );
    }

    // Coupon Vendor Dropdown
    if ( ! empty( $ajax_args['affcoups_search_vendor'] ) ) {
        $coupons = affcoups_pro_search_vendor( $coupons, $ajax_args['affcoups_search_vendor'] );
    }

    $coupon_ids = array();

    foreach ( $coupons as $coupon ) {
        $coupon_ids[] = $coupon->id;
    }

    if ( empty( $coupon_ids ) ) {
        wp_send_json_success( array(
            'no_coupons' => esc_html__( 'No coupons found.', 'affiliate-coupons' )
        ) );
    }

    // Coupon 'Order By' and 'Order' Dropdowns
    $args['orderby'] = ( ! empty( $ajax_args['affcoups_search_orderby'] ) ) ? $ajax_args['affcoups_search_orderby'] : '';
    $args['order'] = ( ! empty( $ajax_args['affcoups_search_order'] ) ) ? $ajax_args['affcoups_search_order'] : '';
    $args['post__in'] = $coupon_ids;
    $args['affcoups_coupon_id'] = $coupon_ids;
    $args['posts_per_page'] = sizeof( $coupon_ids );

    $args = affcoups_pro_search_ordering( $args );
 
    $coupons = affcoups_get_coupons( $args );

    // Sorted coupon ids
    $sorted_coupon_ids = array();

    foreach ( $coupons as $coupon ) {
        $sorted_coupon_ids[] = $coupon->id;
    }

    $args['sorted_coupon_ids'] = $sorted_coupon_ids;
    $args['post__in'] = $sorted_coupon_ids;
    $args['posts_per_page'] = sizeof( $sorted_coupon_ids );
   
    if ( ! empty( $args['pagination'] ) ) {

        $args['paginated_coupon_ids'] = $sorted_coupon_ids;

        $args['paginated'] = 1;

        $offset = $args['pagination_per_page'] * ( $args['paginated'] - 1 );

        $total_pages = sizeof( $args['sorted_coupon_ids'] );
        $args['total_pages'] = (int) ceil( $total_pages / ( $args['pagination_per_page'] ) );

        $args['affcoups_coupon_id'] = array_slice( $args['sorted_coupon_ids'], $offset, $args['pagination_per_page'] );

        $load_more_ids = array_diff( $args['paginated_coupon_ids'], $args['affcoups_coupon_id'] );
        $load_more_ids = array_values( $load_more_ids );
        
    }
    
    $coupons = affcoups_get_coupons( $args );

    ob_start();
    if ( $coupons ) {

        $coupons = apply_filters( 'affcoups_coupons', $coupons, $args );

        $options = affcoups_get_options();

        $template_default  = ( ! empty( $options['template'] ) ) ? esc_html( $options['template'] ) : 'standard';
        $template = ( ! empty( $args['template'] ) ) ? esc_html( $args['template'] ) : $template_default;

        global $affcoups_template_args;
        $affcoups_template_args['style'] = $options['style'];

        // Grid Layout?
        if ( 'grid' !== $args['template'] ) {
            unset( $args['grid_size'] );
        }

        // Get template file
        $file = affcoups_get_template_file( $template, 'coupons' );

        if ( file_exists( $file ) ) {
            include $file;

        } else {
            '<p>' . esc_html_e( 'Template not found.', 'affiliate-coupons' ) . '</p>';
        }

    } else {
        esc_html_e( 'No coupons found.', 'affiliate-coupons' );
    }

    $output = ob_get_clean();

    // Remove unwanted line breaks from output
    $output = preg_replace( '/^\s+|\n|\r|\s+$/m', '', $output );

    $response = array(
        'output' => $output
    );

    if ( ! empty( $args['pagination'] ) ) {

        // if isset: check if it's empty or not
        if ( isset( $load_more_ids ) ) {
            $response['load_more_ids'] = ( ! empty( $load_more_ids ) ) ? $load_more_ids : '';
        }

        $response['load_more_args'] = base64_encode( serialize($args) );
    }

    //affcoups_debug_log( '' );
    //affcoups_debug_log( '------- AJAX SEARCH FILTERS END -------' );
    //affcoups_debug_log( '-----------------------------------------' );

    wp_send_json_success( $response );
}
add_action( 'wp_ajax_nopriv_affcoups_pro_search_filters_action', 'affcoups_pro_ajax_search_filters_action' );
add_action( 'wp_ajax_affcoups_pro_search_filters_action',        'affcoups_pro_ajax_search_filters_action' );

/**
 * Handle AJAX Pagination action
 */
function affcoups_pro_ajax_pagination_action() {

    //affcoups_debug_log( '' );
    //affcoups_debug_log( '------- AJAX PAGINATION START -------' );

    if ( affcoups_is_amp() ) {
        wp_send_json( array( 'error' => 'AMP template is not using pagination!' ) );
        return;
    }

    $paginated = ( isset( $_POST['paginated'] ) ) ? _sanitize_text_fields( $_POST['paginated'], true ) : 1;
    $args = ( isset( $_POST['args'] ) ) ? unserialize( base64_decode( _sanitize_text_fields( $_POST['args'], true ) ) ) : array();

    if ( empty( $paginated ) || ! is_numeric( $paginated ) ) {
        wp_send_json( array( 'error' => 'data is incorrect' ) );
        return;
    }

    $response = array();

    // If 'Search Filters' were selected/changed
    if ( isset( $_POST['load_more_ids'] ) ) {

        if ( empty( $_POST['load_more_ids'] ) ) {
            $load_more_ids = array();

        } else {
            $load_more_ids = explode( ',', _sanitize_text_fields( $_POST['load_more_ids'], true ) );

            $post__in_to_remove = array_values( array_diff( $args['post__in'], $args['paginated_coupon_ids'], $load_more_ids ) );

            $post__in_array = array();

            foreach ( $args['post__in'] as $key => $id ) {

                if ( ! in_array( $id, $post__in_to_remove ) ) {
                    $post__in_array[] = $args['post__in'][$key];
                }
            }

            $args['post__in'] = $post__in_array;

            // If 'Load More' button is clicked first time after any 'Search Filter' was selected/changed
            if ( '1' == $paginated ) {

                $sorted_coupon_ids_to_remove = array_values( array_diff( $args['sorted_coupon_ids'], $args['paginated_coupon_ids'], $load_more_ids ) );

                $sorted_coupon_ids_array = array();

                foreach ( $args['sorted_coupon_ids'] as $key => $id ) {

                    if ( ! in_array( $id, $sorted_coupon_ids_to_remove ) ) {
                        $sorted_coupon_ids_array[] = $args['sorted_coupon_ids'][$key];
                    }
                }

                $args['sorted_coupon_ids'] = $sorted_coupon_ids_array;

                $total_pages = sizeof( $args['sorted_coupon_ids'] );
                $args['total_pages'] = (int) ceil( $total_pages / $args['pagination_per_page'] );
            }
        }
    }

    $paginated++;

    $args['paginated'] = $paginated;

    $coupons = affcoups_get_coupons( $args );

    ob_start();    

    if ( $coupons ) {

        $coupons = apply_filters( 'affcoups_coupons', $coupons, $args );
        $options = affcoups_get_options();
        $template_default  = ( ! empty( $options['template'] ) ) ? esc_html( $options['template'] ) : 'standard';
        $template = ( ! empty( $args['template'] ) ) ? esc_html( $args['template'] ) : $template_default;
        global $affcoups_template_args;
        $affcoups_template_args['style'] = $options['style'];
        // Grid Layout?
        if ( 'grid' !== $args['template'] ) {
            unset( $args['grid_size'] );
        }

        // Get template file
        $file = affcoups_get_template_file( $template, 'coupons' );

        if ( file_exists( $file ) ) {

            // If 'Search Filters' were selected/changed
            if ( isset( $load_more_ids ) ) {

                $offset = $args['pagination_per_page'] * ( $paginated - 1 );

                if ( empty( $load_more_ids ) ) {
                    $response['last'] = true;
                    $response_load_more_ids = array();

                } else {
                    $response_load_more_ids = array_slice( $args['sorted_coupon_ids'], $offset );

                    $next_chunk = array_slice( $args['sorted_coupon_ids'], $offset, $args['pagination_per_page'] );

                    foreach ( $next_chunk as $value ) {
                        $args['affcoups_coupon_id'][] = $value;
                    }

                    $args['paginated_coupon_ids'] = $args['affcoups_coupon_id'];

                    $coupons = affcoups_get_coupons( $args );
                }

                $response['load_more_ids'] = implode( ',', $response_load_more_ids );

            } else {
                $offset = $args['pagination_per_page'] * $args['paginated'];

                $paginated_coupon_ids = array_slice( $args['post__in'], 0, $offset );

                $args['paginated_coupon_ids'] = $paginated_coupon_ids;
                $args['affcoups_coupon_id'] = $paginated_coupon_ids;

                $coupons = affcoups_get_coupons( $args );
            }

            include $file;

        } else {
            '<p>' . esc_html_e( 'Template not found.', 'affiliate-coupons' ) . '</p>';
        }

    } else {
        esc_html_e( 'No coupons found.', 'affiliate-coupons' );
    }

    $output = ob_get_clean();
    $output = apply_filters( 'affcoups_shortcode_output', $output, false );

    // Remove unwanted line breaks from output
    $output = preg_replace( '/^\s+|\n|\r|\s+$/m', '', $output );

    $response['output'] = $output;
    $response['args'] = base64_encode( serialize($args) );
    $response['paginated'] = $paginated;

    if ( $paginated == $args['total_pages'] ) {
        $response['last'] = true;
    }

    //affcoups_debug_log( '' );
    //affcoups_debug_log( '------- AJAX PAGINATION END -------' );
    //affcoups_debug_log( '-----------------------------------------' );

    wp_send_json_success( $response );
}
add_action( 'wp_ajax_nopriv_affcoups_pro_pagination_action', 'affcoups_pro_ajax_pagination_action' );
add_action( 'wp_ajax_affcoups_pro_pagination_action',        'affcoups_pro_ajax_pagination_action' );