<?php
/**
 * Gutenberg Blocks
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Register Gutenberg Blocks
 *
 * @param $meta_boxes
 * @return array|mixed
 */
function affcoups_pro_register_mb_blocks( $meta_boxes ) {

    //affcoups_debug_log( __FUNCTION__ );

    $fields = array(
        array(
            'name'        => esc_html__( 'Coupon', 'affiliate-coupons' ),
            'id'          => AFFCOUPS_PREFIX . 'coupon',
            'type'        => 'post',
            'post_type'   => AFFCOUPS_COUPON_POST_TYPE,
            'field_type'  => 'select_advanced',
            'multiple'    => true,
            'placeholder' => esc_html__( 'Please select...', 'affiliate-coupons' ),
            'query_args'  => array(
                'post_status'    => 'publish',
                'posts_per_page' => - 1,
                'orderby'        => 'name',
                'order'          => 'ASC',
            ),
        ),
        array(
            'name'        => esc_html__( 'Vendor', 'affiliate-coupons' ),
            'id'          => AFFCOUPS_PREFIX . 'vendor',
            'type'        => 'post',
            'post_type'   => AFFCOUPS_VENDOR_POST_TYPE,
            'field_type'  => 'select_advanced',
            'multiple'    => true,
            'placeholder' => esc_html__( 'Please select...', 'affiliate-coupons' ),
            'query_args'  => array(
                'post_status'    => 'publish',
                'posts_per_page' => - 1,
                'orderby'        => 'name',
                'order'          => 'ASC',
            ),
        ),
        array(
            'name'        => esc_html__( 'Category', 'affiliate-coupons' ),
            'id'          => AFFCOUPS_PREFIX . 'category',
            'type'        => 'taxonomy_advanced',
            'taxonomy'    => AFFCOUPS_COUPON_CATEGORY_TAXONOMY,
            'field_type'  => 'checkbox_tree',
            'multiple'    => true,
            'placeholder' => esc_html__( 'Please select...', 'affiliate-coupons' ),
            'query_args'  => array(
                'post_status'    => 'publish',
                'posts_per_page' => - 1,
                'orderby'        => 'name',
                'order'          => 'ASC',
            ),
        ),
        array(
            'name'        => esc_html__( 'Type', 'affiliate-coupons' ),
            'id'          => AFFCOUPS_PREFIX . 'type',
            'type'        => 'taxonomy_advanced',
            'taxonomy'    => AFFCOUPS_COUPON_TYPE_TAXONOMY,
            'field_type'  => 'checkbox_tree',
            'multiple'    => true,
            'placeholder' => esc_html__( 'Please select...', 'affiliate-coupons' ),
            'query_args'  => array(
                'post_status'    => 'publish',
                'posts_per_page' => - 1,
                'orderby'        => 'name',
                'order'          => 'ASC',
            ),
        ),
        array(
            'name'    => esc_html__( 'Order by', 'affiliate-coupons' ),
            'id'      => AFFCOUPS_PREFIX . 'orderby',
            'type'    => 'select_advanced',
            'options' => affcoups_get_orderby_options(),
        ),
        array(
            'name'    => esc_html__( 'Order', 'affiliate-coupons' ),
            'id'      => AFFCOUPS_PREFIX . 'order',
            'type'    => 'select_advanced',
            'options' => array(
                'asc'  => 'ASC',
                'desc' => 'DESC',
            ),
        ),
        array(
            'name'    => esc_html__( 'Search Filters', 'affiliate-coupons-pro' ),
            'id'      => AFFCOUPS_PREFIX . 'search_filters',
            'type'    => 'select_advanced',
            'placeholder' => esc_html__( 'Please select...', 'affiliate-coupons' ),
            'options' => array(
                'true'  => 'true',
                'false' => 'false',
            ),
        ),
        array(
            'name'    => esc_html__( 'Pagination', 'affiliate-coupons' ),
            'id'      => AFFCOUPS_PREFIX . 'pagination',
            'type'    => 'select_advanced',
            'placeholder' => esc_html__( 'Please select...', 'affiliate-coupons' ),
            'options' => array(
                'true'  => 'true',
                'false' => 'false',
            ),
        ),
        array(
            'name' => esc_html__( 'Coupons per page', 'affiliate-coupons-pro' ),
            'desc' => esc_html__( 'only if pagination is set to true', 'affiliate-coupons-pro' ),
            'id'   => AFFCOUPS_PREFIX . 'pagination_per_page',
            'type' => 'number',
            'min'  => 1,
        ),
        array(
            'name'    => esc_html__( 'Template', 'affiliate-coupons' ),
            'id'      => AFFCOUPS_PREFIX . 'template',
            'type'    => 'select_advanced',
            'options' => affcoups_get_template_options(),
        ),
        array(
            'name' => esc_html__( 'Grid size', 'affiliate-coupons' ),
            'desc' => esc_html__( 'for grid template only', 'affiliate-coupons-pro' ),
            'id'   => AFFCOUPS_PREFIX . 'grid',
            'type' => 'number',
            'min'  => 1,
        ),
    );

    $fields = apply_filters( 'affcoups_mb_blocks_fields', $fields );

    $prefix = str_replace( '_', '-', AFFCOUPS_PREFIX );

    $meta_boxes[] = array(
        'id'              => $prefix . 'mb-blocks',
        'title'           => 'Affcoups',
        'description'     => esc_html__( 'Shortcode Generator for Affiliate Coupons', 'affiliate-coupons-pro' ),
        'type'            => 'block',
        'post_types'      => array( 'post', 'page' ),
        'icon'            => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path fill="currentColor" d="M485.5 0L576 160H474.9L405.7 0h79.8zm-128 0l69.2 160H149.3L218.5 0h139zm-267 0h79.8l-69.2 160H0L90.5 0zM0 192h100.7l123 251.7c1.5 3.1-2.7 5.9-5 3.3L0 192zm148.2 0h279.6l-137 318.2c-1 2.4-4.5 2.4-5.5 0L148.2 192zm204.1 251.7l123-251.7H576L357.3 446.9c-2.3 2.7-6.5-.1-5-3.2z"></path></svg>',
        'keywords'        => ['affcoups', 'affiliate', 'coupons', 'shortcode'],
        'context'         => 'side',
        //'mode'            => 'edit',
        'render_template' => AFFCOUPS_PRO_PLUGIN_DIR . 'includes/blocks/output.php',
        'fields'          => $fields,
    );

    $meta_boxes = apply_filters( 'affcoups_mb_blocks', $meta_boxes );

    //affcoups_debug_log( $meta_boxes );

    return $meta_boxes;
}
add_filter( 'rwmb_meta_boxes', 'affcoups_pro_register_mb_blocks' );