<?php
/**
 * The template file to display the block.
 *
 * Available parameters:
 * @param array $attributes The block attributes.
 * @param bool  $is_preview Whether in the preview mode.
 */

if ( ! isset( $attributes ) )
    return;

//affcoups_debug_log( '$attributes:' );
//affcoups_debug_log( $attributes );

$prefix = str_replace( '_', '-', AFFCOUPS_PREFIX );

// Fields data.
if ( ! isset( $attributes['name'] ) || $prefix . 'mb-blocks' !== $attributes['name'] )
    return;

$output = '[affcoups';

if ( empty( $attributes['data'] ) ) {
    echo $output . ']';

} else {

    $data = $attributes['data'];

    // Coupon
    if ( ! empty( $data[AFFCOUPS_PREFIX . 'coupon'] )
       && sizeof( $data[AFFCOUPS_PREFIX . 'coupon'] ) > 0
    ){
        $output .= ' id="' . implode(',', $data[AFFCOUPS_PREFIX . 'coupon'] ) . '"';
    }

    // Vendor
    if ( ! empty( $data[AFFCOUPS_PREFIX . 'vendor'] )
       && sizeof( $data[AFFCOUPS_PREFIX . 'vendor'] ) > 0
    ){
        $output .= ' vendor="' . implode(',', $data[AFFCOUPS_PREFIX . 'vendor'] ) . '"';
    }

    // Category
    if ( ! empty( $data[AFFCOUPS_PREFIX . 'category'] ) ) {
        $output .= ' category="' . $data[AFFCOUPS_PREFIX . 'category'] . '"';
    }

    // Type
    if ( ! empty( $data[AFFCOUPS_PREFIX . 'type'] ) ) {
        $output .= ' type="' . $data[AFFCOUPS_PREFIX . 'type'] . '"';
    }

    // Orderby
    if ( ! empty( $data[AFFCOUPS_PREFIX . 'orderby'] ) ) {
        $output .= ' orderby="' . $data[AFFCOUPS_PREFIX . 'orderby'] . '"';
    }

    // Order
    if ( ! empty( $data[AFFCOUPS_PREFIX . 'order'] ) ) {
        $output .= ' order="' . $data[AFFCOUPS_PREFIX . 'order'] . '"';
    }

    // Search Filters
    if ( ! empty( $data[AFFCOUPS_PREFIX . 'search_filters'] ) ) {
        $output .= ' search_filters="' . $data[AFFCOUPS_PREFIX . 'search_filters'] . '"';
    }

    // Pagination
    if ( ! empty( $data[AFFCOUPS_PREFIX . 'pagination'] ) ) {
        $output .= ' pagination="' . $data[AFFCOUPS_PREFIX . 'pagination'] . '"';

        // Coupons per page
        if ( 'true' == $data[AFFCOUPS_PREFIX . 'pagination'] ) {

            if ( ! empty( $data[AFFCOUPS_PREFIX . 'pagination_per_page'] ) && is_numeric( $data[AFFCOUPS_PREFIX . 'pagination_per_page'] ) && $data[AFFCOUPS_PREFIX . 'pagination_per_page'] > 0 ) {
                $output .= ' pagination_per_page="' . $data[AFFCOUPS_PREFIX . 'pagination_per_page'] . '"';
            }
        }
    }

    // Template
    if ( ! empty( $data[AFFCOUPS_PREFIX . 'template'] ) ) {
        $output .= ' template="' . $data[AFFCOUPS_PREFIX . 'template'] . '"';

        // Grid
        if ( 'grid' == $data[AFFCOUPS_PREFIX . 'template'] ) {

            if ( ! empty( $data[AFFCOUPS_PREFIX . 'grid'] ) && is_numeric( $data[AFFCOUPS_PREFIX . 'grid'] ) && $data[AFFCOUPS_PREFIX . 'grid'] > 0 ) {
                $output .= ' grid="' . $data[AFFCOUPS_PREFIX . 'grid'] . '"';
            }
        }
    }

    echo $output . ']';
}