<?php
/**
 * Coupon Extended Class
 *
 * @package     AffiliateCouponsPro\CouponExtendedClass
 * @since       1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

if (!class_exists('Affcoups_Coupon_Extended')) {

    class Affcoups_Coupon_Extended
    {
        protected $_instance;

        /**
         * Affcoups_Coupon_Extended constructor.
         * @param Affcoups_Coupon $instance
         */
        public function __construct(Affcoups_Coupon $instance) {
            $this->_instance = $instance;
        }

        /**
         * Magic call method
         *
         * @param $method
         * @param $args
         * @return mixed
         */
        public function __call($method, $args) {
            return call_user_func_array(array($this->_instance, $method), $args);
        }

        /**
         * Magic get method
         *
         * @param $key
         * @return mixed
         */
        public function __get($key) {
            return $this->_instance->$key;
        }

        /**
         * Magic set method
         *
         * @param $key
         * @param $val
         * @return mixed
         */
        public function __set($key, $val) {
            return $this->_instance->$key = $val;
        }

        /**
         * Check if coupon is featured
         *
         * @return bool
         */
        public function is_featured() {

            $is_featured = get_post_meta( $this->id, AFFCOUPS_PREFIX . 'coupon_featured', true );

            return ( '1' == $is_featured ) ? true : false;
        }

        /**
         * Check if coupon is highlighted
         *
         * @return bool
         */
        public function is_highlighted() {

            $is_highlighted = get_post_meta( $this->id, AFFCOUPS_PREFIX . 'coupon_highlighted', true );

            return ( '1' == $is_highlighted ) ? true : false;
        }
        /**
         * Check if coupon is click to reveal is disabled
         *
         * @return bool
         */
        public function is_click_to_reveal_disable() {

            $is_click_to_reveal_disable = get_post_meta( $this->id, AFFCOUPS_PREFIX . 'click_to_reveal_disable', true );

            return ( '1' == $is_click_to_reveal_disable ) ? true : false;
        }
        /**
         * Get page url
         *
         * @return false|string
         */
        public function get_page_url() {
            return get_permalink( $this->id );
        }
    }
}