<?php
/**
 * Code Reveal
 *
 * @since       1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Extend button HTML for "click to reveal"
 *
 * @param $button_html
 * @param $button
 * @param Affcoups_Coupon $Coupon
 * @return mixed
 */
function affcoups_pro_button_code_reveal_html( $button_html, $button, $Coupon ) {
    $options = affcoups_get_options();
    if(!isset($options['pagination']))
            $options['pagination']=null;
    if(!isset($options['share_coupon']))
            $options['share_coupon']=null;
    $modal_button = ( ! empty( $options['modal_popup_button_text'] ) ) ? esc_attr( trim( $options['modal_popup_button_text'] ) ) : __( ' Go to Offer', 'affiliate-coupons-pro' );
    if($Coupon->is_click_to_reveal_disable())
        return $button_html;
    if ( ! affcoups_pro_is_click_to_reveal_active() && ( ! isset( $button['code_reveal'] ) || true !== $button['code_reveal'] ) )
        return $button_html;

    if ( affcoups_pro_coupon_redirect_to_page() )
        return $button_html;


    //$options = affcoups_get_options();
    
    $code = $Coupon->get_code();

    if ( empty( $code ) )
        return $button_html;

//    if ( ! $button['text_forced'] )
//        $button['text'] = __( 'Show Code', 'affiliate-coupons-pro' );

    $button['text'] = ( ! empty( $options['click_to_reveal_button_text'] ) ) ? esc_attr( trim( $options['click_to_reveal_button_text'] ) ) : __( 'Show Code', 'affiliate-coupons-pro' );

    // Build HTML markup
    ob_start();
    ?>
    <!-- Code Reveal Button -->
    <a class="affcoups-coupon__button affcoups-coupon__button--code-reveal" href="<?php echo esc_attr( $button['url'] ); ?>" title="<?php echo esc_attr( $button['text'] ) ?>" rel="<?php echo esc_attr( $button['rel'] ); ?>" target="<?php echo esc_attr( $button['target'] ); ?>" data-affcoups-code-reveal="<?php echo $Coupon->get_id(); ?>">
        <span class="affcoups-coupon__button-code"><?php echo esc_attr( $code ); ?></span>
        <span class="affcoups-coupon__button-text"><span class="affcoups-icon-<?php echo esc_attr( $button['icon'] ); ?> affcoups-coupon__button-icon"></span><?php echo esc_attr( $button['text'] ); ?></span>
    </a>
    <?php 
    if(!$options['pagination'] && !$options['share_coupon']){
    ?>
    <!-- Code Reveal Modal -->
    <div id="affcoups-modal-coupon-<?php echo $Coupon->get_id(); ?>" class="affcoups-modal affcoups-modal-coupon mfp-hide">
        <?php $Coupon->the_image(); ?>
        <p class="affcoups-coupon__title"><?php echo esc_attr( $Coupon->get_title() ); ?></p>
        <?php if ( $Coupon->get_code() ) { ?>
            <div class="affcoups-coupon__code">
                <?php $Coupon->the_code(); ?>
            </div>
        <?php } ?>
        <?php if ( $Coupon->get_description() ) { ?>
            <div class="affcoups-coupon__description">
                <p style="font-size:24px; font-weight:600;"><?php _e('Details', 'affiliate-coupons-pro' ); ?></p><br>
                <?php echo wp_kses_post( $Coupon->get_description() ); ?>
            </div>
        <?php } ?>
        <div class="affcoups-coupon__footer">
            <a class="affcoups-coupon__button" href="<?php echo $Coupon->get_url(); ?>" target="_blank" rel="nofollow"><?php echo  $modal_button; ?></a>
        </div>
    </div>
    <?php
    }
    $button_html = ob_get_clean();

    return $button_html;
}
add_filter( 'affcoups_button_html', 'affcoups_pro_button_code_reveal_html', 10, 3 );

/**
 * Maybe hide code inside templates
 *
 * @param $show_code
 * @param Affcoups_Coupon $Coupon
 * @return bool
 */
function affcoups_pro_hide_code_until_revealed( $show_code, $Coupon ) {

    if ( affcoups_pro_is_click_to_reveal_active() )
        return false;

    return $show_code;
}
add_filter( 'affcoups_show_code', 'affcoups_pro_hide_code_until_revealed', 10, 2 );

/**
 * Check whether click to reveal is active or not
 *
 * @return bool
 */
function affcoups_pro_is_click_to_reveal_active() {

    // Check settings
    $options = affcoups_get_options();

    $click_to_reveal = ( isset( $options['code'] ) && 'reveal' === $options['code'] ) ? true : false;

    // Check shortcode attributes
    global $affcoups_shortcode_atts;

    if ( isset( $affcoups_shortcode_atts['code'] ) )
        $click_to_reveal = ( 'reveal' === $affcoups_shortcode_atts['code'] ) ? true : false;

    return $click_to_reveal;
}