<?php
/**
 * Functions
 *
 * @since       1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Check if AJAX call is currently running
 *
 * @return bool
 */
function affcoups_pro_is_doing_ajax() {
    return ( /*! is_admin() &&*/ defined( 'DOING_AJAX' ) && DOING_AJAX );
}

/**
 * Check whether coupon pages are activated or not
 *
 * @return bool
 */
function affcoups_pro_coupon_pages_activated() {

    $coupon_pages = affcoups_get_option( 'coupon_pages', false );

    return ( $coupon_pages ) ? true : false;
}

/**
 * Check whether coupon links/buttons should redirect to coupon pages first
 *
 * @return bool
 */
function affcoups_pro_coupon_redirect_to_pages_activated() {

    $coupon_redirect_to_pages = affcoups_get_option( 'coupon_redirect_to_pages', false );

    return ( $coupon_redirect_to_pages ) ? true : false;
}

/**
 * Check whether to redirect a coupon to its page or not
 *
 * @return bool
 */
function affcoups_pro_coupon_redirect_to_page() {
    return ( affcoups_pro_coupon_pages_activated() && affcoups_pro_coupon_redirect_to_pages_activated() && ! affcoups_pro_is_coupon_page() ) ? true : false;
}

/**
 * Check whether coupon pages should be included in search results or not
 *
 * @return bool
 */
function affcoups_pro_coupon_include_in_search_activated() {

    $coupon_include_in_search = affcoups_get_option( 'coupon_include_in_search', false );

    return ( $coupon_include_in_search ) ? true : false;
}

/**
 * Get coupon slug
 *
 * @return null
 */
function affcoups_pro_get_coupon_slug() {

    $coupon_slug = affcoups_get_option( 'coupon_slug', 'coupon' );

    return $coupon_slug;
}

/**
 * Check whether we are on a coupon page or not
 *
 * @return bool
 */
function affcoups_pro_is_coupon_page() {
    return is_singular( 'affcoups_coupon' );
}

/**
 * Setup coupon extended class object
 *
 * @param Affcoups_Coupon $Coupon
 * @return Affcoups_Coupon_Extended
 */
function affcoups_pro_setup_coupon_extended( $Coupon ) {

    $CouponExtended = new Affcoups_Coupon_Extended( new Affcoups_Coupon( $Coupon->get_id() ) );

    return $CouponExtended;
}

// function that runs when shortcode is called
function affcoups_print_vendor_list() { 
        $vendors = affcoups_get_vendors();  
        ob_start();
        foreach ($vendors as $vendor){
            $url = get_post_meta( $vendor->ID, AFFCOUPS_PREFIX . 'vendor_url', true );
            ?>
            <a class="affcoups_vendor_list" style="text-decoration:none;" href="<?php echo $url; ?>" >
            <?php //echo $vendor->post_title; ?>
            </a><br>
        <?php
        }   
        $output = ob_get_clean();
        echo $output;

    }
    // register shortcode
    add_shortcode('affcoups_vendor_list', 'affcoups_print_vendor_list');